/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.ConfigurationImpl;
import org.apache.cxf.jaxrs.impl.FeatureContextImpl;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ConfigurableImpl<C extends Configurable<C>>
implements Configurable<C> {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurableImpl.class);
    private static final Class<?>[] RESTRICTED_CLASSES_IN_SERVER = new Class[]{ClientRequestFilter.class, ClientResponseFilter.class};
    private static final Class<?>[] RESTRICTED_CLASSES_IN_CLIENT = new Class[]{ContainerRequestFilter.class, ContainerResponseFilter.class};
    private ConfigurationImpl config;
    private final C configurable;
    private final Class<?>[] supportedProviderClasses;
    private final Class<?>[] restrictedContractTypes;
    private final Instantiator instantiator;
    static final long serialVersionUID = 2285971699002074313L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurableImpl(C configurable, RuntimeType rt, Class<?>[] supportedProviderClasses) {
        this(configurable, supportedProviderClasses, new ConfigurationImpl(rt));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", new Object[]{configurable, rt, supportedProviderClasses});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurableImpl(C configurable, Class<?>[] supportedProviderClasses, Configuration config) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", new Object[]{configurable, supportedProviderClasses, config});
        }
        this.instantiator = new Instantiator(){
            static final long serialVersionUID = 940608386316622413L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public <T> Object create(Class<T> cls) {
                return ConfigurationImpl.createProvider(cls);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, null, null);
            }
        };
        this.configurable = configurable;
        this.supportedProviderClasses = supportedProviderClasses;
        this.config = config instanceof ConfigurationImpl ? (ConfigurationImpl)config : new ConfigurationImpl(config, supportedProviderClasses);
        Class<?>[] classArray = this.restrictedContractTypes = RuntimeType.CLIENT.equals((Object)config.getRuntimeType()) ? RESTRICTED_CLASSES_IN_CLIENT : RESTRICTED_CLASSES_IN_SERVER;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static Class<?>[] getImplementedContracts(Object provider, Class<?>[] restrictedClasses) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getImplementedContracts", new Object[]{provider, restrictedClasses});
        }
        Class<?> providerClass = provider instanceof Class ? (Class<?>)provider : provider.getClass();
        Set<Class<?>> interfaces = ConfigurableImpl.collectAllInterfaces(providerClass);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "all interfaces implemented by " + provider + ": " + interfaces);
        }
        for (Class<?> iface : restrictedClasses) {
            if (!interfaces.remove(iface) || !LOG.isLoggable(Level.FINEST)) continue;
            LOG.log(Level.FINEST, "not registering contract " + iface + " for provider, " + provider);
        }
        Class[] classArray = interfaces.toArray(new Class[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classArray = classArray;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getImplementedContracts", classArray);
        }
        return classArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Set<Class<?>> collectAllInterfaces(Class<?> providerClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "collectAllInterfaces", new Object[]{providerClass});
        }
        HashSet interfaces = new HashSet();
        do {
            for (Class<?> anInterface : providerClass.getInterfaces()) {
                ConfigurableImpl.collectInterfaces(interfaces, anInterface);
            }
        } while ((providerClass = providerClass.getSuperclass()) != null && providerClass != Object.class);
        HashSet hashSet = interfaces;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "collectAllInterfaces", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void collectInterfaces(Set<Class<?>> interfaces, Class<?> anInterface) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "collectInterfaces", new Object[]{interfaces, anInterface});
        }
        interfaces.add(anInterface);
        for (Class<?> superInterface : anInterface.getInterfaces()) {
            ConfigurableImpl.collectInterfaces(interfaces, superInterface);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "collectInterfaces");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected C getConfigurable() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfigurable", new Object[0]);
        }
        C c = this.configurable;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfigurable", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Configuration getConfiguration() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfiguration", new Object[0]);
        }
        ConfigurationImpl configurationImpl = this.config;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            configurationImpl = configurationImpl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfiguration", configurationImpl);
        }
        return configurationImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C property(String name, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "property", new Object[]{name, value});
        }
        this.config.setProperty(name, value);
        C c = this.configurable;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "property", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider});
        }
        C c = this.register(provider, AnnotationUtils.getBindingPriority(provider.getClass()));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider, int bindingPriority) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider, bindingPriority});
        }
        C c = this.doRegister(provider, bindingPriority, ConfigurableImpl.getImplementedContracts(provider, this.restrictedContractTypes));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider, contracts});
        }
        C c = this.doRegister(provider, 5000, contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider, contracts});
        }
        C c = this.doRegisterProvider(provider, contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass});
        }
        C c = this.register(providerClass, AnnotationUtils.getBindingPriority(providerClass));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass, int bindingPriority) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass, bindingPriority});
        }
        C c = this.doRegister(this.getInstantiator().create(providerClass), bindingPriority, ConfigurableImpl.getImplementedContracts(providerClass, this.restrictedContractTypes));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass, contracts});
        }
        C c = this.doRegister(providerClass, 5000, contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass, contracts});
        }
        C c = this.register(this.getInstantiator().create(providerClass), contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Instantiator getInstantiator() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getInstantiator", new Object[0]);
        }
        Instantiator instantiator = this.instantiator;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            instantiator = instantiator;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getInstantiator", instantiator);
        }
        return instantiator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private C doRegister(Object provider, int bindingPriority, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", new Object[]{provider, bindingPriority, contracts});
        }
        if (contracts == null || contracts.length == 0) {
            LOG.warning("Null, empty or invalid contracts specified for " + provider + "; ignoring.");
            C c = this.configurable;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                c = c;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
            }
            return c;
        }
        C c = this.doRegisterProvider(provider, ConfigurationImpl.initContractsMap(bindingPriority, contracts));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private C doRegisterProvider(Object provider, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegisterProvider", new Object[]{provider, contracts});
        }
        if (provider instanceof Feature) {
            Feature feature = (Feature)provider;
            boolean enabled = feature.configure((FeatureContext)new FeatureContextImpl(this));
            this.config.setFeature(feature, enabled);
            C c = this.configurable;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                c = c;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegisterProvider", c);
            }
            return c;
        }
        this.config.register(provider, contracts);
        C c = this.configurable;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegisterProvider", c);
        }
        return c;
    }

    public static interface Instantiator {
        public <T> Object create(Class<T> var1);
    }
}

