/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.dd.DeploymentDescriptor;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.ws.javaee.dd.common.Description;
import com.ibm.ws.javaee.dd.common.DisplayName;
import com.ibm.ws.javaee.dd.common.Icon;
import com.ibm.ws.javaee.dd.common.MessageDestination;
import com.ibm.ws.javaee.ddmodel.AnySimpleType;
import com.ibm.ws.javaee.ddmodel.BooleanType;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.TokenType;
import com.ibm.ws.javaee.ddmodel.common.DescriptionType;
import com.ibm.ws.javaee.ddmodel.common.DisplayNameType;
import com.ibm.ws.javaee.ddmodel.common.IconType;
import com.ibm.ws.javaee.ddmodel.common.JNDIEnvironmentRefsGroup;
import com.ibm.ws.javaee.ddmodel.common.MessageDestinationType;
import com.ibm.ws.javaee.ddmodel.common.XSDTokenType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ApplicationClientType
extends JNDIEnvironmentRefsGroup
implements DeploymentDescriptor,
ApplicationClient,
DDParser.RootParsable {
    private final String path;
    private int versionId;
    private TokenType version;
    private BooleanType metadata_complete;
    private DescriptionType.ListType description;
    private DisplayNameType.ListType display_name;
    private IconType.ListType icon;
    private IconType compatIcon;
    private XSDTokenType module_name;
    private XSDTokenType callback_handler;
    private MessageDestinationType.ListType message_destination;
    DDParser.ComponentIDMap idMap;
    static final long serialVersionUID = -5245286234702871848L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ApplicationClientType(String path) {
        this.path = path;
    }

    @Override
    protected boolean isEJBLocalRefSupported() {
        return false;
    }

    @Override
    protected boolean isPersistenceContextRefSupported() {
        return false;
    }

    public String getDeploymentDescriptorPath() {
        return this.path;
    }

    public Object getComponentForId(String id) {
        return this.idMap.getComponentForId(id);
    }

    public String getIdForComponent(Object ddComponent) {
        return this.idMap.getIdForComponent(ddComponent);
    }

    public String getModuleName() {
        return this.module_name != null ? this.module_name.getValue() : null;
    }

    public boolean isSetMetadataComplete() {
        return AnySimpleType.isSet(this.metadata_complete);
    }

    public boolean isMetadataComplete() {
        return this.metadata_complete != null && this.metadata_complete.getBooleanValue();
    }

    public String getVersion() {
        return this.version.getValue();
    }

    public int getVersionID() {
        return this.versionId;
    }

    public List<Description> getDescriptions() {
        if (this.description != null) {
            return this.description.getList();
        }
        return Collections.emptyList();
    }

    public List<DisplayName> getDisplayNames() {
        if (this.display_name != null) {
            return this.display_name.getList();
        }
        return Collections.emptyList();
    }

    public List<Icon> getIcons() {
        if (this.icon != null) {
            return this.icon.getList();
        }
        return Collections.emptyList();
    }

    public String getCallbackHandler() {
        return this.callback_handler != null ? this.callback_handler.getValue() : null;
    }

    public List<MessageDestination> getMessageDestinations() {
        if (this.message_destination != null) {
            return this.message_destination.getList();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isIdAllowed() {
        return true;
    }

    @Override
    public boolean handleAttribute(DDParser parser, String nsURI, String localName, int index) throws DDParser.ParseException {
        if (nsURI == null) {
            if (parser.version >= 14 && "version".equals(localName)) {
                this.version = parser.parseTokenAttributeValue(index);
                return true;
            }
            if (parser.version >= 50 && "metadata-complete".equals(localName)) {
                this.metadata_complete = parser.parseBooleanAttributeValue(index);
                return true;
            }
        }
        return false;
    }

    @Override
    public void finish(DDParser parser) throws DDParser.ParseException {
        super.finish(parser);
        if (this.version == null) {
            if (parser.version < 14) {
                this.version = parser.parseToken(parser.version == 12 ? "1.2" : "1.3");
            } else {
                throw new DDParser.ParseException(parser.requiredAttributeMissing("version"));
            }
        }
        this.versionId = parser.version;
        this.idMap = parser.idMap;
    }

    @Override
    public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
        if (super.handleChild(parser, localName)) {
            return true;
        }
        if ("description".equals(localName)) {
            DescriptionType description = new DescriptionType();
            parser.parse(description);
            this.addDescription(description);
            return true;
        }
        if ("display-name".equals(localName)) {
            DisplayNameType display_name = new DisplayNameType();
            parser.parse(display_name);
            this.addDisplayName(display_name);
            return true;
        }
        if (parser.version < 14 && ("small-icon".equals(localName) || "large-icon".equals(localName))) {
            if (this.compatIcon == null) {
                this.compatIcon = new IconType();
                this.addIcon(this.compatIcon);
            }
            return this.compatIcon.handleChild(parser, localName);
        }
        if ("icon".equals(localName)) {
            IconType icon = new IconType();
            parser.parse(icon);
            this.addIcon(icon);
            return true;
        }
        if ("module-name".equals(localName)) {
            XSDTokenType module_name = new XSDTokenType();
            parser.parse(module_name);
            this.module_name = module_name;
            return true;
        }
        if ("callback-handler".equals(localName)) {
            XSDTokenType callback_handler = new XSDTokenType();
            parser.parse(callback_handler);
            this.callback_handler = callback_handler;
            return true;
        }
        if ("message-destination".equals(localName)) {
            MessageDestinationType message_destination = new MessageDestinationType();
            parser.parse(message_destination);
            this.addMessageDestination(message_destination);
            return true;
        }
        return false;
    }

    private void addDescription(DescriptionType description) {
        if (this.description == null) {
            this.description = new DescriptionType.ListType();
        }
        this.description.add(description);
    }

    private void addDisplayName(DisplayNameType display_name) {
        if (this.display_name == null) {
            this.display_name = new DisplayNameType.ListType();
        }
        this.display_name.add(display_name);
    }

    protected void addIcon(IconType icon) {
        if (this.icon == null) {
            this.icon = new IconType.ListType();
        }
        this.icon.add(icon);
    }

    private void addMessageDestination(MessageDestinationType message_destination) {
        if (this.message_destination == null) {
            this.message_destination = new MessageDestinationType.ListType();
        }
        this.message_destination.add(message_destination);
    }

    @Override
    public void describe(DDParser.Diagnostics diag) {
        diag.describe("version", this.version);
        diag.describeIfSet("metadata-complete", this.metadata_complete);
        diag.describeIfSet("module-name", this.module_name);
        diag.describeIfSet("description", this.description);
        diag.describeIfSet("display-name", this.display_name);
        diag.describeIfSet("icon", this.icon);
        super.describe(diag);
        diag.describeIfSet("callback-handler", this.callback_handler);
        diag.describeIfSet("message-destination", this.message_destination);
    }

    @Override
    protected String toTracingSafeString() {
        return "application-client";
    }

    @Override
    public void describe(StringBuilder sb) {
        DDParser.Diagnostics diag = new DDParser.Diagnostics(this.idMap, sb);
        diag.describe(this.toTracingSafeString(), this);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ApplicationClientType.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
    }
}

