/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.extensions;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.IdentityStoreHandlerService;
import com.ibm.ws.security.javaeesec.cdi.beans.Utils;
import com.ibm.ws.security.javaeesec.properties.ModulePropertiesUtils;
import java.util.Hashtable;
import javax.enterprise.inject.spi.CDI;
import javax.security.auth.Subject;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.credential.CallerOnlyCredential;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={IdentityStoreHandlerService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class IdentityStoreHandlerServiceImpl
implements IdentityStoreHandlerService {
    Utils utils = new Utils();
    static final long serialVersionUID = -7243755902317440092L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(ComponentContext cc) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }

    public Subject createHashtableInSubject(String username, @Sensitive String password) throws AuthenticationException {
        UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
        return this.createHashtableInSubject((Credential)credential);
    }

    public Subject createHashtableInSubject(String username) throws AuthenticationException {
        CallerOnlyCredential credential = new CallerOnlyCredential(username);
        return this.createHashtableInSubject((Credential)credential);
    }

    private Subject createHashtableInSubject(Credential credential) throws AuthenticationException {
        if (this.getModulePropertiesUtils().isHttpAuthenticationMechanism()) {
            IdentityStoreHandler identityStoreHandler = this.utils.getIdentityStoreHandler(this.getCDI());
            if (identityStoreHandler != null) {
                Subject inSubject = new Subject();
                Hashtable<String, Object> subjectHashtable = this.utils.createNewSubjectHashtable(inSubject);
                AuthenticationStatus status = this.utils.validateWithIdentityStore("defaultRealm", inSubject, credential, identityStoreHandler);
                if (status != AuthenticationStatus.SUCCESS) {
                    throw new AuthenticationException("Authentication by IdentityStoreHandler was failed.");
                }
                return inSubject;
            }
            throw new AuthenticationException("IdentityStoreHandler does not exist.");
        }
        throw new AuthenticationException("HttpAuthenticationMechansim is not used in this module.");
    }

    public boolean isIdentityStoreAvailable() {
        return this.getModulePropertiesUtils().isHttpAuthenticationMechanism() && this.utils.isIdentityStoreAvailable(this.getCDI());
    }

    protected CDI getCDI() {
        return CDI.current();
    }

    protected ModulePropertiesUtils getModulePropertiesUtils() {
        return ModulePropertiesUtils.getInstance();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IdentityStoreHandlerServiceImpl.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
    }
}

