/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2.trust;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TrustedIDEvaluatorImpl
implements TrustedIDEvaluator {
    private final Set<String> trustedIdentities;
    static final long serialVersionUID = -8699939715314201747L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TrustedIDEvaluatorImpl() {
        this.trustedIdentities = new HashSet<String>();
    }

    public TrustedIDEvaluatorImpl(Set<String> trustedIdentities) {
        this.trustedIdentities = trustedIdentities;
    }

    public TrustedIDEvaluatorImpl(String pipeSeparatedTrustedIdentities) {
        this(TrustedIDEvaluatorImpl.createSetFrom(pipeSeparatedTrustedIdentities));
    }

    private static Set<String> createSetFrom(String pipeSeparatedTrustedIdentities) {
        HashSet<String> tempTrustedIdentities = new HashSet<String>();
        if (pipeSeparatedTrustedIdentities != null && !pipeSeparatedTrustedIdentities.trim().isEmpty()) {
            String[] parsedTrustedIdentities;
            for (String trustedIdentity : parsedTrustedIdentities = pipeSeparatedTrustedIdentities.split("\\|")) {
                String trimmedTrustedIdentity = trustedIdentity.trim();
                if (trimmedTrustedIdentity.isEmpty()) continue;
                tempTrustedIdentities.add(trimmedTrustedIdentity);
            }
        }
        return tempTrustedIdentities;
    }

    @Override
    public boolean isTrusted(String user) {
        return this.trustedIdentities.contains(user);
    }

    @Override
    public boolean isTrusted(String user, @Sensitive String password) {
        return this.isTrusted(user);
    }

    @Override
    public boolean isTrusted(X509Certificate[] certChain) {
        String issuerDN = certChain[0].getIssuerX500Principal().getName();
        return this.isTrusted(issuerDN);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TrustedIDEvaluatorImpl.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

