/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1EncodableVector;
import com.ibm.ws.transport.iiop.asn1.ASN1Sequence;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERInteger;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERSequence;
import com.ibm.ws.transport.iiop.asn1.DERTaggedObject;
import com.ibm.ws.transport.iiop.asn1.x509.GeneralName;
import java.math.BigInteger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GeneralSubtree
extends ASN1Encodable {
    private GeneralName base;
    private DERInteger minimum;
    private DERInteger maximum;
    static final long serialVersionUID = 6005334481094150988L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public GeneralSubtree(ASN1Sequence seq) {
        this.base = GeneralName.getInstance(seq.getObjectAt(0));
        block0 : switch (seq.size()) {
            case 1: {
                break;
            }
            case 2: {
                ASN1TaggedObject o = (ASN1TaggedObject)seq.getObjectAt(1);
                switch (o.getTagNo()) {
                    case 0: {
                        this.minimum = DERInteger.getInstance(o, false);
                        break block0;
                    }
                    case 1: {
                        this.maximum = DERInteger.getInstance(o, false);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Bad tag number: " + o.getTagNo());
            }
            case 3: {
                this.minimum = DERInteger.getInstance((ASN1TaggedObject)seq.getObjectAt(1), false);
                this.maximum = DERInteger.getInstance((ASN1TaggedObject)seq.getObjectAt(2), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad sequence size: " + seq.size());
            }
        }
    }

    public static GeneralSubtree getInstance(ASN1TaggedObject o, boolean explicit) {
        return new GeneralSubtree(ASN1Sequence.getInstance(o, explicit));
    }

    public static GeneralSubtree getInstance(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof GeneralSubtree) {
            return (GeneralSubtree)obj;
        }
        return new GeneralSubtree(ASN1Sequence.getInstance(obj));
    }

    public GeneralName getBase() {
        return this.base;
    }

    public BigInteger getMinimum() {
        if (this.minimum == null) {
            return BigInteger.valueOf(0L);
        }
        return this.minimum.getValue();
    }

    public BigInteger getMaximum() {
        if (this.maximum == null) {
            return null;
        }
        return this.maximum.getValue();
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.base);
        if (this.minimum != null) {
            v.add(new DERTaggedObject(false, 0, this.minimum));
        }
        if (this.maximum != null) {
            v.add(new DERTaggedObject(false, 1, this.maximum));
        }
        return new DERSequence(v);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(GeneralSubtree.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

