/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.ssl.yoko;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.csiv2.config.CompatibleMechanisms;
import com.ibm.ws.security.csiv2.config.ssl.SSLConfig;
import com.ibm.ws.security.csiv2.config.tss.ServerTransportAddress;
import com.ibm.ws.security.csiv2.util.SecurityServices;
import com.ibm.ws.transport.iiop.security.ClientPolicy;
import com.ibm.ws.transport.iiop.security.config.css.CSSConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSTransportMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.OptionsKey;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechListConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSSLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSTransportMechConfig;
import com.ibm.ws.transport.iiop.yoko.helper.SocketFactoryHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.yoko.orb.OCI.IIOP.Util;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TRANSIENT;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IOP.TaggedComponent;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SocketFactory
extends SocketFactoryHelper {
    private static final TraceComponent tc = Tr.register(SocketFactory.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    private static final String HOST_PROTOCOL = "ssl";
    private final Map<String, SSLSocketFactory> socketFactoryMap = new HashMap<String, SSLSocketFactory>(1);
    private final Map<String, SSLServerSocketFactory> serverSocketFactoryMap = new HashMap<String, SSLServerSocketFactory>(1);
    private final SSLConfig sslConfig;
    private final List<SocketInfo> socketInfos = new ArrayList<SocketInfo>();
    static final long serialVersionUID = 8273269350621981732L;

    public SocketFactory() {
        super(tc);
        this.sslConfig = SecurityServices.getSSLConfig();
    }

    public Socket createSocket(String host, int port) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SocketFactory attempting to create socket for host: " + host + " port: " + port), (Object[])new Object[0]);
        }
        if (Util.isEncodedHost((String)host, (String)HOST_PROTOCOL)) {
            String sslConfigName = Util.decodeHostInfo((String)host);
            host = Util.decodeHost((String)host);
            return this.createSSLSocket(host, (char)port, sslConfigName);
        }
        return this.createPlainSocket(host, port);
    }

    private static CSSConfig getCssConfig(Policy[] policies) {
        CSSConfig cssConfig = null;
        for (Policy policy : policies) {
            if (!(policy instanceof ClientPolicy)) continue;
            cssConfig = ((ClientPolicy)policy).getConfig();
            break;
        }
        return cssConfig;
    }

    /*
     * WARNING - void declaration
     */
    private List<CompatibleMechanisms> getCompatibleMechanisms(CSSConfig cssConfig, TaggedComponent comp) {
        try {
            TSSCompoundSecMechListConfig config = TSSCompoundSecMechListConfig.decodeIOR(this.codec, comp);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("looking at tss: " + config), (Object[])new Object[0]);
            }
            return cssConfig.findCompatibleList(config);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.config.ssl.yoko.SocketFactory", (String)"151", (Object)this, (Object[])new Object[]{cssConfig, comp});
            throw (TRANSIENT)new TRANSIENT("Could not decode IOR TSSCompoundSecMechListConfig").initCause((Throwable)e);
        }
    }

    @FFDCIgnore(value={IOException.class})
    public Socket createSelfConnection(InetAddress address, int port) throws IOException {
        try {
            SocketInfo info = null;
            for (SocketInfo test : this.socketInfos) {
                if (test.port != port || !test.addr.equals(address)) continue;
                info = test;
            }
            if (info == null) {
                throw new IOException("No inbound socket matching address " + address + " and port " + port);
            }
            OptionsKey key = info.key;
            if ((1 & key.requires) == 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Created plain endpoint to " + address.getHostName() + ":" + port), (Object[])new Object[0]);
                }
                return new Socket(address, port);
            }
            return this.createSSLSocket(address.getHostName(), port, info.sslConfigName);
        }
        catch (IOException ex) {
            Tr.error((TraceComponent)tc, (String)("Exception creating a client socket to " + address.getHostName() + ":" + port), (Object[])new Object[]{ex});
            throw ex;
        }
    }

    public ServerSocket createServerSocket(int port, int backlog, String[] params) throws IOException {
        return this.createServerSocket(port, backlog, null, params);
    }

    /*
     * WARNING - void declaration
     */
    public ServerSocket createServerSocket(int port, int backlog, InetAddress address, String[] params) throws IOException {
        try {
            ServerSocket socket;
            String sslConfigName = null;
            boolean soReuseAddr = true;
            for (int i = 0; i < params.length - 1; ++i) {
                String param = params[i];
                if ("--sslConfigName".equals(param)) {
                    sslConfigName = params[++i];
                }
                if (!"--soReuseAddr".equals(param)) continue;
                soReuseAddr = Boolean.parseBoolean(params[++i]);
            }
            OptionsKey options = this.sslConfig.getAssociationOptions(sslConfigName);
            if ((1 & options.requires) == 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Created plain server socket for port " + port), (Object[])new Object[0]);
                }
                socket = new ServerSocket();
            } else {
                SSLServerSocketFactory serverSocketFactory = this.getServerSocketFactory(sslConfigName);
                SSLServerSocket serverSocket = (SSLServerSocket)serverSocketFactory.createServerSocket();
                this.configureServerSocket(serverSocket, serverSocketFactory, sslConfigName, options);
                socket = serverSocket;
            }
            IOException bindError = null;
            for (int i = 0; i < 3 && (bindError = this.openSocket(port, backlog, address, socket, soReuseAddr)) != null; ++i) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("bind error, retry binding... count : " + i), (Object[])new Object[0]);
                    }
                    Thread.sleep(500L);
                    continue;
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.config.ssl.yoko.SocketFactory", (String)"269", (Object)this, (Object[])new Object[]{port, backlog, address, params});
                    Tr.debug((TraceComponent)tc, (String)("An exception is caught while retrying binding. the error message is  " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            if (bindError != null) {
                Tr.error((TraceComponent)tc, (String)"SOCKET_BIND_ERROR", (Object[])new Object[]{address.getHostName(), port, bindError.getLocalizedMessage()});
                throw bindError;
            }
            int listenPort = socket.getLocalPort();
            SocketInfo info = new SocketInfo(address, listenPort, options, sslConfigName);
            this.socketInfos.add(info);
            return socket;
        }
        catch (SSLException socket) {
            void e;
            FFDCFilter.processException((Throwable)socket, (String)"com.ibm.ws.transport.iiop.security.config.ssl.yoko.SocketFactory", (String)"284", (Object)this, (Object[])new Object[]{port, backlog, address, params});
            throw new IOException("Could not retrieve association options from ssl configuration", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SSLSocketFactory getSocketFactory(String id) throws IOException {
        SSLSocketFactory socketFactory = this.socketFactoryMap.get(id);
        if (socketFactory == null) {
            if (id == null) {
                socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                try {
                    socketFactory = this.sslConfig.createSSLFactory(id);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.config.ssl.yoko.SocketFactory", (String)"307", (Object)this, (Object[])new Object[]{id});
                    Tr.error((TraceComponent)tc, (String)"Unable to create client SSL socket factory", (Object[])new Object[]{e});
                    throw (IOException)new IOException("Unable to create client SSL socket factory: " + e.getMessage()).initCause((Throwable)e);
                }
            }
            this.socketFactoryMap.put(id, socketFactory);
        }
        return socketFactory;
    }

    /*
     * WARNING - void declaration
     */
    private SSLServerSocketFactory getServerSocketFactory(String id) throws IOException {
        SSLServerSocketFactory serverSocketFactory = this.serverSocketFactoryMap.get(id);
        if (serverSocketFactory == null) {
            if (id == null) {
                serverSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            } else {
                try {
                    serverSocketFactory = this.sslConfig.createSSLServerFactory(id);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.config.ssl.yoko.SocketFactory", (String)"334", (Object)this, (Object[])new Object[]{id});
                    Tr.error((TraceComponent)tc, (String)"Unable to create server SSL socket factory", (Object[])new Object[]{e});
                    throw (IOException)new IOException("Unable to create server SSL socket factory: " + e.getMessage()).initCause((Throwable)e);
                }
                this.serverSocketFactoryMap.put(id, serverSocketFactory);
            }
            this.getSocketFactory(id);
        }
        return serverSocketFactory;
    }

    /*
     * WARNING - void declaration
     */
    private void configureServerSocket(SSLServerSocket serverSocket, SSLServerSocketFactory serverSocketFactory, String sslConfigName, OptionsKey options) throws IOException {
        try {
            boolean clientAuthSupported;
            String[] cipherSuites = this.sslConfig.getCipherSuites(sslConfigName, serverSocketFactory.getSupportedCipherSuites());
            serverSocket.setEnabledCipherSuites(cipherSuites);
            String protocol = this.sslConfig.getSSLProtocol(sslConfigName);
            if (protocol != null) {
                serverSocket.setEnabledProtocols(new String[]{protocol});
            }
            boolean clientAuthRequired = (options.requires & 0x40) == 64;
            boolean bl = clientAuthSupported = (options.supports & 0x40) == 64;
            if (clientAuthRequired) {
                serverSocket.setNeedClientAuth(true);
            } else if (clientAuthSupported) {
                serverSocket.setWantClientAuth(true);
            } else {
                serverSocket.setNeedClientAuth(false);
            }
            serverSocket.setSoTimeout(60000);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Created SSL server socket on port " + serverSocket.getLocalPort()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("    client authentication " + (clientAuthSupported ? "SUPPORTED" : "UNSUPPORTED")), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("    client authentication " + (clientAuthRequired ? "REQUIRED" : "OPTIONAL")), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"    cipher suites:", (Object[])new Object[0]);
                for (int i = 0; i < cipherSuites.length; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("    " + cipherSuites[i]), (Object[])new Object[0]);
                }
            }
        }
        catch (SSLException cipherSuites) {
            void e;
            FFDCFilter.processException((Throwable)cipherSuites, (String)"com.ibm.ws.transport.iiop.security.config.ssl.yoko.SocketFactory", (String)"397", (Object)this, (Object[])new Object[]{serverSocket, serverSocketFactory, sslConfigName, options});
            throw new IOException("Could not configure server socket", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Socket createSSLSocket(String host, int port, final String clientSSLConfigName) throws IOException {
        String[] iorSuites;
        final SSLSocketFactory factory = this.getSocketFactory(clientSSLConfigName);
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        socket.setSoTimeout(60000);
        try {
            iorSuites = (String[])AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -5476315663388575171L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    return SocketFactory.this.sslConfig.getCipherSuites(clientSSLConfigName, factory.getSupportedCipherSuites());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.transport.iiop.security.config.ssl.yoko.SocketFactory", (String)"430", (Object)this, (Object[])new Object[]{host, port, clientSSLConfigName});
            throw new IOException("Could not configure client socket", pae.getCause());
        }
        SSLParameters params = socket.getSSLParameters();
        if (this.sslConfig.enableVerifyHostname(clientSSLConfigName)) {
            params.setEndpointIdentificationAlgorithm("HTTPS");
        }
        params.setCipherSuites(iorSuites);
        socket.setSSLParameters(params);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created SSL socket to " + host + ":" + port), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"    cipher suites:", (Object[])new Object[0]);
            for (int i = 0; i < iorSuites.length; ++i) {
                Tr.debug((TraceComponent)tc, (String)("    " + iorSuites[i]), (Object[])new Object[0]);
            }
            socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){
                static final long serialVersionUID = -4063672712206206899L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                    Certificate[] certs = handshakeCompletedEvent.getLocalCertificates();
                    if (certs != null) {
                        Tr.debug((TraceComponent)tc, (String)("handshake returned local certs count: " + certs.length), (Object[])new Object[0]);
                        for (int i = 0; i < certs.length; ++i) {
                            Certificate cert = certs[i];
                            Tr.debug((TraceComponent)tc, (String)("cert: " + cert.toString()), (Object[])new Object[0]);
                        }
                    } else {
                        Tr.debug((TraceComponent)tc, (String)"handshake returned no local certs", (Object[])new Object[0]);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
                }
            });
        }
        return socket;
    }

    public int[] tags() {
        return new int[]{33};
    }

    private static TransportAddress createPlainTransportAddress(String host, short port) {
        return new TransportAddress(host, port);
    }

    private static TransportAddress createSslTransportAddress(String host, short port, String sslConfigName) {
        String encodedHost = Util.encodeHost((String)host, (String)HOST_PROTOCOL, (String)sslConfigName);
        return new TransportAddress(encodedHost, port);
    }

    public TransportAddress[] getEndpoints(TaggedComponent tagComponent, Policy[] policies) {
        CSSConfig cssConfig = SocketFactory.getCssConfig(policies);
        ArrayList<TransportAddress> addresses = new ArrayList<TransportAddress>();
        for (CompatibleMechanisms compatibleMechanisms : this.getCompatibleMechanisms(cssConfig, tagComponent)) {
            boolean useProtection;
            Map<ServerTransportAddress, CSSTransportMechConfig> cssTransport_mechs = compatibleMechanisms.getCSSCompoundSecMechConfig().getTransportMechMap();
            TSSTransportMechConfig transport_mech = compatibleMechanisms.getTSSCompoundSecMechConfig().getTransport_mech();
            if (!(transport_mech instanceof TSSSSLTransportConfig)) continue;
            TSSSSLTransportConfig transportConfig = (TSSSSLTransportConfig)transport_mech;
            boolean bl = useProtection = (1 & transportConfig.getRequires()) == 0;
            if (cssTransport_mechs.isEmpty()) {
                String sslConfigName = compatibleMechanisms.getCSSCompoundSecMechConfig().getTransport_mech().getSslConfigName();
                for (TransportAddress addr : transportConfig.getTransportAddresses()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("IOR to target " + addr.host_name + ":" + (char)addr.port + " using client sslConfig " + sslConfigName), (Object[])new Object[0]);
                    }
                    addresses.add(useProtection ? SocketFactory.createSslTransportAddress(addr.host_name, addr.port, sslConfigName) : SocketFactory.createPlainTransportAddress(addr.host_name, addr.port));
                }
                continue;
            }
            for (Map.Entry<ServerTransportAddress, CSSTransportMechConfig> entry : cssTransport_mechs.entrySet()) {
                ServerTransportAddress addr = entry.getKey();
                CSSTransportMechConfig mech_cfg = entry.getValue();
                String sslConfigName = mech_cfg.getSslConfigName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("IOR to target " + addr.getHost() + ":" + (char)addr.getPort() + " using client sslConfig " + sslConfigName), (Object[])new Object[0]);
                }
                addresses.add(useProtection ? SocketFactory.createSslTransportAddress(addr.getHost(), addr.getPort(), sslConfigName) : SocketFactory.createPlainTransportAddress(addr.getHost(), addr.getPort()));
            }
        }
        return addresses.toArray(new TransportAddress[addresses.size()]);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class SocketInfo {
        final InetAddress addr;
        final int port;
        final OptionsKey key;
        final String sslConfigName;
        static final long serialVersionUID = 940386407186482989L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SocketInfo(InetAddress addr, int port, OptionsKey key, String sslConfigName) {
            this.addr = addr;
            this.port = port;
            this.key = key;
            this.sslConfigName = sslConfigName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SocketInfo.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
        }
    }
}

