/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.config.ConfigUtil;
import com.ibm.ws.transport.iiop.security.config.tss.TSSTransportAddressConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSTransportMechConfig;
import com.ibm.ws.transport.iiop.security.util.Util;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CSIIOP.SECIOP_SEC_TRANS;
import org.omg.CSIIOP.SECIOP_SEC_TRANSHelper;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IOP.Codec;
import org.omg.IOP.TaggedComponent;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TSSSECIOPTransportConfig
extends TSSTransportMechConfig {
    private short supports;
    private short requires;
    private String mechOID;
    private String targetName;
    private final List addresses = new ArrayList(1);
    static final long serialVersionUID = -2079552154001155595L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TSSSECIOPTransportConfig() {
    }

    public TSSSECIOPTransportConfig(TaggedComponent component, Codec codec) throws Exception {
        Any any = codec.decode_value(component.component_data, TLS_SEC_TRANSHelper.type());
        SECIOP_SEC_TRANS tst = SECIOP_SEC_TRANSHelper.extract((Any)any);
        this.supports = tst.target_supports;
        this.requires = tst.target_requires;
        this.mechOID = Util.decodeOID(tst.mech_oid);
        this.targetName = new String(tst.target_name);
        for (int i = 0; i < tst.addresses.length; ++i) {
            this.addresses.add(new TSSTransportAddressConfig(tst.addresses[i].port, tst.addresses[i].host_name));
        }
    }

    @Override
    public short getSupports() {
        return this.supports;
    }

    public void setSupports(short supports) {
        this.supports = supports;
    }

    @Override
    public short getRequires() {
        return this.requires;
    }

    public void setRequires(short requires) {
        this.requires = requires;
    }

    public String getMechOID() {
        return this.mechOID;
    }

    public void setMechOID(String mechOID) {
        this.mechOID = mechOID;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public List getAddresses() {
        return this.addresses;
    }

    @Override
    public TaggedComponent encodeIOR(Codec codec) throws Exception {
        TaggedComponent result = new TaggedComponent();
        SECIOP_SEC_TRANS sst = new SECIOP_SEC_TRANS();
        sst.target_supports = this.supports;
        sst.target_requires = this.requires;
        sst.mech_oid = Util.encodeOID(this.mechOID);
        sst.target_name = this.targetName.getBytes();
        sst.addresses = new TransportAddress[this.addresses.size()];
        int i = 0;
        for (TSSTransportAddressConfig transportConfig : this.addresses) {
            sst.addresses[i++] = new TransportAddress(transportConfig.getHostname(), transportConfig.getPort());
        }
        Any any = ORB.init().create_any();
        SECIOP_SEC_TRANSHelper.insert((Any)any, (SECIOP_SEC_TRANS)sst);
        result.tag = 35;
        result.component_data = codec.encode_value(any);
        return result;
    }

    @Override
    public Subject check(SSLSession session) throws SASException {
        return new Subject();
    }

    @Override
    @Trivial
    void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("TSSSASMechConfig: [\n");
        buf.append(moreSpaces).append("SUPPORTS  : ").append(ConfigUtil.flags(this.supports)).append("\n");
        buf.append(moreSpaces).append("REQUIRES  : ").append(ConfigUtil.flags(this.requires)).append("\n");
        buf.append(moreSpaces).append("mechOID   : ").append(this.mechOID).append("\n");
        buf.append(moreSpaces).append("targetName: ").append(this.targetName).append("\n");
        for (TSSTransportAddressConfig tssTransportAddressConfig : this.addresses) {
            tssTransportAddressConfig.toString(moreSpaces, buf);
        }
        buf.append(spaces).append("]\n");
    }

    @Override
    public boolean isTrusted(TrustedIDEvaluator trustedIDEvaluator, SSLSession session) {
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TSSSECIOPTransportConfig.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

