/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.tai.TAIService;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.JaspiService;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelperImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.WebRequestImpl;
import com.ibm.ws.webcontainer.security.internal.SSOAuthenticator;
import com.ibm.ws.webcontainer.security.internal.TAIAuthenticator;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebProviderAuthenticatorProxy
implements WebAuthenticator {
    private static final TraceComponent tc = Tr.register(WebProviderAuthenticatorProxy.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    AuthenticationResult JASPI_CONT = new AuthenticationResult(AuthResult.CONTINUE, "JASPI said continue...");
    protected final AtomicServiceReference<SecurityService> securityServiceRef;
    protected final AtomicServiceReference<TAIService> taiServiceRef;
    protected final ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef;
    protected volatile WebAppSecurityConfig webAppSecurityConfig;
    protected final ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef;
    static final long serialVersionUID = -8881769442349757882L;

    public WebProviderAuthenticatorProxy(AtomicServiceReference<SecurityService> securityServiceRef, AtomicServiceReference<TAIService> taiServiceRef, ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef, WebAppSecurityConfig webAppSecurityConfig, ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef) {
        this.securityServiceRef = securityServiceRef;
        this.taiServiceRef = taiServiceRef;
        this.interceptorServiceRef = interceptorServiceRef;
        this.webAppSecurityConfig = webAppSecurityConfig;
        this.webAuthenticatorRef = webAuthenticatorRef;
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        AuthenticationResult authResult = this.handleTAI(webRequest, true);
        if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleSSO(webRequest, null)).getStatus() == AuthResult.CONTINUE) {
            webRequest.setCallAfterSSO(true);
            authResult = this.handleTAI(webRequest, false);
        }
        return authResult;
    }

    protected AuthenticationResult handleJaspi(final WebRequest webRequest, final HashMap<String, Object> props) {
        JaspiService jaspiService;
        AuthenticationResult authResult = this.JASPI_CONT;
        if (this.webAuthenticatorRef != null && (jaspiService = (JaspiService)this.webAuthenticatorRef.getService((Object)"com.ibm.ws.security.jaspi")) != null) {
            HttpServletRequest request = webRequest.getHttpServletRequest();
            authResult = props == null ? this.authenticateForOtherMechanisms(webRequest, authResult, jaspiService) : this.authenticateForFormMechanism(webRequest, props, jaspiService);
            if (authResult.getStatus() == AuthResult.SUCCESS) {
                if (System.getSecurityManager() == null) {
                    this.processAuthenticationSuccess(webRequest, props, authResult);
                } else {
                    final AuthenticationResult authResultFinal = authResult;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){
                        static final long serialVersionUID = 3397013613883367688L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() {
                            WebProviderAuthenticatorProxy.this.processAuthenticationSuccess(webRequest, props, authResultFinal);
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
                        }
                    });
                }
            }
        }
        return authResult;
    }

    private AuthenticationResult authenticateForOtherMechanisms(WebRequest webRequest, AuthenticationResult authResult, JaspiService jaspiService) {
        AuthResult result;
        authResult = this.handleSSO(webRequest, null);
        if (AuthResult.SUCCESS.equals((Object)authResult.getStatus()) && this.webAppSecurityConfig.isUseLtpaSSOForJaspic()) {
            return authResult;
        }
        Subject subject = authResult.getSubject();
        List<String> tokenUsage = null;
        if (subject != null && !this.isJaspicSessionOrJsr375Form(tokenUsage = this.getTokenUsageFromSSOToken(subject, this.webAppSecurityConfig.createSSOCookieHelper()))) {
            this.clearCacheData(subject);
        }
        boolean isNewAuth = jaspiService.isProcessingNewAuthentication(webRequest.getHttpServletRequest());
        if (!this.isJaspicForm(tokenUsage)) {
            if (!isNewAuth && this.isJaspicSessionOrJsr375Form(tokenUsage)) {
                HashMap<String, Object> requestProps = new HashMap<String, Object>();
                requestProps.put("javax.servlet.http.registerSession.subject", subject);
                webRequest.setProperties(requestProps);
            }
            authResult = jaspiService.authenticate(webRequest);
        }
        if ((result = authResult.getStatus()) != AuthResult.CONTINUE && !isNewAuth) {
            if ("BASIC".equals(authResult.getAuditAuthConfigProviderAuthType())) {
                String authHeader = webRequest.getHttpServletRequest().getHeader("Authorization");
                if (authHeader != null && authHeader.startsWith("Basic ")) {
                    String basicAuthHeader = this.decodeCookieString(authHeader.substring(6));
                    int index = basicAuthHeader.indexOf(58);
                    String uid = basicAuthHeader.substring(0, index);
                    authResult.setAuditCredValue(uid);
                }
                if (result == AuthResult.SEND_401) {
                    authResult.setAuditOutcome("challenge");
                }
            }
            if (result == AuthResult.RETURN) {
                authResult.setAuditOutcome("denied");
            }
            authResult.setAuditCredType("JASPIC");
        }
        return authResult;
    }

    /*
     * WARNING - void declaration
     */
    private AuthenticationResult authenticateForFormMechanism(WebRequest webRequest, HashMap<String, Object> props, JaspiService jaspiService) {
        AuthenticationResult authResult;
        try {
            HttpServletRequest req = webRequest.getHttpServletRequest();
            authResult = jaspiService.authenticate(req, webRequest.getHttpServletResponse(), props);
            if (authResult.getStatus() != AuthResult.CONTINUE) {
                String authHeader = webRequest.getHttpServletRequest().getHeader("Authorization");
                if (authHeader != null && authHeader.startsWith("Basic ")) {
                    String basicAuthHeader = this.decodeCookieString(authHeader.substring(6));
                    int index = basicAuthHeader.indexOf(58);
                    String uid = basicAuthHeader.substring(0, index);
                    authResult.setAuditCredValue(uid);
                } else {
                    String username = req.getParameter("j_username");
                    if (username != null) {
                        authResult.setAuditCredValue(username);
                    }
                }
                authResult.setAuditCredType("JASPIC");
                authResult.setAuditOutcome("denied");
            }
        }
        catch (Exception req) {
            void e;
            FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy", (String)"203", (Object)this, (Object[])new Object[]{webRequest, props, jaspiService});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Internal error handling JASPI request", (Object[])new Object[]{e});
            }
            authResult = new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
        }
        return authResult;
    }

    private void processAuthenticationSuccess(WebRequest webRequest, HashMap<String, Object> props, AuthenticationResult authResult) {
        Subject subject = authResult.getSubject();
        this.attemptToRestorePostParams(webRequest);
        boolean isRegisterSession = false;
        Map<String, Object> reqProps = webRequest.getProperties();
        if (reqProps != null) {
            isRegisterSession = Boolean.valueOf((String)reqProps.get("javax.servlet.http.registerSession"));
        }
        SSOCookieHelper ssoCh = this.webAppSecurityConfig.createSSOCookieHelper();
        if (isRegisterSession) {
            this.registerSession(webRequest, subject, ssoCh);
        } else {
            List<String> tokenUsage = this.getTokenUsageFromSSOToken(subject, ssoCh);
            if (this.isJaspicAttribute(tokenUsage)) {
                if (this.isFormLogin(props)) {
                    this.registerSession(webRequest, subject, ssoCh);
                } else if (!this.isJaspicSession(tokenUsage) && !this.webAppSecurityConfig.isUseLtpaSSOForJaspic()) {
                    ssoCh.createLogoutCookies(webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
                }
            } else if (!this.webAppSecurityConfig.isUseLtpaSSOForJaspic()) {
                this.attemptToRemoveLtpaToken(webRequest, props);
            }
        }
    }

    private void registerSession(final WebRequest webRequest, final Subject subject, final SSOCookieHelper ssoCh) {
        if (System.getSecurityManager() == null) {
            ssoCh.addSSOCookiesToResponse(subject, webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = 2061544974763019296L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    ssoCh.addSSOCookiesToResponse(subject, webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
                }
            });
        }
    }

    private HttpServletResponse attemptToRestorePostParams(WebRequest webRequest) {
        HttpServletResponse res = webRequest.getHttpServletResponse();
        if (!res.isCommitted()) {
            this.restorePostParams(webRequest);
        }
        return res;
    }

    protected void restorePostParams(WebRequest webRequest) {
        PostParameterHelper postParameterHelper = new PostParameterHelper(this.webAppSecurityConfig);
        postParameterHelper.restore(webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
    }

    private void attemptToRemoveLtpaToken(WebRequest webRequest, HashMap<String, Object> props) {
        HttpServletResponse res;
        SSOCookieHelper ssoCh = this.webAppSecurityConfig.createSSOCookieHelper();
        if (!this.isFormLogin(props) && !(res = webRequest.getHttpServletResponse()).isCommitted()) {
            ssoCh.removeSSOCookieFromResponse(res);
        }
    }

    @Override
    public AuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> props) throws Exception {
        WebRequestImpl webRequest = new WebRequestImpl(request, response, null, null, null, null, null);
        AuthenticationResult authResult = this.handleJaspi(webRequest, props);
        return authResult;
    }

    protected AuthenticationResult handleTAI(WebRequest webRequest, boolean beforeSSO) {
        TAIAuthenticator taiAuthenticator = this.getTaiAuthenticator();
        AuthenticationResult authResult = null;
        if (taiAuthenticator == null) {
            authResult = new AuthenticationResult(AuthResult.CONTINUE, "TAI invoke " + (beforeSSO ? "before" : "after") + " SSO is not available, skipping TAI...");
        } else {
            authResult = taiAuthenticator.authenticate(webRequest, beforeSSO);
            if (authResult.getStatus() != AuthResult.CONTINUE) {
                authResult.setAuditCredType("TrustAssociationInterceptor");
            }
        }
        return authResult;
    }

    protected AuthenticationResult handleSSO(WebRequest webRequest, String ssoCookieName) {
        WebAuthenticator authenticator = this.getSSOAuthenticator(webRequest, ssoCookieName);
        AuthenticationResult authResult = authenticator.authenticate(webRequest);
        if (authResult == null || authResult.getStatus() != AuthResult.SUCCESS) {
            authResult = new AuthenticationResult(AuthResult.CONTINUE, "SSO did not succeed, so continue ...");
        }
        return authResult;
    }

    protected boolean isNotNullAndTrue(HttpServletRequest req, String key) {
        Boolean result = (Boolean)req.getAttribute(key);
        if (result != null) {
            return result;
        }
        return false;
    }

    protected TAIAuthenticator getTaiAuthenticator() {
        TAIAuthenticator taiAuthenticator = null;
        TAIService taiService = (TAIService)this.taiServiceRef.getService();
        Iterator interceptorServices = this.interceptorServiceRef.getServices();
        if (taiService != null || interceptorServices != null && interceptorServices.hasNext()) {
            SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
            taiAuthenticator = new TAIAuthenticator(taiService, this.interceptorServiceRef, securityService.getAuthenticationService(), this.webAppSecurityConfig.createSSOCookieHelper());
        }
        return taiAuthenticator;
    }

    public WebAuthenticator getSSOAuthenticator(WebRequest webRequest, String ssoCookieName) {
        SecurityMetadata securityMetadata = webRequest.getSecurityMetadata();
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        SSOCookieHelper cookieHelper = ssoCookieName != null ? new SSOCookieHelperImpl(this.webAppSecurityConfig, ssoCookieName) : this.webAppSecurityConfig.createSSOCookieHelper();
        return new SSOAuthenticator(securityService.getAuthenticationService(), securityMetadata, this.webAppSecurityConfig, cookieHelper);
    }

    public ConcurrentServiceReferenceMap<String, WebAuthenticator> getWebAuthenticatorRefs() {
        return this.webAuthenticatorRef;
    }

    @Sensitive
    private String decodeCookieString(@Sensitive String cookieString) {
        try {
            return Base64Coder.base64Decode((String)cookieString);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy", (String)"383", (Object)this, (Object[])objectArray);
            return null;
        }
    }

    private List<String> getTokenUsageFromSSOToken(Subject subject, SSOCookieHelper ssoCh) {
        String[] attrs;
        SingleSignonToken ssoToken = ssoCh.getDefaultSSOTokenFromSubject(subject);
        if (ssoToken != null && (attrs = ssoToken.getAttributes("com.ibm.ws.authentication.internal.auth.provider")) != null) {
            return Arrays.asList(attrs);
        }
        return null;
    }

    private boolean isJaspicSessionOrJsr375Form(List<String> attrs) {
        return attrs != null && (attrs.contains("jaspic") || attrs.contains("jsr375Form"));
    }

    private boolean isJaspicSession(List<String> attrs) {
        return attrs != null && attrs.contains("jaspic");
    }

    private boolean isJaspicForm(List<String> attrs) {
        return attrs != null && attrs.contains("jaspicForm");
    }

    private boolean isJaspicAttribute(List<String> attrs) {
        return attrs != null && (attrs.contains("jaspic") || attrs.contains("jsr375Form") || attrs.contains("jaspicForm"));
    }

    private boolean isFormLogin(Map<String, Object> props) {
        return props != null && "FORM_LOGIN".equals(props.get("authType"));
    }

    /*
     * WARNING - void declaration
     */
    private void clearCacheData(Subject subject) {
        block3: {
            AuthCacheService authCacheService = ((SecurityService)this.securityServiceRef.getService()).getAuthenticationService().getAuthCacheService();
            WSCredential credential = subject.getPublicCredentials(WSCredential.class).iterator().next();
            try {
                String authUserName = credential.getRealmName() + ":" + credential.getSecurityName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Deleting cache entry of user : " + authUserName), (Object[])new Object[0]);
                }
                authCacheService.remove((Object)authUserName);
            }
            catch (Exception authUserName) {
                void e;
                FFDCFilter.processException((Throwable)authUserName, (String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy", (String)"445", (Object)this, (Object[])new Object[]{subject});
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("A cache entry cannot be deleted. An exception is caught : " + e), (Object[])new Object[0]);
            }
        }
    }
}

