/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LoggedOutJwtSsoCookieCache {
    private static ArrayList<String> clist;
    private static Set<String> cSet;
    private static int maxSize;
    private static int lastPosition;
    private static boolean atCapacity;
    private static boolean initialized;
    private static MessageDigest md;
    private static Object lock;
    static final long serialVersionUID = 445177403806943039L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private LoggedOutJwtSsoCookieCache() {
    }

    private static void init() {
        clist = new ArrayList();
        cSet = new HashSet<String>();
        lock = new Object();
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.internal.LoggedOutJwtSsoCookieCache", (String)"44", null, (Object[])new Object[0]);
        }
        initialized = true;
    }

    private static String toDigest(String input) {
        md.reset();
        try {
            md.update(input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.webcontainer.security.internal.LoggedOutJwtSsoCookieCache", (String)"54", null, (Object[])new Object[]{input});
        }
        String result = Base64Coder.base64EncodeToString((byte[])md.digest());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(String tokenString) {
        if (tokenString == null) {
            return;
        }
        if (!initialized) {
            LoggedOutJwtSsoCookieCache.init();
        }
        Object object = lock;
        synchronized (object) {
            String digest = LoggedOutJwtSsoCookieCache.toDigest(tokenString);
            if (atCapacity) {
                cSet.remove(clist.get(lastPosition));
                clist.set(lastPosition, digest);
            } else {
                clist.add(digest);
            }
            cSet.add(digest);
            if (++lastPosition >= maxSize) {
                lastPosition = 0;
                atCapacity = true;
            }
        }
    }

    static int getSetSize() {
        return cSet.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(String tokenString) {
        if (!initialized) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            return tokenString == null ? false : cSet.contains(LoggedOutJwtSsoCookieCache.toDigest(tokenString));
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LoggedOutJwtSsoCookieCache.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
        clist = null;
        cSet = null;
        maxSize = 10000;
        lastPosition = 0;
        atCapacity = false;
        initialized = false;
        md = null;
        lock = null;
    }
}

