/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.security.oauth20.provider.config"}, configurationPolicy=ConfigurationPolicy.IGNORE, service={ProvidersService.class}, immediate=true, property={"service.vendor=IBM"})
public class ProvidersService {
    private static final String KEY_ID = "id";
    private static final String KEY_OAUTH20_PROVIDER = "oauth20Provider";
    private static final ConcurrentServiceReferenceMap<String, OAuth20Provider> oauth20Providers;
    private static final ReentrantReadWriteLock reentrantReadWriteLock;
    private static final ReentrantReadWriteLock.WriteLock writeLock;
    private static final ReentrantReadWriteLock.ReadLock readLock;
    public static final String REGEX_COMPONENT_ID = "/([\\w-]+)/";
    public static final String apwPattern = "app-passwords|app-passwords/.*";
    public static final String atokPattern = "app-tokens|app-tokens/.*";
    private static final Pattern PATH_RE;
    static final long serialVersionUID = -9175403983628110340L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(name="oauth20Provider", service=OAuth20Provider.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    protected void setOAuth20Provider(ServiceReference<OAuth20Provider> ref) {
        writeLock.lock();
        try {
            oauth20Providers.putReference((Object)((String)ref.getProperty(KEY_ID)), ref);
        }
        finally {
            writeLock.unlock();
        }
    }

    protected void unsetOAuth20Provider(ServiceReference<OAuth20Provider> ref) {
        writeLock.lock();
        try {
            oauth20Providers.removeReference((Object)((String)ref.getProperty(KEY_ID)), ref);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Activate
    protected void activate(ComponentContext cc) {
        writeLock.lock();
        try {
            oauth20Providers.activate(cc);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        writeLock.lock();
        try {
            oauth20Providers.deactivate(cc);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static OAuth20Provider getOAuth20Provider(String id) {
        readLock.lock();
        try {
            OAuth20Provider provider = (OAuth20Provider)oauth20Providers.getService((Object)id);
            if (provider != null) {
                if (provider.isValid()) {
                    if (provider.getComponent() == null) {
                        provider.createCoreClasses();
                    }
                } else {
                    provider = null;
                }
            }
            OAuth20Provider oAuth20Provider = provider;
            return oAuth20Provider;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OAuth20Provider> getProvidersMatchingRequest(HttpServletRequest req) {
        readLock.lock();
        try {
            ArrayList<OAuth20Provider> providers = null;
            Iterator oauthProvidersIterator = oauth20Providers.getServices();
            while (oauthProvidersIterator.hasNext()) {
                OAuth20Provider provider = (OAuth20Provider)oauthProvidersIterator.next();
                if (!provider.isValid() || !provider.isRequestAccepted(req) && !ProvidersService.isAppPasswordOrTokenRequest(provider, req)) continue;
                if (provider.getComponent() == null) {
                    provider.createCoreClasses();
                }
                if (providers == null) {
                    providers = new ArrayList<OAuth20Provider>();
                }
                providers.add(provider);
            }
            ArrayList<OAuth20Provider> arrayList = providers;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    private static boolean isAppPasswordOrTokenRequest(OAuth20Provider provider, HttpServletRequest req) {
        OidcServerConfig oidcServerConfig;
        boolean apptokuri;
        boolean accept = false;
        boolean apppwuri = req != null && req.getRequestURI().contains("app-passwords");
        boolean bl = apptokuri = req != null && req.getRequestURI().contains("app-tokens");
        if ((apppwuri || apptokuri) && (oidcServerConfig = ConfigUtils.getOidcServerConfigForOAuth20Provider(provider.getID())) != null && oidcServerConfig.getProviderId() != null) {
            accept = ProvidersService.requestHasMatchingOidcProvider(req, oidcServerConfig.getProviderId());
        }
        return accept;
    }

    public static boolean requestHasMatchingOidcProvider(HttpServletRequest req, String oidcProviderId) {
        Matcher matcher;
        String contextPath = req.getContextPath();
        String uri = req.getRequestURI();
        if (contextPath != null && contextPath.equals("/oidc") && (matcher = ProvidersService.endpointRequest(req)) != null) {
            return oidcProviderId.equals(ProvidersService.getProviderNameFromUrl(matcher));
        }
        return false;
    }

    protected static String getProviderNameFromUrl(Matcher m) {
        String componentId = m.group(1);
        return componentId;
    }

    private static Matcher endpointRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null || path.isEmpty()) {
            return null;
        }
        Matcher m = PATH_RE.matcher(path);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProvidersService.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
        oauth20Providers = new ConcurrentServiceReferenceMap(KEY_OAUTH20_PROVIDER);
        reentrantReadWriteLock = new ReentrantReadWriteLock();
        writeLock = reentrantReadWriteLock.writeLock();
        readLock = reentrantReadWriteLock.readLock();
        PATH_RE = Pattern.compile("^/([\\w-]+)/(app-passwords|app-passwords/.*|app-tokens|app-tokens/.*)$");
    }
}

