/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.plugins.CacheEntry;
import com.ibm.ws.security.oauth20.util.BoundedCache;
import com.ibm.ws.security.oauth20.util.MessageDigestUtil;
import com.ibm.ws.security.oauth20.web.EndpointUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BaseCache
implements OAuth20EnhancedTokenCache {
    static Thread _cleanupThread;
    static Object _lock;
    Map<String, CacheEntry> _cache;
    static Map<String, List<CacheEntry>> _indexOnUsername;
    final String MYCLASS = BaseCache.class.getName();
    Logger _log = Logger.getLogger(this.MYCLASS);
    private int tokenStoreSize;
    private String accessTokenEncoding = "plain";
    private int accessTokenLength;
    static final long serialVersionUID = 4802606382240904410L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BaseCache() {
    }

    public BaseCache(int tokenStoreSize) {
        this.tokenStoreSize = tokenStoreSize;
    }

    public BaseCache(int tokenStoreSize, String accessTokenEncoding, int accessTokenLength) {
        this.tokenStoreSize = tokenStoreSize;
        this.accessTokenEncoding = accessTokenEncoding;
        this.accessTokenLength = accessTokenLength;
    }

    @Override
    public void initialize() {
        this.getCache(this.tokenStoreSize);
        BaseCache.getIndexOnUsernameCache();
        this.startCleanupThread();
    }

    @Override
    public void init(OAuthComponentConfiguration config) {
        this.getCache(config.getConfigPropertyIntValue("tokenStoreSize"));
        BaseCache.getIndexOnUsernameCache();
        this.startCleanupThread();
    }

    private synchronized void getCache(int storeSize) {
        if (this._cache == null) {
            storeSize = storeSize <= 0 ? 10 : storeSize;
            this._cache = Collections.synchronizedMap(new BoundedCache(storeSize));
        }
    }

    private static synchronized void getIndexOnUsernameCache() {
        if (_indexOnUsername == null) {
            _indexOnUsername = Collections.synchronizedMap(new BoundedCache(2000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuth20Token getByHash(String hash) {
        OAuth20Token result = null;
        Object object = _lock;
        synchronized (object) {
            CacheEntry ce = this._cache.get(hash);
            if (ce != null) {
                if (!ce.isExpired()) {
                    result = ce._token;
                } else {
                    this.removeByHash(hash);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeByHash(String hash) {
        Object object = _lock;
        synchronized (object) {
            CacheEntry ce = this._cache.remove(hash);
            List<CacheEntry> entries = null;
            if (ce != null) {
                String username = ce._token.getUsername();
                entries = _indexOnUsername.get(username);
                if (entries == null) {
                    _indexOnUsername.remove(username);
                } else {
                    entries.remove(ce);
                    if (entries.size() == 0) {
                        _indexOnUsername.remove(username);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String lookupKey, OAuth20Token entry, int lifetime) {
        boolean isAuthorizationGrantTypeAndCodeSubType;
        String hash = lookupKey;
        boolean isAppPasswordOrAppTokenGT = "app_password".equals(entry.getGrantType()) || "app_token".equals(entry.getGrantType());
        boolean bl = isAuthorizationGrantTypeAndCodeSubType = "authorization_grant".equals(entry.getType()) && "authorization_code".equals(entry.getSubType());
        hash = !(isAuthorizationGrantTypeAndCodeSubType || "plain".equals(this.accessTokenEncoding) && !isAppPasswordOrAppTokenGT) ? ("plain".equals(this.accessTokenEncoding) ? EndpointUtils.computeTokenHash(lookupKey) : EndpointUtils.computeTokenHash(lookupKey, this.accessTokenEncoding)) : MessageDigestUtil.getDigest(lookupKey);
        Object object = _lock;
        synchronized (object) {
            CacheEntry ce = new CacheEntry(entry, lifetime);
            this._cache.put(hash, ce);
            List<CacheEntry> entries = null;
            String username = entry.getUsername();
            entries = _indexOnUsername.get(username);
            if (entries == null) {
                entries = new ArrayList<CacheEntry>();
                _indexOnUsername.put(username, entries);
            }
            entries.add(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleanupThread() {
        Class<BaseCache> clazz = BaseCache.class;
        synchronized (BaseCache.class) {
            if (_cleanupThread != null) {
                ((CleanupThread)_cleanupThread).stopCleanup();
                _cleanupThread = null;
            }
            final BaseCache self = this;
            _cleanupThread = (CleanupThread)AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = 7621843589229402025L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    return new CleanupThread(self);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, null, null);
                }
            });
            _cleanupThread.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void stopCleanupThread() {
        if (_cleanupThread != null) {
            ((CleanupThread)_cleanupThread).stopCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OAuth20Token> getAllUserTokens(String username) {
        List<CacheEntry> tokens = _indexOnUsername.get(username);
        ArrayList<OAuth20Token> retVal = new ArrayList<OAuth20Token>();
        if (tokens != null) {
            Object object = _lock;
            synchronized (object) {
                for (CacheEntry ce : tokens) {
                    OAuth20Token t = ce._token;
                    if (t == null || !username.equals(t.getUsername())) continue;
                    retVal.add(t);
                }
            }
        }
        return retVal;
    }

    @Override
    public Collection<OAuth20Token> getAll() {
        ArrayList<OAuth20Token> result = new ArrayList<OAuth20Token>();
        for (CacheEntry entry : this._cache.values()) {
            result.add(entry._token);
        }
        return result;
    }

    @Override
    public OAuth20Token get(String lookupKey) {
        String hash = lookupKey;
        if (!PasswordUtil.isHashed((String)hash)) {
            hash = !"plain".equals(this.accessTokenEncoding) || lookupKey.length() == this.accessTokenLength + 2 ? ("plain".equals(this.accessTokenEncoding) ? EndpointUtils.computeTokenHash(lookupKey) : EndpointUtils.computeTokenHash(lookupKey, this.accessTokenEncoding)) : MessageDigestUtil.getDigest(lookupKey);
        }
        return this.getByHash(hash);
    }

    @Override
    public void remove(String lookupKey) {
        String hash = lookupKey;
        if (!PasswordUtil.isHashed((String)hash)) {
            hash = !"plain".equals(this.accessTokenEncoding) || lookupKey.length() == this.accessTokenLength + 2 ? ("plain".equals(this.accessTokenEncoding) ? EndpointUtils.computeTokenHash(lookupKey) : EndpointUtils.computeTokenHash(lookupKey, this.accessTokenEncoding)) : MessageDigestUtil.getDigest(lookupKey);
        }
        this.removeByHash(hash);
    }

    @Override
    public int getNumTokens(String username, String client) {
        int result = -1;
        Collection<OAuth20Token> alltokens = this.getAllUserTokens(username);
        if (alltokens != null) {
            result = 0;
            for (OAuth20Token token : alltokens) {
                if (!client.equals(token.getClientId())) continue;
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addByHash(String hash, OAuth20Token entry, int lifetime) {
        Object object = _lock;
        synchronized (object) {
            CacheEntry ce = new CacheEntry(entry, lifetime);
            this._cache.put(hash, ce);
            List<CacheEntry> entries = null;
            String username = entry.getUsername();
            entries = _indexOnUsername.get(username);
            if (entries == null) {
                entries = new ArrayList<CacheEntry>();
                _indexOnUsername.put(username, entries);
            }
            entries.add(ce);
        }
    }

    @Override
    public Collection<OAuth20Token> getMatchingTokens(String username, String client, String tokenType) {
        Collection<OAuth20Token> tokens = this.getUserAndClientTokens(username, client);
        if (tokens != null && !tokens.isEmpty()) {
            return BaseCache.getTokensMatchingType(tokens, tokenType);
        }
        return Collections.emptyList();
    }

    private static Collection<OAuth20Token> getTokensMatchingClientId(Collection<OAuth20Token> tokens, String clientId) {
        Iterator<OAuth20Token> it = tokens.iterator();
        HashSet<OAuth20Token> matchingTokens = new HashSet<OAuth20Token>();
        while (it.hasNext()) {
            OAuth20Token token = it.next();
            if (!clientId.equals(token.getClientId())) continue;
            matchingTokens.add(token);
        }
        return matchingTokens;
    }

    private static Collection<OAuth20Token> getTokensMatchingType(Collection<OAuth20Token> tokens, String stateId) {
        Iterator<OAuth20Token> it = tokens.iterator();
        HashSet<OAuth20Token> matchingTokens = new HashSet<OAuth20Token>();
        while (it.hasNext()) {
            OAuth20Token token = it.next();
            if (!token.getStateId().equals(stateId)) continue;
            matchingTokens.add(token);
        }
        return matchingTokens;
    }

    @Override
    public Collection<OAuth20Token> getUserAndClientTokens(String username, String client) {
        Collection<OAuth20Token> tokens = this.getAllUserTokens(username);
        if (tokens != null && !tokens.isEmpty()) {
            return BaseCache.getTokensMatchingClientId(tokens, client);
        }
        return Collections.emptyList();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BaseCache.class, null, null);
        _lock = new Object();
    }

    @Trivial
    class CleanupThread
    extends Thread {
        final String MYCLASS = CleanupThread.class.getName();
        static final int CLEANUP_INTERVAL_SECONDS = 120;
        Logger _log = Logger.getLogger(this.MYCLASS);
        private boolean stopped = false;
        BaseCache _me;

        public CleanupThread(BaseCache me) {
            this._me = me;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String methodName = "run";
            this._log.entering(this.MYCLASS, methodName);
            boolean finestLoggable = this._log.isLoggable(Level.FINEST);
            try {
                while (!this.stopped) {
                    Date now = new Date();
                    long nowTime = now.getTime();
                    if (finestLoggable) {
                        this._log.logp(Level.FINEST, this.MYCLASS, methodName, "About to delete all expired tokens");
                    }
                    Object object = _lock;
                    synchronized (object) {
                        Set<String> keys = this._me._cache.keySet();
                        HashSet<String> keysToRemove = new HashSet<String>();
                        Map<String, CacheEntry> map = this._me._cache;
                        synchronized (map) {
                            for (String key : keys) {
                                CacheEntry ce = this._me._cache.get(key);
                                if (!ce.isExpired()) continue;
                                keysToRemove.add(key);
                            }
                            for (String key : keysToRemove) {
                                this._me.removeByHash(key);
                            }
                        }
                    }
                    CleanupThread.sleep(120000L);
                }
            }
            catch (InterruptedException e) {
                if (finestLoggable) {
                    this._log.logp(Level.FINEST, this.MYCLASS, methodName, "Cleanup thread was interrupted");
                }
            }
            finally {
                this._log.exiting(this.MYCLASS, methodName);
            }
        }

        public void stopCleanup() {
            if (this._log.isLoggable(Level.FINEST)) {
                this._log.logp(Level.FINEST, this.MYCLASS, "stopCleanup", "stopping cleanup thread");
            }
            this.stopped = true;
        }
    }
}

