/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcBaseClientScopeReducer {
    private Set<String> scopeSet = new HashSet<String>();
    private Set<String> preAuthorizedScopeSet = new HashSet<String>();
    private static final String SPACE = " ";
    private boolean bAllScopes = false;
    private boolean bNullEmptyScope = false;
    private boolean bNullEmptyPreAuthorized = false;
    static final long serialVersionUID = -7916553698965932349L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OidcBaseClientScopeReducer(OidcBaseClient client) {
        if (client == null) {
            throw new IllegalArgumentException("OidcBaseClientScopeReducer must be instantiated with a non-null client value.");
        }
        this.bNullEmptyScope = this.setScopeSet(client.getScope(), this.scopeSet);
        this.bNullEmptyPreAuthorized = this.setScopeSet(client.getPreAuthorizedScope(), this.preAuthorizedScopeSet);
    }

    private boolean setScopeSet(String scopes, Set<String> myScopeSet) {
        String[] scopeArr;
        if (OidcOAuth20Util.isNullEmpty(scopes)) {
            return true;
        }
        String trimmedScopes = scopes.trim();
        for (String scope : scopeArr = trimmedScopes.split(SPACE)) {
            myScopeSet.add(scope);
            if (!"ALL_SCOPES".equals(scope)) continue;
            this.bAllScopes = true;
        }
        return false;
    }

    public boolean hasClientScope(String requestScope) {
        if (OidcOAuth20Util.isNullEmpty(requestScope)) {
            return false;
        }
        if (this.bAllScopes) {
            return true;
        }
        return this.scopeSet.contains(requestScope.trim());
    }

    public boolean hasClientPreAuthorizedScope(String requestScope) {
        if (OidcOAuth20Util.isNullEmpty(requestScope)) {
            return false;
        }
        if (this.hasClientScope(requestScope)) {
            return this.preAuthorizedScopeSet.contains(requestScope.trim());
        }
        return false;
    }

    public boolean isNullEmptyScope() {
        return this.bNullEmptyScope;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(OidcBaseClientScopeReducer.class, null, null);
    }
}

