/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.custom;

import com.google.gson.JsonObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.oauth20.store.OAuthConsent;
import com.ibm.websphere.security.oauth20.store.OAuthStore;
import com.ibm.websphere.security.oauth20.store.OAuthStoreException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OauthConsentStore;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OauthConsentStoreImpl
implements OauthConsentStore {
    private static TraceComponent tc = Tr.register(OauthConsentStoreImpl.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private final String componentId;
    private final OAuthStore oauthStore;
    private Timer timer;
    private long cleanupIntervalInMilliseconds = 0L;
    static final long serialVersionUID = 1289643716758690425L;

    public OauthConsentStoreImpl(String componentId, OAuthStore oauthStore, long cleanupIntervalInMilliseconds) {
        this.componentId = componentId;
        this.oauthStore = oauthStore;
        this.cleanupIntervalInMilliseconds = cleanupIntervalInMilliseconds;
    }

    @Override
    public void initialize() {
        this.scheduleCleanupTask();
    }

    private void scheduleCleanupTask() {
        if (this.cleanupIntervalInMilliseconds > 0L) {
            long period;
            CleanupTask cleanupTask = new CleanupTask();
            this.timer = new Timer(true);
            long delay = period = this.cleanupIntervalInMilliseconds;
            this.timer.schedule((TimerTask)cleanupTask, delay, period);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addConsent(String clientId, String user, String scopeAsString, String resource, String providerId, int lifetimeInSeconds) {
        block2: {
            try {
                long expires = this.getExpires(lifetimeInSeconds);
                String consentProperties = this.getConsentProperties(resource);
                OAuthConsent oauthConsent = new OAuthConsent(clientId, user, scopeAsString, resource, providerId, expires, consentProperties);
                this.oauthStore.create(oauthConsent);
            }
            catch (OAuthStoreException expires) {
                void e;
                FFDCFilter.processException((Throwable)expires, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthConsentStoreImpl", (String)"73", (Object)this, (Object[])new Object[]{clientId, user, scopeAsString, resource, providerId, lifetimeInSeconds});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block2;
                Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_CREATE_CONSENT", (Object[])new Object[]{e.getLocalizedMessage()});
            }
        }
    }

    private long getExpires(int lifetimeInSeconds) {
        long expires = 0L;
        if (lifetimeInSeconds > 0) {
            expires = new Date().getTime() + 1000L * (long)lifetimeInSeconds;
        }
        return expires;
    }

    private String getConsentProperties(String resource) {
        JsonObject extendedFields = new JsonObject();
        if (resource != null) {
            extendedFields.addProperty("resource", resource);
        } else {
            extendedFields.addProperty("", "");
        }
        return extendedFields.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean validateConsent(String clientId, String username, String providerId, String[] scopes, String resource) {
        boolean result;
        block2: {
            result = false;
            try {
                OAuthConsent oauthConsent = this.oauthStore.readConsent(providerId, username, clientId, resource);
                result = this.isValid(oauthConsent, scopes);
            }
            catch (OAuthStoreException oauthConsent) {
                void e;
                FFDCFilter.processException((Throwable)oauthConsent, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthConsentStoreImpl", (String)"106", (Object)this, (Object[])new Object[]{clientId, username, providerId, scopes, resource});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block2;
                Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_READ_CONSENT", (Object[])new Object[]{e.getLocalizedMessage()});
            }
        }
        return result;
    }

    private boolean isValid(OAuthConsent oauthConsent, String[] scopes) {
        boolean result = true;
        if (oauthConsent != null && new Date().getTime() < oauthConsent.getExpires()) {
            String scopeStr = oauthConsent.getScope();
            for (String scope : scopes) {
                if (scopeStr.contains(scope)) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void stopCleanupThread() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class CleanupTask
    extends TimerTask {
        static final long serialVersionUID = -4543118500415435299L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private CleanupTask() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            block2: {
                try {
                    OauthConsentStoreImpl.this.oauthStore.deleteConsents(OauthConsentStoreImpl.this.componentId, new Date().getTime());
                }
                catch (OAuthStoreException oAuthStoreException) {
                    void e;
                    FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthConsentStoreImpl$CleanupTask", (String)"146", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block2;
                    Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_DELETE_CONSENTS", (Object[])new Object[]{e.getLocalizedMessage()});
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CleanupTask.class, null, null);
        }
    }
}

