/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.jose4j;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.plugins.jose4j.CauseMsg;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JWTTokenException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(JWTTokenException.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private static final long serialVersionUID = 1L;
    String message = null;
    JWTTokenException childException = null;
    String msgKey = null;
    Object[] objs = new Object[0];
    boolean bFfdcAlready = false;

    private JWTTokenException(boolean bTrError, String msgKey, Object[] objs) {
        super("access_denied", msgKey, null);
        this.msgKey = msgKey;
        this.objs = objs;
        if (objs != null) {
            for (int iI = 0; iI < objs.length; ++iI) {
                if (!(objs[iI] instanceof Throwable)) continue;
                if (objs[iI] instanceof JWTTokenException) {
                    this.childException = (JWTTokenException)objs[iI];
                    continue;
                }
                objs[iI] = new CauseMsg((Throwable)objs[iI]);
            }
        }
        if (bTrError) {
            this.handleTrError();
        }
    }

    @Trivial
    public static JWTTokenException newInstance(boolean parent, String msgKey, Object[] objs) {
        JWTTokenException result = new JWTTokenException(parent, msgKey, objs);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("newInstance JWTTokenException:" + result), (Object[])new Object[0]);
        }
        return result;
    }

    void handleTrError() {
        if (this.childException != null && this.msgKey.equals(this.childException.getMsgKey())) {
            this.childException.handleTrError();
        } else {
            Tr.error((TraceComponent)tc, (String)this.msgKey, (Object[])this.objs);
        }
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        if (this.childException != null && this.msgKey.equals(this.childException.getMsgKey())) {
            return this.childException.getMessage();
        }
        if (this.message == null && this.msgKey != null) {
            this.message = Tr.formatMessage((TraceComponent)tc, (String)this.msgKey, (Object[])this.objs);
        }
        if (this.message != null) {
            return this.message;
        }
        return this.getClass().getName();
    }

    public JWTTokenException(String message) {
        super("access_denied", message, null);
        this.message = message;
    }

    public JWTTokenException(String message, Exception e) {
        super("access_denied", message, e);
        if (tc.isDebugEnabled() && e != null) {
            Tr.debug((TraceComponent)tc, (String)"Exception:", (Object[])new Object[]{e});
        }
        this.message = message;
    }

    Exception getChildException() {
        return this.childException;
    }

    String getMsgKey() {
        return this.msgKey;
    }

    public void handleFfdc() {
        if (!this.bFfdcAlready) {
            FFDCFilter.processException((Throwable)this, (String)"com.ibm.oauth.core.api.error.oauth20.OAuth20Exception", (String)"78758", (Object)this);
            this.bFfdcAlready = true;
        }
    }
}

