/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class TemplateRetriever {
    private static final String CLASS = TemplateRetriever.class.getName();
    private static com.ibm.ejs.ras.TraceComponent tc = Tr.register(TemplateRetriever.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEADER_CONTENT_LANGUAGE = "Content-Language";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static Map<String, Item> templateCache = Collections.synchronizedMap(new HashMap());
    public static final int dftTemplateLifeTime;
    private static int lifetime;
    private static int templateConnectTimeMillis;
    private static int templateReadTimeMillis;
    private static int templateCount;
    private static Semaphore semaphore;
    static final long serialVersionUID = 2558685130068362401L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public TemplateRetriever(OAuth20Provider provider) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)new Object[]{provider});
        }
        if (semaphore == null) {
            semaphore = new Semaphore(templateCount);
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public TemplateRetriever() {
        this(null);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Item getTemplate(String templateUrl, String acceptLanguage) throws IOException {
        String methodName = "getTemplate";
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)new Object[]{templateUrl, acceptLanguage});
        }
        String key = this.getKey(templateUrl, this.getLanguage(acceptLanguage));
        Item retVal = templateCache.get(key);
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("retrieve template from cache: " + retVal));
        }
        if (retVal != null && tc.isDebugEnabled()) {
            Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("template will expire at " + new Date(retVal.getExpriation())));
        }
        if (retVal == null || retVal.getExpriation() < System.currentTimeMillis()) {
            Map<String, Item> map = templateCache;
            synchronized (map) {
                retVal = templateCache.get(templateUrl);
                if (retVal == null || retVal.getExpriation() < System.currentTimeMillis()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("retrive form template from " + templateUrl));
                    }
                    if ((retVal = this.getTemplateFromRemote(templateUrl, acceptLanguage)).getLanguage() != null) {
                        key = this.getKey(templateUrl, retVal.getLanguage());
                    }
                    templateCache.put(key, retVal);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)retVal);
        }
        return retVal;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected URLConnection getConnection(URL url) throws IOException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getConnection", (Object)new Object[]{url});
        }
        if (url.getProtocol().contains("https")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("Protocol: " + url.getProtocol()));
            }
            HttpsURLConnection conns = (HttpsURLConnection)url.openConnection();
            SSLSocketFactory factory = null;
            try {
                JSSEHelper jsseHelper = JSSEHelper.getInstance();
                SSLContext context = jsseHelper.getSSLContext(null, null, null);
                factory = context.getSocketFactory();
            }
            catch (Exception jsseHelper) {
                void e;
                FFDCFilter.processException((Throwable)jsseHelper, (String)"com.ibm.ws.security.oauth20.util.TemplateRetriever", (String)"116", (Object)this, (Object[])new Object[]{url});
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("Failed to get SSL socket factory for connection to OP server, exception [" + e.getMessage() + "]"));
                }
                throw new IOException(e.getMessage(), (Throwable)e);
            }
            conns.setSSLSocketFactory(factory);
            HttpsURLConnection httpsURLConnection = conns;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                httpsURLConnection = httpsURLConnection;
                Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getConnection", (Object)httpsURLConnection);
            }
            return httpsURLConnection;
        }
        URLConnection uRLConnection = url.openConnection();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            uRLConnection = uRLConnection;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getConnection", (Object)uRLConnection);
        }
        return uRLConnection;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Item getTemplateFromRemote(String templateUrl, String acceptLanguage) throws IOException {
        String methodName = "getTemplateFromRemote";
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)new Object[]{templateUrl, acceptLanguage});
        }
        URL url = new URL(templateUrl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        URLConnection conn = this.getConnection(url);
        if (acceptLanguage != null) {
            conn.setRequestProperty(HEADER_ACCEPT_LANGUAGE, acceptLanguage);
        }
        conn.setConnectTimeout(templateConnectTimeMillis);
        conn.setReadTimeout(templateReadTimeMillis);
        InputStream is = conn.getInputStream();
        byte[] buf = new byte[4096];
        int count = -1;
        while ((count = is.read(buf)) != -1) {
            baos.write(buf, 0, count);
        }
        is.close();
        baos.close();
        String contentLanguage = conn.getHeaderField(HEADER_CONTENT_LANGUAGE);
        String contentType = conn.getHeaderField(HEADER_CONTENT_TYPE);
        Item retVal = new Item(baos.toByteArray(), this.getLanguage(contentLanguage), contentType, lifetime);
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("retrieved template lang=" + contentLanguage + " ,type=" + contentType + " len=" + retVal.getContentLength()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)retVal);
        }
        return retVal;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private String getKey(String templateUrl, String language) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getKey", (Object)new Object[]{templateUrl, language});
        }
        StringBuilder sb = new StringBuilder();
        sb.append(templateUrl);
        if (language != null) {
            sb.append("@").append(language);
        }
        String string = sb.toString();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getKey", (Object)string);
        }
        return string;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private String getLanguage(String languageHeader) {
        String methodName = "getLanguage";
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)new Object[]{languageHeader});
        }
        String retVal = null;
        if (languageHeader != null) {
            String[] langs = languageHeader.split(",");
            String[] parts = langs[0].split(";");
            retVal = parts[0].trim().toLowerCase();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, retVal);
        }
        return retVal;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static String normallizeTemplateUrl(HttpServletRequest request, String templateUrl) {
        String retVal;
        String methodName = "normallizeTemplateUrl";
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)new Object[]{templateUrl});
        }
        if (!((retVal = templateUrl) == null || "".equals(retVal.trim()) || retVal.startsWith("http://") || retVal.startsWith("https://"))) {
            String contextPath = request.getContextPath();
            String requestUrl = request.getRequestURL().toString();
            int pos = requestUrl.indexOf(contextPath);
            retVal = retVal.startsWith("/") ? requestUrl.substring(0, pos) + retVal : requestUrl.substring(0, pos) + contextPath + "/" + retVal;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)retVal);
        }
        return retVal;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    static {
        lifetime = dftTemplateLifeTime = Integer.parseInt(System.getProperty(CLASS + ".defaultTemplateLifetime", "600"));
        templateConnectTimeMillis = Integer.parseInt(System.getProperty(CLASS + ".defaultTemplateConnectTimeMillis", "12000"));
        templateReadTimeMillis = Integer.parseInt(System.getProperty(CLASS + ".defaultTemplateReadTimeMillis", "12000"));
        templateCount = Integer.parseInt(System.getProperty(CLASS + ".defaultTemplateCount", "3"));
        semaphore = null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Item {
        private final byte[] content;
        private final long expiration;
        private final String language;
        private final String contentType;
        static final long serialVersionUID = -2814693314723174267L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Item(byte[] content, String language, String contentType, int lifetimeInSecond) {
            this.content = content;
            this.language = language;
            this.expiration = System.currentTimeMillis() + (long)(lifetimeInSecond * 1000);
            this.contentType = contentType;
        }

        public Item(byte[] content, String contentType) {
            this.content = (byte[])content.clone();
            this.contentType = contentType;
            this.language = null;
            this.expiration = 0L;
        }

        public byte[] getContent() {
            return (byte[])this.content.clone();
        }

        public long getExpriation() {
            return this.expiration;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getContentType() {
            return this.contentType;
        }

        public int getContentLength() {
            return this.content.length;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register(Item.class, null, null);
        }
    }
}

