/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.internal.OAuthUtil;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20Client;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClientSerializer;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator;
import com.ibm.ws.security.oauth20.util.Base64;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.AbstractOidcEndpointServices;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RegistrationEndpointServices
extends AbstractOidcEndpointServices {
    private static final int DEFAULT_CLIENT_SECRET_LENGTH = 60;
    public static final String ROLE_REQUIRED = "clientManager";
    public static final String UNAUTHORIZED_HEADER_VALUE = "Basic realm=\"clientManager\"";
    protected static final String MESSAGE_BUNDLE = "com.ibm.ws.security.oauth20.internal.resources.OAuthMessages";
    private static TraceComponent tc = Tr.register(RegistrationEndpointServices.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final String REGEX_REGISTRATION_CLIENTID = "^/([\\w-]+)/registration(/\\S*)?$";
    public static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(OidcBaseClient.class, (Object)new OidcBaseClientSerializer()).create();
    static final long serialVersionUID = -2436181126238739822L;

    protected RegistrationEndpointServices() {
    }

    protected void handleEndpointRequest(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws OidcServerException, IOException {
        if (request.getMethod().equalsIgnoreCase("GET") || request.getMethod().equalsIgnoreCase("HEAD")) {
            this.processHeadOrGet(provider, request, response);
        } else if (request.getMethod().equalsIgnoreCase("POST")) {
            this.processPost(provider, request, response);
        } else if (request.getMethod().equalsIgnoreCase("PUT")) {
            this.processPut(provider, request, response);
        } else if (request.getMethod().equalsIgnoreCase("DELETE")) {
            this.processDelete(provider, request, response);
        } else {
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_UNSUPPORTED_METHOD", (Object[])new Object[]{request.getMethod(), "Registration Endpoint Service"}, (String)"CWWKS1433E: The HTTP method {0} is not supported for the service {1}.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "server_error", 405);
        }
    }

    private void processHeadOrGet(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws OidcServerException, IOException {
        RegistrationEndpointServices.validateJsonAcceptable(request);
        OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
        String clientId = this.extractClientId(request.getPathInfo());
        if (!OidcOAuth20Util.isNullEmpty(clientId)) {
            this.processHeadOrGetSingleClient(clientId, clientProvider, request, response);
        } else {
            this.processHeadOrGetAllClients(clientProvider, request, response);
        }
    }

    private void processHeadOrGetSingleClient(String clientId, OidcOAuth20ClientProvider clientProvider, HttpServletRequest request, HttpServletResponse response) throws IOException, OidcServerException {
        OidcBaseClient client = clientProvider.get(clientId);
        if (client == null) {
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_CLIENTID_NOT_FOUND", (Object[])new Object[]{clientId}, (String)"CWWKS1424E: The client id {0} was not found.");
            Tr.warning((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_client", 404);
        }
        RegistrationEndpointServices.omitEmptyArrays(client);
        String eTag = this.computeETag(client);
        RegistrationEndpointServices.processClientRegistationUri(client, request);
        this.setCommonResponseHeaders(eTag, response, true);
        OidcServerException preconditionException = RegistrationEndpointServices.checkConditionalExecution(request, true, true, eTag, null);
        if (preconditionException != null) {
            response.setStatus(preconditionException.getHttpStatus());
            response.flushBuffer();
            return;
        }
        if (request.getMethod().equalsIgnoreCase("GET")) {
            RegistrationEndpointServices.decodeClientName(client);
            byte[] b = GSON.toJson((Object)client).toString().getBytes("UTF-8");
            response.getOutputStream().write(b);
        }
        response.setStatus(200);
        response.flushBuffer();
    }

    private void processHeadOrGetAllClients(OidcOAuth20ClientProvider clientProvider, HttpServletRequest request, HttpServletResponse response) throws IOException, OidcServerException {
        JsonArray clientsAsJSON = GSON.toJsonTree(clientProvider.getAll(request)).getAsJsonArray();
        RegistrationEndpointServices.omitEmptyArrays(clientsAsJSON);
        String eTag = this.computeETag(clientsAsJSON);
        this.setCommonResponseHeaders(eTag, response, true);
        OidcServerException preconditionException = RegistrationEndpointServices.checkConditionalExecution(request, true, true, eTag, null);
        if (preconditionException != null) {
            response.setStatus(preconditionException.getHttpStatus());
            response.flushBuffer();
            return;
        }
        response.setStatus(200);
        if (request.getMethod().equalsIgnoreCase("GET")) {
            JsonObject responseBody = new JsonObject();
            responseBody.add("data", GSON.toJsonTree((Object)clientsAsJSON));
            response.getOutputStream().write(responseBody.toString().getBytes("UTF-8"));
        }
        response.flushBuffer();
    }

    private void processPost(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws OidcServerException, IOException {
        RegistrationEndpointServices.validateJsonAcceptable(request);
        RegistrationEndpointServices.validateContentType(request, "application/json");
        String clientId = this.extractClientId(request.getPathInfo());
        if (!OidcOAuth20Util.isNullEmpty(clientId)) {
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_INVALID_REQUEST_PATH", null, (String)"CWWKS1425E: The registration request was made to an incorrect URI.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_request", 400);
        }
        OidcBaseClient newClient = this.getOidcBaseClientFromRequestBody(request);
        if (newClient == null) {
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_REGISTRATION_REQUEST_MISSING_CLIENT", null, (String)"CWWKS1463E: The OpenID Connect registration request does not contain a client. Ensure that the request body is not empty and contains a client encoded in JSON format.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_request", 400);
        }
        OidcBaseClient validatedClient = OidcBaseClientValidator.getInstance(newClient).validateCreateUpdate();
        OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
        this.processClientId(validatedClient, clientProvider);
        this.processClientName(validatedClient);
        this.processNewClientSecret(validatedClient);
        RegistrationEndpointServices.processClientRegistationUri(validatedClient, request);
        OidcBaseClient savedClientWithDefaults = OidcBaseClientValidator.getInstance(clientProvider.put(validatedClient)).setDefaultsForOmitted();
        RegistrationEndpointServices.decodeClientName(savedClientWithDefaults);
        RegistrationEndpointServices.omitEmptyArrays(savedClientWithDefaults);
        this.setCommonResponseHeaders(this.computeETag(savedClientWithDefaults), response, true);
        byte[] b = OidcOAuth20Util.GSON_RAW.toJson((Object)savedClientWithDefaults).toString().getBytes("UTF-8");
        response.getOutputStream().write(b);
        response.setStatus(201);
        response.flushBuffer();
    }

    private void processPut(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws OidcServerException, IOException {
        RegistrationEndpointServices.validateJsonAcceptable(request);
        RegistrationEndpointServices.validateContentType(request, "application/json");
        String clientId = this.validateRequestContainsClientId(request);
        OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
        OidcOAuth20Client existingClient = this.validateClientIdExists(clientId, clientProvider);
        OidcBaseClient newClient = this.getOidcBaseClientFromRequestBody(request);
        newClient.setClientId(clientId);
        OidcBaseClient validatedClient = OidcBaseClientValidator.getInstance(newClient).validateCreateUpdate();
        this.copyExistingOutputParams(validatedClient, existingClient);
        this.processClientName(validatedClient);
        ClientSecretAction clientSecretAction = this.processUpdateClientSecret(validatedClient, existingClient);
        String tmpNewSecret = null;
        if (clientSecretAction == ClientSecretAction.NEW) {
            tmpNewSecret = validatedClient.getClientSecret();
            validatedClient.setClientSecret(PasswordUtil.passwordEncode((String)tmpNewSecret));
        }
        RegistrationEndpointServices.processClientRegistationUri(validatedClient, request);
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        RegistrationEndpointServices.omitEmptyArrays((OidcBaseClient)existingClient);
        String currEtag = this.computeETag((OidcBaseClient)existingClient);
        OidcServerException preconditionException = RegistrationEndpointServices.checkConditionalExecution(request, false, true, currEtag, null);
        if (preconditionException == null) {
            OidcBaseClient savedClientWithDefaults = OidcBaseClientValidator.getInstance(clientProvider.update(validatedClient)).setDefaultsForOmitted();
            RegistrationEndpointServices.omitEmptyArrays(savedClientWithDefaults);
            String eTag = this.computeETag(savedClientWithDefaults);
            response.addHeader("ETag", String.format("\"%s\"", eTag));
            RegistrationEndpointServices.decodeClientName(savedClientWithDefaults);
            if (clientSecretAction == ClientSecretAction.RETAIN && !OidcOAuth20Util.isNullEmpty(savedClientWithDefaults.getClientSecret())) {
                byte[] b = GSON.toJson((Object)savedClientWithDefaults).toString().getBytes("UTF-8");
                response.getOutputStream().write(b);
            } else {
                savedClientWithDefaults.setClientSecret(tmpNewSecret);
                byte[] b = OidcOAuth20Util.GSON_RAW.toJson((Object)savedClientWithDefaults).toString().getBytes("UTF-8");
                response.getOutputStream().write(b);
            }
            response.setStatus(200);
        } else {
            if (preconditionException.isComplete()) {
                throw preconditionException;
            }
            response.setStatus(preconditionException.getHttpStatus());
        }
        response.flushBuffer();
    }

    private void processDelete(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws IOException, OidcServerException {
        String clientId = this.extractClientId(request.getPathInfo());
        if (OidcOAuth20Util.isNullEmpty(clientId)) {
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_MISSING_CLIENTID", (Object[])new Object[]{request.getMethod(), "client_id"}, (String)"CWWKS1426E: The {0} operation failed as the request did not contain the {1} parameter.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_request", 400);
        }
        OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
        OidcBaseClient currClient = clientProvider.get(clientId);
        if (currClient == null) {
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_INVALID_CLIENTID", (Object[])new Object[]{request.getMethod(), "client_id", clientId}, (String)"CWWKS1427E: The {0} operation failed as the request contains an invalid {1} parameter {2}.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_client", 404);
        }
        RegistrationEndpointServices.omitEmptyArrays(currClient);
        String eTag = this.computeETag(currClient);
        OidcServerException preconditionException = RegistrationEndpointServices.checkConditionalExecution(request, false, true, eTag, null);
        if (preconditionException != null) {
            response.setStatus(preconditionException.getHttpStatus());
            response.flushBuffer();
            return;
        }
        clientProvider.delete(clientId);
        response.setStatus(204);
        response.flushBuffer();
    }

    /*
     * WARNING - void declaration
     */
    private OidcBaseClient getOidcBaseClientFromRequestBody(HttpServletRequest request) throws IOException, OidcServerException {
        try {
            return (OidcBaseClient)GSON.fromJson((Reader)request.getReader(), OidcBaseClient.class);
        }
        catch (JsonParseException jsonParseException) {
            void e;
            FFDCFilter.processException((Throwable)jsonParseException, (String)"com.ibm.ws.security.oauth20.web.RegistrationEndpointServices", (String)"442", (Object)this, (Object[])new Object[]{request});
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_MALFORMED_REQUEST", null, (String)"CWWKS1428E: The request body is malformed.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)e.getLocalizedMessage(), (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_client_metadata", 400);
        }
    }

    private String extractClientId(String pathInfo) {
        String clientId;
        Pattern PATH_RE = Pattern.compile(REGEX_REGISTRATION_CLIENTID);
        Matcher m = PATH_RE.matcher(pathInfo);
        if (m.matches() && (clientId = m.group(2)) != null) {
            return RegistrationEndpointServices.trimSlashes(clientId);
        }
        return null;
    }

    private void processClientId(OidcBaseClient client, OidcOAuth20ClientProvider clientProvider) throws OidcServerException {
        String clientId = client.getClientId();
        if (!OidcOAuth20Util.isNullEmpty(clientId)) {
            if (clientProvider.exists(clientId)) {
                String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_CLIENTID_EXISTS", (Object[])new Object[]{clientId}, (String)"CWWKS1429E: Client id {0} already exists.");
                Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
                throw new OidcServerException(errorMsg, "invalid_client_metadata", 400);
            }
        } else {
            String generatedClientId = RegistrationEndpointServices.generateUUID();
            while (clientProvider.exists(generatedClientId)) {
                generatedClientId = RegistrationEndpointServices.generateUUID();
            }
            client.setClientId(generatedClientId);
        }
        client.setClientIdIssuedAt(System.currentTimeMillis() / 1000L);
    }

    private void processClientName(OidcBaseClient client) {
        String clientId = client.getClientId();
        if (OidcOAuth20Util.isNullEmpty(client.getClientName()) && !OidcOAuth20Util.isNullEmpty(clientId)) {
            client.setClientName(clientId);
        } else {
            RegistrationEndpointServices.encodeClientName(client);
        }
    }

    private void processNewClientSecret(OidcBaseClient client) throws OidcServerException {
        if ((OidcOAuth20Util.isNullEmpty(client.getTokenEndpointAuthMethod()) || client.getTokenEndpointAuthMethod().equals("client_secret_basic") || client.getTokenEndpointAuthMethod().equals("client_secret_post")) && OidcOAuth20Util.isNullEmpty(client.getClientSecret())) {
            client.setClientSecret(OAuthUtil.getRandom(60));
            return;
        }
        if (!OidcOAuth20Util.isNullEmpty(client.getTokenEndpointAuthMethod()) && client.getTokenEndpointAuthMethod().equals("none") && !OidcOAuth20Util.isNullEmpty(client.getClientSecret())) {
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_PUBLIC_CLIENT_CREATE_FAILURE", null, (String)"CWWKS1438E: Creation of the client fails.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_client_metadata", 400);
        }
    }

    private ClientSecretAction processUpdateClientSecret(OidcBaseClient incomingClient, OidcOAuth20Client existingClient) throws OidcServerException {
        ClientSecretAction action = null;
        action = OidcOAuth20Util.isNullEmpty(incomingClient.getClientSecret()) ? this.setSecretAndGetActionForEmptyUpdatedClientSecret(incomingClient, existingClient) : this.setSecretAndGetActionForNonEmptyUpdatedClientSecret(incomingClient, existingClient);
        if (action == null) {
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_INVALID_CONFIG", null, (String)"CWWKS1432E: An update of the client fails.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_client_metadata", 500);
        }
        return action;
    }

    private ClientSecretAction setSecretAndGetActionForEmptyUpdatedClientSecret(OidcBaseClient incomingClient, OidcOAuth20Client existingClient) {
        ClientSecretAction action = null;
        if (OidcOAuth20Util.isNullEmpty(incomingClient.getTokenEndpointAuthMethod()) || incomingClient.getTokenEndpointAuthMethod().equals("client_secret_basic") || incomingClient.getTokenEndpointAuthMethod().equals("client_secret_post")) {
            action = ClientSecretAction.NEW;
            incomingClient.setClientSecret(OAuthUtil.getRandom(60));
        } else if (incomingClient.getTokenEndpointAuthMethod().equals("none")) {
            action = !OidcOAuth20Util.isNullEmpty(existingClient.getClientSecret()) ? ClientSecretAction.CLEAR : ClientSecretAction.RETAIN;
        }
        return action;
    }

    private ClientSecretAction setSecretAndGetActionForNonEmptyUpdatedClientSecret(OidcBaseClient incomingClient, OidcOAuth20Client existingClient) throws OidcServerException {
        ClientSecretAction action = null;
        if (OidcOAuth20Util.isNullEmpty(incomingClient.getTokenEndpointAuthMethod()) || incomingClient.getTokenEndpointAuthMethod().equals("client_secret_basic") || incomingClient.getTokenEndpointAuthMethod().equals("client_secret_post")) {
            if (incomingClient.getClientSecret().equals("*")) {
                if (OidcOAuth20Util.isNullEmpty(existingClient.getClientSecret())) {
                    String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_CLIENT_SECRET_UPDATE_FAILURE", null, (String)"CWWKS1430E: An update of the client fails.");
                    Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
                    throw new OidcServerException(errorMsg, "invalid_client_metadata", 400);
                }
                action = ClientSecretAction.RETAIN;
                incomingClient.setClientSecret(existingClient.getClientSecret());
            } else {
                action = ClientSecretAction.NEW;
            }
        } else if (incomingClient.getTokenEndpointAuthMethod().equals("none")) {
            action = this.getActionForNonEmptyClientSecretForTokenEndptAuthMethodNone(incomingClient, existingClient);
        }
        return action;
    }

    private ClientSecretAction getActionForNonEmptyClientSecretForTokenEndptAuthMethodNone(OidcBaseClient incomingClient, OidcOAuth20Client existingClient) throws OidcServerException {
        ClientSecretAction action = null;
        if (incomingClient.getClientSecret().equals("*")) {
            if (!OidcOAuth20Util.isNullEmpty(existingClient.getClientSecret())) {
                this.throwErrorForInvalidPublicClientUpdate();
            } else {
                action = ClientSecretAction.RETAIN;
                incomingClient.setClientSecret(existingClient.getClientSecret());
            }
        } else {
            this.throwErrorForInvalidPublicClientUpdate();
        }
        return action;
    }

    private void throwErrorForInvalidPublicClientUpdate() throws OidcServerException {
        String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_PUBLIC_CLIENT_UPDATE_FAILURE", null, (String)"CWWKS1431E: An update of the client fails.");
        Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
        throw new OidcServerException(errorMsg, "invalid_client_metadata", 400);
    }

    public static void processClientRegistationUri(OidcOAuth20Client client, HttpServletRequest request) {
        String registrationClientUri = RegistrationEndpointServices.computeRegistrationUri(request, client.getClientId());
        client.setRegistrationClientUri(registrationClientUri);
    }

    private static String computeRegistrationUri(HttpServletRequest request, String registeredId) {
        String registrationUri = RegistrationEndpointServices.trimTrailingSlash(request.getRequestURL().toString());
        if (!registrationUri.endsWith(registeredId)) {
            registrationUri = registrationUri + "/" + registeredId;
        }
        return registrationUri;
    }

    private OidcOAuth20Client validateClientIdExists(String clientId, OidcOAuth20ClientProvider clientProvider) throws OidcServerException {
        OidcBaseClient client = clientProvider.get(clientId);
        if (client == null) {
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_CLIENTID_NOT_FOUND", (Object[])new Object[]{clientId}, (String)"CWWKS1424E: The client id {0} was not found.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_client", 404);
        }
        return client;
    }

    private String validateRequestContainsClientId(HttpServletRequest request) throws OidcServerException {
        String clientId = this.extractClientId(request.getPathInfo());
        if (OidcOAuth20Util.isNullEmpty(clientId)) {
            String errorMsg = TraceNLS.getFormattedMessage(RegistrationEndpointServices.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_MISSING_CLIENTID", (Object[])new Object[]{request.getMethod(), "client_id"}, (String)"CWWKS1426E: The {0} operation failed as the request did not contain the {1} parameter.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_request", 400);
        }
        return clientId;
    }

    private void copyExistingOutputParams(OidcBaseClient newClient, OidcOAuth20Client existingClient) {
        newClient.setClientIdIssuedAt(existingClient.getClientIdIssuedAt());
        newClient.setClientSecretExpiresAt(existingClient.getClientSecretExpiresAt());
    }

    private String computeETag(OidcBaseClient client) throws IOException {
        JsonArray clientArray = new JsonArray();
        clientArray.add((JsonElement)OidcOAuth20Util.getJsonObj(client));
        String eTag = this.computeETag(clientArray);
        return eTag;
    }

    /*
     * WARNING - void declaration
     */
    private String computeETag(JsonArray results) throws IOException {
        MessageDigest digest;
        Comparator<JsonObject> comparator = new Comparator<JsonObject>(){
            static final long serialVersionUID = 8729864700888484025L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(JsonObject object1, JsonObject object2) {
                String name1 = object1.get("client_id").getAsString();
                String name2 = object2.get("client_id").getAsString();
                return name1.compareTo(name2);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
            }
        };
        List<JsonObject> list = OidcOAuth20Util.getListOfJsonObjects(results);
        Collections.sort(list, comparator);
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.oauth20.web.RegistrationEndpointServices", (String)"725", (Object)this, (Object[])new Object[]{results});
            throw new RuntimeException((Throwable)e);
        }
        for (JsonObject object : list) {
            String tmpRegistrationUri = null;
            JsonElement registrationClientUriEle = object.get("registration_client_uri");
            if (registrationClientUriEle != null && !registrationClientUriEle.getAsString().isEmpty()) {
                tmpRegistrationUri = registrationClientUriEle.getAsString();
                object.remove("registration_client_uri");
            }
            String tmpClientSecret = null;
            JsonElement clientSecretEle = object.get("client_secret");
            if (clientSecretEle != null && !clientSecretEle.getAsString().isEmpty()) {
                tmpClientSecret = clientSecretEle.getAsString();
                object.remove("client_secret");
            }
            StringWriter writer = new StringWriter();
            new Gson().toJson((JsonElement)object, (Appendable)writer);
            digest.update(Base64Coder.getBytes((String)writer.toString()));
            if (tmpRegistrationUri != null) {
                object.add("registration_client_uri", (JsonElement)new JsonPrimitive(tmpRegistrationUri));
            }
            if (tmpClientSecret == null) continue;
            object.add("client_secret", (JsonElement)new JsonPrimitive(tmpClientSecret));
        }
        byte[] digestBytes = digest.digest();
        return Base64.encode(digestBytes);
    }

    private void setCommonResponseHeaders(String eTag, HttpServletResponse response, boolean setContentType) {
        response.setHeader("Cache-Control", "private");
        if (!OidcOAuth20Util.isNullEmpty(eTag)) {
            response.addHeader("ETag", String.format("\"%s\"", eTag));
        }
        if (setContentType) {
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
        }
    }

    public static void omitEmptyArrays(JsonArray clients) {
        if (clients == null || clients.size() == 0) {
            return;
        }
        List<JsonObject> clientObjs = OidcOAuth20Util.getListOfJsonObjects(clients);
        if (clientObjs == null || clientObjs.size() == 0) {
            return;
        }
        for (JsonObject clientObj : clientObjs) {
            OidcBaseClient client = (OidcBaseClient)GSON.fromJson((JsonElement)clientObj, OidcBaseClient.class);
            if (OidcOAuth20Util.isNullEmpty(client.getRedirectUris())) {
                clientObj.remove("redirect_uris");
            }
            if (OidcOAuth20Util.isNullEmpty(client.getPostLogoutRedirectUris())) {
                clientObj.remove("post_logout_redirect_uris");
            }
            if (OidcOAuth20Util.isNullEmpty(client.getTrustedUriPrefixes())) {
                clientObj.remove("trusted_uri_prefixes");
            }
            if (!OidcOAuth20Util.isNullEmpty(client.getFunctionalUserGroupIds())) continue;
            clientObj.remove("functional_user_groupIds");
        }
    }

    public static void omitEmptyArrays(OidcBaseClient client) {
        if (client == null) {
            return;
        }
        if (OidcOAuth20Util.isNullEmpty(client.getRedirectUris())) {
            client.setRedirectUris(null);
        }
        if (OidcOAuth20Util.isNullEmpty(client.getPostLogoutRedirectUris())) {
            client.setPostLogoutRedirectUris(null);
        }
        if (OidcOAuth20Util.isNullEmpty(client.getTrustedUriPrefixes())) {
            client.setTrustedUriPrefixes(null);
        }
        if (OidcOAuth20Util.isNullEmpty(client.getFunctionalUserGroupIds())) {
            client.setFunctionalUserGroupIds(null);
        }
    }

    private static void decodeClientNames(JsonArray clients) {
        if (clients == null || clients.size() == 0) {
            return;
        }
        List<JsonObject> clientObjs = OidcOAuth20Util.getListOfJsonObjects(clients);
        if (clientObjs == null || clientObjs.size() == 0) {
            return;
        }
        for (JsonObject clientObj : clientObjs) {
            OidcBaseClient client = (OidcBaseClient)GSON.fromJson((JsonElement)clientObj, OidcBaseClient.class);
            RegistrationEndpointServices.decodeClientName(client);
        }
    }

    private static void encodeClientName(OidcBaseClient client) {
        if (client.getClientName() != null) {
            client.setClientName(WebUtils.encode(client.getClientName(), null, "UTF-8"));
        }
    }

    private static void decodeClientName(OidcBaseClient client) {
        try {
            if (client.getClientName() != null) {
                client.setClientName(URLDecoder.decode(client.getClientName(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.web.RegistrationEndpointServices", (String)"868", null, (Object[])new Object[]{client});
        }
    }

    private static enum ClientSecretAction {
        NEW,
        RETAIN,
        CLEAR;

    }
}

