/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.mp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.ContextualAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import java.util.ArrayList;
import java.util.concurrent.Callable;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ContextualCallable<T>
implements Callable<T>,
ContextualAction<Callable<T>> {
    private final Callable<T> action;
    private final ThreadContextDescriptor threadContextDescriptor;
    static final long serialVersionUID = -8514008350776037333L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ContextualCallable(ThreadContextDescriptor threadContextDescriptor, Callable<T> action) {
        this.action = action;
        this.threadContextDescriptor = threadContextDescriptor;
    }

    @Override
    public T call() throws Exception {
        ArrayList contextApplied = this.threadContextDescriptor.taskStarting();
        try {
            T t = this.action.call();
            return t;
        }
        finally {
            this.threadContextDescriptor.taskStopping(contextApplied);
        }
    }

    @Trivial
    public Callable<T> getAction() {
        return this.action;
    }

    @Trivial
    public ThreadContextDescriptor getContextDescriptor() {
        return this.threadContextDescriptor;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ContextualCallable.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.mp.resources.CWWKCMessages");
    }
}

