/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.mp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.concurrent.mp.ManagedCompletableFuture;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import java.util.ArrayList;
import java.util.function.Supplier;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ContextualSupplierAction<T>
implements Runnable {
    private final Supplier<T> action;
    private final ManagedCompletableFuture<T> completableFuture;
    private final boolean superComplete;
    private final ThreadContextDescriptor threadContextDescriptor;
    static final long serialVersionUID = -197449292268471153L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ContextualSupplierAction(ThreadContextDescriptor threadContextDescriptor, Supplier<T> action, ManagedCompletableFuture<T> completableFuture, boolean superComplete) {
        this.action = action;
        this.completableFuture = completableFuture;
        this.superComplete = superComplete;
        this.threadContextDescriptor = threadContextDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @FFDCIgnore(value={Error.class, RuntimeException.class})
    public void run() {
        Object result = null;
        Throwable failure = null;
        ArrayList contextApplied = null;
        try {
            if (this.threadContextDescriptor != null) {
                contextApplied = this.threadContextDescriptor.taskStarting();
            }
            result = this.action.get();
            return;
        }
        catch (RuntimeException x) {
            failure = x;
            throw x;
        }
        catch (Error x) {
            failure = x;
            throw x;
        }
        finally {
            try {
                if (contextApplied != null) {
                    this.threadContextDescriptor.taskStopping(contextApplied);
                }
            }
            catch (RuntimeException x) {
                failure = x;
                throw x;
            }
            finally {
                if (failure == null) {
                    if (this.superComplete) {
                        this.completableFuture.super_complete(result);
                    } else {
                        this.completableFuture.complete(result);
                    }
                } else if (this.superComplete) {
                    this.completableFuture.super_completeExceptionally(failure);
                } else {
                    this.completableFuture.completeExceptionally(failure);
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ContextualSupplierAction.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.mp.resources.CWWKCMessages");
    }
}

