/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.encryption;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
final class AuditCrypto {
    private static TraceComponent tc;
    private static final String CRYPTO_ALGORITHM = "RSA";
    private static final String ENCRYPT_ALGORITHM = "DESede";
    private static final String CIPHER = "DESede/ECB/PKCS5Padding";
    private static IvParameterSpec ivs8;
    private static IvParameterSpec ivs16;
    private static SecureRandom random;
    private static double[] ETB;
    private static int slot;
    private static int channels;
    private static int[] samples;
    private static int[] ones;
    private static int[] block;
    private static byte[] seed;
    private static int ri;
    private static boolean seedInitialized;
    static int trMix;
    private static final byte[] Pmd2;
    private static final int[] PC;
    private static final int[] SP0;
    private static final int[] SP1;
    private static final HashMap bigIntegerMap;
    private static final HashMap bigIntegerInverseMap;
    protected static final HashMap rsaKeysMap;
    protected static final HashMap cryptoKeysMap;
    protected static final HashMap verifyKeysMap;
    static final Comparator cachingVerifyKeyComparator;
    static final Comparator cachingKeyComparator;
    static final int MAX_CACHE = 2000;
    static String[][] rsaKeyMaterial;
    static String[][] dsaKeyMaterial;
    static byte[][][] rsaKeys;
    static byte[][][] dsaKeys;
    static final long serialVersionUID = -7162683437668739858L;

    AuditCrypto() {
    }

    static final boolean cmp(byte[] b1, int off1, byte[] b2, int off2, int n) {
        while (--n >= 0) {
            if (b1[off1++] == b2[off2++]) continue;
            return false;
        }
        return true;
    }

    static final int msbf(byte[] data, int off, int n) {
        int v = 0;
        do {
            v |= (data[off++] & 0xFF) << --n * 8;
        } while (n > 0);
        return v;
    }

    static final int msbf2(byte[] data, int i) {
        return (data[i] & 0xFF) << 8 | data[i + 1] & 0xFF;
    }

    static final void msbf(int v, byte[] data, int off, int n) {
        do {
            data[off++] = (byte)(v >>> --n * 8);
        } while (n > 0);
    }

    static final void msbf4(int v, byte[] data, int i) {
        data[i] = (byte)(v >>> 24);
        data[i + 1] = (byte)(v >>> 16);
        data[i + 2] = (byte)(v >>> 8);
        data[i + 3] = (byte)v;
    }

    static final void msbf2(int v, byte[] data, int i) {
        data[i] = (byte)(v >>> 8);
        data[i + 1] = (byte)v;
    }

    static final int lsbf(byte[] data, int i, int n) {
        int v = 0;
        do {
            v |= (data[i + --n] & 0xFF) << n * 8;
        } while (n > 0);
        return v;
    }

    static final int lsbf4(byte[] data, int i) {
        return data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
    }

    static final void lsbf4(int v, byte[] data, int i) {
        data[i] = (byte)v;
        data[i + 1] = (byte)(v >>> 8);
        data[i + 2] = (byte)(v >>> 16);
        data[i + 3] = (byte)(v >>> 24);
    }

    static void lsbf2(int v, byte[] data, int i) {
        data[i] = (byte)v;
        data[i + 1] = (byte)(v >>> 8);
    }

    static final void trng(byte[] to, int off, int len) {
        long accu = 0L;
        int bits = 0;
        while (len-- > 0) {
            while (bits < 8) {
                int s = 0;
                do {
                    long t = System.currentTimeMillis();
                    while (System.currentTimeMillis() == t) {
                        ++s;
                    }
                } while (s == 0);
                int xor = samples[slot] ^ s;
                AuditCrypto.samples[AuditCrypto.slot] = s;
                int i = 0;
                int m = 1;
                do {
                    if ((xor & m) != 0) {
                        int n = i;
                        ones[n] = ones[n] + ((s & m) != 0 ? 1 : -1);
                        channels ^= m;
                    }
                    int n = i;
                    block[n] = block[n] - 1;
                    if (block[n] == 0) {
                        accu = accu << 1 | (long)((channels & m) != 0 ? 1 : 0);
                        ++bits;
                    }
                    if (block[i] <= 0) {
                        int j;
                        for (j = 0; j < 16 && !(Math.abs(0.5 - (double)ones[i] / 56.0) <= ETB[j]); ++j) {
                        }
                        AuditCrypto.block[i] = j == 16 ? -1 : j + 1;
                    }
                    m <<= 1;
                } while (++i < 16);
                slot = (slot + 1) % 56;
            }
            to[off++] = (byte)(accu >>> (bits -= 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void random(byte[] to, int off, int n) {
        if (!seedInitialized) {
            AuditCrypto.trng(seed, 0, 32);
            AuditCrypto.md5(null, seed, 0, 32, seed, 0);
            rsaKeys = new byte[4][][];
            int i = 0;
            int j = 0;
            while (i < rsaKeyMaterial.length) {
                AuditCrypto.rsaKeys[j] = new byte[8][];
                AuditCrypto.rsaKeys[j][2] = new BigInteger(rsaKeyMaterial[i][2], 36).toByteArray();
                AuditCrypto.rsaKeys[j][3] = new BigInteger(rsaKeyMaterial[i][0], 36).toByteArray();
                AuditCrypto.rsaKeys[j][4] = new BigInteger(rsaKeyMaterial[i][1], 36).toByteArray();
                AuditCrypto.setRSAKey(rsaKeys[j]);
                AuditCrypto.rsaKeys[j + 1] = new byte[][]{rsaKeys[j][0], rsaKeys[j][2]};
                ++i;
                j += 2;
            }
            dsaKeys = new byte[4][4][];
            i = 0;
            j = 0;
            while (i < dsaKeyMaterial.length) {
                for (int k = 0; k < 3; ++k) {
                    byte[] byArray = new BigInteger(dsaKeyMaterial[i][k], 36).toByteArray();
                    AuditCrypto.dsaKeys[j + 1][k] = byArray;
                    AuditCrypto.dsaKeys[j][k] = byArray;
                }
                AuditCrypto.dsaKeys[j][3] = new BigInteger(dsaKeyMaterial[i][3], 36).toByteArray();
                AuditCrypto.dsaKeys[j + 1][3] = new BigInteger(dsaKeyMaterial[i][4], 36).toByteArray();
                ++i;
                j += 2;
            }
            seedInitialized = true;
        }
        byte[] byArray = seed;
        synchronized (seed) {
            for (int i = 0; i < n; ++i) {
                int ri8 = ++ri % 8;
                if (ri % trMix == 0) {
                    byte b = seed[ri8];
                    AuditCrypto.trng(seed, ri8, 1);
                    int n2 = ri8;
                    seed[n2] = (byte)(seed[n2] ^ b);
                }
                if (ri8 == 0) {
                    AuditCrypto.md5(null, seed, 0, 32, seed, 0);
                }
                to[off++] = seed[ri8];
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    static final void sha(int[] state, byte[] data, int off, int len, byte[] to, int pos) {
        int A = 1732584193;
        int B = -271733879;
        int C = -1732584194;
        int D = 271733878;
        int E = -1009589776;
        int[] W = new int[80];
        int n = len / 4;
        boolean done = false;
        boolean padded = false;
        do {
            int X;
            int i;
            for (i = 0; i < 16 && n > 0; ++i) {
                W[i] = data[off + 3] & 0xFF | (data[off + 2] & 0xFF) << 8 | (data[off + 1] & 0xFF) << 16 | data[off] << 24;
                --n;
                off += 4;
            }
            if (i < 16) {
                if (!padded) {
                    X = len % 4;
                    int n2 = W[i++] = X != 0 ? AuditCrypto.msbf(data, off, X) << (4 - X) * 8 | 1 << 31 - X * 8 : Integer.MIN_VALUE;
                    if (i == 15) {
                        W[15] = 0;
                    }
                    padded = true;
                }
                if (i <= 14) {
                    while (i < 14) {
                        W[i++] = 0;
                    }
                    if (state != null) {
                        len += state[5];
                    }
                    W[14] = len >>> 29;
                    W[15] = len << 3;
                    done = true;
                }
                i = 16;
            }
            do {
                X = W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16];
                W[i] = X << 1 | X >>> 31;
            } while (++i < 80);
            int A0 = A;
            int B0 = B;
            int C0 = C;
            int D0 = D;
            int E0 = E;
            i = 0;
            do {
                X = (A << 5 | A >>> 27) + (B & C | ~B & D) + E + W[i] + 1518500249;
                E = D;
                D = C;
                C = B << 30 | B >>> 2;
                B = A;
                A = X;
            } while (++i < 20);
            do {
                X = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + W[i] + 1859775393;
                E = D;
                D = C;
                C = B << 30 | B >>> 2;
                B = A;
                A = X;
            } while (++i < 40);
            do {
                X = (A << 5 | A >>> 27) + (B & C | (B | C) & D) + E + W[i] + -1894007588;
                E = D;
                D = C;
                C = B << 30 | B >>> 2;
                B = A;
                A = X;
            } while (++i < 60);
            do {
                X = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + W[i] + -899497514;
                E = D;
                D = C;
                C = B << 30 | B >>> 2;
                B = A;
                A = X;
            } while (++i < 80);
            A += A0;
            B += B0;
            C += C0;
            D += D0;
            E += E0;
        } while (!done);
        AuditCrypto.msbf4(A, to, pos);
        AuditCrypto.msbf4(B, to, pos + 4);
        AuditCrypto.msbf4(C, to, pos + 8);
        AuditCrypto.msbf4(D, to, pos + 12);
        AuditCrypto.msbf4(E, to, pos + 16);
    }

    private static final int FF(int a, int b, int c, int d, int x, int l, int r, int ac) {
        return ((a += (b & c | ~b & d) + x + ac) << l | a >>> r) + b;
    }

    private static final int GG(int a, int b, int c, int d, int x, int l, int r, int ac) {
        return ((a += (b & d | c & ~d) + x + ac) << l | a >>> r) + b;
    }

    private static final int HH(int a, int b, int c, int d, int x, int l, int r, int ac) {
        return ((a += (b ^ c ^ d) + x + ac) << l | a >>> r) + b;
    }

    private static final int II(int a, int b, int c, int d, int x, int l, int r, int ac) {
        return ((a += (c ^ (b | ~d)) + x + ac) << l | a >>> r) + b;
    }

    static final void md5(int[] state, byte[] data, int off, int len, byte[] to, int pos) {
        int a = 1732584193;
        int b = -271733879;
        int c = -1732584194;
        int d = 271733878;
        int n = len / 4;
        int[] W = new int[16];
        boolean done = false;
        boolean padded = false;
        do {
            int a0;
            int i = 0;
            while (i < 16 && n > 0) {
                W[i++] = AuditCrypto.lsbf4(data, off);
                --n;
                off += 4;
            }
            if (i < 16) {
                if (!padded) {
                    a0 = len % 4;
                    int n2 = W[i++] = a0 != 0 ? AuditCrypto.lsbf(data, off, a0) | 128 << a0 * 8 : 128;
                    if (i == 15) {
                        W[15] = 0;
                    }
                    padded = true;
                }
                if (i <= 14) {
                    while (i < 14) {
                        W[i++] = 0;
                    }
                    if (state != null) {
                        len += state[5];
                    }
                    W[14] = len << 3;
                    W[15] = len >>> 29;
                    done = true;
                }
            }
            a0 = a;
            int W0 = W[0];
            a = AuditCrypto.FF(a0, b, c, d, W0, 7, 25, -680876936);
            int d0 = d;
            int W1 = W[1];
            d = AuditCrypto.FF(d0, a, b, c, W1, 12, 20, -389564586);
            int c0 = c;
            int W2 = W[2];
            c = AuditCrypto.FF(c0, d, a, b, W2, 17, 15, 606105819);
            int b0 = b;
            int W3 = W[3];
            b = AuditCrypto.FF(b0, c, d, a, W3, 22, 10, -1044525330);
            int W4 = W[4];
            a = AuditCrypto.FF(a, b, c, d, W4, 7, 25, -176418897);
            int W5 = W[5];
            d = AuditCrypto.FF(d, a, b, c, W5, 12, 20, 1200080426);
            int W6 = W[6];
            c = AuditCrypto.FF(c, d, a, b, W6, 17, 15, -1473231341);
            int W7 = W[7];
            b = AuditCrypto.FF(b, c, d, a, W7, 22, 10, -45705983);
            int W8 = W[8];
            a = AuditCrypto.FF(a, b, c, d, W8, 7, 25, 1770035416);
            int W9 = W[9];
            d = AuditCrypto.FF(d, a, b, c, W9, 12, 20, -1958414417);
            int W10 = W[10];
            c = AuditCrypto.FF(c, d, a, b, W10, 17, 15, -42063);
            int W11 = W[11];
            b = AuditCrypto.FF(b, c, d, a, W11, 22, 10, -1990404162);
            int W12 = W[12];
            a = AuditCrypto.FF(a, b, c, d, W12, 7, 25, 1804603682);
            int W13 = W[13];
            d = AuditCrypto.FF(d, a, b, c, W13, 12, 20, -40341101);
            int W14 = W[14];
            c = AuditCrypto.FF(c, d, a, b, W14, 17, 15, -1502002290);
            int W15 = W[15];
            b = AuditCrypto.FF(b, c, d, a, W15, 22, 10, 1236535329);
            a = AuditCrypto.GG(a, b, c, d, W1, 5, 27, -165796510);
            d = AuditCrypto.GG(d, a, b, c, W6, 9, 23, -1069501632);
            c = AuditCrypto.GG(c, d, a, b, W11, 14, 18, 643717713);
            b = AuditCrypto.GG(b, c, d, a, W0, 20, 12, -373897302);
            a = AuditCrypto.GG(a, b, c, d, W5, 5, 27, -701558691);
            d = AuditCrypto.GG(d, a, b, c, W10, 9, 23, 38016083);
            c = AuditCrypto.GG(c, d, a, b, W15, 14, 18, -660478335);
            b = AuditCrypto.GG(b, c, d, a, W4, 20, 12, -405537848);
            a = AuditCrypto.GG(a, b, c, d, W9, 5, 27, 568446438);
            d = AuditCrypto.GG(d, a, b, c, W14, 9, 23, -1019803690);
            c = AuditCrypto.GG(c, d, a, b, W3, 14, 18, -187363961);
            b = AuditCrypto.GG(b, c, d, a, W8, 20, 12, 1163531501);
            a = AuditCrypto.GG(a, b, c, d, W13, 5, 27, -1444681467);
            d = AuditCrypto.GG(d, a, b, c, W2, 9, 23, -51403784);
            c = AuditCrypto.GG(c, d, a, b, W7, 14, 18, 1735328473);
            b = AuditCrypto.GG(b, c, d, a, W12, 20, 12, -1926607734);
            a = AuditCrypto.HH(a, b, c, d, W5, 4, 28, -378558);
            d = AuditCrypto.HH(d, a, b, c, W8, 11, 21, -2022574463);
            c = AuditCrypto.HH(c, d, a, b, W11, 16, 16, 1839030562);
            b = AuditCrypto.HH(b, c, d, a, W14, 23, 9, -35309556);
            a = AuditCrypto.HH(a, b, c, d, W1, 4, 28, -1530992060);
            d = AuditCrypto.HH(d, a, b, c, W4, 11, 21, 1272893353);
            c = AuditCrypto.HH(c, d, a, b, W7, 16, 16, -155497632);
            b = AuditCrypto.HH(b, c, d, a, W10, 23, 9, -1094730640);
            a = AuditCrypto.HH(a, b, c, d, W13, 4, 28, 681279174);
            d = AuditCrypto.HH(d, a, b, c, W0, 11, 21, -358537222);
            c = AuditCrypto.HH(c, d, a, b, W3, 16, 16, -722521979);
            b = AuditCrypto.HH(b, c, d, a, W6, 23, 9, 76029189);
            a = AuditCrypto.HH(a, b, c, d, W9, 4, 28, -640364487);
            d = AuditCrypto.HH(d, a, b, c, W12, 11, 21, -421815835);
            c = AuditCrypto.HH(c, d, a, b, W15, 16, 16, 530742520);
            b = AuditCrypto.HH(b, c, d, a, W2, 23, 9, -995338651);
            a = AuditCrypto.II(a, b, c, d, W0, 6, 26, -198630844);
            d = AuditCrypto.II(d, a, b, c, W7, 10, 22, 1126891415);
            c = AuditCrypto.II(c, d, a, b, W14, 15, 17, -1416354905);
            b = AuditCrypto.II(b, c, d, a, W5, 21, 11, -57434055);
            a = AuditCrypto.II(a, b, c, d, W12, 6, 26, 1700485571);
            d = AuditCrypto.II(d, a, b, c, W3, 10, 22, -1894986606);
            c = AuditCrypto.II(c, d, a, b, W10, 15, 17, -1051523);
            b = AuditCrypto.II(b, c, d, a, W1, 21, 11, -2054922799);
            a = AuditCrypto.II(a, b, c, d, W8, 6, 26, 1873313359);
            d = AuditCrypto.II(d, a, b, c, W15, 10, 22, -30611744);
            c = AuditCrypto.II(c, d, a, b, W6, 15, 17, -1560198380);
            b = AuditCrypto.II(b, c, d, a, W13, 21, 11, 1309151649);
            a = AuditCrypto.II(a, b, c, d, W4, 6, 26, -145523070);
            d = AuditCrypto.II(d, a, b, c, W11, 10, 22, -1120210379);
            c = AuditCrypto.II(c, d, a, b, W2, 15, 17, 718787259);
            b = AuditCrypto.II(b, c, d, a, W9, 21, 11, -343485551) + b0;
            a += a0;
            c += c0;
            d += d0;
        } while (!done);
        AuditCrypto.lsbf4(a, to, pos);
        AuditCrypto.lsbf4(b, to, pos + 4);
        AuditCrypto.lsbf4(c, to, pos + 8);
        AuditCrypto.lsbf4(d, to, pos + 12);
    }

    static final void md2(byte[][] state, byte[] data, int off, int len, byte[] to, int pos) {
        byte[] p = Pmd2;
        byte f = 0;
        byte[] C = new byte[16];
        byte[] X = new byte[48];
        do {
            byte t = C[15];
            int i = 0;
            do {
                if (len > 0) {
                    f = data[off++];
                    --len;
                } else if (len == 0) {
                    f = (byte)(16 - i);
                    --len;
                } else if (len == -2) {
                    f = C[i];
                }
                byte by = f;
                X[i + 16] = by;
                X[i + 32] = (byte)(X[i] ^ by);
                int n = i++;
                byte by2 = (byte)(C[n] ^ p[(f ^ t) & 0xFF]);
                C[n] = by2;
                t = by2;
            } while (i < 16);
            if (len <= 0) {
                --len;
            }
            t = 0;
            i = 0;
            do {
                int j = 0;
                do {
                    int n = j++;
                    byte by = (byte)(X[n] ^ p[t & 0xFF]);
                    X[n] = by;
                    t = by;
                } while (j < 48);
                t = (byte)(t + i);
            } while (++i < 18);
        } while (len > -3);
        System.arraycopy(X, 0, to, pos, 16);
    }

    static final byte[] rc4key(byte[] rawKey, int off, int len) {
        byte[] S = new byte[258];
        int i = 0;
        int j = 0;
        do {
            S[i] = (byte)i;
        } while (++i < 256);
        i = 0;
        do {
            j = j + S[i] + rawKey[(i + off) % len] & 0xFF;
            byte a = S[i];
            S[i] = S[j];
            S[j] = a;
        } while (++i < 256);
        return S;
    }

    static final void rc4(byte[] key, byte[] data, int off, int len, byte[] to, int pos) {
        if ((len += off) == off) {
            return;
        }
        int Si = key[256] & 0xFF;
        int Sj = key[257] & 0xFF;
        if (off == pos) {
            do {
                Si = Si + 1 & 0xFF;
                byte a = key[Si];
                Sj = Sj + a & 0xFF;
                byte b = key[Sj];
                key[Sj] = a;
                key[Si] = b;
                to[off] = (byte)(data[off] ^ key[key[Sj] + key[Si] & 0xFF]);
            } while (++off < len);
        } else {
            do {
                Si = Si + 1 & 0xFF;
                byte a = key[Si];
                Sj = Sj + a & 0xFF;
                byte b = key[Sj];
                int n = pos++;
                key[Sj] = a;
                key[Si] = b;
                to[n] = (byte)(data[off] ^ key[key[Sj] + key[Si] & 0xFF]);
            } while (++off < len);
        }
        key[256] = (byte)Si;
        key[257] = (byte)Sj;
    }

    static final int[] desKey(boolean encrypt, byte[] rawKey, int off, int len) {
        int[] pc = PC;
        int[] key = new int[len * 4];
        int n = 0;
        boolean e = encrypt;
        do {
            int c = AuditCrypto.lsbf4(rawKey, off + n);
            int d = AuditCrypto.lsbf4(rawKey, off + n + 4);
            int t = (d >>> 4 ^ c) & 0xF0F0F0F;
            c ^= t;
            d ^= t << 4;
            t = (c << 18 ^ c) & 0xCCCC0000;
            c ^= t ^ t >>> 18;
            t = (d << 18 ^ d) & 0xCCCC0000;
            d ^= t ^ t >>> 18;
            t = (d >>> 1 ^ c) & 0x55555555;
            c ^= t;
            d ^= t << 1;
            t = (c >>> 8 ^ d) & 0xFF00FF;
            d ^= t;
            c ^= t << 8;
            t = (d >>> 1 ^ c) & 0x55555555;
            d ^= t << 1;
            d = d << 16 & 0xFF0000 | d & 0xFF00 | d >> 16 & 0xFF | (c ^= t) >> 4 & 0xF000000;
            c &= 0xFFFFFFF;
            int i = 0;
            do {
                int a = (32508 >> i & 1) == 1 ? 2 : 1;
                c = (c >>> a | c << 28 - a) & 0xFFFFFFF;
                int s = pc[c & 0x3F] | pc[0x40 | c >> 6 & 3 | c >> 7 & 0x3C] | pc[0x80 | c >> 13 & 0xF | c >> 14 & 0x30] | pc[0xC0 | c >> 20 & 1 | c >> 21 & 6 | c >> 22 & 0x38];
                d = (d >>> a | d << 28 - a) & 0xFFFFFFF;
                t = pc[0x100 | d & 0x3F] | pc[0x140 | d >> 7 & 3 | d >> 8 & 0x3C] | pc[0x180 | d >> 15 & 0x3F] | pc[0x1C0 | d >> 21 & 0xF | d >> 22 & 0x30];
                int j = (encrypt ? n : len - n - 8) * 4 + (e ? i : 15 - i) * 2;
                key[j] = t << 16 | s & 0xFFFF;
                s = s >>> 16 | t & 0xFFFF0000;
                key[j + 1] = s << 4 | s >>> 28;
            } while (++i < 16);
            e ^= true;
        } while ((n += 8) < len);
        return key;
    }

    static final void des(boolean encrypt, int[] key, byte[] iv, byte[] data, int off, int len, byte[] to, int pos) {
        int[] sp0 = SP0;
        int[] sp1 = SP1;
        int il = 0;
        int ir = 0;
        int al = 0;
        int ar = 0;
        int K = key.length;
        if (iv != null) {
            il = AuditCrypto.lsbf4(iv, 0);
            ir = AuditCrypto.lsbf4(iv, 4);
        }
        len += off;
        while (off < len) {
            int l = AuditCrypto.lsbf4(data, off);
            int r = AuditCrypto.lsbf4(data, off + 4);
            off += 8;
            if (iv != null) {
                if (encrypt) {
                    l ^= il;
                    r ^= ir;
                } else {
                    al = l;
                    ar = r;
                }
            }
            int t = (r >>> 4 ^ l) & 0xF0F0F0F;
            l ^= t;
            r ^= t << 4;
            t = (l >>> 16 ^ r) & 0xFFFF;
            r ^= t;
            l ^= t << 16;
            t = (r >>> 2 ^ l) & 0x33333333;
            l ^= t;
            r ^= t << 2;
            t = (l >>> 8 ^ r) & 0xFF00FF;
            r ^= t;
            l ^= t << 8;
            t = (r >>> 1 ^ l) & 0x55555555;
            int u = (r ^= t << 1) << 1 | r >>> 31;
            r = (l ^= t) << 1 | l >>> 31;
            int k = 32;
            while (true) {
                l = u;
                int i = k - 32;
                do {
                    u = r ^ key[i + 1];
                    t = u >>> 4 | u << 28 | 0xC040C040;
                    u = r ^ key[i] | 0x80008000;
                    l ^= sp0[t & 0x7F] | sp0[t >>> 8 & 0xFF] | sp1[t >>> 16 & 0x7F] | sp1[t >>> 24] | sp0[u & 0x3F] | sp0[u >>> 8 & 0xBF] | sp1[u >>> 16 & 0x3F] | sp1[u >>> 24 & 0xBF];
                    u = l ^ key[i + 3];
                    t = u >>> 4 | u << 28 | 0xC040C040;
                    u = l ^ key[i + 2] | 0x80008000;
                    r ^= sp0[t & 0x7F] | sp0[t >>> 8 & 0xFF] | sp1[t >>> 16 & 0x7F] | sp1[t >>> 24] | sp0[u & 0x3F] | sp0[u >>> 8 & 0xBF] | sp1[u >>> 16 & 0x3F] | sp1[u >>> 24 & 0xBF];
                } while ((i += 4) < k);
                if ((k += 32) > K) break;
                u = r;
                r = l;
            }
            l = l >>> 1 | l << 31;
            r = r >>> 1 | r << 31;
            t = (r >>> 1 ^ l) & 0x55555555;
            l ^= t;
            r ^= t << 1;
            t = (l >>> 8 ^ r) & 0xFF00FF;
            r ^= t;
            l ^= t << 8;
            t = (r >>> 2 ^ l) & 0x33333333;
            l ^= t;
            r ^= t << 2;
            t = (l >>> 16 ^ r) & 0xFFFF;
            r ^= t;
            l ^= t << 16;
            t = (r >>> 4 ^ l) & 0xF0F0F0F;
            l ^= t;
            r ^= t << 4;
            if (iv != null) {
                if (encrypt) {
                    il = l;
                    ir = r;
                } else {
                    l ^= il;
                    r ^= ir;
                    il = al;
                    ir = ar;
                }
            }
            if (to == null) continue;
            AuditCrypto.lsbf4(l, to, pos);
            AuditCrypto.lsbf4(r, to, pos + 4);
            pos += 8;
        }
        if (iv != null) {
            AuditCrypto.lsbf4(il, iv, 0);
            AuditCrypto.lsbf4(ir, iv, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final byte[] rsa(boolean padData, int padType, byte[][] key, byte[] data, int off, int len) {
        BigInteger b;
        byte[] buf;
        int l;
        int i;
        CachingKey ck = new CachingKey(key, data, off, len, padData);
        CachingKey result = (CachingKey)rsaKeysMap.get(ck);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("size:" + rsaKeysMap.size()), (Object[])new Object[0]);
        }
        if (result != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("rsa.caching successful:" + result.hashcode), (Object[])new Object[0]);
            }
            ++result.successfulUses;
            result.reused = true;
            return result.result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rsa.caching failed:" + ck.hashcode), (Object[])new Object[0]);
        }
        if (rsaKeysMap.size() > 2000) {
            HashMap hashMap = rsaKeysMap;
            synchronized (hashMap) {
                int i2;
                CachingKey[] keys = rsaKeysMap.keySet().toArray(new CachingKey[rsaKeysMap.size()]);
                Arrays.sort(keys, cachingKeyComparator);
                if (cachingKeyComparator.compare(keys[0], keys[keys.length - 1]) < 0) {
                    for (i2 = 0; i2 < 400; ++i2) {
                        rsaKeysMap.remove(keys[i2]);
                        --keys[i2 + 400].successfulUses;
                        --keys[i2 + 800].successfulUses;
                        --keys[i2 + 1200].successfulUses;
                        --keys[i2 + 1600].successfulUses;
                    }
                } else {
                    for (i2 = 0; i2 < 400; ++i2) {
                        rsaKeysMap.remove(keys[keys.length - 1 - i2]);
                        --keys[keys.length - 1 - i2 - 400].successfulUses;
                        --keys[keys.length - 1 - i2 - 800].successfulUses;
                        --keys[keys.length - 1 - i2 - 1200].successfulUses;
                        --keys[keys.length - 1 - i2 - 1600].successfulUses;
                    }
                }
            }
        }
        byte[] ret = null;
        int kl = key.length;
        BigInteger[] k = new BigInteger[kl];
        if (kl == 8) {
            i = 3;
            l = kl;
            if (padType == 3) {
                k[0] = new BigInteger(key[0]);
            }
        } else {
            i = 0;
            l = 2;
        }
        do {
            k[i] = new BigInteger(key[i]);
        } while (++i < l);
        int mlb = i == 2 ? k[0].bitLength() : k[3].bitLength() + k[4].bitLength();
        int ml = (mlb + 7) / 8;
        if (padType != 3 || !padData && padType == 3) {
            buf = new byte[ml + 1];
            System.arraycopy(data, off, buf, ml + 1 - len, len);
            if (padData && padType != 0) {
                l = ml - len - 3;
                Random rand = null;
                buf[2] = (byte)padType;
                if (buf[2] == 2) {
                    rand = new Random(System.currentTimeMillis() ^ (long)data.hashCode() ^ (long)l);
                }
                int a = -1;
                i = 3;
                while (l-- > 0) {
                    if (padType == 2) {
                        byte by;
                        do {
                            by = (byte)rand.nextInt();
                            a = by;
                        } while (by == 0);
                    }
                    buf[i++] = a;
                }
            }
            b = new BigInteger(buf);
        } else {
            buf = AuditCrypto.padISO9796(data, off, len, mlb);
            if (buf == null) {
                return null;
            }
            b = new BigInteger(1, buf);
        }
        if (kl > 3) {
            BigInteger m1 = b.remainder(k[3]).modPow(k[5], k[3]);
            BigInteger m2 = b.remainder(k[4]).modPow(k[6], k[4]);
            b = m1.add(k[3]).subtract(m2).multiply(k[7]).remainder(k[3]).multiply(k[4]).add(m2);
        } else {
            b = b.modPow(k[1], k[0]);
        }
        if (padType == 3 && (!padData && !b.remainder(BigInteger.valueOf(16L)).equals(BigInteger.valueOf(6L)) || padData && b.multiply(BigInteger.valueOf(2L)).compareTo(k[0]) == 1)) {
            b = k[0].subtract(b);
        }
        buf = b.toByteArray();
        kl = 0;
        if (padData || padType == 3) {
            l = ml;
            i = buf.length - l;
            if (i == 0) {
                return buf;
            }
            if (i < 0) {
                kl = -i;
                i = 0;
            }
        } else if (padType == 0) {
            i = buf[0] == 0 && buf.length > 1 ? 1 : 0;
            l = buf.length - i;
        } else if (buf[0] == padType) {
            i = 1;
            while (i < buf.length && buf[i++] != 0) {
            }
            l = buf.length - i;
            if (l == 0) {
                return null;
            }
        } else {
            return null;
        }
        ret = new byte[l];
        System.arraycopy(buf, i, ret, kl, l - kl);
        HashMap hashMap = rsaKeysMap;
        synchronized (hashMap) {
            rsaKeysMap.put(ck, ck);
            ck.result = ret;
            ck.successfulUses = 0L;
        }
        return ret;
    }

    static final byte[] signISO9796(byte[][] key, byte[] data, int off, int len) {
        return AuditCrypto.signISO9796(key, data, off, len, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static final byte[] signISO9796(byte[][] key, byte[] data, int off, int len, boolean useJCE) {
        CachingKey ck;
        CachingKey result;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("crypto.map.size=" + cryptoKeysMap.size()), (Object[])new Object[0]);
        }
        if ((result = (CachingKey)cryptoKeysMap.get(ck = new CachingKey(key, data, off, len, useJCE))) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("crypto.caching successful:" + result.hashcode), (Object[])new Object[0]);
            }
            ++result.successfulUses;
            result.reused = true;
            return result.result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("crypto.caching failed:" + ck.hashcode), (Object[])new Object[0]);
        }
        if (cryptoKeysMap.size() > 2000) {
            HashMap hashMap = cryptoKeysMap;
            synchronized (hashMap) {
                int i;
                CachingKey[] keys = cryptoKeysMap.keySet().toArray(new CachingKey[cryptoKeysMap.size()]);
                Arrays.sort(keys, cachingKeyComparator);
                if (cachingKeyComparator.compare(keys[0], keys[keys.length - 1]) < 0) {
                    for (i = 0; i < 400; ++i) {
                        cryptoKeysMap.remove(keys[i]);
                        --keys[i + 400].successfulUses;
                        --keys[i + 800].successfulUses;
                        --keys[i + 1200].successfulUses;
                        --keys[i + 1600].successfulUses;
                    }
                } else {
                    for (i = 0; i < 400; ++i) {
                        cryptoKeysMap.remove(keys[keys.length - 1 - i]);
                        --keys[keys.length - 1 - i - 400].successfulUses;
                        --keys[keys.length - 1 - i - 800].successfulUses;
                        --keys[keys.length - 1 - i - 1200].successfulUses;
                        --keys[keys.length - 1 - i - 1600].successfulUses;
                    }
                }
            }
        }
        byte[] sig = null;
        if (useJCE) {
            try {
                BigInteger n = new BigInteger(key[0]);
                BigInteger e = new BigInteger(key[2]);
                BigInteger p = new BigInteger(key[3]);
                BigInteger q = new BigInteger(key[4]);
                BigInteger d = e.modInverse(p.subtract(BigInteger.ONE).multiply(q.subtract(BigInteger.ONE)));
                KeyFactory kFact = null;
                kFact = KeyFactory.getInstance(CRYPTO_ALGORITHM);
                RSAPrivateKeySpec privKeySpec = new RSAPrivateKeySpec(n, d);
                PrivateKey privKey = kFact.generatePrivate(privKeySpec);
                Signature rsaSig = null;
                rsaSig = Signature.getInstance("SHA256withRSA");
                rsaSig.initSign(privKey);
                rsaSig.update(data, off, len);
                sig = rsaSig.sign();
            }
            catch (NoSuchAlgorithmException n) {
                void e;
                FFDCFilter.processException((Throwable)n, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1215", null, (Object[])new Object[]{key, data, off, len, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"1296");
            }
            catch (InvalidKeySpecException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1218", null, (Object[])new Object[]{key, data, off, len, useJCE});
                Tr.debug((TraceComponent)tc, (String)"Error: KeySpec invalid", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"1304");
            }
            catch (InvalidKeyException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1222", null, (Object[])new Object[]{key, data, off, len, useJCE});
                Tr.debug((TraceComponent)tc, (String)"Error: Key invalid", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"1308");
            }
            catch (SignatureException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1226", null, (Object[])new Object[]{key, data, off, len, useJCE});
                Tr.debug((TraceComponent)tc, (String)"Error: Signature operation failed", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCryptoCrypto", (String)"1312");
            }
        } else {
            sig = AuditCrypto.rsa(true, 3, key, data, off, len);
        }
        HashMap hashMap = cryptoKeysMap;
        synchronized (hashMap) {
            cryptoKeysMap.put(ck, ck);
            ck.result = sig;
            ck.successfulUses = 0L;
        }
        return sig;
    }

    static final boolean verifyISO9796(byte[][] key, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen) {
        return AuditCrypto.verifyISO9796(key, data, off, len, sig, sigOff, sigLen, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static final boolean verifyISO9796(byte[][] key, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen, boolean useJCE) {
        CachingVerifyKey ck = new CachingVerifyKey(key, data, off, len, sig, sigOff, sigLen, useJCE);
        CachingVerifyKey result = (CachingVerifyKey)verifyKeysMap.get(ck);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("v.size:" + verifyKeysMap.size()), (Object[])new Object[0]);
        }
        if (result != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("verify.caching successful:" + result.hashcode), (Object[])new Object[0]);
            }
            ++result.successfulUses;
            result.reused = true;
            return result.result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("verify.caching failed:" + ck.hashcode), (Object[])new Object[0]);
        }
        if (verifyKeysMap.size() > 2000) {
            HashMap hashMap = verifyKeysMap;
            synchronized (hashMap) {
                int i;
                CachingVerifyKey[] keys = verifyKeysMap.keySet().toArray(new CachingVerifyKey[verifyKeysMap.size()]);
                Arrays.sort(keys, cachingVerifyKeyComparator);
                if (cachingVerifyKeyComparator.compare(keys[0], keys[keys.length - 1]) < 0) {
                    for (i = 0; i < 400; ++i) {
                        verifyKeysMap.remove(keys[i]);
                        --keys[i + 400].successfulUses;
                        --keys[i + 800].successfulUses;
                        --keys[i + 1200].successfulUses;
                        --keys[i + 1600].successfulUses;
                    }
                } else {
                    for (i = 0; i < 400; ++i) {
                        verifyKeysMap.remove(keys[keys.length - 1 - i]);
                        --keys[keys.length - 1 - i - 400].successfulUses;
                        --keys[keys.length - 1 - i - 800].successfulUses;
                        --keys[keys.length - 1 - i - 1200].successfulUses;
                        --keys[keys.length - 1 - i - 1600].successfulUses;
                    }
                }
            }
        }
        boolean verified = false;
        if (useJCE) {
            try {
                BigInteger n = new BigInteger(key[0]);
                BigInteger e = new BigInteger(key[1]);
                KeyFactory kFact = null;
                kFact = KeyFactory.getInstance(CRYPTO_ALGORITHM, "IBMJCE");
                RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(n, e);
                PublicKey pubKey = kFact.generatePublic(pubKeySpec);
                Signature rsaSig = null;
                rsaSig = Signature.getInstance("SHA256withRSA");
                rsaSig.initVerify(pubKey);
                rsaSig.update(data, off, len);
                verified = rsaSig.verify(sig);
            }
            catch (NoSuchAlgorithmException n) {
                void e;
                FFDCFilter.processException((Throwable)n, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1529", null, (Object[])new Object[]{key, data, off, len, sig, sigOff, sigLen, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"1614");
            }
            catch (NoSuchProviderException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1532", null, (Object[])new Object[]{key, data, off, len, sig, sigOff, sigLen, useJCE});
                Tr.debug((TraceComponent)tc, (String)"Error: Provider not found", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"1618");
            }
            catch (InvalidKeySpecException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1536", null, (Object[])new Object[]{key, data, off, len, sig, sigOff, sigLen, useJCE});
                Tr.debug((TraceComponent)tc, (String)"Error: KeySpec invalid", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"1622");
            }
            catch (InvalidKeyException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1540", null, (Object[])new Object[]{key, data, off, len, sig, sigOff, sigLen, useJCE});
                Tr.debug((TraceComponent)tc, (String)"Error: Key invalid", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"1626");
            }
            catch (SignatureException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1544", null, (Object[])new Object[]{key, data, off, len, sig, sigOff, sigLen, useJCE});
                Tr.debug((TraceComponent)tc, (String)"Error: Signature operation failed", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"1630");
            }
        } else {
            sig = AuditCrypto.rsa(false, 3, key, sig, sigOff, sigLen);
            verified = (data = AuditCrypto.padISO9796(data, off, len, new BigInteger(key[0]).bitLength())).length == sig.length && AuditCrypto.cmp(data, 0, sig, 0, sig.length);
        }
        HashMap hashMap = verifyKeysMap;
        synchronized (hashMap) {
            verifyKeysMap.put(ck, ck);
            ck.result = verified;
            ck.successfulUses = 0L;
        }
        return verified;
    }

    static final byte[] padISO9796(byte[] data, int off, int len, int sigbits) {
        return AuditCrypto.padISO9796(data, off, len, sigbits, false);
    }

    static final byte[] padISO9796(byte[] data, int off, int len, int sigbits, boolean useJCE) {
        byte[] pad = null;
        if (!useJCE) {
            if (len * 16 > --sigbits + 3) {
                return null;
            }
            pad = new byte[(sigbits + 7) / 8];
            for (int i = 0; i < pad.length / 2; ++i) {
                pad[pad.length - 1 - 2 * i] = data[off + len - 1 - i % len];
            }
            if ((pad.length & 1) != 0) {
                pad[0] = data[off + len - 1 - pad.length / 2 % len];
            }
            long perm = 2064737499334935870L;
            for (int i = 0; i < pad.length / 2; ++i) {
                int j = pad.length - 1 - 2 * i;
                pad[j - 1] = (byte)((perm >> (pad[j] >>> 2 & 0x3C) & 0xFL) << 4 | perm >> ((pad[j] & 0xF) << 2) & 0xFL);
            }
            int n = pad.length - 2 * len;
            pad[n] = (byte)(pad[n] ^ 1);
            int n2 = sigbits % 8;
            pad[0] = (byte)(pad[0] & (byte)((1 << n2) - 1));
            pad[0] = (byte)(pad[0] | 1 << (n2 - 1 + 8) % 8);
            pad[pad.length - 1] = (byte)(pad[pad.length - 1] << 4 | 6);
        }
        return pad;
    }

    static final void setRSAKey(byte[][] key) {
        int i;
        BigInteger[] k = new BigInteger[8];
        for (i = 0; i < 8; ++i) {
            if (key[i] == null) continue;
            k[i] = new BigInteger(1, key[i]);
        }
        if (k[3].compareTo(k[4]) < 0) {
            BigInteger tmp = k[3];
            k[3] = k[4];
            k[4] = tmp;
            tmp = k[5];
            k[5] = k[6];
            k[6] = tmp;
            k[7] = null;
        }
        if (k[7] == null) {
            k[7] = k[4].modInverse(k[3]);
        }
        if (k[0] == null) {
            k[0] = k[3].multiply(k[4]);
        }
        if (k[1] == null) {
            k[1] = k[2].modInverse(k[3].subtract(BigInteger.valueOf(1L)).multiply(k[4].subtract(BigInteger.valueOf(1L))));
        }
        if (k[5] == null) {
            k[5] = k[1].remainder(k[3].subtract(BigInteger.valueOf(1L)));
        }
        if (k[6] == null) {
            k[6] = k[1].remainder(k[4].subtract(BigInteger.valueOf(1L)));
        }
        for (i = 0; i < 8; ++i) {
            key[i] = k[i].toByteArray();
        }
    }

    static final byte[][] rsaKey(int len, boolean crt, boolean f4) {
        return AuditCrypto.rsaKey(len, crt, f4, false);
    }

    /*
     * WARNING - void declaration
     */
    static final byte[][] rsaKey(int len, boolean crt, boolean f4, boolean useJCE) {
        byte[][] key = new byte[crt ? 8 : 3][];
        if (useJCE) {
            BigInteger pub_e = BigInteger.valueOf(f4 ? 65537L : 3L);
            KeyPair pair = null;
            try {
                RSAKeyGenParameterSpec rsaKeyGenSpec = new RSAKeyGenParameterSpec(len * 8, pub_e);
                KeyPairGenerator keyGen = null;
                SecureRandom random = null;
                keyGen = KeyPairGenerator.getInstance(CRYPTO_ALGORITHM, "IBMJCE");
                random = SecureRandom.getInstance("IBMSecureRandom");
                keyGen.initialize(len * 8, random);
                pair = keyGen.generateKeyPair();
                RSAPublicKey rsaPubKey = (RSAPublicKey)pair.getPublic();
                byte[] publicKey = rsaPubKey.getEncoded();
                RSAPrivateCrtKey rsaPrivKey = (RSAPrivateCrtKey)pair.getPrivate();
                byte[] privateKey = rsaPrivKey.getEncoded();
                BigInteger e = rsaPubKey.getPublicExponent();
                BigInteger n = rsaPubKey.getModulus();
                BigInteger pe = rsaPrivKey.getPrivateExponent();
                key[0] = n.toByteArray();
                key[1] = crt ? null : pe.toByteArray();
                key[2] = e.toByteArray();
                if (crt) {
                    BigInteger p = rsaPrivKey.getPrimeP();
                    BigInteger q = rsaPrivKey.getPrimeQ();
                    BigInteger ep = rsaPrivKey.getPrimeExponentP();
                    BigInteger eq = rsaPrivKey.getPrimeExponentQ();
                    BigInteger c = rsaPrivKey.getCrtCoefficient();
                    key[3] = p.toByteArray();
                    key[4] = q.toByteArray();
                    key[5] = ep.toByteArray();
                    key[6] = eq.toByteArray();
                    key[7] = c.toByteArray();
                }
            }
            catch (NoSuchAlgorithmException rsaKeyGenSpec) {
                void e;
                FFDCFilter.processException((Throwable)rsaKeyGenSpec, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1669", null, (Object[])new Object[]{len, crt, f4, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"1796");
            }
            catch (NoSuchProviderException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1672", null, (Object[])new Object[]{len, crt, f4, useJCE});
                Tr.debug((TraceComponent)tc, (String)"Error: Provider not found", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.ltpa.LTPACrypto", (String)"1800");
            }
        } else {
            BigInteger d;
            BigInteger n;
            BigInteger q;
            BigInteger e = BigInteger.valueOf(f4 ? 65537L : 3L);
            BigInteger one = BigInteger.valueOf(1L);
            BigInteger two = BigInteger.valueOf(2L);
            byte[] b = new byte[(len /= 2) + 1];
            BigInteger p = null;
            while (true) {
                q = null;
                while (true) {
                    if (q == null) {
                        AuditCrypto.random(b, 1, len);
                        b[1] = (byte)(b[1] | 0xC0);
                        int n2 = len;
                        b[n2] = (byte)(b[n2] | 1);
                        q = new BigInteger(b);
                    } else if ((q = q.add(two)).bitLength() > len * 8) {
                        q = null;
                        continue;
                    }
                    if (q.isProbablePrime(32) && e.gcd(q.subtract(one)).equals(one)) break;
                }
                if (p == null) {
                    p = q;
                    continue;
                }
                n = p.multiply(q);
                if (n.bitLength() == len * 2 * 8) {
                    d = e.modInverse(p.subtract(one).multiply(q.subtract(one)));
                    if (p.modPow(e, n).modPow(d, n).equals(p)) break;
                }
                p = null;
            }
            key[0] = n.toByteArray();
            key[1] = crt ? null : d.toByteArray();
            key[2] = e.toByteArray();
            if (crt) {
                if (p.compareTo(q) < 0) {
                    e = p;
                    p = q;
                    q = e;
                }
                key[3] = p.toByteArray();
                key[4] = q.toByteArray();
                key[5] = d.remainder(p.subtract(one)).toByteArray();
                key[6] = d.remainder(q.subtract(one)).toByteArray();
                key[7] = q.modInverse(p).toByteArray();
            }
        }
        return key;
    }

    static final boolean dsa(int mode, byte[][] key, byte[] data, int off, int len, byte[] sig, int pos) {
        int i = 0;
        BigInteger[] p = new BigInteger[6];
        do {
            p[i] = new BigInteger(key[i]);
        } while (++i < 4);
        if (p[1].bitLength() != 160) {
            return false;
        }
        byte[] b = new byte[21];
        if (mode == 2) {
            AuditCrypto.sha(null, data, off, len, b, 1);
        } else if (len == 20) {
            System.arraycopy(data, off, b, 1, 20);
        } else {
            return false;
        }
        BigInteger hash = new BigInteger(b);
        if (mode == 0) {
            b = new byte[20];
            AuditCrypto.random(b, 0, 20);
            b[0] = (byte)(b[0] & 0x7F);
            BigInteger k = new BigInteger(b);
            p[4] = p[2].modPow(k, p[0]).remainder(p[1]);
            p[5] = k.modInverse(p[1]).multiply(p[3].multiply(p[4]).add(hash)).remainder(p[1]);
            i = 0;
            do {
                sig[pos + i] = 0;
            } while (++i < 40);
            i = 0;
            do {
                int l;
                int j = (l = (b = p[i + 4].toByteArray()).length) > 20 ? 1 : 0;
                System.arraycopy(b, j, sig, pos + 20 * i + (20 - (l -= j)), l);
            } while (++i < 2);
            return true;
        }
        i = 0;
        do {
            byte j;
            if (mode == 1) {
                System.arraycopy(sig, pos + i * 20, b, 1, 20);
            } else if (sig[pos] == 2 && (j = sig[pos + 1]) > 0 && j <= 21) {
                b = new byte[j];
                System.arraycopy(sig, pos + 2, b, 0, j);
                pos += j + 2;
            } else {
                return false;
            }
            p[i + 4] = new BigInteger(b);
        } while (++i < 2);
        BigInteger w = p[5].modInverse(p[1]);
        BigInteger u1 = hash.multiply(w).remainder(p[1]);
        BigInteger u2 = p[4].multiply(w).remainder(p[1]);
        BigInteger v = p[2].modPow(u1, p[0]).multiply(p[3].modPow(u2, p[0])).remainder(p[0]).remainder(p[1]);
        return v.equals(p[4]);
    }

    static final byte getBits(String s, int pos, int len) {
        int i = pos / 7;
        byte a = (byte)s.charAt(i);
        int j = pos % 7;
        a = (byte)(a & 127 >>> j);
        if ((j = len - (7 - j)) > 0) {
            return (byte)(a << j | (byte)s.charAt(i + 1) >>> 7 - j);
        }
        if (j < 0) {
            return (byte)(a >>> -j);
        }
        return a;
    }

    static final void printBytes(String name, byte[] b, int off, int len) {
        System.out.println(name);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            buf.append("0123456789ABCDEF".charAt(b[off] >> 4 & 0xF));
            buf.append("0123456789ABCDEF".charAt(b[off] & 0xF));
            buf.append(" ");
            if (++i % 16 == 0 || i == len) {
                System.out.println(buf.toString());
                buf.setLength(0);
            }
            ++off;
        }
    }

    static final void printInfo(String label, int N, long t1, long t2, long t3, long t4) {
        System.out.print((label + "....................").substring(0, 20));
        for (int i = 0; i < 2; ++i) {
            long te;
            long tb = i == 0 ? t1 : t3;
            long l = te = i == 0 ? t2 : t4;
            if (tb == -1L) {
                System.out.print("      ");
                continue;
            }
            String s = "     " + (long)(N * 1000) / (te - tb);
            System.out.print(s.substring(s.length() - 6));
        }
        System.out.println();
    }

    static final boolean verifyBuf(byte[] b, int N, String alg) {
        for (int i = 0; i < 1024 * N; ++i) {
            if (b[i] == (byte)(i % 128)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(alg + " failed!"), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    static final boolean testRSAKeys(byte[] b, byte[][] privKey, byte[][] pubKey) {
        int i;
        int l = pubKey[0].length;
        if (pubKey[0][0] == 0) {
            --l;
        }
        long t1 = System.currentTimeMillis();
        byte[] rsa_b = AuditCrypto.rsa(true, 0, pubKey, b, 1, l);
        long t2 = System.currentTimeMillis();
        rsa_b = AuditCrypto.rsa(false, 0, privKey, rsa_b, 0, rsa_b.length);
        long t3 = System.currentTimeMillis();
        String s = "RSA/" + (privKey.length == 8 ? "CRT/" : "") + l * 8 + (pubKey[1].length == 1 && pubKey[1][0] == 3 ? "/3" : "/F4") + " ...................";
        s = s.substring(0, 20);
        for (i = 0; i < 2; ++i) {
            String ss = "     " + (i == 0 ? t3 - t2 : t2 - t1);
            s = s + ss.substring(ss.length() - 5);
        }
        for (i = 0; i < rsa_b.length; ++i) {
            if (rsa_b[i] == (byte)((i + 1) % 128)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RSA failed!", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    static final boolean testDSAKeys(byte[] b, byte[][] privKey, byte[][] pubKey) {
        int l = privKey[0].length;
        if (privKey[0][0] == 0) {
            --l;
        }
        long t1 = System.currentTimeMillis();
        byte[] sig = new byte[40];
        AuditCrypto.dsa(0, privKey, b, 0, 20, sig, 0);
        long t2 = System.currentTimeMillis();
        boolean ok = AuditCrypto.dsa(1, pubKey, b, 0, 20, sig, 0);
        long t3 = System.currentTimeMillis();
        String s = ("DSA/" + l * 8 + " ...................").substring(0, 20);
        for (int i = 0; i < 2; ++i) {
            String ss = "     " + (i == 0 ? t2 - t1 : t3 - t2);
            s = s + ss.substring(ss.length() - 5);
        }
        if (!ok && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DSA failed!", (Object[])new Object[0]);
        }
        return !ok;
    }

    static final byte[] generateSecretKey(int length) {
        new SecureRandom();
        return SecureRandom.getSeed(length);
    }

    static final byte[] generate3DESKey() {
        return AuditCrypto.generate3DESKey(false);
    }

    /*
     * WARNING - void declaration
     */
    static final byte[] generate3DESKey(boolean useJCE) {
        byte[] rndSeed = null;
        if (useJCE) {
            try {
                SecureRandom random = null;
                KeyGenerator keyGen = null;
                random = SecureRandom.getInstance("IBMSecureRandom");
                keyGen = KeyGenerator.getInstance(ENCRYPT_ALGORITHM);
                keyGen.init(random);
                SecretKey key = keyGen.generateKey();
                rndSeed = key.getEncoded();
            }
            catch (NoSuchAlgorithmException random) {
                void e;
                FFDCFilter.processException((Throwable)random, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"1963", null, (Object[])new Object[]{useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2157");
            }
        } else {
            int len = 24;
            rndSeed = new byte[len];
            AuditCrypto.random(rndSeed, 0, len);
        }
        return rndSeed;
    }

    static final byte[] encrypt(byte[] data, byte[] key) {
        return AuditCrypto.encrypt(data, key, CIPHER, true);
    }

    /*
     * WARNING - void declaration
     */
    static final byte[] encrypt(byte[] data, byte[] key, String cipher, boolean useJCE) {
        long start_time = 0L;
        if (tc.isDebugEnabled()) {
            start_time = System.currentTimeMillis();
            Tr.debug((TraceComponent)tc, (String)("Cipher used to encrypt: " + cipher), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Data size: " + data.length), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Key size: " + key.length), (Object[])new Object[0]);
        }
        byte[] mesg = null;
        if (useJCE) {
            try {
                if (null == data) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Array was null", (Object[])new Object[0]);
                    }
                    return null;
                }
                SecretKey sKey = null;
                if (cipher.indexOf("AES") != -1) {
                    sKey = new SecretKeySpec(key, 0, 16, "AES");
                } else {
                    DESedeKeySpec kSpec = new DESedeKeySpec(key);
                    SecretKeyFactory kFact = null;
                    kFact = SecretKeyFactory.getInstance(ENCRYPT_ALGORITHM);
                    sKey = kFact.generateSecret(kSpec);
                }
                Cipher ci = null;
                ci = Cipher.getInstance(cipher);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The Provider Cipher used to encrypt: " + ci.getProvider()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("The Algorithm Cipher used to encrypt: " + ci.getAlgorithm()), (Object[])new Object[0]);
                }
                if (cipher.indexOf("ECB") == -1) {
                    if (cipher.indexOf("AES") != -1) {
                        if (ivs16 == null) {
                            AuditCrypto.setIVS16(key);
                        }
                        ci.init(1, (Key)sKey, ivs16);
                    } else {
                        if (ivs8 == null) {
                            AuditCrypto.setIVS8(key);
                        }
                        ci.init(1, (Key)sKey, ivs8);
                    }
                } else {
                    ci.init(1, sKey);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("encrypt() Cipher.doFinal()\n   data: " + new String(data)), (Object[])new Object[0]);
                }
                mesg = ci.doFinal(data);
            }
            catch (NoSuchAlgorithmException sKey) {
                void e;
                FFDCFilter.processException((Throwable)sKey, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2038", null, (Object[])new Object[]{data, key, cipher, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2256");
            }
            catch (InvalidKeyException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2041", null, (Object[])new Object[]{data, key, cipher, useJCE});
                Tr.debug((TraceComponent)tc, (String)"Error: Key invalid", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2264");
            }
            catch (InvalidKeySpecException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2045", null, (Object[])new Object[]{data, key, cipher, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2267");
            }
            catch (NoSuchPaddingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2048", null, (Object[])new Object[]{data, key, cipher, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2270");
            }
            catch (IllegalBlockSizeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2051", null, (Object[])new Object[]{data, key, cipher, useJCE});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2273");
            }
            catch (BadPaddingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2054", null, (Object[])new Object[]{data, key, cipher, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2276");
            }
            catch (InvalidAlgorithmParameterException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2057", null, (Object[])new Object[]{data, key, cipher, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2279");
            }
        } else {
            int len = key.length;
            int[] encrInternalKey = AuditCrypto.desKey(true, key, 0, len);
            mesg = AuditCrypto.padPKCS5(data);
            if (null == mesg) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Array was null", (Object[])new Object[0]);
                }
                return null;
            }
            AuditCrypto.des(true, encrInternalKey, null, mesg, 0, mesg.length, mesg, 0);
        }
        if (tc.isDebugEnabled()) {
            long end_time = System.currentTimeMillis();
            Tr.debug((TraceComponent)tc, (String)("Total encryption time: " + (end_time - start_time)), (Object[])new Object[0]);
        }
        return mesg;
    }

    static final byte[] decrypt(byte[] mesg, byte[] key) {
        return AuditCrypto.decrypt(mesg, key, CIPHER, true);
    }

    /*
     * WARNING - void declaration
     */
    static final byte[] decrypt(byte[] mesg, byte[] key, String cipher, boolean useJCE) {
        long start_time = 0L;
        if (tc.isDebugEnabled()) {
            start_time = System.currentTimeMillis();
            Tr.debug((TraceComponent)tc, (String)("Cipher used to decrypt: " + cipher), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("key size: " + key.length), (Object[])new Object[0]);
        }
        byte[] tmpMesg = null;
        if (useJCE) {
            try {
                if (null == mesg) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Array was null", (Object[])new Object[0]);
                    }
                    return null;
                }
                SecretKey sKey = null;
                if (cipher.indexOf("AES") != -1) {
                    sKey = new SecretKeySpec(key, 0, 16, "AES");
                } else {
                    DESedeKeySpec kSpec = new DESedeKeySpec(key);
                    SecretKeyFactory kFact = null;
                    kFact = SecretKeyFactory.getInstance(ENCRYPT_ALGORITHM);
                    sKey = kFact.generateSecret(kSpec);
                }
                Cipher ci = null;
                ci = Cipher.getInstance(cipher);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The Provider Cipher used to decrypt: " + ci.getProvider()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("The Algorithm Cipher used to decrypt: " + ci.getAlgorithm()), (Object[])new Object[0]);
                }
                if (cipher.indexOf("ECB") == -1) {
                    if (cipher.indexOf("AES") != -1) {
                        if (ivs16 == null) {
                            AuditCrypto.setIVS16(key);
                        }
                        ci.init(2, (Key)sKey, ivs16);
                    } else {
                        if (ivs8 == null) {
                            AuditCrypto.setIVS8(key);
                        }
                        ci.init(2, (Key)sKey, ivs8);
                    }
                } else {
                    ci.init(2, sKey);
                }
                tmpMesg = ci.doFinal(mesg);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("decrypt() Cipher.doFinal()\n   tmpMesg: " + new String(tmpMesg)), (Object[])new Object[0]);
                }
            }
            catch (NoSuchAlgorithmException sKey) {
                void e;
                FFDCFilter.processException((Throwable)sKey, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2150", null, (Object[])new Object[]{mesg, key, cipher, useJCE});
                Tr.error((TraceComponent)tc, (String)"no such algorithm exception", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2385");
            }
            catch (InvalidKeyException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2153", null, (Object[])new Object[]{mesg, key, cipher, useJCE});
                Tr.debug((TraceComponent)tc, (String)"Error: Key invalid", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2393");
            }
            catch (InvalidKeySpecException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2157", null, (Object[])new Object[]{mesg, key, cipher, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2396");
            }
            catch (NoSuchPaddingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2160", null, (Object[])new Object[]{mesg, key, cipher, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2399");
            }
            catch (IllegalBlockSizeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2163", null, (Object[])new Object[]{mesg, key, cipher, useJCE});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2402");
            }
            catch (BadPaddingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2166", null, (Object[])new Object[]{mesg, key, cipher, useJCE});
                Tr.debug((TraceComponent)tc, (String)"BadPaddingException validating token, normal when token generated from other factory.", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditCrypto", (String)"2405");
            }
            catch (InvalidAlgorithmParameterException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2169", null, (Object[])new Object[]{mesg, key, cipher, useJCE});
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object[])new Object[]{e});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.auditAuditCrypto", (String)"2408");
            }
        } else {
            int len = key.length;
            int[] decrInternalKey = AuditCrypto.desKey(false, key, 0, len);
            AuditCrypto.des(false, decrInternalKey, null, mesg, 0, mesg.length, mesg, 0);
            tmpMesg = AuditCrypto.unpadPKCS5(mesg);
            if (null == tmpMesg) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Array was not properly paded", (Object[])new Object[0]);
                }
                return null;
            }
        }
        if (tc.isDebugEnabled()) {
            long end_time = System.currentTimeMillis();
            Tr.debug((TraceComponent)tc, (String)("Total decryption time: " + (end_time - start_time)), (Object[])new Object[0]);
        }
        return tmpMesg;
    }

    private static final byte[] unpadPKCS5(byte[] aB) {
        if (null == aB) {
            return null;
        }
        if (0 == aB.length) {
            return null;
        }
        int aBl = aB.length;
        byte pc = aB[aBl - 1];
        if (pc > 8 || pc < 1) {
            return null;
        }
        for (int i = aBl - pc; i < aBl; ++i) {
            if (aB[i] == pc) continue;
            return null;
        }
        byte[] unpadB = new byte[aBl - pc];
        System.arraycopy(aB, 0, unpadB, 0, aBl - pc);
        return unpadB;
    }

    private static final byte[] padPKCS5(byte[] aB) {
        if (null == aB) {
            return null;
        }
        int aBl = aB.length;
        int pc = 8 - aBl % 8;
        byte[] padB = new byte[aBl + pc];
        System.arraycopy(aB, 0, padB, 0, aBl);
        for (int i = aBl; i < padB.length; ++i) {
            padB[i] = (byte)pc;
        }
        return padB;
    }

    public static String toHexString(byte[] bytes) {
        String hexString = null;
        for (int i = 0; i < bytes.length; ++i) {
            String byteString = Integer.toHexString(bytes[i]);
            if (byteString.length() == 1) {
                byteString = "0" + byteString;
            }
            hexString = hexString + byteString;
        }
        return hexString;
    }

    public static IvParameterSpec getIVS8() {
        return ivs8;
    }

    public static IvParameterSpec getIVS16() {
        return ivs16;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static synchronized void setIVS8(byte[] key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setIVS8", (Object[])new Object[0]);
        }
        if (ivs8 == null) {
            try {
                byte[] iv8 = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    iv8[i] = key[i];
                }
                ivs8 = new IvParameterSpec(iv8);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"setIVS8: ivs8 successfully set", (Object[])new Object[0]);
                }
            }
            catch (Exception iv8) {
                void e;
                FFDCFilter.processException((Throwable)iv8, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2297", null, (Object[])new Object[]{key});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"setIVS8 unxepected exception setting initialization vector", (Object[])new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.ltpa.LTPAToken2Factory.initialize", (String)"2539");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static synchronized void setIVS16(byte[] key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setIVS16", (Object[])new Object[0]);
        }
        if (ivs16 == null) {
            try {
                byte[] iv16 = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv16[i] = key[i];
                }
                ivs16 = new IvParameterSpec(iv16);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"setIVS16: ivs16 successfully set", (Object[])new Object[0]);
                }
            }
            catch (Exception iv16) {
                void e;
                FFDCFilter.processException((Throwable)iv16, (String)"com.ibm.ws.security.audit.encryption.AuditCrypto", (String)"2322", null, (Object[])new Object[]{key});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"setIVS16 unxepected exception setting initialization vector", (Object[])new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.ltpa.LTPAToken2Factory.initialize", (String)"2568");
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        int i;
        tc = Tr.register(AuditCrypto.class, null, (String)"com.ibm.ejs.resources.security");
        ivs8 = null;
        ivs16 = null;
        random = null;
        ETB = new double[16];
        AuditCrypto.ETB[0] = 0.001;
        double d = 0.001;
        double log2d = Math.log(2.0 * d);
        int i2 = 1;
        do {
            AuditCrypto.ETB[i2++] = Math.exp(log2d / (double)i2) / 2.0;
        } while (i2 < ETB.length);
        samples = new int[56];
        ones = new int[16];
        block = new int[16];
        seed = new byte[32];
        seedInitialized = false;
        trMix = 128;
        Pmd2 = new byte[256];
        String p = "\u0014KH<M\u000b0|\u0000O&e%\u0007Yp\u0003\u0004l*8\u0017g@c\\qIDLWY^\u0013\u0010,Pz6W\u001e?:N\u0000YNB7F\u0011!?\u0014%>'1\u001amT{<IP>~Xul_n=*-\u0007LD+2\u0003OrL\u0010B\u0012\u000b\u0011\u0017d\u0018\u0003};\u001a-$\u0006\"9T}Lso~y8\u000f~\u0019\u0018,i\n-W#W/$E*bZUF'n\u0007\r\u0014ZH}[\u001d_F_\n8t\u0002<(YkA2d8ad\b2o\u001ees\u000b5\u0000\u0010m@%VkV\u000bOX8F0Z&D\u0003x\u001eU#hd=jF^:aW\u001f\u001cuk\u000bj\u0013\u000b\n0k:\n(B\u0002:=~7hA@S*&VpoH605?Q\u0013B{\u0004\u0003\u0017[\n)q\bJb|6\u001f![ieu?cX\u0000:9y;vps\u00191Pr)Nw\u0017cVu%BF\u0014\"Bi\u000fvGc-\\f\u001a3OD01 ";
        int i3 = 0;
        do {
            AuditCrypto.Pmd2[i3] = AuditCrypto.getBits("\u0014KH<M\u000b0|\u0000O&e%\u0007Yp\u0003\u0004l*8\u0017g@c\\qIDLWY^\u0013\u0010,Pz6W\u001e?:N\u0000YNB7F\u0011!?\u0014%>'1\u001amT{<IP>~Xul_n=*-\u0007LD+2\u0003OrL\u0010B\u0012\u000b\u0011\u0017d\u0018\u0003};\u001a-$\u0006\"9T}Lso~y8\u000f~\u0019\u0018,i\n-W#W/$E*bZUF'n\u0007\r\u0014ZH}[\u001d_F_\n8t\u0002<(YkA2d8ad\b2o\u001ees\u000b5\u0000\u0010m@%VkV\u000bOX8F0Z&D\u0003x\u001eU#hd=jF^:aW\u001f\u001cuk\u000bj\u0013\u000b\n0k:\n(B\u0002:=~7hA@S*&VpoH605?Q\u0013B{\u0004\u0003\u0017[\n)q\bJb|6\u001f![ieu?cX\u0000:9y;vps\u00191Pr)Nw\u0017cVu%BF\u0014\"Bi\u000fvGc-\\f\u001a3OD01 ", i3 * 8, 8);
        } while (++i3 < 256);
        PC = new int[512];
        String cd = "\bu\u00011)Y\u001b\u0001(\"N\u0000$`\f\u0002-T@ \u001c\u0003\r\u00118@\u0013U\u0006 6\u000e\u0001$ \u0019@!\u001b\u0001\nI4H\tX\u0002K";
        int n = 0;
        int o = 0;
        int c = 0;
        do {
            byte l;
            if ((l = AuditCrypto.getBits("\bu\u00011)Y\u001b\u0001(\"N\u0000$`\f\u0002-T@ \u001c\u0003\r\u00118@\u0013U\u0006 6\u000e\u0001$ \u0019@!\u001b\u0001\nI4H\tX\u0002K", c * 6, 6)) == 32) continue;
            i = 0;
            do {
                if ((1 << n & i) == 0) continue;
                int n2 = o + i;
                PC[n2] = PC[n2] | 1 << l;
            } while (++i < 64);
            if ((n = (n + 1) % 6) != 0) continue;
            o += 64;
        } while (++c < 56);
        SP0 = new int[256];
        SP1 = new int[256];
        String sp = "@\rs\u0014TY%\u001eK\u000b\"\tRYI95%2YW}\u0003\u0012\u0004A0\u0000\bI$(\u0000Q\u0014\u0002\u0002J\u0004D\u0012 (\u0000@Y\u0010!\u0016\u00020\u0001 \u0011-iC\u0007RX6(o\u007fA$\f\u0000`I\u0011\u0001P\u0005\u0000$4\u0006  \n\n\b(\f\u0000R\f\u0010A\u0004\u0011\u0010a@\u0004XSU\u0016.pe\u0007a@)\u0016K\u001as\u0016=&$Q\u0004V\rJ\u001bj\"gO\u0004\u0005\u0014l\u000emF[#(3\u0010)rEG\rpKc\u000e \u0000&J(mM\u0013\u00146Zd\u0000\u0004F\u001a-\u001d\u001cy&\u001cV\u0010\u000e8aqSI1%r`\u0015M9\u0014S4RFlh";
        String sp1 = "\u0001'%dK''$N\u0018d\t\u0012yGa4i\u0013GH\u0000\u0011K#G\u0016#'&fL\u0000\u0002\u000b\u0016\u001d\u000f\f\u001c\u001f9C\u0014\u0001c-\u0016RXpV\u001cxAG\u0014Z+)\fkRe\u007fP\t\u0018!\u000008\u0000B( \t\u0010\u0010\u0018#\u0010 ,\u0011A\u0002\u0012\t!\u0004\u0018\u0003 )\u0004\u0004\u0005]\u0014T^rFi-\u0002\bpYcltX\u0002k<\u0001R<lIK\u0016L9F\b\r\u001b\u0006_\u0013\u0018S\u001a.D\u0019,+\u00165\u0014\u0016fL\u007f|\u0001D\u0004\u0002H@BIB\b\u0001\n\u0002\u0004)!\u0004\f\u00004`!\u0006\fA\u0011\u0010`\u0012B\u0002\u0005\u0016<l\u0018N\u001ai5\u0014";
        int[] st = SP0;
        while (true) {
            int a = 0;
            int j = 63;
            int r = 0;
            int c2 = 0;
            long v = 0L;
            int n3 = 3;
            do {
                i = 0;
                do {
                    if (v == 0L) {
                        c2 = AuditCrypto.getBits(sp, a, 8) & 0xFF;
                        if (c2 == 0) {
                            a += 8;
                            i += 64;
                            continue;
                        }
                        a += 8;
                        if (c2 == 255) {
                            r = 2;
                            continue;
                        }
                        v = 0L;
                        int t = 0;
                        do {
                            v <<= 8;
                            v |= (long)(AuditCrypto.getBits(sp, a, 8) & 0xFF);
                            a += 8;
                        } while (++t < 8);
                    }
                    if ((v & 1L << j) != 0L) {
                        int n4 = i;
                        st[n4] = st[n4] | c2 << n3 * 8;
                    }
                    ++i;
                    if (--j >= 0) continue;
                    j = 63;
                    v = 0L;
                    if (r <= 0) continue;
                    --r;
                    i -= 64;
                } while (i < 256);
            } while (--n3 >= 0);
            if (st != SP0) break;
            st = SP1;
            sp = "\u0001'%dK''$N\u0018d\t\u0012yGa4i\u0013GH\u0000\u0011K#G\u0016#'&fL\u0000\u0002\u000b\u0016\u001d\u000f\f\u001c\u001f9C\u0014\u0001c-\u0016RXpV\u001cxAG\u0014Z+)\fkRe\u007fP\t\u0018!\u000008\u0000B( \t\u0010\u0010\u0018#\u0010 ,\u0011A\u0002\u0012\t!\u0004\u0018\u0003 )\u0004\u0004\u0005]\u0014T^rFi-\u0002\bpYcltX\u0002k<\u0001R<lIK\u0016L9F\b\r\u001b\u0006_\u0013\u0018S\u001a.D\u0019,+\u00165\u0014\u0016fL\u007f|\u0001D\u0004\u0002H@BIB\b\u0001\n\u0002\u0004)!\u0004\f\u00004`!\u0006\fA\u0011\u0010`\u0012B\u0002\u0005\u0016<l\u0018N\u001ai5\u0014";
        }
        bigIntegerMap = new HashMap();
        bigIntegerInverseMap = new HashMap();
        rsaKeysMap = new HashMap();
        cryptoKeysMap = new HashMap();
        verifyKeysMap = new HashMap();
        cachingVerifyKeyComparator = new Comparator(){
            static final long serialVersionUID = 9072056121561120650L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public int compare(Object o1, Object o2) {
                CachingVerifyKey k1 = (CachingVerifyKey)o1;
                CachingVerifyKey k2 = (CachingVerifyKey)o2;
                if (k1.successfulUses < k2.successfulUses) {
                    return -1;
                }
                if (k1.successfulUses == k2.successfulUses) {
                    return 0;
                }
                return 1;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
            }
        };
        cachingKeyComparator = new Comparator(){
            static final long serialVersionUID = -410129092549263601L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public int compare(Object o1, Object o2) {
                CachingKey k1 = (CachingKey)o1;
                CachingKey k2 = (CachingKey)o2;
                if (!k1.reused) {
                    if (k2.reused) {
                        return -1;
                    }
                } else if (!k2.reused) {
                    return 1;
                }
                if (k1.successfulUses < k2.successfulUses) {
                    return -1;
                }
                if (k1.successfulUses == k2.successfulUses) {
                    return 0;
                }
                return 1;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
            }
        };
        rsaKeyMaterial = new String[][]{{"4svq2jqtxo3zn2njenso9vwyg2bynvo08ekktj4d7sqwk9s3oz", "4se994le3trmoep5f74ytxfupr2o0oi9dem4nzailb4k4g5e7j", "1ekh"}, {"uk5febz1u9c5x7knn185refnb02syox36xqwae0lm30z9j9p03hyu175dyxbiczds3k1n6jiwqdeyetwgsy1qrvje8a7o40cmb5", "ujsuw3e4k53dtzgbsm3tjpytf5h25i71r8cs8ijbigo607ceo5zy5toem0kp4oeb77tt86h7gkix5fjdq13sa7puya61b2ep82n", "3"}};
        dsaKeyMaterial = new String[][]{{"otj4bi3e6pxy54h5tkjwpuzycvm3ta6jg9f6lj52mvygb9l72y1tkrs0ppuldns6kem6vzw3fbwhinhdhpqjvn284fc0dsaz39h", "jpdh5mk2p667os7al4gmvbdfmar3bsv", "cdybrmm4x665tomdaiedafq3d2wiajhlkbeql7iui72eeayleaa3ppn7lhfdbrh508kum7havwgb7otsnme3pc8r7kipf55hvio", "lpb2xrb2yivmklm6i6pyzvagsu9qhdz", "6d3ng23juhszoxet3kkzw2ei7y3hxo67c9oqvuf5d1dpev7qzwhzy11tcaikknfxtr62zyk96d9vvhli6zw2b2sxbrnlc3xkuzy"}, {"10uj5jh4khn7t93eh41c1d7sfptfuqiycpiimudbj62leu8fwnnt3k5cdkzynrvbhlflm3qe6sfwsjs3bbvjm8j8ctzaljlothjtbujclhafng31uzf4zmj11qjni0z9ou77rap19wl7ps7v52fbuoycrgu6xohwoobiwfanlkh4t18wtw3kf1nsdxz7mwpu9ddu4cz", "s6zmy3zi8dumvm43ofheresn52f9trj", "z4asx4yhsha3vd0d0uhhnahzmtj1qg572k3frvtq46x9lrawlm4x70oc99d4qsplci9e8qjtaqt3sqf719tfojrwjnonkqbxm9op3ck61fcxx2q6l4vg1rizk9kn74pi9859nqqctvn9174smwqzosvdrnd89eykgocc09ph343gpen9lgo0h6dk32a35gut5wb6w1", "f8xedoxwqju60mngerxyt5jv7rl8wbg", "egc8c7ptmx0hr5i4x2bzgeumx8kcmc9jokca88r8e4k1ih802bnz9flr08topo1v7kodqg9yab3xpf2j0lv9zmg8jhh38okgjfeou1fb7xn6blo4t1m8fb64p849eaqa66f1c0ar7m1uwdwc9k57vr58frxezjd1w4sc4zp8s6wn89lmbzem0brt6phtukhg2qfgrn"}};
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class CachingVerifyKey {
        boolean reused = false;
        long successfulUses;
        byte[][] key;
        byte[] data;
        int off;
        int len;
        byte[] sig;
        int sigOff;
        int sigLen;
        boolean useJCE;
        int hashcode;
        boolean result;
        static final long serialVersionUID = 3597009894451834432L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CachingVerifyKey(byte[][] key, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen, boolean useJCE) {
            this.key = key;
            this.data = data;
            this.off = off;
            this.len = len;
            this.sig = sig;
            this.sigOff = sigOff;
            this.sigLen = sigLen;
            this.useJCE = useJCE;
            this.successfulUses = 0L;
            this.reused = false;
            this.hashcode = 0;
            if (key != null && key.length > 0 && key[0] != null && key[0].length > 0) {
                this.hashcode += key[0][0];
            }
            if (data != null) {
                int i;
                for (i = 0; i < data.length && i < 10; ++i) {
                    this.hashcode += data[i];
                }
                for (i = data.length - 1; i >= 0 && i > data.length - 10; --i) {
                    this.hashcode += data[i];
                }
            }
            this.hashcode += off;
            if (off != 0) {
                this.hashcode *= off;
            }
            if (useJCE) {
                this.hashcode *= 2;
            }
        }

        public boolean equals(Object to) {
            int i;
            if (!(to instanceof CachingVerifyKey)) {
                return false;
            }
            CachingVerifyKey ck = (CachingVerifyKey)to;
            if (this.hashcode != ck.hashcode) {
                return false;
            }
            if (this.len != ck.len) {
                return false;
            }
            if (this.key != null) {
                if (ck.key == null) {
                    return false;
                }
                if (this.key.length != ck.key.length) {
                    return false;
                }
                for (i = 0; i < this.key.length; ++i) {
                    if (this.key[i] != null) {
                        if (ck.key[i] == null) {
                            return false;
                        }
                        if (this.key[i].length != ck.key[i].length) {
                            return false;
                        }
                        for (int o = 0; o < this.key[i].length; ++o) {
                            if (this.key[i][o] == ck.key[i][o]) continue;
                            return false;
                        }
                        continue;
                    }
                    if (ck.key[i] == null) continue;
                    return false;
                }
            } else if (ck.key != null) {
                return false;
            }
            if (this.data != null) {
                if (ck.data == null) {
                    return false;
                }
                if (this.data.length != ck.data.length) {
                    return false;
                }
                for (i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == ck.data[i]) continue;
                    return false;
                }
            } else if (ck.data != null) {
                return false;
            }
            if (this.sig != null) {
                if (ck.sig == null) {
                    return false;
                }
                if (this.sig.length != ck.sig.length) {
                    return false;
                }
                for (i = 0; i < this.sig.length; ++i) {
                    if (this.sig[i] == ck.sig[i]) continue;
                    return false;
                }
            } else if (ck.sig != null) {
                return false;
            }
            if (this.off != ck.off) {
                return false;
            }
            if (this.useJCE != ck.useJCE) {
                return false;
            }
            if (this.sigOff != ck.sigOff) {
                return false;
            }
            return this.sigLen == ck.sigLen;
        }

        public int hashCode() {
            return this.hashcode;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CachingVerifyKey.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class CachingKey {
        boolean reused = false;
        long successfulUses;
        byte[][] key;
        byte[] data;
        int off;
        int len;
        boolean useJCE;
        int hashcode;
        byte[] result;
        static final long serialVersionUID = 8747459933057148079L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CachingKey(byte[][] key, byte[] data, int off, int len, boolean useJCE) {
            this.key = key;
            this.data = data;
            this.off = off;
            this.len = len;
            this.useJCE = useJCE;
            this.successfulUses = 0L;
            this.reused = false;
            this.hashcode = 0;
            if (key != null && key.length > 0 && key[0] != null && key[0].length > 0) {
                this.hashcode += key[0][0];
            }
            if (data != null) {
                for (int i = 0; i < data.length; ++i) {
                    this.hashcode += data[i];
                }
            }
            this.hashcode += off + len;
            if (off != 0) {
                this.hashcode *= off;
            }
            if (useJCE) {
                this.hashcode *= 2;
            }
        }

        public boolean equals(Object to) {
            int i;
            if (!(to instanceof CachingKey)) {
                return false;
            }
            CachingKey ck = (CachingKey)to;
            if (this.hashcode != ck.hashcode) {
                return false;
            }
            if (this.len != ck.len) {
                return false;
            }
            if (this.key != null) {
                if (ck.key == null) {
                    return false;
                }
                if (this.key.length != ck.key.length) {
                    return false;
                }
                for (i = 0; i < this.key.length; ++i) {
                    if (this.key[i] != null) {
                        if (ck.key[i] == null) {
                            return false;
                        }
                        if (this.key[i].length != ck.key[i].length) {
                            return false;
                        }
                        for (int o = 0; o < this.key[i].length; ++o) {
                            if (this.key[i][o] == ck.key[i][o]) continue;
                            return false;
                        }
                        continue;
                    }
                    if (ck.key[i] == null) continue;
                    return false;
                }
            } else if (ck.key != null) {
                return false;
            }
            if (this.data != null) {
                if (ck.data == null) {
                    return false;
                }
                if (this.data.length != ck.data.length) {
                    return false;
                }
                for (i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == ck.data[i]) continue;
                    return false;
                }
            } else if (ck.data != null) {
                return false;
            }
            if (this.off != ck.off) {
                return false;
            }
            return this.useJCE == ck.useJCE;
        }

        public int hashCode() {
            return this.hashcode;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CachingKey.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
        }
    }
}

