/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.source;

import com.ibm.websphere.event.Topic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditConstants;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.websphere.security.audit.InvalidConfigurationException;
import com.ibm.ws.collector.manager.buffer.BufferManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.utils.SequenceNumber;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.event.AuditMgmtEvent;
import com.ibm.ws.security.audit.utils.AuditUtils;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.Source;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.audit.AuditService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={AuditService.class, Source.class}, configurationPid={"com.ibm.ws.security.audit.event"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.vendor=IBM"}, immediate=true)
public class AuditServiceImpl
implements AuditService,
Source {
    private static final String VAR_DEFAULTHOSTNAME = "${defaultHostName}";
    private static final String VAR_WLPSERVERNAME = "${wlp.server.name}";
    private static final String VAR_WLPUSERDIR = "${wlp.user.dir}";
    private static final String ENV_VAR_CONTAINERHOST = "${env.CONTAINER_HOST}";
    private static final String ENV_VAR_CONTAINERNAME = "${env.CONTAINER_NAME}";
    private static final String AUDIT_SERVER_ID_PREFIX = "websphere: ";
    private static final String AUDIT_SERVER_ID_SEPARATOR = ":";
    public static final Topic TOPIC_QUEUED_WORK = new Topic("com/ibm/ws/jmx/QUEUED_AUDIT_WORK");
    public static final String TOPIC_QUEUED_WORK_NAME = TOPIC_QUEUED_WORK.getName();
    private int eventSequenceNumber = 0;
    private static Object syncObject = new Object();
    private static Object syncSeqNum = new Object();
    private final SequenceNumber sequenceNumber = new SequenceNumber();
    private static final String INCORRECT_AUDIT_EVENT_CONFIGURATION = "INCORRECT_AUDIT_EVENT_CONFIGURATION";
    private static final String INCORRECT_AUDIT_OUTCOME_CONFIGURATION = "INCORRECT_AUDIT_OUTCOME_CONFIGURATION";
    public static final String KEY_RUNNABLE = "JMXWork";
    private static final String VARIABLE_REGISTRY_SERVICE = "variableRegistryService";
    private static final AtomicServiceReference<VariableRegistry> variableRegistryServiceRef = new AtomicServiceReference("variableRegistryService");
    private static final TraceComponent tc = Tr.register(AuditServiceImpl.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
    private BufferManager bufferMgr;
    private BufferManager saved_bufferMgr;
    private final ConcurrentHashMap<String, List<Map<String, Object>>> handlerEventsMap = new ConcurrentHashMap();
    private String eventName = null;
    private boolean isCustomEvent = false;
    private String[] auditData = null;
    private String[] outcome = null;
    private Map<String, Object> thisConfiguration = null;
    private AuditEvent[] savedEvent = new AuditEvent[10];
    private int savedEventIndex = 0;
    private final boolean savedEventEmitted = false;
    private String serverID = null;
    private volatile BufferManagerImpl auditLogConduit;
    private boolean auditServiceStarted = false;
    private boolean emitted1 = false;
    private final boolean emitted2 = false;
    static final long serialVersionUID = 6843185502841969608L;

    @Reference(name="variableRegistryService", service=VariableRegistry.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setVariableRegistryService(ServiceReference<VariableRegistry> variableRegistry) {
        variableRegistryServiceRef.setReference(variableRegistry);
    }

    protected void unsetVariableRegistryService(ServiceReference<VariableRegistry> variableRegistry) {
        variableRegistryServiceRef.unsetReference(variableRegistry);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> configuration) {
        Tr.info((TraceComponent)tc, (String)"AUDIT_SERVICE_STARTING", (Object[])new Object[0]);
        this.thisConfiguration = configuration;
        variableRegistryServiceRef.activate(cc);
        if (configuration != null && !configuration.isEmpty()) {
            for (Map.Entry<String, Object> entry : configuration.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key.equals("eventName")) {
                    this.setEventName(value);
                    continue;
                }
                if (key.equals("CUSTOM")) {
                    this.setIsCustomEvent(value);
                    continue;
                }
                if (key.equals("auditData")) {
                    this.setAuditData(value);
                    continue;
                }
                if (!key.equals("outcome")) continue;
                this.setOutcome(value);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("configuration: " + configuration.toString()), (Object[])new Object[0]);
        }
    }

    public void auditStarted(String serviceName) {
        if (this.isAuditRequired("SECURITY_AUDIT_MGMT", "success")) {
            AuditMgmtEvent av = new AuditMgmtEvent(this.thisConfiguration, "AuditService", "start");
            this.sendEvent(av);
        }
        this.auditServiceStarted = true;
        this.saved_bufferMgr = this.bufferMgr;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("auditStarted, bufferMgr = " + this.bufferMgr + " saved_bufferMgr = " + this.saved_bufferMgr), (Object[])new Object[0]);
        }
        this.auditServiceStarted = true;
        Tr.info((TraceComponent)tc, (String)"AUDIT_SERVICE_READY", (Object[])new Object[0]);
    }

    public void auditStopped(String serviceName) {
        if (this.isAuditRequired("SECURITY_AUDIT_MGMT", "success")) {
            AuditMgmtEvent av = new AuditMgmtEvent(this.thisConfiguration, "AuditService", "stop");
            this.sendEvent(av);
            this.emitted1 = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"auditStopped, emitted1 = false, saved_bufferMgr = null", (Object[])new Object[0]);
            }
            this.saved_bufferMgr = null;
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        Tr.info((TraceComponent)tc, (String)"AUDIT_SERVICE_STOPPED", (Object[])new Object[0]);
        this.handlerEventsMap.clear();
        variableRegistryServiceRef.deactivate(cc);
    }

    @Modified
    protected void modified(Map<String, Object> configuration) {
    }

    public void registerEvents(String handlerName, List<Map<String, Object>> configuredEvents) throws InvalidConfigurationException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("size of configuredEvents: " + configuredEvents.size()), (Object[])new Object[0]);
        }
        if (this.validateEventsAndOutcomes(handlerName, configuredEvents)) {
            if (!this.handlerEventsMap.containsKey(handlerName)) {
                this.handlerEventsMap.put(handlerName, configuredEvents);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handlerEventsMap: " + this.handlerEventsMap.toString()), (Object[])new Object[0]);
            }
            this.auditStarted("AuditService");
            if (this.handlerEventsMap.isEmpty() || this.handlerEventsMap.containsKey("AuditFileHandler")) {
                AuditMgmtEvent av = new AuditMgmtEvent(this.thisConfiguration, "AuditHandler:AuditFileHandler", "start");
                this.sendEvent(av);
            }
        } else {
            throw new InvalidConfigurationException();
        }
    }

    public boolean validateEventsAndOutcomes(String handlerName, List<Map<String, Object>> configuredEvents) {
        if (configuredEvents.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"configuredEvents is empty, returning true as all events are valid", (Object[])new Object[0]);
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("configuredEvents: " + configuredEvents.toString()), (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("size of configuredEvents: " + configuredEvents.size()), (Object[])new Object[0]);
        }
        for (Map<String, Object> events : configuredEvents) {
            if (events.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"no events or outcomes specified, all events and outcomes are honoured", (Object[])new Object[0]);
                }
                return true;
            }
            boolean isFoundEventName = false;
            String foundEventName = null;
            boolean isFoundOutcome = false;
            String foundOutcome = null;
            for (Map.Entry<String, Object> entry : events.entrySet()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("entry: " + entry.toString()), (Object[])new Object[0]);
                }
                if (entry.getKey().equals("CUSTOM") && entry.getValue().equals(Boolean.TRUE)) {
                    return true;
                }
                if (entry.getKey().equals("eventName")) {
                    isFoundEventName = true;
                    foundEventName = (String)entry.getValue();
                    if (this.validateEventName((String)entry.getValue())) continue;
                    String eventsList = "";
                    for (String temp : AuditConstants.validEventNamesList) {
                        eventsList = eventsList.concat(temp).concat(" ");
                    }
                    Tr.error((TraceComponent)tc, (String)INCORRECT_AUDIT_EVENT_CONFIGURATION, (Object[])new Object[]{foundEventName, handlerName, eventsList});
                    return false;
                }
                if (!entry.getKey().equals("outcome")) continue;
                isFoundOutcome = true;
                foundOutcome = (String)entry.getValue();
                if (this.validateOutcomeName((String)entry.getValue())) continue;
                String outcomesList = "";
                for (String temp : AuditConstants.validOutcomesList) {
                    outcomesList = outcomesList.concat(temp).concat(" ");
                }
                Tr.error((TraceComponent)tc, (String)INCORRECT_AUDIT_OUTCOME_CONFIGURATION, (Object[])new Object[]{foundOutcome, handlerName, outcomesList});
                return false;
            }
            if (isFoundEventName || !isFoundOutcome) continue;
            String eventsList = "";
            for (String temp : AuditConstants.validEventNamesList) {
                eventsList = eventsList.concat(temp).concat(" ");
            }
            Tr.error((TraceComponent)tc, (String)"INCORRECT_AUDIT_CONFIGURATION_OUTCOME_SPECIFIED_MISSING_EVENTNAME", (Object[])new Object[]{foundOutcome, handlerName, eventsList});
            return false;
        }
        return true;
    }

    public boolean validateEventName(String eventName) {
        boolean isValid = false;
        if (AuditConstants.validEventNamesList.contains(eventName)) {
            isValid = true;
        }
        return isValid;
    }

    public boolean validateOutcomeName(String outcome) {
        boolean isValid = false;
        if (AuditConstants.validOutcomesList.contains(outcome)) {
            isValid = true;
        }
        return isValid;
    }

    public void unRegisterEvents(String handlerName) {
        if (this.handlerEventsMap.containsKey(handlerName)) {
            if (this.handlerEventsMap.size() == 1) {
                this.auditStopped(null);
            }
            this.handlerEventsMap.remove(handlerName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handlerEventsMap: " + this.handlerEventsMap.toString()), (Object[])new Object[0]);
        }
    }

    public boolean isAuditRequired(String eventType, String outcome) {
        for (Map.Entry<String, List<Map<String, Object>>> handlerMap : this.handlerEventsMap.entrySet()) {
            List<Map<String, Object>> handlerEventsList = handlerMap.getValue();
            if (handlerEventsList.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"handlerEventsList is empty, returning true for isAuditRequired", (Object[])new Object[0]);
                }
                return true;
            }
            for (Map<String, Object> handlerEvents : handlerEventsList) {
                if (handlerEvents.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"no events or outcomes specified, all events and outcomes are honoured", (Object[])new Object[0]);
                    }
                    return true;
                }
                boolean foundMatchingEvent = false;
                boolean foundAnOutcome = false;
                boolean foundMatchingEventAndOutcome = false;
                for (Map.Entry<String, Object> entry : handlerEvents.entrySet()) {
                    if (entry.getKey().equals("eventName") && entry.getValue().equals(eventType)) {
                        foundMatchingEvent = true;
                        continue;
                    }
                    if (!entry.getKey().equals("outcome")) continue;
                    foundAnOutcome = true;
                    if (!entry.getValue().toString().equalsIgnoreCase(outcome) || !foundMatchingEvent) continue;
                    foundMatchingEventAndOutcome = true;
                }
                if (!foundMatchingEventAndOutcome && (!foundMatchingEvent || foundAnOutcome)) continue;
                return true;
            }
        }
        return false;
    }

    private GenericData map2GenericData(GenericData gdo, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                if (!entry.getKey().equals("target.appname")) continue;
                gdo.addPair(entry.getKey(), AuditUtils.getJ2EEComponentName());
                continue;
            }
            gdo.addPair(entry.getKey(), entry.getValue().toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("gdo: " + gdo.toString()), (Object[])new Object[0]);
        }
        return gdo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(AuditEvent event) {
        if (event == null) {
            this.emitSavedEvents();
        } else {
            String eo;
            String en = (String)event.getMap().get("eventName");
            if (this.isAuditRequired(en, eo = (String)event.getMap().get("outcome"))) {
                Object object = syncSeqNum;
                synchronized (object) {
                    if (event.getTarget().get("target.id") == "null" || event.getTarget().get("target.id") == null) {
                        event.set("target.id", (Object)this.getServerID());
                    }
                    if (event.getObserver().get("observer.id") == "null" || event.getObserver().get("observer.id") == null) {
                        event.set("observer.id", (Object)this.getServerID());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("sendEvent, bufferMgr = " + this.bufferMgr + " saved_bufferMgr = " + this.saved_bufferMgr), (Object[])new Object[0]);
                    }
                    if (this.bufferMgr != null && this.saved_bufferMgr != null) {
                        event.set("eventSequenceNumber", (Object)this.eventSequenceNumber++);
                        GenericData gdo = new GenericData();
                        gdo.setSourceName("com.ibm.ws.audit.source.auditsource");
                        long dateVal = System.currentTimeMillis();
                        gdo.addPair("ibm_datetime", dateVal);
                        gdo.addPair("ibm_sequence", this.sequenceNumber.next(dateVal));
                        gdo.addPair("ibm_threadId", new Integer((int)Thread.currentThread().getId()).intValue());
                        final GenericData f_gdo = gdo = this.map2GenericData(gdo, event.getMap());
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){
                            static final long serialVersionUID = -1675801668238874533L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public Void run() {
                                AuditServiceImpl.this.bufferMgr.add((Object)f_gdo);
                                return null;
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(1.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
                            }
                        });
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("gdo: " + gdo.toString()), (Object[])new Object[0]);
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("sendEvent, savedEventIndex = " + this.savedEventIndex + " saved event: " + event.toString()), (Object[])new Object[0]);
                        }
                        this.savedEvent[this.savedEventIndex++] = event;
                    }
                }
            }
        }
    }

    public void emitSavedEvents() {
        if (tc.isDebugEnabled() && this.bufferMgr == null) {
            Tr.debug((TraceComponent)tc, (String)"emitSavedEvents, bufferMgr is null", (Object[])new Object[0]);
        }
        if (this.bufferMgr != null && this.savedEvent != null && this.savedEvent.length > 0) {
            for (int i = 0; i < this.savedEventIndex; ++i) {
                this.sendEvent(this.savedEvent[i]);
            }
            this.savedEvent = new AuditEvent[10];
            this.savedEventIndex = 0;
        }
    }

    public String getSourceName() {
        return "audit";
    }

    public String getLocation() {
        return "server";
    }

    public void setBufferManager(BufferManager bufferMgr) {
        this.bufferMgr = bufferMgr;
        this.saved_bufferMgr = bufferMgr;
    }

    public void unsetBufferManager(BufferManager bufferMgr) {
        this.bufferMgr = null;
    }

    public void setEventName(Object value) {
        this.eventName = (String)value;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setIsCustomEvent(Object value) {
        this.isCustomEvent = (Boolean)value;
    }

    public Boolean getIsCustomEvent() {
        return this.isCustomEvent;
    }

    public void setAuditData(Object value) {
        this.auditData = ((String)value).split(", ");
    }

    public String[] getAuditData() {
        return this.auditData;
    }

    public void setOutcome(Object value) {
        this.outcome = ((String)value).split(", ");
    }

    public String[] getOutcome() {
        return this.outcome;
    }

    public String getServerID() {
        if (this.serverID == null) {
            String serverName = null;
            String serverHostName = null;
            String serverUserDir = null;
            serverName = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = 2227927240783736755L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    return ((VariableRegistry)variableRegistryServiceRef.getService()).resolveString(AuditServiceImpl.ENV_VAR_CONTAINERNAME);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
                }
            });
            if (ENV_VAR_CONTAINERNAME.equals(serverName)) {
                serverName = AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = -2623495597264900483L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        return ((VariableRegistry)variableRegistryServiceRef.getService()).resolveString(AuditServiceImpl.VAR_WLPSERVERNAME);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(3.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
                    }
                });
            }
            if (VAR_WLPSERVERNAME.equals(serverName)) {
                serverName = "";
            }
            if (VAR_WLPUSERDIR.equals(serverUserDir = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = 1266175293067549381L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    return ((VariableRegistry)variableRegistryServiceRef.getService()).resolveString(AuditServiceImpl.VAR_WLPUSERDIR);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
                }
            }))) {
                serverUserDir = "";
            }
            if (ENV_VAR_CONTAINERHOST.equals(serverHostName = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = -8691217427522735428L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    return ((VariableRegistry)variableRegistryServiceRef.getService()).resolveString(AuditServiceImpl.ENV_VAR_CONTAINERHOST);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(5.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
                }
            })) && (VAR_DEFAULTHOSTNAME.equals(serverHostName = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = 4091797805058126250L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    return ((VariableRegistry)variableRegistryServiceRef.getService()).resolveString(AuditServiceImpl.VAR_DEFAULTHOSTNAME);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(6.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
                }
            })) || serverHostName.equals("localhost"))) {
                try {
                    serverHostName = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                        static final long serialVersionUID = -4819644461941220785L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public String run() throws UnknownHostException {
                            return InetAddress.getLocalHost().getCanonicalHostName();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(7.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.audit.source.AuditServiceImpl", (String)"646", (Object)this, (Object[])new Object[0]);
                    serverHostName = "";
                }
            }
            this.serverID = AUDIT_SERVER_ID_PREFIX + serverHostName + AUDIT_SERVER_ID_SEPARATOR + serverUserDir + AUDIT_SERVER_ID_SEPARATOR + serverName;
        }
        return this.serverID;
    }
}

