/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleType;
import com.ibm.ws.jaxws.metadata.ServiceSecurityInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsModuleInfo
implements Serializable {
    private static final long serialVersionUID = -8116043459266953308L;
    private final JaxWsModuleType moduleType;
    private final Map<String, EndpointInfo> endpointInfoMap = new HashMap<String, EndpointInfo>();
    private String contextRoot;
    private transient ServiceSecurityInfo serviceSecurityInfo;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JaxWsModuleInfo(JaxWsModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public void addEndpointInfo(String name, EndpointInfo endpointInfo) {
        endpointInfo.setPortLink(name);
        this.endpointInfoMap.put(name, endpointInfo);
    }

    public EndpointInfo getEndpointInfo(String name) {
        return this.endpointInfoMap.get(name);
    }

    public Set<String> getEndpointNames() {
        return Collections.unmodifiableSet(this.endpointInfoMap.keySet());
    }

    public Collection<EndpointInfo> getEndpointInfos() {
        return Collections.unmodifiableCollection(this.endpointInfoMap.values());
    }

    public boolean contains(String name) {
        return this.endpointInfoMap.containsKey(name);
    }

    public int endpointInfoSize() {
        return this.endpointInfoMap.size();
    }

    public Map<String, EndpointInfo> getEndpointInfoMap() {
        return Collections.unmodifiableMap(this.endpointInfoMap);
    }

    public Set<String> getEndpointImplBeanClassNames() {
        HashSet<String> serviceClassNames = new HashSet<String>();
        for (EndpointInfo endpointInfo : this.endpointInfoMap.values()) {
            serviceClassNames.add(endpointInfo.getImplBeanClassName());
        }
        return serviceClassNames;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public ServiceSecurityInfo getServiceSecurityInfo() {
        return this.serviceSecurityInfo;
    }

    public void setServiceSecurityInfo(ServiceSecurityInfo serviceSecurityInfo) {
        this.serviceSecurityInfo = serviceSecurityInfo;
    }

    public JaxWsModuleType getModuleType() {
        return this.moduleType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JaxWsModuleInfo.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    }
}

