/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer40.srt;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.websphere.servlet40.IResponse40;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer31.osgi.srt.SRTConnectionContext31;
import com.ibm.ws.webcontainer31.srt.SRTServletResponse31;
import com.ibm.ws.webcontainer40.osgi.srt.SRTConnectionContext40;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer40.WCCustomProperties40;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class SRTServletResponse40
extends SRTServletResponse31
implements HttpServletResponse {
    private static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer40.srt");
    private static final TraceNLS servlet40NLS = TraceNLS.getTraceNLS(SRTServletResponse40.class, (String)"com.ibm.ws.webcontainer40.resources.Messages");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer40.srt.SRTServletResponse40";
    ArrayList<Cookie> addedCookies;
    private Supplier<Map<String, String>> trailerFieldSupplier;

    public SRTServletResponse40(SRTConnectionContext40 context) {
        super((SRTConnectionContext31)context);
    }

    public void initForNextResponse(IResponse resp) {
        super.initForNextResponse(resp);
        this.addedCookies = null;
    }

    protected String getXPoweredbyHeader() {
        return "Servlet/4.0";
    }

    public void addCookie(Cookie cookie) {
        WebAppDispatcherContext dispatchContext;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addCookie", "Adding cookie --> " + cookie.getName(), "[" + (Object)((Object)this) + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addCookie", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addCookie cookie --> " + cookie.getName());
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
            if (this.logWarningActionNow(wrapper)) {
                this.logAlreadyCommittedWarning(new Throwable(), "addCookie");
            } else {
                logger.logp(Level.FINE, CLASS_NAME, "addCookie", "Cannot set header.  Response already committed.");
            }
        } else {
            this._response.addCookie(cookie);
            if (this.addedCookies == null) {
                this.addedCookies = new ArrayList();
            }
            this.addedCookies.add(cookie);
        }
    }

    public Cookie[] getAddedCookies() {
        if (this.addedCookies != null) {
            Cookie[] cookies = new Cookie[this.addedCookies.size()];
            return this.addedCookies.toArray(cookies);
        }
        return null;
    }

    public void setTrailerFields(Supplier<Map<String, String>> supplier) throws IllegalStateException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setTrailerFields", "[" + (Object)((Object)this) + "]");
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(servlet40NLS.getString("set.trailer.fields.committed.response"));
        }
        IExtendedRequest extendedReq = this.getRequest();
        IRequest req = extendedReq.getIRequest();
        String httpProtocol = req.getProtocol();
        String[] args = httpProtocol.split("/");
        float version = Float.valueOf(args[1]).floatValue();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setTrailerFields", "httpProtocol = " + httpProtocol);
            logger.logp(Level.FINE, CLASS_NAME, "setTrailerFields", "version = " + version);
        }
        if ((double)version >= 1.1) {
            String transferEncoding = this.getHeader("Transfer-Encoding");
            String contentLength = this.getHeader("Content-Length");
            int contentLengthValue = -1;
            if (contentLength != null) {
                contentLengthValue = Integer.valueOf(contentLength);
            }
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setTrailerFields", "transferEncoding = " + transferEncoding);
                logger.logp(Level.FINE, CLASS_NAME, "setTrailerFields", "contentLengthInt = " + contentLengthValue);
            }
            if (transferEncoding != null && !transferEncoding.equals("chunked") || contentLengthValue > 0) {
                throw new IllegalStateException(servlet40NLS.getString("set.trailer.fields.incorrect.transfer.encoding"));
            }
        } else {
            throw new IllegalStateException(servlet40NLS.getString("set.trailer.fields.incorrect.http.version"));
        }
        this.trailerFieldSupplier = supplier;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setTrailerFields", "supplier : " + this.trailerFieldSupplier);
        }
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getTrailerFields", "trailerFieldSupplier = " + this.trailerFieldSupplier + " [" + (Object)((Object)this) + "]");
        }
        return this.trailerFieldSupplier;
    }

    public void finish() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "finish", " trailerFieldSupplier = " + this.trailerFieldSupplier + "[" + (Object)((Object)this) + "]");
        }
        if (this.trailerFieldSupplier != null) {
            if (!this.trailerFieldSupplier.get().isEmpty()) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "finish", " set trailer fields [" + (Object)((Object)this) + "]");
                }
                ((IResponse40)this._response).setTrailers(this.trailerFieldSupplier.get());
            } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "finish", "supplier is empty");
            }
        }
        super.finish();
    }

    protected String getSpecLevelEncoding(String encoding, WebApp webApp) {
        String servlet40encoding = null;
        if (webApp != null) {
            servlet40encoding = webApp.getConfiguration().getModuleResponseEncoding();
            if (servlet40encoding != null && EncodingUtils.isCharsetSupported((String)encoding)) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getSpecLevelEncoding", "Encoding from web module [" + encoding + "]");
                }
            } else {
                servlet40encoding = null;
            }
        }
        if (servlet40encoding == null) {
            servlet40encoding = WCCustomProperties40.SERVER_RESPONSE_ENCODING;
            if (servlet40encoding != null && !encoding.isEmpty() && EncodingUtils.isCharsetSupported((String)encoding)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getSpecLevelEncoding", "Encoding from WC property->[" + encoding + "]");
                }
            } else {
                servlet40encoding = null;
            }
        }
        if (servlet40encoding == null) {
            servlet40encoding = encoding;
        }
        return servlet40encoding;
    }
}

