/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jbatch.rest.utils.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipHelper {
    static final long serialVersionUID = 2179114279668492059L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void zipFileToStream(File file, List<File> zipRootDirs, OutputStream outputStream) throws IOException {
        ZipHelper.zipFilesToStream(Arrays.asList(file), zipRootDirs, outputStream);
    }

    public static void zipFileToStream(File file, File zipRootDir, OutputStream outputStream) throws IOException {
        ZipHelper.zipFilesToStream(Arrays.asList(file), Arrays.asList(zipRootDir), outputStream);
    }

    public static void zipFilesToStream(List<File> files, List<File> zipRootDirs, OutputStream outputStream) throws IOException {
        ZipOutputStream zipStream = new ZipOutputStream(outputStream);
        for (File file : files) {
            zipStream.putNextEntry(new ZipEntry(ZipHelper.getNormalizedRelativePath(file, zipRootDirs)));
            ZipHelper.copyStream(new FileInputStream(file), zipStream);
            zipStream.closeEntry();
        }
        zipStream.close();
    }

    public static void zipFilesToStream(List<File> files, File zipRootDir, OutputStream outputStream) throws IOException {
        ZipHelper.zipFilesToStream(files, Arrays.asList(zipRootDir), outputStream);
    }

    protected static String getNormalizedRelativePath(File file, List<File> rootDirs) throws IOException {
        for (File rootDir : rootDirs) {
            if (!file.getCanonicalPath().contains(rootDir.getCanonicalPath())) continue;
            return StringUtils.normalizePath(ZipHelper.getRelativePath(file, rootDir));
        }
        return "";
    }

    protected static String getRelativePath(File file, File rootDir) throws IOException {
        return StringUtils.trimPrefix(file.getCanonicalPath(), rootDir.getParentFile().getCanonicalPath() + File.separator);
    }

    public static void copyStream(InputStream from, OutputStream to) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        while ((bytesRead = from.read(buffer)) != -1) {
            to.write(buffer, 0, bytesRead);
        }
        from.close();
    }

    public static void aggregateFilesToStream(List<File> files, List<File> rootDirs, OutputStream outputStream) throws IOException {
        for (File file : files) {
            outputStream.write(ZipHelper.buildAggregateHeader(file, rootDirs).getBytes("UTF-8"));
            ZipHelper.copyStream(new FileInputStream(file), outputStream);
            outputStream.write(ZipHelper.buildAggregateFooter(file, rootDirs).getBytes("UTF-8"));
        }
    }

    public static void aggregateFilesToStream(List<File> files, File rootDir, OutputStream outputStream) throws IOException {
        ZipHelper.aggregateFilesToStream(files, Arrays.asList(rootDir), outputStream);
    }

    protected static String buildAggregateHeader(File file, List<File> rootDirs) throws IOException {
        return "xxxxx Begin file: " + ZipHelper.getNormalizedRelativePath(file, rootDirs) + " xxxxxxxxxxxxxxxxxx\n";
    }

    protected static String buildAggregateFooter(File file, List<File> rootDirs) throws IOException {
        return "\nxxxxx End file: " + ZipHelper.getNormalizedRelativePath(file, rootDirs) + " xxxxxxxxxxxxxxxxxx\n";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ZipHelper.class, (String)"wsbatch", null);
    }
}

