/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.internal.resources;

import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.rest.internal.resources.RequestHandler;
import com.ibm.ws.jbatch.rest.internal.resources.RequestRouter;
import com.ibm.ws.jbatch.rest.utils.BatchJSONHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import javax.batch.operations.JobSecurityException;
import javax.batch.runtime.BatchRuntime;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JobDefinitions
implements RESTHandler {
    private WSJobRepository jobRepository;
    private RequestRouter requestRouter = new RequestRouter().addHandler(new JobDefinitionsHandler());
    static final long serialVersionUID = -1103767869466787550L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSJobRepository(WSJobRepository ref) {
        this.jobRepository = ref;
    }

    protected void unsetWSJobRepository(WSJobRepository ref) {
        if (this.jobRepository == ref) {
            this.jobRepository = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        try {
            BatchRuntime.getJobOperator();
            this.requestRouter.routeRequest(request, response);
        }
        catch (JobSecurityException jobSecurityException) {
            void jse;
            FFDCFilter.processException((Throwable)jobSecurityException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobDefinitions", (String)"76", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(401, jse.getMessage());
        }
        catch (Exception jse) {
            void e;
            FFDCFilter.processException((Throwable)jse, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobDefinitions", (String)"78", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(500, e.getMessage());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JobDefinitions.class, (String)"wsbatch", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobDefinitionsHandler
    extends RequestHandler {
        static final long serialVersionUID = -1852269639639884870L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public JobDefinitionsHandler() {
            super("/batch/jobdefinitions");
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            if (request.isUserInRole("Administrator")) {
                response.setContentType("application/json; charset=UTF-8");
                BatchJSONHelper.writeJobDefinitions(JobDefinitions.this.jobRepository.getJobNames(), response.getOutputStream());
            } else {
                response.setStatus(401);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(JobDefinitionsHandler.class, (String)"wsbatch", null);
        }
    }
}

