/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.spi.IIOPEndpoint;
import com.ibm.wsspi.channelfw.ChannelConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class IIOPEndpointImpl
implements IIOPEndpoint {
    private static final TraceComponent tc = Tr.register(IIOPEndpointImpl.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
    private String host;
    private int iiopPort;
    private List<Map<String, Object>> iiopsOptions;
    private ChannelConfiguration tcpOptions;
    static final long serialVersionUID = -3601378638714062100L;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setTcpOptions(ChannelConfiguration service) {
        this.tcpOptions = service;
    }

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        this.host = (String)properties.get("host");
        Integer iiopPort = (Integer)properties.get("iiopPort");
        this.iiopPort = iiopPort == null ? -1 : iiopPort;
        this.iiopsOptions = Nester.nest("iiopsOptions", properties);
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private void resolveListenerAddress() throws PrivilegedActionException {
        if (this.host == null) {
            try {
                this.host = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                    static final long serialVersionUID = 1271184699950567092L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() throws UnknownHostException {
                        return InetAddress.getLocalHost().getHostName();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"IiopEndpoint cannot determine name of local host", (Object[])new Object[]{e});
                }
                this.host = "localhost";
            }
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getIiopPort() {
        return this.iiopPort;
    }

    @Override
    public Map<String, Object> getTcpOptions() {
        return this.tcpOptions.getConfiguration();
    }

    @Override
    public List<Map<String, Object>> getIiopsOptions() {
        return this.iiopsOptions;
    }
}

