/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.concurrent.persistent;

import com.ibm.websphere.concurrent.persistent.PersistentExecutor;
import com.ibm.websphere.concurrent.persistent.TaskStatus;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl;
import com.ibm.ws.concurrent.persistent.internal.TaskStatusImpl;
import com.ibm.ws.concurrent.persistent.internal.Utils;
import java.util.Arrays;

@Trivial
public final class TaskRecord {
    private static final String EOLN = String.format("%n", new Object[0]);
    private static final int ID = 1;
    private static final int ID_OF_CLASSLOADER = 2;
    private static final int ID_OF_OWNER = 4;
    private static final int ID_OF_PARTITION = 8;
    private static final int MISC_BINARY_FLAGS = 16;
    private static final int NAME = 32;
    private static final int NEXT_EXEC_TIME = 64;
    private static final int ORIG_SUBMIT_TIME = 128;
    private static final int PREV_SCHED_START_TIME = 256;
    private static final int PREV_START_TIME = 512;
    private static final int PREV_STOP_TIME = 1024;
    private static final int RESULT = 2048;
    private static final int RFAILS = 4096;
    private static final int STATE = 8192;
    private static final int TASK = 16384;
    private static final int TASK_INFO = 32768;
    private static final int TRIGGER = 65536;
    private static final int TX_TIMEOUT = 131072;
    private static final int VERSION = 262144;
    private int attrs;
    private short consecutiveFailureCount;
    private long id;
    private String idOfClassLoader;
    private String idOfOwner;
    private long idOfPartition;
    private short miscBinaryFlags;
    private String name;
    private long nextExecTime;
    private long origSubmitTime;
    private Long prevSchedStartTime;
    private Long prevStartTime;
    private Long prevStopTime;
    private byte[] result;
    private short state;
    private byte[] task;
    private byte[] taskInfo;
    private byte[] trigger;
    private int txTimeout;
    private int version;

    public TaskRecord(boolean allAttributesAreSpecified) {
        this.attrs = allAttributesAreSpecified ? 65535 : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TaskRecord) {
            TaskRecord other = (TaskRecord)obj;
            return !(this.attrs != other.attrs || (this.attrs & 1) != 0 && this.id != other.id || (this.attrs & 2) != 0 && !TaskRecord.match(this.idOfClassLoader, other.idOfClassLoader) || (this.attrs & 4) != 0 && !TaskRecord.match(this.idOfOwner, other.idOfOwner) || (this.attrs & 8) != 0 && this.idOfPartition != other.idOfPartition || (this.attrs & 0x10) != 0 && this.miscBinaryFlags != other.miscBinaryFlags || (this.attrs & 0x20) != 0 && !TaskRecord.match(this.name, other.name) || (this.attrs & 0x40) != 0 && this.nextExecTime != other.nextExecTime || (this.attrs & 0x80) != 0 && this.origSubmitTime != other.origSubmitTime || (this.attrs & 0x100) != 0 && !TaskRecord.match(this.prevSchedStartTime, other.prevSchedStartTime) || (this.attrs & 0x200) != 0 && !TaskRecord.match(this.prevStartTime, other.prevStartTime) || (this.attrs & 0x400) != 0 && !TaskRecord.match(this.prevStopTime, other.prevStopTime) || (this.attrs & 0x800) != 0 && !Arrays.equals(this.result, other.result) || (this.attrs & 0x1000) != 0 && this.consecutiveFailureCount != other.consecutiveFailureCount || (this.attrs & 0x2000) != 0 && this.state != other.state || (this.attrs & 0x4000) != 0 && !Arrays.equals(this.task, other.task) || (this.attrs & 0x8000) != 0 && !Arrays.equals(this.taskInfo, other.taskInfo) || (this.attrs & 0x10000) != 0 && !Arrays.equals(this.trigger, other.trigger) || (this.attrs & 0x20000) != 0 && this.txTimeout != other.txTimeout || (this.attrs & 0x40000) != 0 && this.version != other.version);
        }
        return false;
    }

    public final short getConsecutiveFailureCount() {
        if ((this.attrs & 0x1000) == 0) {
            throw new IllegalStateException();
        }
        return this.consecutiveFailureCount;
    }

    public final long getId() {
        if ((this.attrs & 1) == 0) {
            throw new IllegalStateException();
        }
        return this.id;
    }

    public final String getIdentifierOfClassLoader() {
        if ((this.attrs & 2) == 0) {
            throw new IllegalStateException();
        }
        return this.idOfClassLoader;
    }

    public final String getIdentifierOfOwner() {
        if ((this.attrs & 4) == 0) {
            throw new IllegalStateException();
        }
        return this.idOfOwner;
    }

    public final long getIdentifierOfPartition() {
        if ((this.attrs & 8) == 0) {
            throw new IllegalStateException();
        }
        return this.idOfPartition;
    }

    public final short getMiscBinaryFlags() {
        if ((this.attrs & 0x10) == 0) {
            throw new IllegalStateException();
        }
        return this.miscBinaryFlags;
    }

    public final String getName() {
        if ((this.attrs & 0x20) == 0) {
            throw new IllegalStateException();
        }
        return this.name;
    }

    public final long getNextExecutionTime() {
        if ((this.attrs & 0x40) == 0) {
            throw new IllegalStateException();
        }
        return this.nextExecTime;
    }

    public final long getOriginalSubmitTime() {
        if ((this.attrs & 0x80) == 0) {
            throw new IllegalStateException();
        }
        return this.origSubmitTime;
    }

    public final Long getPreviousScheduledStartTime() {
        if ((this.attrs & 0x100) == 0) {
            throw new IllegalStateException();
        }
        return this.prevSchedStartTime;
    }

    public final Long getPreviousStartTime() {
        if ((this.attrs & 0x200) == 0) {
            throw new IllegalStateException();
        }
        return this.prevStartTime;
    }

    public final Long getPreviousStopTime() {
        if ((this.attrs & 0x400) == 0) {
            throw new IllegalStateException();
        }
        return this.prevStopTime;
    }

    public final byte[] getResult() {
        if ((this.attrs & 0x800) == 0) {
            throw new IllegalStateException();
        }
        return this.result;
    }

    public final short getState() {
        if ((this.attrs & 0x2000) == 0) {
            throw new IllegalStateException();
        }
        return this.state;
    }

    public final byte[] getTask() {
        if ((this.attrs & 0x4000) == 0) {
            throw new IllegalStateException();
        }
        return this.task;
    }

    public final byte[] getTaskInformation() {
        if ((this.attrs & 0x8000) == 0) {
            throw new IllegalStateException();
        }
        return this.taskInfo;
    }

    public int getTransactionTimeout() {
        if ((this.attrs & 0x20000) == 0) {
            throw new IllegalStateException();
        }
        return this.txTimeout;
    }

    public final byte[] getTrigger() {
        if ((this.attrs & 0x10000) == 0) {
            throw new IllegalStateException();
        }
        return this.trigger;
    }

    public final int getVersion() {
        if ((this.attrs & 0x40000) == 0) {
            throw new IllegalStateException();
        }
        return this.version;
    }

    public final int hashCode() {
        return (int)this.id;
    }

    public final boolean hasConsecutiveFailureCount() {
        return (this.attrs & 0x1000) != 0;
    }

    public final boolean hasId() {
        return (this.attrs & 1) != 0;
    }

    public final boolean hasIdentifierOfClassLoader() {
        return (this.attrs & 2) != 0;
    }

    public final boolean hasIdentifierOfOwner() {
        return (this.attrs & 4) != 0;
    }

    public final boolean hasIdentifierOfPartition() {
        return (this.attrs & 8) != 0;
    }

    public final boolean hasMiscBinaryFlags() {
        return (this.attrs & 0x10) != 0;
    }

    public final boolean hasName() {
        return (this.attrs & 0x20) != 0;
    }

    public final boolean hasNextExecutionTime() {
        return (this.attrs & 0x40) != 0;
    }

    public final boolean hasOriginalSubmitTime() {
        return (this.attrs & 0x80) != 0;
    }

    public final boolean hasPreviousScheduledStartTime() {
        return (this.attrs & 0x100) != 0;
    }

    public final boolean hasPreviousStartTime() {
        return (this.attrs & 0x200) != 0;
    }

    public final boolean hasPreviousStopTime() {
        return (this.attrs & 0x400) != 0;
    }

    public final boolean hasResult() {
        return (this.attrs & 0x800) != 0;
    }

    public final boolean hasState() {
        return (this.attrs & 0x2000) != 0;
    }

    public final boolean hasTask() {
        return (this.attrs & 0x4000) != 0;
    }

    public final boolean hasTaskInformation() {
        return (this.attrs & 0x8000) != 0;
    }

    public final boolean hasTransactionTimeout() {
        return (this.attrs & 0x20000) != 0;
    }

    public final boolean hasTrigger() {
        return (this.attrs & 0x10000) != 0;
    }

    public final boolean hasVersion() {
        return (this.attrs & 0x40000) != 0;
    }

    private static final boolean match(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public final void setConsecutiveFailureCount(short consecutiveFailureCount) {
        this.consecutiveFailureCount = consecutiveFailureCount;
        this.attrs |= 0x1000;
    }

    public final void setId(long id) {
        this.id = id;
        this.attrs |= 1;
    }

    public final void setIdentifierOfClassLoader(String identifier) {
        this.idOfClassLoader = identifier;
        this.attrs |= 2;
    }

    public final void setIdentifierOfOwner(String identifier) {
        this.idOfOwner = identifier;
        this.attrs |= 4;
    }

    public final void setIdentifierOfPartition(long partitionId) {
        this.idOfPartition = partitionId;
        this.attrs |= 8;
    }

    public final void setMiscBinaryFlags(short miscBinaryFlags) {
        this.miscBinaryFlags = miscBinaryFlags;
        this.attrs |= 0x10;
    }

    public final void setName(String name) {
        this.name = name;
        this.attrs |= 0x20;
    }

    public final void setNextExecutionTime(long nextExecTime) {
        this.nextExecTime = nextExecTime;
        this.attrs |= 0x40;
    }

    public final void setOriginalSubmitTime(long origSubmitTime) {
        this.origSubmitTime = origSubmitTime;
        this.attrs |= 0x80;
    }

    public final void setPreviousScheduledStartTime(Long prevSchedStartTime) {
        this.prevSchedStartTime = prevSchedStartTime;
        this.attrs |= 0x100;
    }

    public final void setPreviousStartTime(Long prevStartTime) {
        this.prevStartTime = prevStartTime;
        this.attrs |= 0x200;
    }

    public final void setPreviousStopTime(Long prevStopTime) {
        this.prevStopTime = prevStopTime;
        this.attrs |= 0x400;
    }

    public final void setResult(byte[] result) {
        this.result = result;
        this.attrs |= 0x800;
    }

    public final void setState(short state) {
        this.state = state;
        this.attrs |= 0x2000;
    }

    public final void setTask(byte[] task) {
        this.task = task;
        this.attrs |= 0x4000;
    }

    public final void setTaskInformation(byte[] taskInfo) {
        this.taskInfo = taskInfo;
        this.attrs |= 0x8000;
    }

    public final void setTransactionTimeout(int txTimeout) {
        this.txTimeout = txTimeout;
        this.attrs |= 0x20000;
    }

    public final void setTrigger(byte[] trigger) {
        this.trigger = trigger;
        this.attrs |= 0x10000;
    }

    public final void setVersion(int version) {
        this.version = version;
        this.attrs |= 0x40000;
    }

    public String toString() {
        StringBuilder output = new StringBuilder(500).append("TaskRecord");
        if ((this.attrs & 1) != 0) {
            output.append('[').append(this.id).append(']');
        }
        output.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        if ((this.attrs & 2) != 0) {
            output.append(EOLN).append("CLASSLOADER=").append(this.idOfClassLoader);
        }
        if ((this.attrs & 4) != 0) {
            output.append(EOLN).append("OWNER=").append(this.idOfOwner);
        }
        if ((this.attrs & 8) != 0) {
            output.append(EOLN).append("PARTITION=").append(this.idOfPartition);
        }
        if ((this.attrs & 0x10) != 0) {
            output.append(EOLN).append("FLAGS=").append(Integer.toBinaryString(this.miscBinaryFlags));
        }
        if ((this.attrs & 0x20) != 0) {
            output.append(EOLN).append("NAME=").append(this.name);
        }
        if ((this.attrs & 0x40) != 0) {
            Utils.appendDate(output.append(EOLN).append("NEXTEXEC="), this.nextExecTime);
        }
        if ((this.attrs & 0x80) != 0) {
            Utils.appendDate(output.append(EOLN).append("ORIGSBMT="), this.origSubmitTime);
        }
        if ((this.attrs & 0x100) != 0) {
            Utils.appendDate(output.append(EOLN).append("PREVSCHD="), this.prevSchedStartTime);
        }
        if ((this.attrs & 0x200) != 0) {
            Utils.appendDate(output.append(EOLN).append("PREVSTRT="), this.prevStartTime);
        }
        if ((this.attrs & 0x400) != 0) {
            Utils.appendDate(output.append(EOLN).append("PREVSTOP="), this.prevStopTime);
        }
        if ((this.attrs & 0x800) != 0) {
            output.append(EOLN).append("RESULT=");
            if (this.result != null) {
                output.append("byte[").append(this.result.length).append(']');
            }
        }
        if ((this.attrs & 0x1000) != 0) {
            output.append(EOLN).append("FAILURES=").append(this.consecutiveFailureCount);
        }
        if ((this.attrs & 0x2000) != 0) {
            Utils.appendState(output.append(EOLN).append("STATE="), this.state);
        }
        if ((this.attrs & 0x4000) != 0) {
            output.append(EOLN).append("TASK=");
            if (this.task != null) {
                output.append("byte[").append(this.task.length).append(']');
            }
        }
        if ((this.attrs & 0x8000) != 0) {
            output.append(EOLN).append("TASKINFO=");
            if (this.taskInfo != null) {
                output.append("byte[").append(this.taskInfo.length).append(']');
            }
        }
        if ((this.attrs & 0x10000) != 0) {
            output.append(EOLN).append("TRIGGER=");
            if (this.trigger != null) {
                output.append("byte[").append(this.trigger.length).append(']');
            }
        }
        if ((this.attrs & 0x20000) != 0) {
            output.append(EOLN).append("TXTIMEOUT=").append(this.txTimeout);
        }
        if ((this.attrs & 0x40000) != 0) {
            output.append(EOLN).append("VERSION=").append(this.version);
        }
        return output.toString();
    }

    public <T> TaskStatus<T> toTaskStatus(PersistentExecutor executor) {
        return new TaskStatusImpl(this, (PersistentExecutorImpl)executor);
    }

    public final void unsetConsecutiveFailureCount() {
        this.attrs &= 0xFFFFEFFF;
    }

    public final void unsetId() {
        this.attrs &= 0xFFFFFFFE;
    }

    public final void unsetIdentifierOfClassLoader() {
        this.attrs &= 0xFFFFFFFD;
    }

    public final void unsetIdentifierOfOwner() {
        this.attrs &= 0xFFFFFFFB;
    }

    public final void unsetIdentifierOfPartition() {
        this.attrs &= 0xFFFFFFF7;
    }

    public final void unsetMiscBinaryFlags() {
        this.attrs &= 0xFFFFFFEF;
    }

    public final void unsetName() {
        this.attrs &= 0xFFFFFFDF;
    }

    public final void unsetNextExecutionTime() {
        this.attrs &= 0xFFFFFFBF;
    }

    public final void unsetOriginalSubmitTime() {
        this.attrs &= 0xFFFFFF7F;
    }

    public final void unsetPreviousScheduledStartTime() {
        this.attrs &= 0xFFFFFEFF;
    }

    public final void unsetPreviousStartTime() {
        this.attrs &= 0xFFFFFDFF;
    }

    public final void unsetPreviousStopTime() {
        this.attrs &= 0xFFFFFBFF;
    }

    public final void unsetResult() {
        this.attrs &= 0xFFFFF7FF;
    }

    public final void unsetState() {
        this.attrs &= 0xFFFFDFFF;
    }

    public final void unsetTask() {
        this.attrs &= 0xFFFFBFFF;
    }

    public final void unsetTaskInformation() {
        this.attrs &= 0xFFFF7FFF;
    }

    public final void unsetTransactionTimeout() {
        this.attrs &= 0xFFFDFFFF;
    }

    public final void unsetTrigger() {
        this.attrs &= 0xFFFEFFFF;
    }

    public final void unsetVersion() {
        this.attrs &= 0xFFFBFFFF;
    }

    @Trivial
    public static enum Flags {
        AUTO_PURGE_ALWAYS(1),
        AUTO_PURGE_ON_SUCCESS(2),
        EJB_SINGLETON(8),
        EJB_TIMER(16),
        ONE_SHOT_TASK(256),
        SUSPEND_TRAN_OF_EXECUTOR_THREAD(4096);

        public final short bit;

        private Flags(short bit) {
            this.bit = bit;
        }
    }
}

