/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.equinox.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.equinox.module.internal.ModuleBundleFile;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.artifact.equinox.module.ModuleContainerFinder;
import com.ibm.wsspi.kernel.equinox.module.ModuleBundleFileFactory;
import com.ibm.wsspi.kernel.equinox.module.ModuleInfo;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ModuleBundleFileFactoryImpl
implements ModuleBundleFileFactory {
    ConcurrentServiceReferenceSet<ModuleContainerFinder> containerFinders = new ConcurrentServiceReferenceSet("ContainerFinder");
    Map<File, Container> nestedFiles = Collections.synchronizedMap(new HashMap());
    BundleContext context;
    static final long serialVersionUID = 922548402845661164L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(ComponentContext ctx) {
        this.containerFinders.activate(ctx);
        this.context = ctx.getBundleContext();
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        this.containerFinders.deactivate(ctx);
    }

    public BundleFileWrapper createBundleFile(ModuleInfo moduleInfo) {
        Container container = this.getContainer(moduleInfo);
        return container == null ? null : new ModuleBundleFile(container, moduleInfo.getBundleFile(), this.nestedFiles, this.context);
    }

    private Container getContainer(ModuleInfo moduleInfo) {
        if (moduleInfo.isBundleRoot()) {
            Iterator iFinders = this.containerFinders.getServices();
            while (iFinders.hasNext()) {
                Container result = ((ModuleContainerFinder)iFinders.next()).findContainer(moduleInfo.getLocation());
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return this.nestedFiles.get(moduleInfo.getBundleFile().getBaseFile());
    }

    @Reference(service=ModuleContainerFinder.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setContainerFinder(ServiceReference<ModuleContainerFinder> ref) {
        this.containerFinders.addReference(ref);
    }

    protected void unsetContainerFinder(ServiceReference<ModuleContainerFinder> ref) {
        this.containerFinders.removeReference(ref);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ModuleBundleFileFactoryImpl.class, (String)"equinox.module", null);
    }
}

