/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.metrics.impl.CounterImpl;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BaseMetrics {
    private static BaseMetrics baseMetrics;
    private static String BASE;
    MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private static Set<String> gcObjectNames;
    private static SharedMetricRegistries SHARED_METRIC_REGISTRY;
    static final long serialVersionUID = -6196655065527816198L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static synchronized BaseMetrics getInstance(SharedMetricRegistries sharedMetricRegistry) {
        SHARED_METRIC_REGISTRY = sharedMetricRegistry;
        if (baseMetrics == null) {
            baseMetrics = new BaseMetrics();
        }
        return baseMetrics;
    }

    protected BaseMetrics() {
        Set<ObjectInstance> mBeanObjectInstanceSet = this.mbs.queryMBeans(null, null);
        this.populateGcNames(mBeanObjectInstanceSet);
        this.createBaseMetrics();
    }

    private void populateGcNames(Set<ObjectInstance> mBeanObjectInstanceSet) {
        for (ObjectInstance objInstance : mBeanObjectInstanceSet) {
            String objectName = objInstance.getObjectName().toString();
            if (!objectName.matches("java.lang:.*type=GarbageCollector.*")) continue;
            for (String subString : objectName.split(",")) {
                if (!(subString = subString.trim()).contains("name=")) continue;
                String name = subString.split("=")[1];
                gcObjectNames.add(name);
            }
        }
    }

    public void createBaseMetrics() {
        MetricRegistry registry = SHARED_METRIC_REGISTRY.getOrCreate(BASE);
        registry.register(Metadata.builder().withName("memory.usedHeap").withDisplayName("Used Heap Memory").withDescription("memory.usedHeap.description").withType(MetricType.GAUGE).withUnit("bytes").build(), new BMGauge("java.lang:type=Memory", "HeapMemoryUsage", "used"));
        registry.register(Metadata.builder().withName("memory.committedHeap").withDisplayName("Committed Heap Memory").withDescription("memory.committedHeap.description").withType(MetricType.GAUGE).withUnit("bytes").build(), new BMGauge("java.lang:type=Memory", "HeapMemoryUsage", "committed"));
        registry.register(Metadata.builder().withName("memory.maxHeap").withDisplayName("Max Heap Memory").withDescription("memory.maxHeap.description").withType(MetricType.GAUGE).withUnit("bytes").build(), new BMGauge("java.lang:type=Memory", "HeapMemoryUsage", "max"));
        registry.register(Metadata.builder().withName("jvm.uptime").withDisplayName("JVM Uptime").withDescription("jvm.uptime.description").withType(MetricType.GAUGE).withUnit("milliseconds").build(), new BMGauge("java.lang:type=Runtime", "Uptime"));
        registry.register(Metadata.builder().withName("thread.count").withDisplayName("Thread Count").withDescription("thread.count.description").withType(MetricType.GAUGE).withUnit("none").build(), new BMGauge("java.lang:type=Threading", "ThreadCount"));
        registry.register(Metadata.builder().withName("thread.daemon.count").withDisplayName("Daemon Thread Count").withDescription("thread.daemon.count.description").withType(MetricType.GAUGE).withUnit("none").build(), new BMGauge("java.lang:type=Threading", "DaemonThreadCount"));
        registry.register(Metadata.builder().withName("thread.max.count").withDisplayName("Peak Thread Count").withDescription("thread.max.count.description").withType(MetricType.GAUGE).withUnit("none").build(), new BMGauge("java.lang:type=Threading", "PeakThreadCount"));
        registry.register(Metadata.builder().withName("classloader.loadedClasses.count").withDisplayName("Current Loaded Class Count").withDescription("classloader.currentLoadedClass.count.description").withType(MetricType.GAUGE).withUnit("none").build(), new BMGauge("java.lang:type=ClassLoading", "LoadedClassCount"));
        registry.register(Metadata.builder().withName("classloader.loadedClasses.total").withDisplayName("Total Loaded Class Count").withDescription("classloader.totalLoadedClass.count.description").withType(MetricType.COUNTER).withUnit("none").build(), (Metric)new BMCounter("java.lang:type=ClassLoading", "TotalLoadedClassCount"));
        registry.register(Metadata.builder().withName("classloader.unloadedClasses.total").withDisplayName("Total Unloaded Class Count").withDescription("classloader.totalUnloadedClass.count.description").withType(MetricType.COUNTER).withUnit("none").build(), (Metric)new BMCounter("java.lang:type=ClassLoading", "UnloadedClassCount"));
        registry.register(Metadata.builder().withName("cpu.availableProcessors").withDisplayName("Available Processors").withDescription("cpu.availableProcessors.description").withType(MetricType.GAUGE).withUnit("none").build(), new BMGauge("java.lang:type=OperatingSystem", "AvailableProcessors"));
        registry.register(Metadata.builder().withName("cpu.systemLoadAverage").withDisplayName("System Load Average").withDescription("cpu.systemLoadAverage.description").withType(MetricType.GAUGE).withUnit("none").build(), new BMGauge("java.lang:type=OperatingSystem", "SystemLoadAverage"));
        registry.register(Metadata.builder().withName("cpu.processCpuLoad").withDisplayName("Process CPU Load").withDescription("cpu.processCpuLoad.description").withType(MetricType.GAUGE).withUnit("percent").build(), new BMGauge("java.lang:type=OperatingSystem", "ProcessCpuLoad"));
        for (String gcName : gcObjectNames) {
            String gcNameNoSpace = this.removeSpaces(gcName);
            Tag gcNameNoSpaceTag = new Tag("name", gcNameNoSpace);
            String nameToRegister = "gc.total";
            registry.register(Metadata.builder().withName(nameToRegister).withDisplayName("Garbage Collection Count").withDescription("garbageCollectionCount.description").withType(MetricType.COUNTER).withUnit("none").build(), (Metric)new BMCounter("java.lang:type=GarbageCollector,name=" + gcName, "CollectionCount"), new Tag[]{gcNameNoSpaceTag});
            nameToRegister = "gc.time";
            registry.register(Metadata.builder().withName(nameToRegister).withDisplayName("Garbage Collection Time").withDescription("garbageCollectionTime.description").withType(MetricType.GAUGE).withUnit("milliseconds").build(), new BMGauge("java.lang:type=GarbageCollector,name=" + gcName, "CollectionTime"), new Tag[]{gcNameNoSpaceTag});
        }
    }

    private String removeSpaces(String aString) {
        return aString.replaceAll("\\s+", "");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BaseMetrics.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        baseMetrics = null;
        BASE = MetricRegistry.Type.BASE.getName();
        gcObjectNames = new HashSet<String>();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class BMCounter
    extends CounterImpl {
        String objectName;
        String attribute;
        static final long serialVersionUID = 879823269078749467L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BMCounter(String objectName, String attribute) {
            this.objectName = objectName;
            this.attribute = attribute;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getCount() {
            try {
                Number value = (Number)BaseMetrics.this.mbs.getAttribute(new ObjectName(this.objectName), this.attribute);
                return value.longValue();
            }
            catch (Exception value) {
                void e;
                FFDCFilter.processException((Throwable)value, (String)"com.ibm.ws.microprofile.metrics.BaseMetrics$BMCounter", (String)"184", (Object)this, (Object[])new Object[0]);
                e.printStackTrace();
                return 0L;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BMCounter.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class BMGauge<T>
    implements Gauge<T> {
        String objectName;
        String attribute;
        String subAttribute;
        boolean isComposite = false;
        static final long serialVersionUID = -2426175065504428914L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BMGauge(String objectName, String attribute) {
            this.objectName = objectName;
            this.attribute = attribute;
        }

        public BMGauge(String objectName, String attribute, String subAttribute) {
            this.objectName = objectName;
            this.attribute = attribute;
            this.subAttribute = subAttribute;
            this.isComposite = true;
        }

        /*
         * WARNING - void declaration
         */
        public T getValue() {
            try {
                if (this.isComposite) {
                    CompositeData value = (CompositeData)BaseMetrics.this.mbs.getAttribute(new ObjectName(this.objectName), this.attribute);
                    return (T)value.get(this.subAttribute);
                }
                Object value = BaseMetrics.this.mbs.getAttribute(new ObjectName(this.objectName), this.attribute);
                return (T)value;
            }
            catch (Exception value) {
                void e;
                FFDCFilter.processException((Throwable)value, (String)"com.ibm.ws.microprofile.metrics.BaseMetrics$BMGauge", (String)"164", (Object)this, (Object[])new Object[0]);
                e.printStackTrace();
                return null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BMGauge.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        }
    }
}

