/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricAppNameConfigSource
implements ConfigSource {
    private static final String METRICS_APPNAME_CONFIG_KEY = "mp.metrics.appName";
    private static final int CONFIG_ORDINAL = 80;
    private static Map<String, String> applicationContextRootMap;
    static final long serialVersionUID = 6901098530533286220L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public int getOrdinal() {
        return 80;
    }

    public String getName() {
        return "Metric Instrumented Application's Name";
    }

    public Set<String> getPropertyNames() {
        return applicationContextRootMap.keySet();
    }

    public Map<String, String> getProperties() {
        return applicationContextRootMap;
    }

    public String getValue(String propertyName) {
        if (propertyName.equals(METRICS_APPNAME_CONFIG_KEY)) {
            Object appName = null;
            String contextRoot = null;
            contextRoot = this.resolveContextRoot();
            if (contextRoot == null) {
                contextRoot = this.resolveApplicationModuleString();
            }
            return contextRoot;
        }
        return null;
    }

    private String resolveApplicationModuleString() {
        String applicationModuleString = null;
        try {
            ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            String applicationName = cmdai.getComponentMetaData().getJ2EEName().getApplication();
            String modulename = cmdai.getComponentMetaData().getJ2EEName().getModule();
            applicationModuleString = applicationName + "#" + modulename;
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.microprofile.metrics.config.MetricAppNameConfigSource", (String)"93", (Object)this, (Object[])new Object[0]);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.metrics.config.MetricAppNameConfigSource", (String)"94", (Object)this, (Object[])new Object[0]);
        }
        return applicationModuleString;
    }

    private String resolveContextRoot() {
        String contextRoot = null;
        try {
            ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            ModuleMetaData mmd = cmdai.getComponentMetaData().getModuleMetaData();
            if (mmd instanceof WebModuleMetaData) {
                WebModuleMetaData wmmd = (WebModuleMetaData)mmd;
                WebAppConfig appCfg = wmmd.getConfiguration();
                contextRoot = appCfg.getContextRoot();
            }
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.microprofile.metrics.config.MetricAppNameConfigSource", (String)"114", (Object)this, (Object[])new Object[0]);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.metrics.config.MetricAppNameConfigSource", (String)"115", (Object)this, (Object[])new Object[0]);
        }
        return contextRoot;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MetricAppNameConfigSource.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        applicationContextRootMap = new HashMap<String, String>();
    }
}

