/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwtsso.internal;

import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.security.jwtsso.config.JwtSsoBuilderConfig;
import com.ibm.ws.security.jwtsso.utils.ConfigUtils;
import com.ibm.ws.security.jwtsso.utils.IssuerUtil;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import javax.management.DynamicMBean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JwtSsoBuilderConfig.class, JwtConfig.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.security.jwtsso"}, name="jwtSsoBuilderConfig", property={"service.vendor=IBM"})
public class JwtSsoBuilderComponent
implements JwtSsoBuilderConfig {
    private static final TraceComponent tc = Tr.register(JwtSsoBuilderComponent.class, (String)"JWTSSO", (String)"com.ibm.ws.security.jwtsso.internal.resources.JWTSSOMessages");
    private DynamicMBean httpsendpointInfoMBean;
    private DynamicMBean httpendpointInfoMBean;
    private ServerInfoMBean serverInfoMBean;
    private boolean setCookiePathToWebAppContextPath;
    private boolean includeLtpaCookie;
    private boolean useLtpaIfJwtAbsent;
    private boolean cookieSecureFlag;
    private String jwtBuilderRef;
    private String jwtConsumerRef;
    private String cookieName;
    private WebAppSecurityConfig webAppSecConfig;
    private String signatureAlgorithm = "RS256";
    private static final String KEY_JWT_SERVICE = "jwtConfig";
    private static final String CFG_KEY_ID = "id";
    private final JwtConfig builderConfig = null;
    private final Object initlock = new Object();
    ConcurrentServiceReferenceMap<String, JwtConfig> jwtServiceMapRef = new ConcurrentServiceReferenceMap("jwtConfig");
    protected static final String KEY_UNIQUE_ID = "id";
    protected String uniqueId = null;
    private IssuerUtil issuerUtil;
    private boolean isDefaultBuilder = false;
    static final long serialVersionUID = 3314271036061681926L;

    @Override
    public boolean isHttpOnlyCookies() {
        return WebConfigUtils.getWebAppSecurityConfig().getHttpOnlyCookies();
    }

    @Override
    public boolean isSsoUseDomainFromURL() {
        return WebConfigUtils.getWebAppSecurityConfig().getSSOUseDomainFromURL();
    }

    @Override
    public List<String> getSsoDomainNames() {
        return WebConfigUtils.getWebAppSecurityConfig().getSSODomainList();
    }

    @Override
    public boolean isSetCookiePathToWebAppContextPath() {
        return this.setCookiePathToWebAppContextPath;
    }

    @Override
    public boolean isIncludeLtpaCookie() {
        return this.includeLtpaCookie;
    }

    @Override
    public boolean isUseLtpaIfJwtAbsent() {
        return this.useLtpaIfJwtAbsent;
    }

    @Override
    public boolean isCookieSecured() {
        return this.cookieSecureFlag;
    }

    @Override
    public String getJwtBuilderRef() {
        return this.jwtBuilderRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=JwtConfig.class, name="jwtConfig", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.RELUCTANT)
    protected void setJwtConfig(ServiceReference<JwtConfig> ref) {
        Object object = this.initlock;
        synchronized (object) {
            this.jwtServiceMapRef.putReference((Object)((String)ref.getProperty("id")), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetJwtConfig(ServiceReference<JwtConfig> ref) {
        Object object = this.initlock;
        synchronized (object) {
            this.jwtServiceMapRef.removeReference((Object)((String)ref.getProperty("id")), ref);
        }
    }

    @Reference(target="(jmx.objectname=WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        this.httpendpointInfoMBean = endpointInfoMBean;
    }

    protected void unsetEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        if (this.httpendpointInfoMBean == endpointInfoMBean) {
            this.httpendpointInfoMBean = null;
        }
    }

    @Reference(target="(jmx.objectname=WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint-ssl)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setHttpsEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        this.httpsendpointInfoMBean = endpointInfoMBean;
    }

    protected void unsetHttpsEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        if (this.httpsendpointInfoMBean == endpointInfoMBean) {
            this.httpsendpointInfoMBean = null;
        }
    }

    @Reference(target="(jmx.objectname=WebSphere:feature=kernel,name=ServerInfo)", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setServerInfoMBean(ServerInfoMBean serverInfoMBean) {
        this.serverInfoMBean = serverInfoMBean;
    }

    protected void unsetServerInfoMBean(ServerInfoMBean serverInfoMBean) {
        if (this.serverInfoMBean == serverInfoMBean) {
            this.serverInfoMBean = null;
        }
    }

    @Activate
    public void activate(Map<String, Object> properties, ComponentContext cc) {
        this.uniqueId = (String)properties.get("id");
        this.process(properties);
    }

    @Modified
    protected void modify(Map<String, Object> properties) {
        this.process(properties);
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext cc) {
    }

    @ManualTrace
    private void process(Map<String, Object> props) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"process", (Object[])new Object[0]);
        }
        if (props == null || props.isEmpty()) {
            return;
        }
        this.setCookiePathToWebAppContextPath = (Boolean)props.get("setCookiePathToWebAppContextRoot");
        this.includeLtpaCookie = (Boolean)props.get("includeLtpaCookie");
        this.useLtpaIfJwtAbsent = (Boolean)props.get("useLtpaIfJwtAbsent");
        this.cookieSecureFlag = (Boolean)props.get("setCookieSecureFlag");
        this.jwtBuilderRef = JwtUtils.trimIt((String)((String)props.get("jwtBuilderRef")));
        this.isDefaultBuilder = false;
        if (this.jwtBuilderRef == null) {
            this.setJwtSsoBuilderDefaults();
            this.isDefaultBuilder = true;
        }
        this.jwtConsumerRef = JwtUtils.trimIt((String)((String)props.get("mpjwtConsumerRef")));
        this.cookieName = JwtUtils.trimIt((String)((String)props.get("cookieName")));
        this.cookieName = new ConfigUtils().validateCookieName(this.cookieName, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"process");
        }
    }

    private void setJwtSsoBuilderDefaults() {
        this.jwtBuilderRef = this.getId();
        this.signatureAlgorithm = "RS256";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"builder id = ", (Object[])new Object[]{this.jwtBuilderRef});
        }
        this.issuerUtil = new IssuerUtil();
    }

    public String getId() {
        return this.getUniqueId();
    }

    public List<String> getAudiences() {
        return null;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getSharedKey() {
        return null;
    }

    public String getTrustStoreRef() {
        return null;
    }

    public String getTrustedAlias() {
        return null;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getIssuerUrl() {
        return this.getResolvedHostAndPortUrl();
    }

    public boolean isJwkEnabled() {
        return false;
    }

    public long getValidTime() {
        long result = 0L;
        if (this.isDefaultBuilder) {
            result = 7200L;
        } else {
            boolean haveNull = this.jwtServiceMapRef.getReference((Object)this.jwtBuilderRef) == null || this.jwtServiceMapRef.getReference((Object)this.jwtBuilderRef).getProperty("expiry") == null;
            result = haveNull ? 0L : (Long)this.jwtServiceMapRef.getReference((Object)this.jwtBuilderRef).getProperty("expiry");
        }
        return result;
    }

    public List<String> getClaims() {
        return null;
    }

    public String getScope() {
        return null;
    }

    public boolean getJti() {
        return false;
    }

    public String getKeyStoreRef() {
        return null;
    }

    public String getKeyAlias() {
        return null;
    }

    public String getJwkJsonString() {
        return null;
    }

    public JSONWebKey getJSONWebKey() {
        return null;
    }

    public long getJwkRotationTime() {
        return 0L;
    }

    public int getJwkSigningKeySize() {
        return 0;
    }

    public String getResolvedHostAndPortUrl() {
        return this.issuerUtil.getResolvedHostAndPortUrl(this.httpsendpointInfoMBean, this.httpendpointInfoMBean, this.serverInfoMBean, this.uniqueId);
    }

    public PrivateKey getPrivateKey() {
        return null;
    }

    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public String getCookieName() {
        return this.cookieName;
    }
}

