/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwtsso.utils;

import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.DynamicMBean;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IssuerUtil {
    public static final String JWTSSO_CONTEXT_PATH = "/jwt/";
    static final long serialVersionUID = -1938670114246964366L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getResolvedHostAndPortUrl(DynamicMBean httpsendpointInfoMBean, DynamicMBean httpendpointInfoMBean, ServerInfoMBean serverInfoMBean, String uniqueId) {
        String hosturl = null;
        if (httpsendpointInfoMBean != null) {
            try {
                String host = this.resolveHost((String)httpsendpointInfoMBean.getAttribute("Host"), serverInfoMBean);
                int port = (Integer)httpsendpointInfoMBean.getAttribute("Port");
                hosturl = "https://" + host + ":" + port;
            }
            catch (Exception host) {
                FFDCFilter.processException((Throwable)host, (String)"com.ibm.ws.security.jwtsso.utils.IssuerUtil", (String)"39", (Object)this, (Object[])new Object[]{httpsendpointInfoMBean, httpendpointInfoMBean, serverInfoMBean, uniqueId});
            }
        } else if (httpendpointInfoMBean != null) {
            try {
                String host = this.resolveHost((String)httpendpointInfoMBean.getAttribute("Host"), serverInfoMBean);
                int port = (Integer)httpendpointInfoMBean.getAttribute("Port");
                hosturl = "http://" + host + ":" + port;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwtsso.utils.IssuerUtil", (String)"47", (Object)this, (Object[])new Object[]{httpsendpointInfoMBean, httpendpointInfoMBean, serverInfoMBean, uniqueId});
            }
        }
        if (hosturl != null) {
            hosturl = hosturl + JWTSSO_CONTEXT_PATH + uniqueId;
        }
        return hosturl;
    }

    protected String resolveHost(String host, ServerInfoMBean serverInfoMBean) {
        if ("*".equals(host)) {
            if (serverInfoMBean != null) {
                host = serverInfoMBean.getDefaultHostname();
                if (host == null || host.equals("localhost")) {
                    host = this.getLocalHostIpAddress();
                }
            } else {
                host = this.getLocalHostIpAddress();
            }
        }
        return host == null || host.trim().isEmpty() ? "localhost" : host;
    }

    protected String getLocalHostIpAddress() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                static final long serialVersionUID = -465638403826903137L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostAddress();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"JWTSSO", (String)"com.ibm.ws.security.jwtsso.internal.resources.JWTSSOMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.jwtsso.utils.IssuerUtil", (String)"89", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IssuerUtil.class, (String)"JWTSSO", (String)"com.ibm.ws.security.jwtsso.internal.resources.JWTSSOMessages");
    }
}

