/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.annotations.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annotations.FragmentAnnotations;
import com.ibm.ws.container.service.annotations.SpecificAnnotations;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.config.WebFragmentInfo;
import com.ibm.ws.container.service.config.WebFragmentsInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_ClassLoader;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_Factory;
import com.ibm.wsspi.anno.classsource.ClassSource_MappedContainer;
import com.ibm.wsspi.anno.classsource.ClassSource_Options;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.info.InfoStoreException;
import com.ibm.wsspi.anno.info.InfoStoreFactory;
import com.ibm.wsspi.anno.service.AnnotationService_Service;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Exception;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Factory;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebAnnotationsImpl
implements WebAnnotations {
    private static final TraceComponent tc = Tr.register(WebAnnotationsImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    private final AnnotationService_Service annotationService;
    private final Container rootContainer;
    private final OverlayContainer rootOverlayContainer;
    private final ArtifactContainer rootArtifactContainer;
    private final Container adaptableContainer;
    private final ApplicationInfo appInfo;
    private final String appName;
    private final WebModuleInfo webModuleInfo;
    private final String webModuleName;
    private final ClassLoader webModuleClassLoader;
    private WebFragmentsInfo webFragments;
    private Map<String, WebFragmentInfo> idToFragmentMap;
    private ClassSource_Aggregate webModuleClassSource;
    private AnnotationTargets_Targets webModuleAnnotationTargets;
    private InfoStore webModuleInfoStore;
    static final long serialVersionUID = 4425124062305530199L;

    public WebAnnotationsImpl(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt, AnnotationService_Service annotationService) {
        this.annotationService = annotationService;
        this.rootContainer = root;
        this.rootOverlayContainer = rootOverlay;
        this.rootArtifactContainer = artifactContainer;
        this.adaptableContainer = containerToAdapt;
        this.webModuleInfo = this.retrieveFromOverlay(WebModuleInfo.class);
        this.webModuleName = this.webModuleInfo.getName();
        this.appInfo = this.webModuleInfo.getApplicationInfo();
        this.appName = this.appInfo.getName();
        this.webModuleClassLoader = this.webModuleInfo.getClassLoader();
    }

    private AnnotationService_Service getAnnotationService() {
        return this.annotationService;
    }

    private ClassSource_Factory getClassSourceFactory() {
        return this.getAnnotationService().getClassSourceFactory();
    }

    private AnnotationTargets_Factory getAnnotationTargetsFactory() {
        return this.getAnnotationService().getAnnotationTargetsFactory();
    }

    private InfoStoreFactory getInfoStoreFactory() {
        return this.getAnnotationService().getInfoStoreFactory();
    }

    protected Container getRootContainer() {
        return this.rootContainer;
    }

    private OverlayContainer getRootOverlayContainer() {
        return this.rootOverlayContainer;
    }

    private <T> T retrieveFromOverlay(Class<T> targetClass) {
        Object retrievedInfo = this.getRootOverlayContainer().getFromNonPersistentCache(this.getRootArtifactPath(), targetClass);
        return (T)retrievedInfo;
    }

    private <T> void addToOverlay(Class<T> targetClass, T targetObject) {
        this.getRootOverlayContainer().addToNonPersistentCache(this.getRootArtifactPath(), targetClass, targetObject);
    }

    private ArtifactContainer getRootArtifactContainer() {
        return this.rootArtifactContainer;
    }

    private String getRootArtifactPath() {
        return this.getRootArtifactContainer().getPath();
    }

    private Container getAdaptableContainer() {
        return this.adaptableContainer;
    }

    private String getAppName() {
        return this.appName;
    }

    private String getWebModuleName() {
        return this.webModuleName;
    }

    private ClassLoader getWebModuleClassLoader() {
        return this.webModuleClassLoader;
    }

    @Override
    public ClassInfo getClassInfo(String className) throws UnableToAdaptException {
        return this.getInfoStore().getDelayableClassInfo(className);
    }

    private WebFragmentsInfo getWebFragmentsInfo() throws UnableToAdaptException {
        if (this.webFragments == null) {
            Container useAdaptableContainer = this.getAdaptableContainer();
            this.webFragments = (WebFragmentsInfo)useAdaptableContainer.adapt(WebFragmentsInfo.class);
        }
        return this.webFragments;
    }

    @Override
    public List<WebFragmentInfo> getOrderedItems() throws UnableToAdaptException {
        return this.getWebFragmentsInfo().getOrderedFragments();
    }

    @Override
    public List<WebFragmentInfo> getExcludedItems() throws UnableToAdaptException {
        return this.getWebFragmentsInfo().getExcludedFragments();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClassSource_Aggregate getClassSource() throws UnableToAdaptException {
        String name;
        ClassSource_Aggregate useClassSource;
        if (this.webModuleClassSource != null) {
            return this.webModuleClassSource;
        }
        this.webModuleClassSource = this.retrieveFromOverlay(ClassSource_Aggregate.class);
        if (this.webModuleClassSource != null) {
            return this.webModuleClassSource;
        }
        String containerName = this.getAppName() + " " + this.getWebModuleName();
        ClassSource_Options options = this.getClassSourceFactory().createOptions();
        options.setUseJandex(this.appInfo.getUseJandex());
        try {
            useClassSource = this.getClassSourceFactory().createAggregateClassSource(containerName, options);
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"276", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.create.module.class.source.CWWKM0465E", (Object[])new Object[]{"Failed to create module class source", containerName, e});
            throw new UnableToAdaptException(msg);
        }
        for (WebFragmentInfo fragment : this.getOrderedItems()) {
            String cName;
            name = fragment.getLibraryURI();
            int nameSuffix = 1;
            if (this.idToFragmentMap == null) {
                this.idToFragmentMap = new HashMap<String, WebFragmentInfo>();
            }
            name = cName = this.getClassSourceFactory().getCanonicalName(name);
            while (this.idToFragmentMap.containsKey(name)) {
                name = cName + "_" + ++nameSuffix;
            }
            this.idToFragmentMap.put(name, fragment);
            ClassSource_Aggregate.ScanPolicy scanPolicy = fragment.isSeedFragment() ? ClassSource_Aggregate.ScanPolicy.SEED : ClassSource_Aggregate.ScanPolicy.PARTIAL;
            Container container = fragment.getFragmentContainer();
            try {
                ClassSource_MappedContainer containerSource = this.getClassSourceFactory().createContainerClassSource(useClassSource.getInternMap(), name, options, container);
                useClassSource.addClassSource((ClassSource)containerSource, scanPolicy);
                cName = containerSource.getCanonicalName();
                if (name.equals(cName)) continue;
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"canonical.name.does.not.match.original.name.for.module.CWWKM0466E", (Object[])new Object[]{"Canonical name does not match original name", containerName, cName, name});
                throw new UnableToAdaptException(msg);
            }
            catch (ClassSource_Exception containerSource) {
                void e;
                FFDCFilter.processException((Throwable)containerSource, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"317", (Object)this, (Object[])new Object[0]);
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.create.module.fragment.class.source.CWWKM0467E", (Object[])new Object[]{"Failed to create module fragment class source", containerName, name, e});
                throw new UnableToAdaptException(msg);
            }
        }
        for (WebFragmentInfo fragment : this.getExcludedItems()) {
            name = fragment.getLibraryURI();
            Container container = fragment.getFragmentContainer();
            ClassSource_Aggregate.ScanPolicy scanPolicy = ClassSource_Aggregate.ScanPolicy.EXCLUDED;
            try {
                ClassSource_MappedContainer containerSource = this.getClassSourceFactory().createContainerClassSource(useClassSource.getInternMap(), name, options, container);
                useClassSource.addClassSource((ClassSource)containerSource, scanPolicy);
            }
            catch (ClassSource_Exception containerSource) {
                void e;
                FFDCFilter.processException((Throwable)containerSource, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"335", (Object)this, (Object[])new Object[0]);
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.create.module.fragment.class.source.CWWKM0468E", (Object[])new Object[]{"Failed to create module fragment class source", containerName, name, e});
                throw new UnableToAdaptException(msg);
            }
        }
        String clName = containerName + " parent classloader";
        ClassLoader cl = this.getWebModuleClassLoader();
        try {
            ClassSource_ClassLoader clSource = this.getClassSourceFactory().createClassLoaderClassSource(useClassSource.getInternMap(), clName, options, cl);
            useClassSource.addClassSource((ClassSource)clSource, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
        }
        catch (ClassSource_Exception clSource) {
            void e;
            FFDCFilter.processException((Throwable)clSource, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"351", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.create.class.source.for.module.classloader.CWWKM0469E", (Object[])new Object[]{"Failed to create module fragment class source", containerName, clName, e});
            throw new UnableToAdaptException(msg);
        }
        this.webModuleClassSource = useClassSource;
        this.addToOverlay(ClassSource_Aggregate.class, this.webModuleClassSource);
        return this.webModuleClassSource;
    }

    private String getClassSourceName(WebFragmentInfo webFragmentItem) {
        if (this.idToFragmentMap == null) {
            return null;
        }
        for (Map.Entry<String, WebFragmentInfo> mapEntry : this.idToFragmentMap.entrySet()) {
            if (mapEntry.getValue() != webFragmentItem) continue;
            return mapEntry.getKey();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AnnotationTargets_Targets getAnnotationTargets() throws UnableToAdaptException {
        AnnotationTargets_Targets useTargets;
        if (this.webModuleAnnotationTargets != null) {
            return this.webModuleAnnotationTargets;
        }
        this.webModuleAnnotationTargets = this.retrieveFromOverlay(AnnotationTargets_Targets.class);
        if (this.webModuleAnnotationTargets != null) {
            return this.webModuleAnnotationTargets;
        }
        long startTime = this.reportScanStart();
        ClassSource_Aggregate useClassSource = this.getClassSource();
        AnnotationTargets_Factory useTargetsFactory = this.getAnnotationTargetsFactory();
        try {
            useTargets = useTargetsFactory.createTargets();
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            void e;
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"397", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0470E", (Object[])new Object[]{"Failed to obtain module annotation targets", e});
            throw new UnableToAdaptException(msg);
        }
        try {
            useTargets.scan(useClassSource);
        }
        catch (AnnotationTargets_Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"411", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0471E", (Object[])new Object[]{"Failed to obtain module annotation targets", e});
            throw new UnableToAdaptException(msg);
        }
        this.reportScanEnd(startTime, useTargets);
        this.webModuleAnnotationTargets = useTargets;
        this.addToOverlay(AnnotationTargets_Targets.class, this.webModuleAnnotationTargets);
        return this.webModuleAnnotationTargets;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InfoStore getInfoStore() throws UnableToAdaptException {
        if (this.webModuleInfoStore != null) {
            return this.webModuleInfoStore;
        }
        this.webModuleInfoStore = this.retrieveFromOverlay(InfoStore.class);
        if (this.webModuleInfoStore != null) {
            return this.webModuleInfoStore;
        }
        ClassSource_Aggregate useClassSource = this.getClassSource();
        try {
            this.webModuleInfoStore = this.getInfoStoreFactory().createInfoStore(useClassSource);
        }
        catch (InfoStoreException infoStoreException) {
            void e;
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"440", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0472E", (Object[])new Object[]{"Failed to obtain module annotation targets", e});
            throw new UnableToAdaptException(msg);
        }
        this.addToOverlay(InfoStore.class, this.webModuleInfoStore);
        return this.webModuleInfoStore;
    }

    @Override
    public FragmentAnnotations getFragmentAnnotations(WebFragmentInfo webFragmentItem) throws UnableToAdaptException {
        return new FragmentAnnotationsImpl(this.getAnnotationTargets(), this.getClassSourceName(webFragmentItem));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpecificAnnotations getSpecificAnnotations(Set<String> specificClassNames) throws UnableToAdaptException {
        AnnotationTargets_Targets specificTargets;
        long startTime = this.reportScanStart();
        ClassSource_Aggregate useClassSource = this.getClassSource();
        AnnotationTargets_Factory useTargetsFactory = this.getAnnotationTargetsFactory();
        try {
            specificTargets = useTargetsFactory.createTargets();
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            void e;
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"504", (Object)this, (Object[])new Object[]{specificClassNames});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0473E", (Object[])new Object[]{"Failed to obtain module annotation targets", e});
            throw new UnableToAdaptException(msg);
        }
        try {
            specificTargets.scan(useClassSource, specificClassNames);
        }
        catch (AnnotationTargets_Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"518", (Object)this, (Object[])new Object[]{specificClassNames});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0474E", (Object[])new Object[]{"Failed to obtain module annotation targets", specificClassNames, e});
            throw new UnableToAdaptException(msg);
        }
        this.reportScanEnd(startTime, specificTargets);
        return new SpecificAnnotationsImpl(specificTargets);
    }

    private long reportScanStart() {
        long startTime = this.getTimeInMillis();
        return startTime;
    }

    private void reportScanEnd(long startTime, AnnotationTargets_Targets targetsTable) {
    }

    private long getTimeInMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean isIncludedClass(String className) throws UnableToAdaptException {
        return this.getAnnotationTargets().isSeedClassName(className);
    }

    @Override
    public boolean isPartialClass(String className) throws UnableToAdaptException {
        return this.getAnnotationTargets().isPartialClassName(className);
    }

    @Override
    public boolean isExcludedClass(String className) throws UnableToAdaptException {
        return this.getAnnotationTargets().isExcludedClassName(className);
    }

    @Override
    public boolean isExternalClass(String className) throws UnableToAdaptException {
        return this.getAnnotationTargets().isExternalClassName(className);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void openInfoStore() throws UnableToAdaptException {
        try {
            this.getInfoStore().open();
        }
        catch (InfoStoreException infoStoreException) {
            void e;
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"685", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.open.web.module.info.store.CWWKM0475E", (Object[])new Object[]{"Failed to open web module info store", e});
            throw new UnableToAdaptException(msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeInfoStore() throws UnableToAdaptException {
        try {
            this.getInfoStore().close();
        }
        catch (InfoStoreException infoStoreException) {
            void e;
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl", (String)"697", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.close.web.module.info.store.CWWKM0476E", (Object[])new Object[]{"Failed to close web module info store", e});
            throw new UnableToAdaptException(msg);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SpecificAnnotationsImpl
    implements SpecificAnnotations {
        private final AnnotationTargets_Targets specificTargets;
        static final long serialVersionUID = -9117332051248833848L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SpecificAnnotationsImpl(AnnotationTargets_Targets specificTargets) {
            this.specificTargets = specificTargets;
        }

        @Override
        public Set<String> selectAnnotatedClasses(Class<?> annotationClass) throws UnableToAdaptException {
            String annotationClassName = annotationClass.getName();
            Set selectedClassNames = this.specificTargets.getAnnotatedClasses(annotationClassName, AnnotationTargets_Targets.POLICY_SEED);
            return selectedClassNames;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SpecificAnnotationsImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class FragmentAnnotationsImpl
    implements FragmentAnnotations {
        private final AnnotationTargets_Targets annoTargets;
        private final String classSourceName;
        static final long serialVersionUID = 3344977358086824367L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        FragmentAnnotationsImpl(AnnotationTargets_Targets annoTargets, String classSourceName) {
            this.annoTargets = annoTargets;
            this.classSourceName = classSourceName;
        }

        @Override
        public Set<String> selectAnnotatedClasses(Class<?> annotationClass) throws UnableToAdaptException {
            String annotationClassName = annotationClass.getName();
            Set selectedClassNames = this.annoTargets.getAnnotatedClasses(this.classSourceName, annotationClassName, AnnotationTargets_Targets.POLICY_SEED);
            return selectedClassNames;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FragmentAnnotationsImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        }
    }
}

