/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.config.extended;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.dd.commonbnd.AuthenticationAlias;
import com.ibm.ws.javaee.dd.commonbnd.CustomLoginConfiguration;
import com.ibm.ws.javaee.dd.commonbnd.DataSource;
import com.ibm.ws.javaee.dd.commonbnd.EJBRef;
import com.ibm.ws.javaee.dd.commonbnd.EnvEntry;
import com.ibm.ws.javaee.dd.commonbnd.MessageDestinationRef;
import com.ibm.ws.javaee.dd.commonbnd.Property;
import com.ibm.ws.javaee.dd.commonbnd.RefBindingsGroup;
import com.ibm.ws.javaee.dd.commonbnd.ResourceEnvRef;
import com.ibm.ws.javaee.dd.commonext.ResourceRef;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefConfig;
import com.ibm.ws.resource.ResourceRefConfigList;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RefBndAndExtHelper {
    static final long serialVersionUID = 1400084891559563171L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void configureEJBRefBindings(RefBindingsGroup refBindingsGroup, Map<String, String> ejbRefBndMap) {
        List ejbEjbRefList;
        if (refBindingsGroup != null && !(ejbEjbRefList = refBindingsGroup.getEJBRefs()).isEmpty()) {
            for (EJBRef ejbRefBnd : ejbEjbRefList) {
                String name = ejbRefBnd.getName();
                String bindingName = ejbRefBnd.getBindingName();
                if (name == null || bindingName == null) continue;
                ejbRefBndMap.put(name, bindingName);
            }
        }
    }

    public static void configureResourceRefBindings(RefBindingsGroup refBindingsGroup, Map<String, String> resourceRefBindings, ResourceRefConfigList resRefConfigList) {
        List resRefBnds;
        if (refBindingsGroup != null && !(resRefBnds = refBindingsGroup.getResourceRefs()).isEmpty()) {
            for (com.ibm.ws.javaee.dd.commonbnd.ResourceRef resRefBnd : resRefBnds) {
                String authAliasName;
                CustomLoginConfiguration clc;
                String name = resRefBnd.getName();
                if (name == null) continue;
                String bindingName = resRefBnd.getBindingName();
                if (bindingName != null) {
                    resourceRefBindings.put(name, bindingName);
                }
                if ((clc = resRefBnd.getCustomLoginConfiguration()) != null) {
                    String clcName = clc.getName();
                    if (clcName == null) continue;
                    ResourceRefConfig resRefConfig = RefBndAndExtHelper.getResourceRefConfig(resRefConfigList, name);
                    resRefConfig.setLoginConfigurationName(clcName);
                    for (Property property : clc.getProperties()) {
                        String propertyName = property.getName();
                        String propertyValue = property.getValue();
                        if (propertyName == null || propertyValue == null) continue;
                        resRefConfig.addLoginProperty(propertyName, propertyValue);
                    }
                    continue;
                }
                AuthenticationAlias authAlias = resRefBnd.getAuthenticationAlias();
                if (authAlias == null || (authAliasName = authAlias.getName()) == null) continue;
                ResourceRefConfig resRefConfig = RefBndAndExtHelper.getResourceRefConfig(resRefConfigList, name);
                resRefConfig.addLoginProperty("DefaultPrincipalMapping", authAliasName);
            }
        }
    }

    public static void configureResourceRefExtensions(List<ResourceRef> resRefExts, ResourceRefConfigList resRefConfigList) {
        if (!resRefExts.isEmpty()) {
            for (ResourceRef resRefExt : resRefExts) {
                String name = resRefExt.getName();
                if (name == null) continue;
                ResourceRefConfig resRefConfig = RefBndAndExtHelper.getResourceRefConfig(resRefConfigList, name);
                if (resRefExt.isSetIsolationLevel()) {
                    switch (resRefExt.getIsolationLevel()) {
                        case TRANSACTION_NONE: {
                            resRefConfig.setIsolationLevel(0);
                            break;
                        }
                        case TRANSACTION_READ_UNCOMMITTED: {
                            resRefConfig.setIsolationLevel(1);
                            break;
                        }
                        case TRANSACTION_READ_COMMITTED: {
                            resRefConfig.setIsolationLevel(2);
                            break;
                        }
                        case TRANSACTION_REPEATABLE_READ: {
                            resRefConfig.setIsolationLevel(4);
                            break;
                        }
                        case TRANSACTION_SERIALIZABLE: {
                            resRefConfig.setIsolationLevel(8);
                        }
                    }
                }
                if (resRefExt.isSetCommitPriority()) {
                    resRefConfig.setCommitPriority(resRefExt.getCommitPriority());
                }
                if (!resRefExt.isSetBranchCoupling()) continue;
                switch (resRefExt.getBranchCoupling()) {
                    case LOOSE: {
                        resRefConfig.setBranchCoupling(0);
                        break;
                    }
                    case TIGHT: {
                        resRefConfig.setBranchCoupling(1);
                    }
                }
            }
        }
    }

    public static ResourceRefConfig getResourceRefConfig(ResourceRefConfigList resRefConfigList, String name) {
        if (resRefConfigList != null) {
            return resRefConfigList.findOrAddByName(name);
        }
        return null;
    }

    public static void configureResourceEnvRefBindings(RefBindingsGroup refBindingsGroup, Map<String, String> resourceEnvRefBindings) {
        List resEnvRefBnds;
        if (refBindingsGroup != null && !(resEnvRefBnds = refBindingsGroup.getResourceEnvRefs()).isEmpty()) {
            for (ResourceEnvRef resEnvRefBnd : resEnvRefBnds) {
                String name = resEnvRefBnd.getName();
                String bindingName = resEnvRefBnd.getBindingName();
                if (name == null || bindingName == null) continue;
                resourceEnvRefBindings.put(name, bindingName);
            }
        }
    }

    public static void configureMessageDestinationRefBindings(RefBindingsGroup refBindingsGroup, Map<String, String> msgDestValues) {
        List msgDestRefBnds;
        if (refBindingsGroup != null && !(msgDestRefBnds = refBindingsGroup.getMessageDestinationRefs()).isEmpty()) {
            for (MessageDestinationRef msgDestBnd : msgDestRefBnds) {
                String name = msgDestBnd.getName();
                String bindingName = msgDestBnd.getBindingName();
                if (name == null || bindingName == null) continue;
                msgDestValues.put(name, bindingName);
            }
        }
    }

    public static void configureEnvEntryBindings(RefBindingsGroup refBindingsGroup, Map<String, String> envEntryValues, Map<String, String> envEntryBindings) {
        List envEntryBnds;
        if (refBindingsGroup != null && !(envEntryBnds = refBindingsGroup.getEnvEntries()).isEmpty()) {
            for (EnvEntry envEntryBnd : envEntryBnds) {
                String bindingName;
                String name = envEntryBnd.getName();
                if (name == null) continue;
                String value = envEntryBnd.getValue();
                if (value != null) {
                    envEntryValues.put(name, value);
                }
                if ((bindingName = envEntryBnd.getBindingName()) == null) continue;
                envEntryBindings.put(name, bindingName);
            }
        }
    }

    public static void configureDataSourceBindings(RefBindingsGroup refBindingsGroup, Map<String, String> dataSourceBindings) {
        List dataSourceBnds;
        if (refBindingsGroup != null && !(dataSourceBnds = refBindingsGroup.getDataSources()).isEmpty()) {
            for (DataSource dataSourceBnd : dataSourceBnds) {
                String name = dataSourceBnd.getName();
                String bindingName = dataSourceBnd.getBindingName();
                if (name == null || bindingName == null) continue;
                dataSourceBindings.put(name, bindingName);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RefBndAndExtHelper.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    }
}

