/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.microprofile.metrics.cdi.producer.MetricRegistryFactory;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi.AnnotatedTypeDecorator;
import io.astefanutti.metrics.cdi.MetricName;
import io.astefanutti.metrics.cdi.MetricProducer;
import io.astefanutti.metrics.cdi.MetricRegistryBean;
import io.astefanutti.metrics.cdi.MetricsBinding;
import io.astefanutti.metrics.cdi.MetricsConfigurationEvent;
import io.astefanutti.metrics.cdi.MetricsParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.Nonbinding;
import javax.interceptor.InterceptorBinding;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WebSphereCDIExtension.class}, immediate=true)
public class MetricsExtension
implements Extension,
WebSphereCDIExtension {
    private static final AnnotationLiteral<Nonbinding> NON_BINDING;
    private static final AnnotationLiteral<InterceptorBinding> INTERCEPTOR_BINDING;
    private static final AnnotationLiteral<MetricsBinding> METRICS_BINDING;
    private static final AnnotationLiteral<Default> DEFAULT;
    private final Map<Bean<?>, AnnotatedMember<?>> metrics = new HashMap();
    private final Set<String> metricNames = Collections.synchronizedSortedSet(new TreeSet());
    private final MetricsConfigurationEvent configuration = new MetricsConfigurationEvent();
    private final Map<Member, Map<Annotation, String>> memberMap = Collections.synchronizedMap(new HashMap());
    private final Set<Class<?>> beansVisited = Collections.synchronizedSet(new HashSet());
    static final long serialVersionUID = 8878777144124892339L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    public void getSharedMetricRegistries(SharedMetricRegistries sharedMetricRegistry) {
        MetricRegistryFactory.SHARED_METRIC_REGISTRIES = sharedMetricRegistry;
    }

    public Set<MetricsParameter> getParameters() {
        return this.configuration.getParameters();
    }

    private <X> void metricsAnnotations(@Observes @WithAnnotations(value={Counted.class, Gauge.class, Metered.class, Timed.class}) ProcessAnnotatedType<X> pat) {
        pat.setAnnotatedType(new AnnotatedTypeDecorator(pat.getAnnotatedType(), (Annotation)METRICS_BINDING));
    }

    private void metricProducerField(@Observes ProcessProducerField<? extends Metric, ?> ppf) {
        this.metrics.put((Bean<?>)ppf.getBean(), (AnnotatedMember<?>)ppf.getAnnotatedProducerField());
    }

    private void metricProducerMethod(@Observes ProcessProducerMethod<? extends Metric, ?> ppm) {
        if (!ppm.getBean().getBeanClass().equals(MetricProducer.class)) {
            this.metrics.put((Bean<?>)ppm.getBean(), (AnnotatedMember<?>)ppm.getAnnotatedProducerMethod());
        }
    }

    private void defaultMetricRegistry(@Observes AfterBeanDiscovery abd, BeanManager manager) {
        if (manager.getBeans(MetricRegistry.class, new Annotation[0]).isEmpty()) {
            abd.addBean((Bean)new MetricRegistryBean(manager));
        }
    }

    private void configuration(@Observes AfterDeploymentValidation adv, BeanManager manager) {
        manager.fireEvent((Object)this.configuration, new Annotation[0]);
        this.configuration.unmodifiable();
        MetricRegistry registry = MetricsExtension.getReference(manager, MetricRegistry.class);
        MetricName name = MetricsExtension.getReference(manager, MetricName.class);
        for (Map.Entry<Bean<?>, AnnotatedMember<?>> bean : this.metrics.entrySet()) {
            if (!bean.getKey().getQualifiers().contains(DEFAULT) || MetricsExtension.hasInjectionPoints(bean.getValue())) continue;
            Metadata metadata = name.metadataOf(bean.getValue());
            registry.register(metadata.getName(), (Metric)MetricsExtension.getReference(manager, bean.getValue().getBaseType(), bean.getKey()), metadata);
            this.addMetricName(metadata.getName());
        }
        this.metrics.clear();
    }

    private void beforeShutdown(@Observes BeforeShutdown shutdown) {
        MetricRegistry registry = MetricRegistryFactory.getApplicationRegistry();
        for (String name : this.metricNames) {
            registry.remove(name);
        }
    }

    private static <T> T getReference(BeanManager manager, Class<T> type) {
        return MetricsExtension.getReference(manager, type, manager.resolve(manager.getBeans(type, new Annotation[0])));
    }

    private static <T> T getReference(BeanManager manager, Type type, Bean<?> bean) {
        return (T)manager.getReference(bean, type, manager.createCreationalContext(bean));
    }

    private static boolean hasInjectionPoints(AnnotatedMember<?> member) {
        if (!(member instanceof AnnotatedMethod)) {
            return false;
        }
        AnnotatedMethod method = (AnnotatedMethod)member;
        for (AnnotatedParameter parameter : method.getParameters()) {
            if (!parameter.getBaseType().equals(InjectionPoint.class)) continue;
            return true;
        }
        return false;
    }

    public String getMetricNameForMember(Member member, Annotation annotation) {
        Map<Annotation, String> map = this.memberMap.get(member);
        if (map == null) {
            return null;
        }
        return map.get(annotation);
    }

    public void addMetricName(Member member, Annotation annotation, String name) {
        Map<Annotation, String> map = this.memberMap.get(member);
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
            this.memberMap.put(member, map);
        }
        map.put(annotation, name);
        this.metricNames.add(name);
    }

    public Set<Class<?>> getBeansVisited() {
        return this.beansVisited;
    }

    public void addMetricName(String name) {
        this.metricNames.add(name);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MetricsExtension.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
        NON_BINDING = new AnnotationLiteral<Nonbinding>(){
            static final long serialVersionUID = 8662321982711469362L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
            }
        };
        INTERCEPTOR_BINDING = new AnnotationLiteral<InterceptorBinding>(){
            static final long serialVersionUID = 5540080568594958297L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
            }
        };
        METRICS_BINDING = new AnnotationLiteral<MetricsBinding>(){
            static final long serialVersionUID = -3600391104145099065L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
            }
        };
        DEFAULT = new AnnotationLiteral<Default>(){
            static final long serialVersionUID = -8130924682324653194L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(4.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
            }
        };
    }
}

