/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.external;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.AnnotatedEndpoint;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HandshakeRequestExt
implements HandshakeRequest {
    private HttpServletRequest request = null;
    private Map<String, List<String>> headers = null;
    private Map<String, List<String>> parameterMap = null;
    private String queryString = null;
    private HttpSession httpSession = null;
    private Principal principal = null;
    private URI requestURI = null;
    static final long serialVersionUID = 3938810490588032999L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public HandshakeRequestExt(HttpServletRequest _request, Map<String, List<String>> _headers, Map<String, List<String>> _parameterMap, URI _requestURI, Endpoint _ep, EndpointConfig _epc) {
        this.headers = _headers;
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>();
        }
        this.headers = Collections.unmodifiableMap(this.headers);
        this.request = _request;
        Map<String, List<String>> pathParams = this.determinePathParams(_ep, _epc, _requestURI);
        _parameterMap.putAll(pathParams);
        this.parameterMap = Collections.unmodifiableMap(_parameterMap);
        this.queryString = this.request.getQueryString();
        this.httpSession = this.request.getSession();
        this.principal = this.request.getUserPrincipal();
        this.requestURI = _requestURI;
    }

    private Map<String, List<String>> determinePathParams(Endpoint endpoint, EndpointConfig endpointConfig, URI _uri) {
        HashMap<String, List<String>> pathParameters = new HashMap<String, List<String>>();
        String[] endpointURIParts = null;
        if (endpoint != null && endpoint instanceof AnnotatedEndpoint) {
            endpointURIParts = ((AnnotatedEndpoint)endpoint).getEndpointPath().split("/");
        } else if (endpointConfig != null) {
            endpointURIParts = ((ServerEndpointConfig)endpointConfig).getPath().split("/");
        }
        if (endpointURIParts == null || _uri == null) {
            return pathParameters;
        }
        String[] requestURIParts = _uri.getPath().split("/");
        int i = endpointURIParts.length - 1;
        int j = requestURIParts.length - 1;
        while (i > 1) {
            if (endpointURIParts[i].startsWith("{") && endpointURIParts[i].endsWith("}")) {
                String endpointPart = endpointURIParts[i].substring(1, endpointURIParts[i].length() - 1);
                List<String> list = Arrays.asList(requestURIParts[j]);
                pathParameters.put(endpointPart, list);
            }
            --i;
            --j;
        }
        return pathParameters;
    }

    @Sensitive
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Object getHttpSession() {
        return this.httpSession;
    }

    public Map<String, List<String>> getParameterMap() {
        return this.parameterMap;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    @Sensitive
    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(HandshakeRequestExt.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    }
}

