/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.internal.ZipFileContainer;
import com.ibm.ws.artifact.zip.internal.ZipFileEntry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipFileContainerUtils {
    private static final List<Integer> EMPTY_OFFSETS;
    private static final int[] EMPTY_OFFSETS_ARRAY;
    public static final ZipEntryDataComparator ZIP_ENTRY_DATA_COMPARATOR;
    static final long serialVersionUID = -1364992702720339641L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private static List<Integer> allocateOffsets(List<List<Integer>> offsetsStorage) {
        if (offsetsStorage.isEmpty()) {
            return new ArrayList<Integer>();
        }
        return offsetsStorage.remove(0);
    }

    private static int[] releaseOffsets(List<List<Integer>> offsetsStorage, List<Integer> offsets) {
        int[] extractedValues;
        int numValues = offsets.size();
        if (numValues == 0) {
            extractedValues = EMPTY_OFFSETS_ARRAY;
        } else {
            extractedValues = new int[numValues];
            for (int valueNo = 0; valueNo < numValues; ++valueNo) {
                extractedValues[valueNo] = offsets.get(valueNo);
            }
        }
        offsets.clear();
        offsetsStorage.add(offsets);
        return extractedValues;
    }

    @Trivial
    public static Map<String, IteratorData> collectIteratorData(ZipEntryData[] zipEntryData) {
        HashMap<String, IteratorData> allNestingData = new HashMap<String, IteratorData>();
        ArrayList<List<Integer>> offsetsStorage = new ArrayList<List<Integer>>(32);
        String r_lastPath = "";
        int r_lastPathLen = 0;
        List<Integer> offsets = EMPTY_OFFSETS;
        int nestingDepth = 0;
        ArrayList<String> r_pathStack = new ArrayList<String>(32);
        ArrayList<List<Integer>> offsetsStack = new ArrayList<List<Integer>>(32);
        for (int nextOffset = 0; nextOffset < zipEntryData.length; ++nextOffset) {
            String r_nextPath = zipEntryData[nextOffset].r_getPath();
            int r_nextPathLen = r_nextPath.length();
            while (!ZipFileContainerUtils.isChildOf(r_nextPath, r_nextPathLen, r_lastPath, r_lastPathLen)) {
                if (offsets != EMPTY_OFFSETS) {
                    allNestingData.put(r_lastPath, new IteratorData(r_lastPath, ZipFileContainerUtils.releaseOffsets(offsetsStorage, offsets)));
                }
                r_lastPath = (String)r_pathStack.remove(--nestingDepth);
                r_lastPathLen = r_lastPath.length();
                offsets = (List)offsetsStack.remove(nestingDepth);
            }
            Integer nextOffsetObj = nextOffset;
            int lastSlashLoc = r_lastPathLen + 1;
            while (lastSlashLoc != -1) {
                int r_nextPartialPathLen;
                String r_nextPartialPath;
                int nextSlashLoc = r_nextPath.indexOf(47, lastSlashLoc);
                if (nextSlashLoc == -1) {
                    r_nextPartialPath = r_nextPath;
                    r_nextPartialPathLen = r_nextPathLen;
                    lastSlashLoc = nextSlashLoc;
                } else {
                    r_nextPartialPath = r_nextPath.substring(0, nextSlashLoc);
                    r_nextPartialPathLen = nextSlashLoc;
                    lastSlashLoc = nextSlashLoc + 1;
                }
                if (offsets == EMPTY_OFFSETS) {
                    offsets = ZipFileContainerUtils.allocateOffsets(offsetsStorage);
                }
                offsets.add(nextOffsetObj);
                ++nestingDepth;
                r_pathStack.add(r_lastPath);
                offsetsStack.add(offsets);
                r_lastPath = r_nextPartialPath;
                r_lastPathLen = r_nextPartialPathLen;
                offsets = EMPTY_OFFSETS;
            }
        }
        while (nestingDepth > 0) {
            if (offsets != EMPTY_OFFSETS) {
                allNestingData.put(r_lastPath, new IteratorData(r_lastPath, ZipFileContainerUtils.releaseOffsets(offsetsStorage, offsets)));
            }
            r_lastPath = (String)r_pathStack.remove(--nestingDepth);
            offsets = (List<Integer>)offsetsStack.remove(nestingDepth);
        }
        if (offsets != EMPTY_OFFSETS) {
            allNestingData.put(r_lastPath, new IteratorData(r_lastPath, ZipFileContainerUtils.releaseOffsets(offsetsStorage, offsets)));
        }
        return allNestingData;
    }

    @Trivial
    private static boolean isChildOf(String childPath, int childLen, String parentPath, int parentLen) {
        if (parentLen == 0) {
            return true;
        }
        if (childLen <= parentLen) {
            return false;
        }
        if (childPath.charAt(parentLen) != '/') {
            return false;
        }
        return childPath.regionMatches(0, parentPath, 0, parentLen);
    }

    @Trivial
    private static final ZipEntryData createZipEntryData(ZipEntry entry) {
        String path = entry.getName();
        if (path.charAt(path.length() - 1) == '/') {
            return new DirZipEntryData(entry);
        }
        return new FileZipEntryData(entry);
    }

    @Trivial
    public static ZipEntryData[] collectZipEntries(ZipFile zipFile) {
        ArrayList<ZipEntryData> entriesList = new ArrayList<ZipEntryData>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            entriesList.add(ZipFileContainerUtils.createZipEntryData(zipEntries.nextElement()));
        }
        ZipEntryData[] entryData = entriesList.toArray(new ZipEntryData[entriesList.size()]);
        Arrays.sort(entryData, ZIP_ENTRY_DATA_COMPARATOR);
        return entryData;
    }

    @Trivial
    public static Map<String, ZipEntryData> setLocations(ZipEntryData[] entryData) {
        HashMap<String, ZipEntryData> entryDataMap = new HashMap<String, ZipEntryData>(entryData.length);
        for (int entryNo = 0; entryNo < entryData.length; ++entryNo) {
            ZipEntryData entry = entryData[entryNo];
            entry.setOffset(entryNo);
            entryDataMap.put(entry.r_path, entry);
        }
        return entryDataMap;
    }

    @Trivial
    public static int locatePath(ZipEntryData[] entryData, String r_path) {
        SearchZipEntryData targetData = new SearchZipEntryData(r_path);
        return Arrays.binarySearch(entryData, targetData, ZIP_ENTRY_DATA_COMPARATOR);
    }

    @Trivial
    private static String stripPath(String path) {
        int pathLen = path.length();
        if (pathLen == 0) {
            return path;
        }
        if (pathLen == 1) {
            if (path.charAt(0) == '/') {
                return "";
            }
            return path;
        }
        if (path.charAt(0) == '/') {
            if (path.charAt(pathLen - 1) == '/') {
                return path.substring(1, pathLen - 1);
            }
            return path.substring(1, pathLen);
        }
        if (path.charAt(pathLen - 1) == '/') {
            return path.substring(0, pathLen - 1);
        }
        return path;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ZipFileContainerUtils.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        EMPTY_OFFSETS = null;
        EMPTY_OFFSETS_ARRAY = new int[0];
        ZIP_ENTRY_DATA_COMPARATOR = new ZipEntryDataComparator();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ZipEntryDataComparator
    implements Comparator<ZipEntryData> {
        static final long serialVersionUID = -2566636648327323343L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public int compare(ZipEntryData data1, ZipEntryData data2) {
            return PathUtils.PATH_COMPARATOR.compare(data1.r_getPath(), data2.r_getPath());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ZipEntryDataComparator.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SearchZipEntryData
    extends ZipEntryData {
        static final long serialVersionUID = 8522872747977322770L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        SearchZipEntryData(String r_path) {
            super(r_path, -1L);
        }

        @Override
        @Trivial
        String getPath() {
            return null;
        }

        @Override
        @Trivial
        boolean isDirectory() {
            return false;
        }

        @Override
        @Trivial
        int getSize() {
            return -1;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SearchZipEntryData.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @Trivial
    private static class DirZipEntryData
    extends ZipEntryData {
        DirZipEntryData(ZipEntry zipEntry) {
            super(ZipFileContainerUtils.stripPath(zipEntry.getName()), zipEntry.getTime());
        }

        @Override
        String getPath() {
            return this.r_path;
        }

        @Override
        boolean isDirectory() {
            return true;
        }

        @Override
        int getSize() {
            return 0;
        }
    }

    @Trivial
    private static class FileZipEntryData
    extends ZipEntryData {
        final String path;
        final int size;

        FileZipEntryData(ZipEntry zipEntry) {
            super(ZipFileContainerUtils.stripPath(zipEntry.getName()), zipEntry.getTime());
            this.path = zipEntry.getName();
            this.size = (int)zipEntry.getSize();
        }

        @Override
        String getPath() {
            return this.path;
        }

        @Override
        boolean isDirectory() {
            return false;
        }

        @Override
        int getSize() {
            return this.size;
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static abstract class ZipEntryData {
        final String r_path;
        private final long time;
        private int offset = -1;
        static final long serialVersionUID = -1358756175292229554L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        ZipEntryData(String r_path, long time) {
            this.r_path = r_path;
            this.time = time;
        }

        final void setOffset(int offset) {
            this.offset = offset;
        }

        final int getOffset() {
            return this.offset;
        }

        @Trivial
        final String r_getPath() {
            return this.r_path;
        }

        @Trivial
        final long getTime() {
            return this.time;
        }

        abstract String getPath();

        abstract boolean isDirectory();

        abstract int getSize();

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ZipEntryData.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class IteratorData {
        public final String path;
        public final int[] locations;
        static final long serialVersionUID = 6630039768231186397L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public IteratorData(String path, int[] locations) {
            this.path = path;
            this.locations = locations;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(IteratorData.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ZipFileEntryIterator
    implements Iterator<ArtifactEntry> {
        private final ZipFileContainer rootContainer;
        private final ZipEntryData[] allEntryData;
        private final ArtifactContainer nestedContainer;
        private final String parentPath;
        private final int[] locations;
        private int index;
        static final long serialVersionUID = -4062822372951001514L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public ZipFileEntryIterator(ZipFileContainer rootContainer, ArtifactContainer nestedContainer, ZipEntryData[] allEntryData, IteratorData iteratorData) {
            this.rootContainer = rootContainer;
            this.allEntryData = allEntryData;
            this.nestedContainer = nestedContainer;
            this.parentPath = iteratorData.path;
            this.locations = iteratorData.locations;
            this.index = 0;
        }

        @Override
        @Trivial
        public boolean hasNext() {
            return this.index < this.locations.length;
        }

        @Override
        public ZipFileEntry next() {
            String entryPath;
            String entryName;
            int parentLen;
            int location;
            ZipEntryData nextEntryData;
            String nextPath;
            int slashLoc;
            if (this.index >= this.locations.length) {
                throw new NoSuchElementException();
            }
            if ((slashLoc = (nextPath = (nextEntryData = this.allEntryData[location = this.locations[this.index++]]).r_getPath()).indexOf(47, parentLen = this.parentPath.isEmpty() ? 0 : this.parentPath.length() + 1)) == -1) {
                entryName = nextPath.substring(parentLen);
                entryPath = nextPath;
            } else {
                entryName = nextPath.substring(parentLen, slashLoc);
                entryPath = nextPath.substring(0, slashLoc);
                nextEntryData = null;
            }
            String a_entryPath = "/" + entryPath;
            ZipFileEntry nextZipFileEntry = this.rootContainer.createEntry(this.nestedContainer, entryName, a_entryPath, nextEntryData);
            return nextZipFileEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ZipFileEntryIterator.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }
}

