/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.credentials.wscred;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.credentials.ExpirableCredential;
import java.io.UnsupportedEncodingException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.CredentialExpiredException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSCredentialImpl
implements WSCredential,
ExpirableCredential {
    private static final long serialVersionUID = 7097141765627715179L;
    private static final String REALM_SEPARATOR = "/";
    private static final Permission APP_READ_PERMISSION;
    private static final Permission APP_UPDATE_PERMISSION;
    private static final Permission READ_PERMISSION;
    private static final Permission UPDATE_PERMISSION;
    private static final Permission CREATE_PERMISSION;
    private static final String LTPA_AUTHMECH_OID = "1.3.18.0.2.30.2";
    private static final String DEFAULT_AUTHMECH_OID = "1.3.18.0.2.30.2";
    private static byte[] emptyByteArray;
    private final String realmName;
    private final String securityName;
    private final String realmSecurityName;
    private final String uniqueSecurityName;
    private final String realmUniqueSecurityName;
    private final String primaryGroupId;
    private final String accessId;
    private final ArrayList<String> groupIds;
    private long expiration = 0L;
    private final boolean unauthenticated;
    private final boolean isBasicAuthCred;
    private final boolean forwardable;
    private final String authMechOID;
    private final Hashtable<String, Object> hashTable;
    private byte[] credentialToken = null;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WSCredentialImpl(String realmName, String securityName, String uniqueSecurityName, String unauthenticatedUserid, String primaryUniqueGroupAccessId, String accessId, List<String> roles, List<String> uniqueGroupAccessIds) {
        ArrayList<String> arrayList;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_PERMISSION);
        }
        this.realmName = realmName;
        this.securityName = securityName;
        this.realmSecurityName = realmName + REALM_SEPARATOR + securityName;
        this.uniqueSecurityName = uniqueSecurityName;
        this.realmUniqueSecurityName = realmName + REALM_SEPARATOR + uniqueSecurityName;
        this.primaryGroupId = primaryUniqueGroupAccessId;
        this.accessId = accessId;
        if (uniqueGroupAccessIds != null) {
            arrayList = this.createListCopy(uniqueGroupAccessIds);
        } else {
            ArrayList<String> arrayList2;
            arrayList = arrayList2;
        }
        this.groupIds = arrayList;
        this.unauthenticated = unauthenticatedUserid != null && unauthenticatedUserid.equalsIgnoreCase(securityName);
        this.hashTable = new Hashtable(32);
        this.isBasicAuthCred = false;
        this.forwardable = true;
        this.authMechOID = "1.3.18.0.2.30.2";
    }

    public WSCredentialImpl(String realmName, String securityName, @Sensitive String password) {
        this.realmName = realmName;
        this.securityName = securityName;
        this.credentialToken = WSCredentialImpl.getConvertedBytes(password);
        this.isBasicAuthCred = true;
        this.authMechOID = "oid:2.23.130.1.1.1";
        this.forwardable = true;
        this.uniqueSecurityName = null;
        this.realmSecurityName = null;
        this.realmUniqueSecurityName = null;
        this.accessId = null;
        this.primaryGroupId = null;
        this.groupIds = null;
        this.unauthenticated = false;
        this.hashTable = new Hashtable(32);
    }

    @Sensitive
    @FFDCIgnore(value={UnsupportedEncodingException.class})
    private static byte[] getConvertedBytes(@Sensitive String in_String) {
        byte[] convertedBytes = null;
        if (in_String == null) {
            return null;
        }
        if (in_String.length() == 0) {
            return emptyByteArray;
        }
        try {
            convertedBytes = in_String.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return convertedBytes;
    }

    private ArrayList<String> createListCopy(List<String> groupIds) {
        ArrayList<String> list = new ArrayList<String>();
        for (String id : groupIds) {
            list.add(id);
        }
        return list;
    }

    public String getRealmName() throws CredentialDestroyedException, CredentialExpiredException {
        return this.realmName;
    }

    public String getSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        return this.securityName;
    }

    public String getRealmSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        return this.realmSecurityName;
    }

    public String getUniqueSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        return this.uniqueSecurityName;
    }

    public String getRealmUniqueSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        return this.realmUniqueSecurityName;
    }

    public long getExpiration() throws CredentialDestroyedException, CredentialExpiredException {
        return this.expiration;
    }

    public String getPrimaryGroupId() throws CredentialDestroyedException, CredentialExpiredException {
        return this.primaryGroupId;
    }

    public String getAccessId() throws CredentialDestroyedException, CredentialExpiredException {
        return this.accessId;
    }

    public ArrayList getGroupIds() throws CredentialDestroyedException, CredentialExpiredException {
        return this.groupIds;
    }

    public Object get(String key) throws CredentialDestroyedException, CredentialExpiredException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(APP_READ_PERMISSION);
        }
        if (key.startsWith("wssecurity") && sm != null) {
            sm.checkPermission(READ_PERMISSION);
        }
        return this.hashTable.get(key);
    }

    public Object set(String key, Object value) throws CredentialDestroyedException, CredentialExpiredException {
        SecurityManager sm = System.getSecurityManager();
        if (key.startsWith("wssecurity") && sm != null) {
            sm.checkPermission(UPDATE_PERMISSION);
        }
        if (this.hashTable.get(key) != null && sm != null) {
            sm.checkPermission(APP_UPDATE_PERMISSION);
        }
        return this.hashTable.put(key, value);
    }

    @Override
    public void setExpiration(long expirationInMilliseconds) {
        this.expiration = expirationInMilliseconds;
    }

    public boolean isUnauthenticated() {
        return this.unauthenticated;
    }

    public String toString() {
        return super.toString() + ",realmName=" + this.realmName + ",securityName=" + this.securityName + ",realmSecurityName=" + this.realmSecurityName + ",uniqueSecurityName=" + this.uniqueSecurityName + ",primaryGroupId=" + this.primaryGroupId + ",accessId=" + this.accessId + ",groupIds=" + this.groupIds;
    }

    public String getOID() throws CredentialDestroyedException, CredentialExpiredException {
        return this.authMechOID;
    }

    public boolean isBasicAuth() {
        return this.isBasicAuthCred;
    }

    public boolean isForwardable() throws CredentialDestroyedException, CredentialExpiredException {
        return this.forwardable;
    }

    @Sensitive
    public byte[] getCredentialToken() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.credentialToken != null) {
            return (byte[])this.credentialToken.clone();
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WSCredentialImpl.class, null, null);
        APP_READ_PERMISSION = new AuthPermission("wssecurity.applicationReadCredential");
        APP_UPDATE_PERMISSION = new AuthPermission("wssecurity.applicationUpdateCredential");
        READ_PERMISSION = new AuthPermission("wssecurity.readCredential");
        UPDATE_PERMISSION = new AuthPermission("wssecurity.updateCredential");
        CREATE_PERMISSION = new AuthPermission("wssecurity.createCredential");
        emptyByteArray = new byte[0];
    }
}

