/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.joblog.internal.impl;

import com.ibm.jbatch.container.instance.WorkUnitDescriptor;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jbatch.joblog.internal.impl.BatchLogPartNotCreatedException;
import com.ibm.ws.jbatch.joblog.internal.impl.JobLogEntryDetail;
import com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler;
import com.ibm.ws.jbatch.joblog.internal.impl.JobLogFormatter;
import com.ibm.ws.jbatch.joblog.internal.impl.JobLogManagerImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JobLogHandler
extends Handler {
    private final ThreadLocal<Boolean> loggingInProgress = new ThreadLocal();
    private final ThreadLocal<JobLogFileHandler> threadHandler = new ThreadLocal();
    private final ThreadLocal<JobLogEntryDetail> threadDetail = new ThreadLocal();
    private int maxRecords = 0;
    private int maxTime = 0;
    private Boolean purgeOnPublish = null;
    private Boolean sendFinalNotification = false;
    private final Set<JobLogFileHandler> jobLogFileHandlers = Collections.synchronizedSet(new HashSet());
    private JobLogManagerImpl jobLogManagerImpl;
    private final List<Logger> registeredWithLoggers = new ArrayList<Logger>();
    static final long serialVersionUID = -2810262092908271497L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JobLogHandler() {
        this.setFormatter(new JobLogFormatter());
    }

    public JobLogHandler setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    public JobLogHandler setMaxTime(int maxTimeFromConfig) {
        this.maxTime = maxTimeFromConfig;
        return this;
    }

    public JobLogHandler setPurgeOnPublish(Boolean purgeOnPublish) {
        this.purgeOnPublish = purgeOnPublish == null ? Boolean.valueOf(false) : purgeOnPublish;
        return this;
    }

    public JobLogHandler setFinalNotification(Boolean sendFinalNotification) {
        this.sendFinalNotification = sendFinalNotification;
        return this;
    }

    @Override
    @Trivial
    public void publish(LogRecord record) {
        if (this.loggingInProgress.get() == null) {
            this.loggingInProgress.set(false);
        }
        if (!this.isLoggable(record) || this.loggingInProgress.get().booleanValue()) {
            return;
        }
        this.loggingInProgress.set(true);
        try {
            JobLogFileHandler fileHandler = this.threadHandler.get();
            if (fileHandler != null) {
                this.addJobDetails(record);
                fileHandler.publish(record);
            }
        }
        finally {
            this.loggingInProgress.set(false);
        }
    }

    private String getLogDirPath(WorkUnitDescriptor ctx) {
        String jobName = ctx.getTopLevelJobName();
        long instanceId = ctx.getTopLevelInstanceId();
        long executionId = ctx.getTopLevelExecutionId();
        String result = this.jobLogManagerImpl.getJobExecutionLogDirName(jobName, instanceId, executionId) + File.separator;
        switch (ctx.getWorkUnitType()) {
            case PARTITIONED_STEP: {
                result = result.concat(ctx.getPartitionedStepName() + File.separator + ctx.getPartitionNumber() + File.separator);
                break;
            }
            case SPLIT_FLOW: {
                result = result.concat(ctx.getSplitName() + File.separator + ctx.getFlowName() + File.separator);
                break;
            }
        }
        return result;
    }

    protected String setExecutionContext(WorkUnitDescriptor ctx) throws BatchLogPartNotCreatedException {
        this.loggingInProgress.set(false);
        String logDirPath = this.getLogDirPath(ctx);
        switch (ctx.getWorkUnitType()) {
            case PARTITIONED_STEP: {
                this.threadDetail.set(new JobLogEntryDetail(ctx.getPartitionedStepName(), "partition" + ctx.getPartitionNumber()));
                break;
            }
            case SPLIT_FLOW: {
                this.threadDetail.set(new JobLogEntryDetail(ctx.getSplitName(), ctx.getFlowName()));
                break;
            }
        }
        BatchEventsPublisher publisher = this.jobLogManagerImpl.getEventsPublisher();
        boolean purgeOnPublishHandler = false;
        if (publisher != null) {
            purgeOnPublishHandler = this.purgeOnPublish;
        }
        JobLogFileHandler handler = new JobLogFileHandler(logDirPath.concat("part.%d.log"), this.maxRecords, purgeOnPublishHandler, ctx, this.maxTime);
        this.jobLogFileHandlers.add(handler);
        this.threadHandler.set(handler);
        return logDirPath;
    }

    protected void clearExecutionContext() {
        JobLogFileHandler handler = this.threadHandler.get();
        if (handler != null) {
            if (this.hasLoggers() || this.sendFinalNotification.booleanValue()) {
                handler.handleFinalJobLogPart();
            }
            handler.close();
            this.jobLogFileHandlers.remove(handler);
        }
        this.threadHandler.set(null);
        this.threadDetail.set(null);
        this.loggingInProgress.set(false);
    }

    protected void setJobLogManagerImpl(JobLogManagerImpl jobLogManagerImpl) {
        this.jobLogManagerImpl = jobLogManagerImpl;
    }

    @Override
    public void flush() {
        for (JobLogFileHandler fileHandler : this.jobLogFileHandlers) {
            fileHandler.flush();
        }
    }

    @Override
    public void close() {
        Iterator<JobLogFileHandler> iter = this.jobLogFileHandlers.iterator();
        while (iter.hasNext()) {
            iter.next().handleFinalJobLogPart();
            iter.remove();
        }
    }

    @Trivial
    private void addJobDetails(LogRecord record) {
        if (this.threadDetail.get() != null) {
            this.addParams(record, this.threadDetail.get());
        }
    }

    @Trivial
    private void addParams(LogRecord record, Object ... additionalParams) {
        Object[] curParams = record.getParameters();
        if (curParams != null) {
            Object o;
            int n;
            Object[] newParams = new Object[curParams.length + additionalParams.length];
            int i = 0;
            Object[] objectArray = curParams;
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                newParams[i] = o = objectArray[n];
                ++i;
            }
            objectArray = additionalParams;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                newParams[i] = o = objectArray[n];
                ++i;
            }
            record.setParameters(newParams);
        } else {
            record.setParameters(additionalParams);
        }
    }

    public synchronized void addToLogger(Logger logger) {
        if (!this.registeredWithLoggers.contains(logger)) {
            logger.addHandler(this);
            this.registeredWithLoggers.add(logger);
        }
    }

    public synchronized void removeFromLoggers() {
        for (Logger logger : this.registeredWithLoggers) {
            logger.removeHandler(this);
            logger.setUseParentHandlers(true);
        }
        this.registeredWithLoggers.clear();
    }

    public synchronized boolean hasLoggers() {
        return !this.registeredWithLoggers.isEmpty();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JobLogHandler.class, null, null);
    }
}

