/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.TablePerMultitenantPolicy;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.helper.QueryCounter;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.history.HistoricalSession;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.ProtectedValueHolder;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.EmptyRecord;
import org.eclipse.persistence.internal.sessions.IdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.SessionFinalizer;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.cdi.DisabledEntityListenerInjectionManager;
import org.eclipse.persistence.internal.sessions.cdi.EntityListenerInjectionManager;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.JPAQueryBuilder;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventManager;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.coordination.MetadataRefreshListener;
import org.eclipse.persistence.sessions.serializers.Serializer;
import org.eclipse.persistence.sessions.server.ClientSession;

public abstract class AbstractSession
extends CoreAbstractSession<ClassDescriptor, Login, Platform, Project, SessionEventManager>
implements Session,
CommandProcessor,
Serializable,
Cloneable {
    protected transient ExceptionHandler exceptionHandler;
    protected transient IntegrityChecker integrityChecker;
    protected transient Project project;
    protected transient ConcurrencyManager transactionMutex;
    protected IdentityMapAccessor identityMapAccessor;
    protected boolean wasJTSTransactionInternallyStarted;
    protected transient Collection<Accessor> accessors;
    protected transient Platform platform;
    protected transient Map<String, List<DatabaseQuery>> queries;
    protected Map<String, AttributeGroup> attributeGroups;
    protected boolean jpaQueriesProcessed = false;
    protected transient CommitManager commitManager;
    protected transient SessionProfiler profiler;
    protected transient AbstractSession broker;
    protected String name;
    protected transient int numberOfActiveUnitsOfWork;
    protected Map objectsLockedForClone;
    protected transient SessionLog sessionLog;
    protected transient String logSessionString;
    protected transient SessionEventManager eventManager;
    protected Map<Object, Object> properties;
    protected transient ExternalTransactionController externalTransactionController;
    protected transient ClassDescriptor lastDescriptorAccessed;
    protected transient Map<Class, ClassDescriptor> descriptors;
    protected transient List<ClassDescriptor> tablePerTenantDescriptors;
    protected transient List<DatabaseQuery> tablePerTenantQueries;
    protected boolean isInBroker;
    protected transient CommandManager commandManager;
    protected boolean shouldCheckWriteLock;
    protected boolean shouldPropagateChanges;
    protected boolean isInProfile;
    protected boolean isLoggingOff;
    protected boolean isFinalizersEnabled;
    protected transient ExposedNodeLinkedList activeCommandThreads;
    protected boolean isSynchronized;
    protected ReferenceMode defaultReferenceMode;
    protected Integer pessimisticLockTimeoutDefault;
    protected TimeUnit pessimisticLockTimeoutUnitDefault;
    protected int queryTimeoutDefault;
    protected TimeUnit queryTimeoutUnitDefault;
    protected boolean isConcurrent;
    protected Map<String, String> staticMetamodelClasses;
    protected List<DescriptorEvent> deferredEvents;
    protected boolean isExecutingEvents;
    protected PartitioningPolicy partitioningPolicy;
    protected MetadataRefreshListener metadatalistener;
    protected Set<String> multitenantContextProperties;
    protected transient JPAQueryBuilder queryBuilder;
    protected transient Serializer serializer;
    protected transient EntityListenerInjectionManager entityListenerInjectionManager;
    protected boolean shouldOptimizeResultSetAccess;
    protected boolean tolerateInvalidJPQL = false;

    protected AbstractSession() {
        this.name = "";
        this.queryTimeoutUnitDefault = DescriptorQueryManager.DefaultTimeoutUnit;
        this.pessimisticLockTimeoutUnitDefault = DescriptorQueryManager.DefaultTimeoutUnit;
        this.initializeIdentityMapAccessor();
    }

    protected AbstractSession(int nothing) {
    }

    public AbstractSession(Login login) {
        this(new Project(login));
    }

    public AbstractSession(Project project) {
        this();
        this.project = project;
        if (project.getDatasourceLogin() == null) {
            throw ValidationException.projectLoginIsNull(this);
        }
        for (DatabaseQuery query : project.getQueries()) {
            this.addQuery(query.getName(), query);
        }
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public JPAQueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            AbstractSession parent = this.getParent();
            this.queryBuilder = parent != null ? parent.getQueryBuilder() : this.buildDefaultQueryBuilder();
        }
        return this.queryBuilder;
    }

    public void setQueryBuilder(JPAQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected JPAQueryBuilder buildDefaultQueryBuilder() {
        String queryBuilderClassName = (String)this.getProperty("eclipselink.jpql.parser");
        if (queryBuilderClassName == null) {
            queryBuilderClassName = "org.eclipse.persistence.internal.jpa.jpql.HermesParser";
        }
        String validation = (String)this.getProperty("eclipselink.jpql.validation");
        JPAQueryBuilder builder = null;
        try {
            Class parserClass = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    parserClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(queryBuilderClassName));
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else {
                parserClass = PrivilegedAccessHelper.getClassForName(queryBuilderClassName);
            }
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    builder = (JPAQueryBuilder)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(parserClass));
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else {
                builder = (JPAQueryBuilder)PrivilegedAccessHelper.newInstanceFromClass(parserClass);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load the JPQL parser class.", e);
        }
        if (validation != null) {
            builder.setValidationLevel(validation);
        }
        return builder;
    }

    public void setLoggingOff(boolean loggingOff) {
        this.isLoggingOff = loggingOff;
    }

    public boolean isLoggingOff() {
        return this.isLoggingOff;
    }

    public long getNextQueryId() {
        return QueryCounter.getCount();
    }

    public UnitOfWorkImpl acquireNonSynchronizedUnitOfWork() {
        return this.acquireNonSynchronizedUnitOfWork(null);
    }

    public UnitOfWorkImpl acquireNonSynchronizedUnitOfWork(ReferenceMode referenceMode) {
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        UnitOfWorkImpl unitOfWork = new UnitOfWorkImpl(this, referenceMode);
        if (this.shouldLog(2, "transaction")) {
            this.log(2, "transaction", "acquire_unit_of_work_with_argument", String.valueOf(System.identityHashCode(unitOfWork)));
        }
        return unitOfWork;
    }

    @Override
    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        if (clause == null || clause.getValue() == null) {
            throw ValidationException.cannotAcquireHistoricalSession();
        }
        if (!(this.getProject().hasGenericHistorySupport() || this.hasBroker() || this.getPlatform() != null && this.getPlatform().isOracle())) {
            throw ValidationException.historicalSessionOnlySupportedOnOracle();
        }
        return new HistoricalSession(this, clause);
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork() {
        UnitOfWorkImpl unitOfWork = this.acquireNonSynchronizedUnitOfWork(this.getDefaultReferenceMode());
        unitOfWork.registerWithTransactionIfRequired();
        return unitOfWork;
    }

    public RepeatableWriteUnitOfWork acquireRepeatableWriteUnitOfWork(ReferenceMode referenceMode) {
        return new RepeatableWriteUnitOfWork(this, referenceMode);
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork(ReferenceMode referenceMode) {
        UnitOfWorkImpl unitOfWork = this.acquireNonSynchronizedUnitOfWork(referenceMode);
        unitOfWork.registerWithTransactionIfRequired();
        return unitOfWork;
    }

    public void addAlias(String alias, ClassDescriptor descriptor) {
        this.project.addAlias(alias, descriptor);
    }

    @Override
    public void addJPAQuery(DatabaseQuery query) {
        this.getProject().addJPAQuery(query);
    }

    public void addJPATablePerTenantQuery(DatabaseQuery query) {
        this.getProject().addJPATablePerTenantQuery(query);
    }

    public void addMultitenantContextProperty(String contextProperty) {
        this.getMultitenantContextProperties().add(contextProperty);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void addQuery(DatabaseQuery query, boolean nameMustBeUnique) {
        Vector queriesByName = (Vector)this.getQueries().get(query.getName());
        if (queriesByName == null) {
            queriesByName = NonSynchronizedVector.newInstance();
            this.getQueries().put(query.getName(), queriesByName);
        }
        if (nameMustBeUnique) {
            if (queriesByName.size() > 1) throw new IllegalStateException(ExceptionLocalization.buildMessage("argument_keyed_named_query_with_JPA", new Object[]{query.getName()}));
            queriesByName.clear();
        } else {
            for (DatabaseQuery existingQuery : queriesByName) {
                if (!Helper.areTypesAssignable(query.getArgumentTypes(), existingQuery.getArgumentTypes())) continue;
                throw ValidationException.existingQueryTypeConflict(query, existingQuery);
            }
        }
        queriesByName.add(query);
    }

    @Override
    public void addQuery(String name, DatabaseQuery query) {
        query.setName(name);
        this.addQuery(query, false);
    }

    public void addQuery(String name, DatabaseQuery query, boolean replace) {
        query.setName(name);
        this.addQuery(query, replace);
    }

    public void addStaticMetamodelClass(String modelClassName, String metamodelClassName) {
        if (this.staticMetamodelClasses == null) {
            this.staticMetamodelClasses = new HashMap<String, String>();
        }
        this.staticMetamodelClasses.put(modelClassName, metamodelClassName);
    }

    protected void addTablePerTenantDescriptor(ClassDescriptor descriptor) {
        this.getTablePerTenantDescriptors().add(descriptor);
    }

    protected void addTablePerTenantQuery(DatabaseQuery query) {
        this.getTablePerTenantQueries().add(query);
    }

    /*
     * Unable to fully structure code
     */
    protected void basicBeginTransaction() throws DatabaseException {
        block7: {
            accessors = this.getAccessors();
            if (accessors == null) {
                return;
            }
            failedAccessor = null;
            try {
                var4_3 = accessors.iterator();
                while (var4_3.hasNext()) {
                    failedAccessor = accessor = var4_3.next();
                    this.basicBeginTransaction(accessor);
                }
                break block7;
            }
            catch (RuntimeException exception) {
                ** for (accessor : accessors)
            }
lbl-1000:
            // 1 sources

            {
                if (accessor == failedAccessor) break;
                try {
                    accessor.rollbackTransaction(this);
                }
                catch (RuntimeException v0) {}
                continue;
            }
lbl20:
            // 2 sources

            throw exception;
        }
    }

    protected void basicBeginTransaction(Accessor accessor) throws DatabaseException {
        try {
            accessor.beginTransaction(this);
        }
        catch (DatabaseException databaseException) {
            if (!this.getDatasourceLogin().shouldUseExternalTransactionController() && databaseException.isCommunicationFailure()) {
                DatabaseException exceptionToThrow = databaseException;
                Object[] args = new Object[]{databaseException};
                this.log(5, "transaction", "communication_failure_attempting_begintransaction_retry", args, null);
                exceptionToThrow = this.retryTransaction(accessor, databaseException, 0, this);
                if (exceptionToThrow == null) {
                    return;
                }
                this.handleException(exceptionToThrow);
            } else {
                this.handleException(databaseException);
            }
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    public DatabaseException retryTransaction(Accessor accessor, DatabaseException databaseException, int retryCount, AbstractSession executionSession) {
        DatabaseException exceptionToThrow = databaseException;
        int count = this.getLogin().getQueryRetryAttemptCount();
        while (retryCount < count) {
            try {
                accessor.reestablishConnection(this);
                accessor.beginTransaction(this);
                return null;
            }
            catch (DatabaseException newException) {
                exceptionToThrow = newException;
                ++retryCount;
                try {
                    Thread.currentThread();
                    Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                    Object[] args = new Object[]{databaseException};
                    this.log(5, "transaction", "communication_failure_attempting_begintransaction_retry", args, null);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        return exceptionToThrow;
    }

    public void releaseJTSConnection() {
    }

    protected void basicCommitTransaction() throws DatabaseException {
        Collection<Accessor> accessors = this.getAccessors();
        if (accessors == null) {
            return;
        }
        try {
            for (Accessor accessor : accessors) {
                accessor.commitTransaction(this);
            }
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    protected void basicRollbackTransaction() throws DatabaseException {
        Collection<Accessor> accessors = this.getAccessors();
        if (accessors == null) {
            return;
        }
        RuntimeException exception = null;
        for (Accessor accessor : accessors) {
            try {
                accessor.rollbackTransaction(this);
            }
            catch (RuntimeException failure) {
                exception = failure;
            }
        }
        if (exception != null) {
            this.handleException(exception);
        }
    }

    public boolean beginExternalTransaction() {
        boolean externalTransactionHasBegun = false;
        if (this.hasExternalTransactionController() && !this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().beginTransaction(this);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
            if (this.wasJTSTransactionInternallyStarted()) {
                externalTransactionHasBegun = true;
                this.log(2, "transaction", "external_transaction_has_begun_internally");
            }
        }
        return externalTransactionHasBegun;
    }

    public void beginTransaction() throws DatabaseException, ConcurrencyException {
        ConcurrencyManager mutex = this.getTransactionMutex();
        if (!mutex.isAcquired()) {
            this.beginExternalTransaction();
        }
        if (this.isClientSession()) {
            mutex.setActiveThread(Thread.currentThread());
        }
        mutex.acquire();
        if (!mutex.isNested()) {
            if (this.eventManager != null) {
                this.eventManager.preBeginTransaction();
            }
            this.basicBeginTransaction();
            if (this.eventManager != null) {
                this.eventManager.postBeginTransaction();
            }
        }
    }

    protected ClassDescriptor checkHierarchyForDescriptor(Class theClass) {
        return this.getDescriptor(theClass.getSuperclass());
    }

    public void cleanUpEntityListenerInjectionManager() {
        if (this.entityListenerInjectionManager != null) {
            this.entityListenerInjectionManager.cleanUp(this);
        }
    }

    @Override
    public void clearIntegrityChecker() {
        this.setIntegrityChecker(null);
    }

    public void clearLastDescriptorAccessed() {
        this.lastDescriptorAccessed = null;
    }

    public void clearDescriptors() {
        this.descriptors = null;
    }

    @Override
    public void clearProfile() {
        this.setProfiler(null);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean commitExternalTransaction() {
        boolean externalTransactionHasCommitted = false;
        if (this.hasExternalTransactionController() && this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().commitTransaction(this);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
            if (!this.wasJTSTransactionInternallyStarted()) {
                externalTransactionHasCommitted = true;
                this.log(2, "transaction", "external_transaction_has_committed_internally");
            }
        }
        return externalTransactionHasCommitted;
    }

    public void commitTransaction() throws DatabaseException, ConcurrencyException {
        ConcurrencyManager mutex = this.getTransactionMutex();
        if (!mutex.isNested()) {
            if (this.eventManager != null) {
                this.eventManager.preCommitTransaction();
            }
            this.basicCommitTransaction();
            if (this.eventManager != null) {
                this.eventManager.postCommitTransaction();
            }
        }
        mutex.release();
        if (!mutex.isAcquired()) {
            this.commitExternalTransaction();
        }
    }

    public boolean compareObjects(Object firstObject, Object secondObject) {
        if (firstObject == null && secondObject == null) {
            return true;
        }
        if (firstObject == null || secondObject == null) {
            return false;
        }
        if (!firstObject.getClass().equals(secondObject.getClass())) {
            return false;
        }
        ObjectBuilder builder = this.getDescriptor(firstObject.getClass()).getObjectBuilder();
        return builder.compareObjects(builder.unwrapObject(firstObject, this), builder.unwrapObject(secondObject, this), this);
    }

    public boolean compareObjectsDontMatch(Object firstObject, Object secondObject) {
        return !this.compareObjects(firstObject, secondObject);
    }

    @Override
    public boolean containsQuery(String queryName) {
        return this.getQueries().containsKey(queryName);
    }

    @Override
    public Object copy(Object originalObjectOrObjects) {
        return this.copy(originalObjectOrObjects, new CopyGroup());
    }

    @Override
    public Object copy(Object originalObjectOrObjects, AttributeGroup group) {
        if (originalObjectOrObjects == null) {
            return null;
        }
        CopyGroup copyGroup = group.toCopyGroup();
        copyGroup.setSession(this);
        if (originalObjectOrObjects instanceof Collection) {
            Collection originalCollection = (Collection)originalObjectOrObjects;
            AbstractCollection copies = originalCollection instanceof List ? new ArrayList() : new HashSet();
            Iterator it = originalCollection.iterator();
            while (it.hasNext()) {
                copies.add(this.copyInternal(it.next(), copyGroup));
            }
            return copies;
        }
        return this.copyInternal(originalObjectOrObjects, copyGroup);
    }

    public Object copyInternal(Object originalObject, CopyGroup copyGroup) {
        if (originalObject == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(originalObject);
        if (descriptor == null) {
            return originalObject;
        }
        return descriptor.getObjectBuilder().copyObject(originalObject, copyGroup);
    }

    @Override
    public Object copyObject(Object original) {
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setShouldResetPrimaryKey(true);
        return this.copy(original, copyGroup);
    }

    @Override
    public Object copyObject(Object original, ObjectCopyingPolicy policy) {
        return this.copy(original, policy);
    }

    public Vector copyReadOnlyClasses() {
        return this.getDefaultReadOnlyClasses();
    }

    public DatabaseValueHolder createCloneQueryValueHolder(ValueHolderInterface attributeValue, Object clone, AbstractRecord row, ForeignReferenceMapping mapping) {
        return new ProtectedValueHolder(attributeValue, mapping, this);
    }

    public DatabaseValueHolder createCloneTransformationValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractTransformationMapping mapping) {
        return new ProtectedValueHolder(attributeValue, mapping, this);
    }

    public EntityListenerInjectionManager createEntityListenerInjectionManager(Object beanManager) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                Class elim = (Class)AccessController.doPrivileged(new PrivilegedClassForName("org.eclipse.persistence.internal.sessions.cdi.EntityListenerInjectionManagerImpl", true, this.getLoader()));
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(elim, new Class[]{String.class}, false));
                return (EntityListenerInjectionManager)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{beanManager}));
            }
            Class elim = PrivilegedAccessHelper.getClassForName("org.eclipse.persistence.internal.sessions.cdi.EntityListenerInjectionManagerImpl", true, this.getLoader());
            Constructor constructor = PrivilegedAccessHelper.getConstructorFor(elim, new Class[]{Object.class}, false);
            return (EntityListenerInjectionManager)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{beanManager});
        }
        catch (Exception e) {
            this.logThrowable(1, "jpa", e);
            return new DisabledEntityListenerInjectionManager();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object createProtectedInstanceFromCachedData(Object cached, Integer refreshCascade, ClassDescriptor descriptor) {
        block13: {
            localCacheKey = this.getIdentityMapAccessorInstance().getCacheKeyForObject(cached);
            if (localCacheKey != null && localCacheKey.getObject() != null) {
                return localCacheKey.getObject();
            }
            identityMapLocked = this.shouldCheckWriteLock != false && this.getParent().getIdentityMapAccessorInstance().acquireWriteLock() != false;
            rootOfCloneRecursion = false;
            cacheKey = this.getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(cached);
            try {
                key = null;
                lockValue = null;
                readTime = 0L;
                if (cacheKey != null) {
                    if (identityMapLocked) {
                        this.checkAndRefreshInvalidObject(cached, cacheKey, descriptor);
                    } else if (this.objectsLockedForClone == null) {
                        if (descriptor.shouldAcquireCascadedLocks()) {
                            this.objectsLockedForClone = this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireLocksForClone(cached, descriptor, cacheKey, this);
                        } else {
                            this.checkAndRefreshInvalidObject(cached, cacheKey, descriptor);
                            cacheKey.acquireReadLock();
                        }
                        rootOfCloneRecursion = true;
                    }
                    key = cacheKey.getKey();
                    lockValue = cacheKey.getWriteLockValue();
                    readTime = cacheKey.getReadTime();
                }
                if (descriptor.hasInheritance()) {
                    descriptor = this.getClassDescriptor(cached.getClass());
                }
                builder = descriptor.getObjectBuilder();
                workingClone = builder.instantiateWorkingCopyClone(cached, this);
                builder.populateAttributesForClone(cached, cacheKey, workingClone, refreshCascade, this);
                this.getIdentityMapAccessorInstance().putInIdentityMap(workingClone, key, lockValue, readTime, descriptor);
                var15_13 = workingClone;
                return var15_13;
            }
            finally {
                if (rootOfCloneRecursion == false) return var15_13;
                if (this.objectsLockedForClone == null && cacheKey != null) {
                    cacheKey.releaseReadLock();
                    break block13;
                }
                iterator = this.objectsLockedForClone.values().iterator();
                ** while (iterator.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                ((CacheKey)iterator.next()).releaseReadLock();
                continue;
            }
lbl43:
            // 1 sources

            this.objectsLockedForClone = null;
        }
        this.executeDeferredEvents();
        return var15_13;
    }

    public void checkAndRefreshInvalidObject(Object object, CacheKey cacheKey, ClassDescriptor descriptor) {
        if (this.isConsideredInvalid(object, cacheKey, descriptor)) {
            ReadObjectQuery query = new ReadObjectQuery();
            query.setReferenceClass(object.getClass());
            query.setSelectionId(cacheKey.getKey());
            query.refreshIdentityMapResult();
            query.setIsExecutionClone(true);
            this.executeQuery(query);
        }
    }

    public boolean isConsideredInvalid(Object object, CacheKey cacheKey, ClassDescriptor descriptor) {
        if (cacheKey.getObject() != null) {
            CacheInvalidationPolicy cachePolicy = descriptor.getCacheInvalidationPolicy();
            return cachePolicy.shouldRefreshInvalidObjectsOnClone() && cachePolicy.isInvalidated(cacheKey);
        }
        return false;
    }

    public void deferEvent(DescriptorEvent event) {
        if (this.deferredEvents == null) {
            this.deferredEvents = new ArrayList<DescriptorEvent>();
        }
        this.deferredEvents.add(event);
    }

    public void deleteAllObjects(Collection domainObjects) throws DatabaseException, OptimisticLockException {
        Iterator objectsEnum = domainObjects.iterator();
        while (objectsEnum.hasNext()) {
            this.deleteObject(objectsEnum.next());
        }
    }

    @Deprecated
    public void deleteAllObjects(Vector domainObjects) throws DatabaseException, OptimisticLockException {
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            this.deleteObject(objectsEnum.nextElement());
        }
    }

    public Object deleteObject(Object domainObject) throws DatabaseException, OptimisticLockException {
        DeleteObjectQuery query = new DeleteObjectQuery();
        query.setObject(domainObject);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public boolean doesObjectExist(Object object) throws DatabaseException {
        DoesExistQuery query = new DoesExistQuery();
        query.setObject(object);
        query.checkDatabaseForDoesExist();
        query.setIsExecutionClone(true);
        return (Boolean)this.executeQuery(query);
    }

    @Override
    public void dontLogMessages() {
        this.setLogLevel(8);
    }

    @Override
    public void endOperationProfile(String operationName) {
        if (this.isInProfile) {
            this.getProfiler().endOperationProfile(operationName);
        }
    }

    public void endOperationProfile(String operationName, DatabaseQuery query, int weight) {
        if (this.isInProfile) {
            this.getProfiler().endOperationProfile(operationName, query, weight);
        }
    }

    @Override
    public void updateProfile(String operationName, Object value) {
        if (this.isInProfile) {
            this.getProfiler().update(operationName, value);
        }
    }

    public void updateTablePerTenantDescriptors(String property, Object value) {
        boolean shouldInitializeDescriptors = this.hasTablePerTenantDescriptors();
        for (ClassDescriptor descriptor : this.getTablePerTenantDescriptors()) {
            TablePerMultitenantPolicy policy = (TablePerMultitenantPolicy)descriptor.getMultitenantPolicy();
            if (!policy.hasContextTenant() && policy.usesContextProperty(property)) {
                policy.setContextTenant((String)value);
            }
            boolean bl = shouldInitializeDescriptors = shouldInitializeDescriptors && policy.hasContextTenant();
        }
        if (shouldInitializeDescriptors) {
            try {
                for (ClassDescriptor descriptor : this.tablePerTenantDescriptors) {
                    descriptor.preInitialize(this);
                }
                for (ClassDescriptor descriptor : this.tablePerTenantDescriptors) {
                    descriptor.initialize(this);
                }
                for (ClassDescriptor descriptor : this.tablePerTenantDescriptors) {
                    descriptor.postInitialize(this);
                }
                if (this.getIntegrityChecker().hasErrors()) {
                    this.handleSevere(new IntegrityException(this.getIntegrityChecker()));
                }
            }
            finally {
                this.clearIntegrityChecker();
            }
            this.getCommitManager().initializeCommitOrder();
            if (this.hasTablePerTenantQueries()) {
                for (DatabaseQuery query : this.getTablePerTenantQueries()) {
                    this.processJPAQuery(query);
                }
            }
        }
    }

    @Override
    public void incrementProfile(String operationName) {
        if (this.isInProfile) {
            this.getProfiler().occurred(operationName, this);
        }
    }

    public void incrementProfile(String operationName, DatabaseQuery query) {
        if (this.isInProfile) {
            this.getProfiler().occurred(operationName, query, this);
        }
    }

    public void executeDeferredEvents() {
        if (!this.isExecutingEvents && this.deferredEvents != null) {
            this.isExecutingEvents = true;
            try {
                int i = 0;
                while (i < this.deferredEvents.size()) {
                    DescriptorEvent event = this.deferredEvents.get(i);
                    event.getDescriptor().getEventManager().executeEvent(event);
                    ++i;
                }
                this.deferredEvents.clear();
            }
            finally {
                this.isExecutingEvents = false;
            }
        }
    }

    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        if (query.getAccessors() == null) {
            query.setAccessors(this.getAccessors());
        }
        try {
            Object object = this.basicExecuteCall(call, translationRow, query);
            return object;
        }
        finally {
            if (call.isFinished()) {
                query.setAccessors(null);
            }
        }
    }

    public void releaseConnectionAfterCall(DatabaseQuery query) {
    }

    @Override
    public int executeNonSelectingCall(Call call) throws DatabaseException {
        DataModifyQuery query = new DataModifyQuery();
        query.setIsExecutionClone(true);
        query.setCall(call);
        Integer value = (Integer)this.executeQuery(query);
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    public void executeNonSelectingSQL(String sqlString) throws DatabaseException {
        this.executeNonSelectingCall(new SQLCall(sqlString));
    }

    @Override
    public Object executeQuery(String queryName) throws DatabaseException {
        DatabaseQuery query = this.getQuery(queryName);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName);
        }
        return this.executeQuery(query);
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass) throws DatabaseException {
        ClassDescriptor descriptor = this.getDescriptor(domainClass);
        if (descriptor == null) {
            throw QueryException.descriptorIsMissingForNamedQuery(domainClass, queryName);
        }
        DatabaseQuery query = descriptor.getQueryManager().getQuery(queryName);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName, domainClass);
        }
        return this.executeQuery(query);
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass, Object arg1) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        return this.executeQuery(queryName, domainClass, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass, Object arg1, Object arg2) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        return this.executeQuery(queryName, domainClass, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass, Object arg1, Object arg2, Object arg3) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        argumentValues.addElement(arg3);
        return this.executeQuery(queryName, domainClass, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass, List argumentValues) throws DatabaseException {
        if (argumentValues instanceof Vector) {
            return this.executeQuery(queryName, domainClass, (Vector)argumentValues);
        }
        return this.executeQuery(queryName, domainClass, new Vector(argumentValues));
    }

    public Object executeQuery(String queryName, Class domainClass, Vector argumentValues) throws DatabaseException {
        ClassDescriptor descriptor = this.getDescriptor(domainClass);
        if (descriptor == null) {
            throw QueryException.descriptorIsMissingForNamedQuery(domainClass, queryName);
        }
        DatabaseQuery query = descriptor.getQueryManager().getQuery(queryName, argumentValues);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName, domainClass);
        }
        return this.executeQuery(query, (List)argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Object arg1) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        return this.executeQuery(queryName, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Object arg1, Object arg2) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        return this.executeQuery(queryName, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, Object arg1, Object arg2, Object arg3) throws DatabaseException {
        Vector<Object> argumentValues = new Vector<Object>();
        argumentValues.addElement(arg1);
        argumentValues.addElement(arg2);
        argumentValues.addElement(arg3);
        return this.executeQuery(queryName, argumentValues);
    }

    @Override
    public Object executeQuery(String queryName, List argumentValues) throws DatabaseException {
        if (argumentValues instanceof Vector) {
            return this.executeQuery(queryName, (Vector)argumentValues);
        }
        return this.executeQuery(queryName, new Vector(argumentValues));
    }

    public Object executeQuery(String queryName, Vector argumentValues) throws DatabaseException {
        DatabaseQuery query = this.getQuery(queryName, argumentValues);
        if (query == null) {
            throw QueryException.queryNotDefined(queryName);
        }
        return this.executeQuery(query, (List)argumentValues);
    }

    @Override
    public Object executeQuery(DatabaseQuery query) throws DatabaseException {
        return this.executeQuery(query, EmptyRecord.getEmptyRecord());
    }

    @Override
    public Object executeQuery(DatabaseQuery query, List argumentValues) throws DatabaseException {
        if (query == null) {
            throw QueryException.queryNotDefined();
        }
        AbstractRecord row = query.rowFromArguments(argumentValues, this);
        return this.executeQuery(query, row);
    }

    public Object executeQuery(DatabaseQuery query, AbstractRecord row) throws DatabaseException {
        if (this.hasBroker() && (!query.isDataModifyQuery() && !query.isDataReadQuery() || query.getSessionName() != null)) {
            return this.getBroker().executeQuery(query, row);
        }
        if (query == null) {
            throw QueryException.queryNotDefined();
        }
        if (query.isUserDefinedSQLCall() && query.isSQLCallQuery() && !query.isJPQLCallQuery() && !query.shouldAllowNativeSQLQuery(this.getProject().allowNativeSQLQueries())) {
            throw QueryException.nativeSQLQueriesAreDisabled(query);
        }
        this.log(1, "query", "execute_query", query);
        return this.executeQuery(query, row, 0);
    }

    public Object executeQuery(DatabaseQuery query, AbstractRecord row, int retryCount) throws DatabaseException {
        try {
            if (this.eventManager != null) {
                this.eventManager.preExecuteQuery(query);
            }
            Object result = this.isInProfile() ? this.getProfiler().profileExecutionOfQuery(query, row, this) : this.internalExecuteQuery(query, row);
            if (this.eventManager != null) {
                this.eventManager.postExecuteQuery(query, result);
            }
            return result;
        }
        catch (RuntimeException exception2) {
            DatabaseException exception2;
            if (exception2 instanceof QueryException) {
                QueryException queryException = (QueryException)exception2;
                if (queryException.getQuery() == null) {
                    queryException.setQuery(query);
                }
                if (queryException.getQueryArgumentsRecord() == null) {
                    queryException.setQueryArguments(row);
                }
                if (queryException.getSession() == null) {
                    queryException.setSession(this);
                }
            } else if (exception2 instanceof DatabaseException) {
                DatabaseException databaseException = (DatabaseException)exception2;
                if (databaseException.getQuery() == null) {
                    databaseException.setQuery(query);
                }
                if (databaseException.getQueryArgumentsRecord() == null) {
                    databaseException.setQueryArguments(row);
                }
                if (databaseException.getSession() == null) {
                    databaseException.setSession(this);
                }
                if (!this.isInTransaction() && query.isReadQuery() && databaseException.isCommunicationFailure()) {
                    Object[] args = new Object[]{databaseException};
                    this.log(5, "query", "communication_failure_attempting_query_retry", args, null);
                    Object result = this.retryQuery(query, row, databaseException, retryCount, this);
                    if (result instanceof DatabaseException) {
                        exception2 = (DatabaseException)result;
                    } else {
                        return result;
                    }
                }
            }
            return this.handleException(exception2);
        }
    }

    public Object retryQuery(DatabaseQuery query, AbstractRecord row, DatabaseException databaseException, int retryCount, AbstractSession executionSession) {
        DatabaseException exception = databaseException;
        if (retryCount <= this.getLogin().getQueryRetryAttemptCount()) {
            try {
                ++retryCount;
                try {
                    if (retryCount > 1) {
                        Thread.currentThread();
                        Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                    }
                    return executionSession.executeQuery(query, row, retryCount);
                }
                catch (DatabaseException newException) {
                    exception = newException;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return exception;
    }

    @Override
    public Vector executeSelectingCall(Call call) throws DatabaseException {
        DataReadQuery query = new DataReadQuery();
        query.setCall(call);
        query.setIsExecutionClone(true);
        return (Vector)this.executeQuery(query);
    }

    @Override
    public Vector executeSQL(String sqlString) throws DatabaseException {
        return this.executeSelectingCall(new SQLCall(sqlString));
    }

    public Accessor getAccessor() {
        Collection<Accessor> accessors = this.getAccessors();
        if (accessors == null || accessors.isEmpty()) {
            return null;
        }
        if (accessors instanceof List) {
            return (Accessor)((List)accessors).get(0);
        }
        return accessors.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Accessor> getAccessors() {
        if (this.accessors == null && this.project != null && this.project.getDatasourceLogin() != null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.accessors == null && this.project != null && this.project.getDatasourceLogin() != null) {
                    ArrayList<Accessor> newAccessors = new ArrayList<Accessor>(1);
                    newAccessors.add(this.project.getDatasourceLogin().buildAccessor());
                    this.accessors = newAccessors;
                }
            }
        }
        return this.accessors;
    }

    public Collection<Accessor> getAccessors(Call call, AbstractRecord translationRow, DatabaseQuery query) {
        List<Accessor> accessors = null;
        if (query.getPartitioningPolicy() != null && (accessors = query.getPartitioningPolicy().getConnectionsForQuery(this, query, translationRow)) != null) {
            return accessors;
        }
        ClassDescriptor descriptor = query.getDescriptor();
        if (descriptor != null && descriptor.getPartitioningPolicy() != null && (accessors = descriptor.getPartitioningPolicy().getConnectionsForQuery(this, query, translationRow)) != null) {
            return accessors;
        }
        if (this.partitioningPolicy != null && (accessors = this.partitioningPolicy.getConnectionsForQuery(this, query, translationRow)) != null) {
            return accessors;
        }
        return accessors;
    }

    public Object basicExecuteCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        Object result = null;
        if (query.getAccessors().size() == 1) {
            result = query.getAccessor().executeCall(call, translationRow, this);
        } else {
            RuntimeException exception = null;
            for (Accessor accessor : query.getAccessors()) {
                Object object;
                block10: {
                    object = null;
                    try {
                        object = accessor.executeCall(call, translationRow, this);
                    }
                    catch (RuntimeException failed) {
                        if (exception != null) break block10;
                        exception = failed;
                    }
                }
                if (call.isOneRowReturned()) {
                    if (object == null) continue;
                    result = object;
                    break;
                }
                if (call.isNothingReturned()) {
                    if (result == null) {
                        result = object;
                        continue;
                    }
                    if (!(object instanceof Integer) || (Integer)result == 0 || (Integer)object == 0) continue;
                    result = object;
                    continue;
                }
                if (result == null) {
                    result = object;
                    continue;
                }
                if (!(object instanceof List)) break;
                ((List)result).addAll((List)object);
            }
            if (exception != null) {
                throw exception;
            }
        }
        return result;
    }

    public ExposedNodeLinkedList getActiveCommandThreads() {
        if (this.activeCommandThreads == null) {
            this.activeCommandThreads = new ExposedNodeLinkedList();
        }
        return this.activeCommandThreads;
    }

    @Override
    public Session getActiveSession() {
        Session activeSession = this.getActiveUnitOfWork();
        if (activeSession == null) {
            activeSession = this;
        }
        return activeSession;
    }

    @Override
    public UnitOfWork getActiveUnitOfWork() {
        if (this.hasExternalTransactionController()) {
            return this.getExternalTransactionController().getActiveUnitOfWork();
        }
        if (this.isClientSession()) {
            return ((ClientSession)this).getParent().getActiveUnitOfWork();
        }
        return null;
    }

    public Map getAliasDescriptors() {
        return this.project.getAliasDescriptors();
    }

    @Override
    public AsOfClause getAsOfClause() {
        return null;
    }

    public AbstractSession getBroker() {
        return this.broker;
    }

    public AbstractSession getRootSession(DatabaseQuery query) {
        ClassDescriptor descriptor = null;
        if (query != null) {
            descriptor = query.getDescriptor();
        }
        return this.getParentIdentityMapSession(descriptor, true, true);
    }

    public AbstractSession getParent() {
        return null;
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query) {
        ClassDescriptor descriptor = null;
        if (query != null) {
            descriptor = query.getDescriptor();
        }
        return this.getParentIdentityMapSession(descriptor, false, false);
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        ClassDescriptor descriptor = null;
        if (query != null) {
            descriptor = query.getDescriptor();
        }
        return this.getParentIdentityMapSession(descriptor, canReturnSelf, terminalOnly);
    }

    public AbstractSession getParentIdentityMapSession(ClassDescriptor descriptor, boolean canReturnSelf, boolean terminalOnly) {
        return this;
    }

    public Integer getPessimisticLockTimeoutDefault() {
        return this.pessimisticLockTimeoutDefault;
    }

    public TimeUnit getPessimisticLockTimeoutUnitDefault() {
        return this.pessimisticLockTimeoutUnitDefault;
    }

    public int getQueryTimeoutDefault() {
        return this.queryTimeoutDefault;
    }

    public TimeUnit getQueryTimeoutUnitDefault() {
        return this.queryTimeoutUnitDefault;
    }

    public EntityListenerInjectionManager getEntityListenerInjectionManager() {
        if (this.entityListenerInjectionManager == null) {
            this.entityListenerInjectionManager = this.createEntityListenerInjectionManager(this.getProperty("javax.persistence.bean.manager"));
        }
        return this.entityListenerInjectionManager;
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        return this;
    }

    public boolean hasCommitManager() {
        return this.commitManager != null;
    }

    public CommitManager getCommitManager() {
        if (this.hasBroker()) {
            return this.getBroker().getCommitManager();
        }
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this);
        }
        return this.commitManager;
    }

    public Vector getDefaultReadOnlyClasses() {
        if (this.hasBroker()) {
            return this.getBroker().getDefaultReadOnlyClasses();
        }
        return this.getProject().getDefaultReadOnlyClasses();
    }

    @Override
    public ClassDescriptor getClassDescriptor(Class theClass) {
        if (theClass == null) {
            return null;
        }
        return this.getDescriptor(theClass);
    }

    @Override
    public ClassDescriptor getClassDescriptor(Object domainObject) {
        if (domainObject == null) {
            return null;
        }
        return this.getDescriptor(domainObject);
    }

    @Override
    public ClassDescriptor getClassDescriptorForAlias(String alias) {
        return this.project.getDescriptorForAlias(alias);
    }

    @Override
    public ClassDescriptor getDescriptor(Class theClass) {
        if (theClass == null) {
            return null;
        }
        ClassDescriptor descriptor = this.lastDescriptorAccessed;
        if (descriptor != null && descriptor.getJavaClass() == theClass) {
            return descriptor;
        }
        descriptor = this.descriptors != null ? this.descriptors.get(theClass) : this.project.getDescriptors().get(theClass);
        if (descriptor == null) {
            if (this.hasBroker()) {
                descriptor = this.getBroker().getDescriptor(theClass);
            }
            if (descriptor == null) {
                if (this.eventManager != null) {
                    this.eventManager.missingDescriptor(theClass);
                }
                if ((descriptor = this.getDescriptors().get(theClass)) == null && !theClass.isInterface()) {
                    Class<?>[] interfaces = theClass.getInterfaces();
                    int index = 0;
                    while (index < interfaces.length) {
                        Class<?> interfaceClass = interfaces[index];
                        descriptor = this.getDescriptor(interfaceClass);
                        if (descriptor != null) {
                            this.getDescriptors().put(interfaceClass, descriptor);
                            break;
                        }
                        ++index;
                    }
                    if (descriptor == null) {
                        descriptor = this.checkHierarchyForDescriptor(theClass);
                    }
                }
            }
        }
        this.lastDescriptorAccessed = descriptor;
        return descriptor;
    }

    @Override
    public ClassDescriptor getDescriptor(Object domainObject) {
        if (domainObject == null) {
            return null;
        }
        if (this.project.hasProxyIndirection()) {
            return this.getDescriptor(ProxyIndirectionPolicy.getValueFromProxy(domainObject).getClass());
        }
        return this.getDescriptor(domainObject.getClass());
    }

    @Override
    public ClassDescriptor getDescriptorForAlias(String alias) {
        ClassDescriptor desc = this.project.getDescriptorForAlias(alias);
        if (desc != null && this.descriptors != null) {
            return this.descriptors.get(desc.getJavaClass());
        }
        return desc;
    }

    @Override
    public Map<Class, ClassDescriptor> getDescriptors() {
        return this.project.getDescriptors();
    }

    public boolean hasEventManager() {
        return this.eventManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionEventManager getEventManager() {
        if (this.eventManager == null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.eventManager == null) {
                    this.eventManager = new SessionEventManager(this);
                }
            }
        }
        return this.eventManager;
    }

    public String getExceptionHandlerClass() {
        String className = null;
        try {
            className = this.getExceptionHandler().getClass().getName();
        }
        catch (Exception exception) {
            return null;
        }
        return className;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public ExternalTransactionController getExternalTransactionController() {
        return this.externalTransactionController;
    }

    @Override
    public org.eclipse.persistence.sessions.IdentityMapAccessor getIdentityMapAccessor() {
        return this.identityMapAccessor;
    }

    public IdentityMapAccessor getIdentityMapAccessorInstance() {
        return this.identityMapAccessor;
    }

    @Override
    public IntegrityChecker getIntegrityChecker() {
        if (this.integrityChecker == null) {
            this.integrityChecker = new IntegrityChecker();
        }
        return this.integrityChecker;
    }

    @Override
    public List<DatabaseQuery> getJPAQueries() {
        return this.getProject().getJPAQueries();
    }

    public List<DatabaseQuery> getJPATablePerTenantQueries() {
        return this.getProject().getJPATablePerTenantQueries();
    }

    @Override
    public Writer getLog() {
        return this.getSessionLog().getWriter();
    }

    public String getLogSessionString() {
        if (this.logSessionString == null) {
            StringWriter writer = new StringWriter();
            writer.write(this.getSessionTypeString());
            writer.write("(");
            writer.write(String.valueOf(System.identityHashCode(this)));
            writer.write(")");
            this.logSessionString = writer.toString();
        }
        return this.logSessionString;
    }

    public String getSessionTypeString() {
        return Helper.getShortClassName(this.getClass());
    }

    public String getStaticMetamodelClass(String modelClassName) {
        if (this.staticMetamodelClasses != null) {
            return this.staticMetamodelClasses.get(modelClassName);
        }
        return null;
    }

    @Override
    public DatabaseLogin getLogin() {
        try {
            return (DatabaseLogin)this.getDatasourceLogin();
        }
        catch (ClassCastException classCastException) {
            throw ValidationException.notSupportedForDatasource();
        }
    }

    @Override
    public Login getDatasourceLogin() {
        if (this.project == null) {
            return null;
        }
        return this.project.getDatasourceLogin();
    }

    public ClassDescriptor getMappedSuperclass(String className) {
        ClassDescriptor desc = this.getProject().getMappedSuperclass(className);
        if (desc == null && this.hasBroker()) {
            this.getBroker().getMappedSuperclass(className);
        }
        return desc;
    }

    public Set<String> getMultitenantContextProperties() {
        if (this.multitenantContextProperties == null) {
            this.multitenantContextProperties = new HashSet<String>();
        }
        return this.multitenantContextProperties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Number getNextSequenceNumberValue(Class domainClass) {
        return (Number)this.getSequencing().getNextValue(domainClass);
    }

    public int getNumberOfActiveUnitsOfWork() {
        return this.numberOfActiveUnitsOfWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheKey getCacheKeyFromTargetSessionForMerge(Object implementation, ObjectBuilder builder, ClassDescriptor descriptor, MergeManager mergeManager) {
        Object original = null;
        Object primaryKey = builder.extractPrimaryKeyFromObject(implementation, this, true);
        if (primaryKey == null) {
            return null;
        }
        CacheKey cacheKey = null;
        if (mergeManager == null) {
            cacheKey = this.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, implementation.getClass(), descriptor, true);
            if (cacheKey != null) {
                cacheKey.checkReadLock();
            }
            return cacheKey;
        }
        cacheKey = this.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, implementation.getClass(), descriptor, true);
        if (cacheKey != null) {
            if (cacheKey.acquireReadLockNoWait()) {
                original = cacheKey.getObject();
                cacheKey.releaseReadLock();
            } else {
                if (!mergeManager.isTransitionedToDeferredLocks()) {
                    this.getIdentityMapAccessorInstance().getWriteLockManager().transitionToDeferredLocks(mergeManager);
                }
                cacheKey.acquireDeferredLock();
                original = cacheKey.getObject();
                if (original == null) {
                    CacheKey cacheKey2 = cacheKey;
                    synchronized (cacheKey2) {
                        if (cacheKey.isAcquired()) {
                            try {
                                cacheKey.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        original = cacheKey.getObject();
                    }
                }
                cacheKey.releaseDeferredLock();
            }
        }
        return cacheKey;
    }

    @Override
    public DatabasePlatform getPlatform() {
        if (this.platform == null) {
            this.platform = this.getDatasourceLogin().getPlatform();
        }
        return (DatabasePlatform)this.platform;
    }

    public ClassLoader getLoader() {
        return this.getDatasourcePlatform().getConversionManager().getLoader();
    }

    @Override
    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            this.platform = this.getDatasourceLogin().getDatasourcePlatform();
        }
        return this.platform;
    }

    @Override
    public ServerPlatform getServerPlatform() {
        return null;
    }

    @Override
    public Platform getPlatform(Class domainClass) {
        if (this.platform == null) {
            this.platform = this.getDatasourcePlatform();
        }
        return this.platform;
    }

    @Override
    public SessionProfiler getProfiler() {
        return this.profiler;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>(5);
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean hasTablePerTenantDescriptors() {
        return this.tablePerTenantDescriptors != null && !this.tablePerTenantDescriptors.isEmpty();
    }

    public boolean hasTablePerTenantQueries() {
        return this.tablePerTenantQueries != null && !this.tablePerTenantQueries.isEmpty();
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.getProperties().get(name);
    }

    @Override
    public Map<String, List<DatabaseQuery>> getQueries() {
        if (this.queries == null) {
            this.queries = new HashMap<String, List<DatabaseQuery>>(5);
        }
        return this.queries;
    }

    public Map<String, AttributeGroup> getAttributeGroups() {
        if (this.attributeGroups == null) {
            this.attributeGroups = new HashMap<String, AttributeGroup>(5);
        }
        return this.attributeGroups;
    }

    public List<DatabaseQuery> getAllQueries() {
        Vector<DatabaseQuery> allQueries = new Vector<DatabaseQuery>();
        Iterator<List<DatabaseQuery>> vectors = this.getQueries().values().iterator();
        while (vectors.hasNext()) {
            allQueries.addAll((Vector)vectors.next());
        }
        return allQueries;
    }

    @Override
    public DatabaseQuery getQuery(String name) {
        return this.getQuery(name, null);
    }

    @Override
    public DatabaseQuery getQuery(String name, List arguments) {
        if (arguments instanceof Vector) {
            return this.getQuery(name, (Vector)arguments);
        }
        return this.getQuery(name, new Vector(arguments));
    }

    public DatabaseQuery getQuery(String name, Vector arguments) {
        return this.getQuery(name, arguments, true);
    }

    public DatabaseQuery getQuery(String name, Vector arguments, boolean shouldSearchParent) {
        AbstractSession parent;
        Vector queries = (Vector)this.getQueries().get(name);
        if (queries != null && !queries.isEmpty()) {
            if (queries.size() == 1) {
                return (DatabaseQuery)queries.firstElement();
            }
            int argumentTypesSize = 0;
            if (arguments != null) {
                argumentTypesSize = arguments.size();
            }
            Vector argumentTypes = new Vector(argumentTypesSize);
            int i = 0;
            while (i < argumentTypesSize) {
                argumentTypes.addElement(arguments.elementAt(i).getClass());
                ++i;
            }
            Enumeration queriesEnum = queries.elements();
            while (queriesEnum.hasMoreElements()) {
                DatabaseQuery query = (DatabaseQuery)queriesEnum.nextElement();
                if (!Helper.areTypesAssignable(argumentTypes, query.getArgumentTypes())) continue;
                return query;
            }
        }
        if (shouldSearchParent && (parent = this.getParent()) != null) {
            return parent.getQuery(name, arguments, true);
        }
        return null;
    }

    public Sequencing getSequencing() {
        return null;
    }

    public AbstractSession getSessionForClass(Class domainClass) {
        if (this.hasBroker()) {
            return this.getBroker().getSessionForClass(domainClass);
        }
        return this;
    }

    public AbstractSession getSessionForName(String name) throws ValidationException {
        if (this.hasBroker()) {
            return this.getBroker().getSessionForName(name);
        }
        return this;
    }

    @Override
    public SessionLog getSessionLog() {
        if (this.sessionLog == null) {
            this.setSessionLog(new DefaultSessionLog());
        }
        return this.sessionLog;
    }

    public List<ClassDescriptor> getTablePerTenantDescriptors() {
        if (this.tablePerTenantDescriptors == null) {
            this.tablePerTenantDescriptors = new ArrayList<ClassDescriptor>();
        }
        return this.tablePerTenantDescriptors;
    }

    public List<DatabaseQuery> getTablePerTenantQueries() {
        if (this.tablePerTenantQueries == null) {
            this.tablePerTenantQueries = new ArrayList<DatabaseQuery>();
        }
        return this.tablePerTenantQueries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrencyManager getTransactionMutex() {
        if (this.transactionMutex == null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.transactionMutex == null) {
                    this.transactionMutex = new ConcurrencyManager();
                }
            }
        }
        return this.transactionMutex;
    }

    @Override
    public Object handleException(RuntimeException exception) throws RuntimeException {
        if (exception instanceof EclipseLinkException) {
            EclipseLinkException eclipseLinkException = (EclipseLinkException)exception;
            if (eclipseLinkException.getSession() == null) {
                eclipseLinkException.setSession(this);
            }
            if (!eclipseLinkException.hasBeenLogged()) {
                this.logThrowable(6, null, exception);
                eclipseLinkException.setHasBeenLogged(true);
            }
        } else {
            this.logThrowable(6, null, exception);
        }
        if (this.hasExceptionHandler()) {
            if (this.broker != null && this.broker.hasExceptionHandler()) {
                try {
                    return this.getExceptionHandler().handleException(exception);
                }
                catch (RuntimeException runtimeException) {
                    return this.broker.getExceptionHandler().handleException(exception);
                }
            }
            return this.getExceptionHandler().handleException(exception);
        }
        if (this.broker != null && this.broker.hasExceptionHandler()) {
            return this.broker.getExceptionHandler().handleException(exception);
        }
        throw exception;
    }

    public boolean hasBroker() {
        return this.broker != null;
    }

    @Override
    public boolean hasDescriptor(Class theClass) {
        if (theClass == null) {
            return false;
        }
        return this.getDescriptors().get(theClass) != null;
    }

    @Override
    public boolean hasExceptionHandler() {
        return this.exceptionHandler != null;
    }

    @Override
    public boolean hasExternalTransactionController() {
        return this.externalTransactionController != null;
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new IdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public Object insertObject(Object domainObject) throws DatabaseException {
        InsertObjectQuery query = new InsertObjectQuery();
        query.setObject(domainObject);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord databaseRow) throws DatabaseException {
        return query.execute(this, databaseRow);
    }

    public boolean isBroker() {
        return false;
    }

    public boolean isInBroker() {
        return this.isInBroker;
    }

    public boolean isClassReadOnly(Class theClass) {
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        return this.isClassReadOnly(theClass, descriptor);
    }

    public boolean isClassReadOnly(Class theClass, ClassDescriptor descriptor) {
        if (descriptor != null && descriptor.shouldBeReadOnly()) {
            return true;
        }
        if (theClass != null) {
            return this.getDefaultReadOnlyClasses().contains(theClass);
        }
        return false;
    }

    @Override
    public boolean isClientSession() {
        return false;
    }

    public boolean isIsolatedClientSession() {
        return false;
    }

    public boolean isExclusiveIsolatedClientSession() {
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this.getAccessor() == null) {
            return false;
        }
        return this.getAccessor().isConnected();
    }

    @Override
    public boolean isDatabaseSession() {
        return false;
    }

    @Override
    public boolean isDistributedSession() {
        return false;
    }

    @Override
    public boolean isInProfile() {
        return this.isInProfile;
    }

    public void setIsInProfile(boolean inProfile) {
        this.isInProfile = inProfile;
    }

    public void setIsInBroker(boolean isInBroker) {
        this.isInBroker = isInBroker;
    }

    @Override
    public boolean isFinalizersEnabled() {
        return this.isFinalizersEnabled;
    }

    public void registerFinalizer() {
        this.setProperty("finalizer", new SessionFinalizer(this));
    }

    public boolean isHistoricalSession() {
        return false;
    }

    @Override
    public void setIsFinalizersEnabled(boolean isFinalizersEnabled) {
        this.isFinalizersEnabled = isFinalizersEnabled;
    }

    public boolean isInTransaction() {
        return this.transactionMutex != null && this.transactionMutex.isAcquired();
    }

    public boolean isJPAQueriesProcessed() {
        return this.jpaQueriesProcessed;
    }

    public boolean isProtectedSession() {
        return true;
    }

    @Override
    public boolean isRemoteSession() {
        return false;
    }

    @Override
    public boolean isRemoteUnitOfWork() {
        return false;
    }

    @Override
    public boolean isServerSession() {
        return false;
    }

    @Override
    public boolean isSessionBroker() {
        return false;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    @Override
    public boolean isUnitOfWork() {
        return false;
    }

    @Override
    public Object getId(Object domainObject) throws ValidationException {
        ClassDescriptor descriptor = this.getDescriptor(domainObject);
        return this.keyFromObject(domainObject, descriptor);
    }

    @Override
    @Deprecated
    public Vector keyFromObject(Object domainObject) throws ValidationException {
        ClassDescriptor descriptor = this.getDescriptor(domainObject);
        return (Vector)this.keyFromObject(domainObject, descriptor);
    }

    public Object keyFromObject(Object domainObject, ClassDescriptor descriptor) throws ValidationException {
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(domainObject.getClass().getName());
        }
        Object implemention = descriptor.getObjectBuilder().unwrapObject(domainObject, this);
        if (implemention == null) {
            return null;
        }
        return descriptor.getObjectBuilder().extractPrimaryKeyFromObject(implemention, this);
    }

    @Override
    public void log(SessionLogEntry entry) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            if (entry.getSession() == null) {
                entry.setSession(this);
            }
            this.getSessionLog().log(entry);
        }
    }

    @Override
    public void logMessage(String message) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(2, "misc", message, null, null, false);
    }

    public DatabaseQuery prepareDatabaseQuery(DatabaseQuery query) {
        if (!this.isUnitOfWork() && query.isObjectLevelReadQuery()) {
            return ((ObjectLevelReadQuery)query).prepareOutsideUnitOfWork(this);
        }
        return query;
    }

    @Override
    public Vector readAllObjects(Class domainClass) throws DatabaseException {
        ReadAllQuery query = new ReadAllQuery();
        query.setIsExecutionClone(true);
        query.setReferenceClass(domainClass);
        return (Vector)this.executeQuery(query);
    }

    public Vector readAllObjects(Class domainClass, String sqlString) throws DatabaseException {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(domainClass);
        query.setSQLString(sqlString);
        query.setIsExecutionClone(true);
        return (Vector)this.executeQuery(query);
    }

    @Override
    public Vector readAllObjects(Class referenceClass, Call aCall) throws DatabaseException {
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(referenceClass);
        raq.setCall(aCall);
        raq.setIsExecutionClone(true);
        return (Vector)this.executeQuery(raq);
    }

    @Override
    public Vector readAllObjects(Class domainClass, Expression expression) throws DatabaseException {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(domainClass);
        query.setSelectionCriteria(expression);
        query.setIsExecutionClone(true);
        return (Vector)this.executeQuery(query);
    }

    @Override
    public Object readObject(Class domainClass) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    public Object readObject(Class domainClass, String sqlString) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setSQLString(sqlString);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public Object readObject(Class domainClass, Call aCall) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setCall(aCall);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public Object readObject(Class domainClass, Expression expression) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(domainClass);
        query.setSelectionCriteria(expression);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public Object readObject(Object object) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject(object);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    public Object refreshAndLockObject(Object object) throws DatabaseException {
        return this.refreshAndLockObject(object, (short)1);
    }

    public Object refreshAndLockObject(Object object, short lockMode) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject(object);
        query.refreshIdentityMapResult();
        query.cascadePrivateParts();
        query.setLockMode(lockMode);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public Object refreshObject(Object object) throws DatabaseException {
        return this.refreshAndLockObject(object, (short)0);
    }

    @Override
    public void release() {
    }

    public void releaseUnitOfWork(UnitOfWorkImpl unitOfWork) {
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() - 1);
    }

    @Override
    public void removeProperty(String property) {
        this.getProperties().remove(property);
    }

    @Override
    public void removeQuery(String queryName) {
        this.getQueries().remove(queryName);
    }

    public void removeQuery(String queryName, Vector argumentTypes) {
        Vector queries = (Vector)this.getQueries().get(queryName);
        if (queries == null) {
            return;
        }
        DatabaseQuery query = null;
        Enumeration enumtr = queries.elements();
        while (enumtr.hasMoreElements()) {
            query = (DatabaseQuery)enumtr.nextElement();
            if (Helper.areTypesAssignable(argumentTypes, query.getArgumentTypes())) break;
        }
        if (query != null) {
            queries.remove(query);
        }
    }

    protected boolean rollbackExternalTransaction() {
        boolean externalTransactionHasRolledBack = false;
        if (this.hasExternalTransactionController() && this.wasJTSTransactionInternallyStarted()) {
            try {
                this.getExternalTransactionController().rollbackTransaction(this);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
            if (!this.wasJTSTransactionInternallyStarted()) {
                externalTransactionHasRolledBack = true;
                this.log(2, "transaction", "external_transaction_has_rolled_back_internally");
            }
        }
        return externalTransactionHasRolledBack;
    }

    public void rollbackTransaction() throws DatabaseException, ConcurrencyException {
        ConcurrencyManager mutex = this.getTransactionMutex();
        try {
            if (!mutex.isNested()) {
                if (this.eventManager != null) {
                    this.eventManager.preRollbackTransaction();
                }
                this.basicRollbackTransaction();
                if (this.eventManager != null) {
                    this.eventManager.postRollbackTransaction();
                }
            }
        }
        finally {
            mutex.release();
            if (!mutex.isAcquired()) {
                this.rollbackExternalTransaction();
            }
        }
    }

    public void setAccessor(Accessor accessor) {
        this.accessors = new ArrayList<Accessor>(1);
        this.accessors.add(accessor);
    }

    public void setBroker(AbstractSession broker) {
        this.broker = broker;
    }

    public void setCommitManager(CommitManager commitManager) {
        this.commitManager = commitManager;
    }

    public void setEntityListenerInjectionManager(EntityListenerInjectionManager entityListenerInjectionManager) {
        this.entityListenerInjectionManager = entityListenerInjectionManager;
    }

    public void setEventManager(SessionEventManager eventManager) {
        this.eventManager = eventManager;
        if (eventManager != null) {
            this.eventManager.setSession(this);
        }
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void setExternalTransactionController(ExternalTransactionController externalTransactionController) {
        this.externalTransactionController = externalTransactionController;
        if (externalTransactionController == null) {
            return;
        }
        if (!this.hasBroker()) {
            externalTransactionController.setSession(this);
        }
    }

    @Override
    public void setIntegrityChecker(IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
    }

    public void setJPAQueriesProcessed(boolean jpaQueriesProcessed) {
        this.jpaQueriesProcessed = jpaQueriesProcessed;
    }

    @Override
    public void setLog(Writer log) {
        this.getSessionLog().setWriter(log);
    }

    public void setLogin(DatabaseLogin login) {
        this.setDatasourceLogin(login);
    }

    public void setLogin(Login login) {
        this.setDatasourceLogin(login);
    }

    public void setDatasourceLogin(Login login) {
        this.getProject().setDatasourceLogin(login);
        this.platform = null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected void setNumberOfActiveUnitsOfWork(int numberOfActiveUnitsOfWork) {
        this.numberOfActiveUnitsOfWork = numberOfActiveUnitsOfWork;
    }

    public void setPessimisticLockTimeoutDefault(Integer pessimisticLockTimeoutDefault) {
        this.pessimisticLockTimeoutDefault = pessimisticLockTimeoutDefault;
    }

    public void setPessimisticLockTimeoutUnitDefault(TimeUnit pessimisticLockTimeoutUnitDefault) {
        this.pessimisticLockTimeoutUnitDefault = pessimisticLockTimeoutUnitDefault;
    }

    @Override
    public void setQueryTimeoutDefault(int queryTimeoutDefault) {
        this.queryTimeoutDefault = queryTimeoutDefault;
    }

    @Override
    public void setQueryTimeoutUnitDefault(TimeUnit queryTimeoutUnitDefault) {
        this.queryTimeoutUnitDefault = queryTimeoutUnitDefault;
    }

    @Override
    public void setProfiler(SessionProfiler profiler) {
        this.profiler = profiler;
        if (profiler != null) {
            profiler.setSession(this);
            this.setIsInProfile(this.getProfiler().getProfileWeight() != 0);
            this.getIdentityMapAccessorInstance().getIdentityMapManager().checkIsCacheAccessPreCheckRequired();
        } else {
            this.setIsInProfile(false);
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setProperties(Map<Object, Object> propertiesMap) {
        if (propertiesMap == null) {
            this.properties = propertiesMap;
        } else {
            this.properties = new HashMap<Object, Object>();
            this.properties.putAll(propertiesMap);
        }
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        this.getProperties().put(propertyName, propertyValue);
    }

    public void setQueries(Map<String, List<DatabaseQuery>> queries) {
        this.queries = queries;
    }

    @Override
    public void setSessionLog(SessionLog sessionLog) {
        this.isLoggingOff = false;
        this.sessionLog = sessionLog;
        if (sessionLog != null && sessionLog.getSession() == null) {
            sessionLog.setSession(this);
        }
    }

    public void setSynchronized(boolean synched) {
        this.isSynchronized = synched;
    }

    protected void setTransactionMutex(ConcurrencyManager transactionMutex) {
        this.transactionMutex = transactionMutex;
    }

    public void setWasJTSTransactionInternallyStarted(boolean wasJTSTransactionInternallyStarted) {
        this.wasJTSTransactionInternallyStarted = wasJTSTransactionInternallyStarted;
    }

    @Override
    public boolean shouldLogMessages() {
        if (this.isLoggingOff) {
            return false;
        }
        return this.getLogLevel(null) != 8;
    }

    @Override
    public void startOperationProfile(String operationName) {
        if (this.isInProfile) {
            this.getProfiler().startOperationProfile(operationName);
        }
    }

    public void startOperationProfile(String operationName, DatabaseQuery query, int weight) {
        if (this.isInProfile) {
            this.getProfiler().startOperationProfile(operationName, query, weight);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(String.valueOf(this.getSessionTypeString()) + "(" + Helper.cr() + "\t" + this.getAccessor() + Helper.cr() + "\t" + this.getDatasourcePlatform() + ")");
        return writer.toString();
    }

    public Object unwrapObject(Object proxy) {
        return this.getDescriptor(proxy).getObjectBuilder().unwrapObject(proxy, this);
    }

    public Object updateObject(Object domainObject) throws DatabaseException, OptimisticLockException {
        UpdateObjectQuery query = new UpdateObjectQuery();
        query.setObject(domainObject);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    @Override
    public void validateCache() {
        this.getIdentityMapAccessorInstance().validateCache();
    }

    public void validateQuery(DatabaseQuery query) {
    }

    public boolean verifyDelete(Object domainObject) {
        ObjectBuilder builder = this.getDescriptor(domainObject).getObjectBuilder();
        Object implementation = builder.unwrapObject(domainObject, this);
        return builder.verifyDelete(implementation, this);
    }

    public boolean wasJTSTransactionInternallyStarted() {
        return this.wasJTSTransactionInternallyStarted;
    }

    public Object wrapObject(Object implementation) {
        return this.getDescriptor(implementation).getObjectBuilder().wrapObject(implementation, this);
    }

    protected void writeAllObjectsWithChangeSet(UnitOfWorkChangeSet uowChangeSet) throws DatabaseException, OptimisticLockException {
        this.getCommitManager().commitAllObjectsWithChangeSet(uowChangeSet);
    }

    public Object writeObject(Object domainObject) throws DatabaseException, OptimisticLockException {
        WriteObjectQuery query = new WriteObjectQuery();
        query.setObject(domainObject);
        query.setIsExecutionClone(true);
        return this.executeQuery(query);
    }

    public void writesCompleted() {
        if (this.getAccessors() == null) {
            return;
        }
        for (Accessor accessor : this.getAccessors()) {
            accessor.writesCompleted(this);
        }
    }

    @Override
    public void processCommand(Object command) {
        ((Command)command).executeWithSession(this);
    }

    public void processJPAQueries() {
        if (!this.jpaQueriesProcessed) {
            for (DatabaseQuery jpaQuery : this.getJPAQueries()) {
                this.processJPAQuery(jpaQuery);
            }
            for (DatabaseQuery jpaQuery : this.getJPATablePerTenantQueries()) {
                boolean processQuery = true;
                for (ClassDescriptor descriptor : jpaQuery.getDescriptors()) {
                    if (descriptor.isFullyInitialized()) continue;
                    processQuery = false;
                    break;
                }
                if (processQuery) {
                    this.processJPAQuery(jpaQuery);
                    continue;
                }
                this.addTablePerTenantQuery(jpaQuery);
            }
            this.jpaQueriesProcessed = true;
        }
    }

    protected void processJPAQuery(DatabaseQuery jpaQuery) {
        block2: {
            try {
                jpaQuery.prepareInternal(this);
            }
            catch (RuntimeException re) {
                if (this.tolerateInvalidJPQL) break block2;
                throw re;
            }
        }
        DatabaseQuery databaseQuery = (DatabaseQuery)jpaQuery.getProperty("databasequery");
        databaseQuery = databaseQuery == null ? jpaQuery : databaseQuery;
        this.addQuery(databaseQuery, false);
    }

    @Override
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public void setCommandManager(CommandManager mgr) {
        this.commandManager = mgr;
    }

    public boolean shouldPropagateChanges() {
        return this.shouldPropagateChanges;
    }

    public void setShouldPropagateChanges(boolean choice) {
        this.shouldPropagateChanges = choice;
    }

    @Override
    public boolean shouldLogMessages(int logLevel) {
        if (this.isLoggingOff) {
            return false;
        }
        if (1 == logLevel) {
            return this.getLogLevel("propagation") <= 7;
        }
        if (2 == logLevel) {
            return this.getLogLevel("propagation") <= 6;
        }
        if (3 == logLevel) {
            return this.getLogLevel("propagation") <= 2;
        }
        if (4 == logLevel) {
            return this.getLogLevel("propagation") <= 1;
        }
        return false;
    }

    @Override
    public void logMessage(int logLevel, String message) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLogMessages(logLevel)) {
            int level;
            switch (logLevel) {
                case 1: {
                    level = 7;
                    break;
                }
                case 2: {
                    level = 6;
                    break;
                }
                case 3: {
                    level = 2;
                    break;
                }
                case 4: {
                    level = 1;
                    break;
                }
                default: {
                    level = 0;
                }
            }
            this.log(level, "propagation", message, null, null, false);
        }
    }

    @Override
    public int getLogLevel(String category) {
        return this.getSessionLog().getLevel(category);
    }

    @Override
    public int getLogLevel() {
        return this.getSessionLog().getLevel();
    }

    @Override
    public void setLogLevel(int level) {
        this.isLoggingOff = false;
        this.getSessionLog().setLevel(level);
    }

    public boolean shouldDisplayData() {
        return this.getSessionLog().shouldDisplayData();
    }

    @Override
    public boolean shouldLog(int Level2, String category) {
        if (this.isLoggingOff) {
            return false;
        }
        return this.getSessionLog().shouldLog(Level2, category);
    }

    public void log(int level, String category, String message) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, null);
    }

    public void log(int level, String category, String message, Object param) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, new Object[]{param});
    }

    public void log(int level, String category, String message, Object param1, Object param2) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, new Object[]{param1, param2});
    }

    public void log(int level, String category, String message, Object param1, Object param2, Object param3) {
        if (this.isLoggingOff) {
            return;
        }
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, new Object[]{param1, param2, param3});
    }

    public void log(int level, String category, String message, Object[] params) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(level, category, message, params, null);
    }

    public void log(int level, String category, String message, Object[] params, Accessor accessor) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(level, category, message, params, accessor, true);
    }

    public void log(int level, String category, String message, Object[] params, Accessor accessor, boolean shouldTranslate) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(level, category)) {
            this.startOperationProfile("Timer:Logging");
            this.log(new SessionLogEntry(level, category, this, message, params, accessor, shouldTranslate));
            this.endOperationProfile("Timer:Logging");
        }
    }

    @Deprecated
    public void log(int level, String message, Object[] params, Accessor accessor) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(level, message, params, accessor, true);
    }

    @Deprecated
    public void log(int level, String message, Object[] params, Accessor accessor, boolean shouldTranslate) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(level, null)) {
            this.startOperationProfile("Timer:Logging");
            this.log(new SessionLogEntry(level, this, message, params, accessor, shouldTranslate));
            this.endOperationProfile("Timer:Logging");
        }
    }

    public void logThrowable(int level, String category, Throwable throwable) {
        if (this.isLoggingOff) {
            return;
        }
        if (this.shouldLog(level, category)) {
            this.startOperationProfile("Timer:Logging");
            this.log(new SessionLogEntry(this, level, category, throwable));
            this.endOperationProfile("Timer:Logging");
        }
    }

    public void severe(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(7, category, message);
    }

    public void warning(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(6, category, message);
    }

    public void info(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(5, category, message);
    }

    public void config(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(4, category, message);
    }

    public void fine(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(3, category, message);
    }

    public void finer(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(2, category, message);
    }

    public void finest(String message, String category) {
        if (this.isLoggingOff) {
            return;
        }
        this.log(1, category, message);
    }

    @Override
    public Object handleSevere(RuntimeException exception) throws RuntimeException {
        this.logThrowable(7, null, exception);
        if (this.hasExceptionHandler()) {
            return this.getExceptionHandler().handleException(exception);
        }
        throw exception;
    }

    public void releaseReadConnection(Accessor connection) {
    }

    public void copyDescriptorsFromProject() {
        this.descriptors = this.getDescriptors();
    }

    public void copyDescriptorNamedQueries(boolean allowSameQueryNameDiffArgsCopyToSession) {
        for (ClassDescriptor descriptor : this.getProject().getOrderedDescriptors()) {
            Map<String, List<DatabaseQuery>> queries = descriptor.getQueryManager().getQueries();
            if (queries == null || queries.size() <= 0) continue;
            for (Map.Entry<String, List<DatabaseQuery>> entry : queries.entrySet()) {
                Vector thisQueries = (Vector)entry.getValue();
                if (thisQueries == null || thisQueries.size() <= 0) continue;
                for (DatabaseQuery queryToBeAdded : thisQueries) {
                    if (allowSameQueryNameDiffArgsCopyToSession) {
                        this.addQuery(queryToBeAdded, false);
                        continue;
                    }
                    if (this.getQuery(queryToBeAdded.getName()) == null) {
                        this.addQuery(queryToBeAdded, false);
                        continue;
                    }
                    this.log(6, "properties", "descriptor_named_query_cannot_be_added", new Object[]{queryToBeAdded, queryToBeAdded.getName(), queryToBeAdded.getArgumentTypes()});
                }
            }
        }
    }

    public void postAcquireConnection(Accessor accessor) {
        if (this.getProject().hasVPDIdentifier(this)) {
            if (this.getPlatform().supportsVPD()) {
                DatabaseQuery query = this.getPlatform().getVPDSetIdentifierQuery(this.getProject().getVPDIdentifier());
                ArrayList<Object> argValues = new ArrayList<Object>();
                query.addArgument(this.getProject().getVPDIdentifier());
                argValues.add(this.getProperty(this.getProject().getVPDIdentifier()));
                this.executeQuery(query, argValues);
            } else {
                throw ValidationException.vpdNotSupported(this.getPlatform().getClass().getName());
            }
        }
        if (this.eventManager != null) {
            this.eventManager.postAcquireConnection(accessor);
        }
    }

    public void preReleaseConnection(Accessor accessor) {
        if (this.getProject().hasVPDIdentifier(this)) {
            if (this.getPlatform().supportsVPD()) {
                DatabaseQuery query = this.getPlatform().getVPDClearIdentifierQuery(this.getProject().getVPDIdentifier());
                ArrayList<Object> argValues = new ArrayList<Object>();
                query.addArgument(this.getProject().getVPDIdentifier());
                argValues.add(this.getProperty(this.getProject().getVPDIdentifier()));
                this.executeQuery(query, argValues);
            } else {
                throw ValidationException.vpdNotSupported(this.getPlatform().getClass().getName());
            }
        }
        if (this.eventManager != null) {
            this.eventManager.preReleaseConnection(accessor);
        }
    }

    public int priviledgedExecuteNonSelectingCall(Call call) throws DatabaseException {
        DataModifyQuery query = new DataModifyQuery();
        query.setAllowNativeSQLQuery(true);
        query.setIsExecutionClone(true);
        query.setCall(call);
        Integer value = (Integer)this.executeQuery(query);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public Vector priviledgedExecuteSelectingCall(Call call) throws DatabaseException {
        DataReadQuery query = new DataReadQuery();
        query.setAllowNativeSQLQuery(true);
        query.setCall(call);
        query.setIsExecutionClone(true);
        return (Vector)this.executeQuery(query);
    }

    public boolean isExclusiveConnectionRequired() {
        return false;
    }

    @Override
    public ReferenceMode getDefaultReferenceMode() {
        return this.defaultReferenceMode;
    }

    @Override
    public void setDefaultReferenceMode(ReferenceMode defaultReferenceMode) {
        this.defaultReferenceMode = defaultReferenceMode;
    }

    public void load(Object objectOrCollection, AttributeGroup group) {
        if (objectOrCollection == null || group == null) {
            return;
        }
        if (objectOrCollection instanceof Collection) {
            for (Object object : (Collection)objectOrCollection) {
                this.load(object, group, this.getClassDescriptor(object.getClass()), false);
            }
        } else {
            ClassDescriptor concreteDescriptor = this.getClassDescriptor(objectOrCollection.getClass());
            this.load(objectOrCollection, group, concreteDescriptor, false);
        }
    }

    public void load(Object objectOrCollection, AttributeGroup group, ClassDescriptor referenceDescriptor, boolean fromFetchGroup) {
        if (objectOrCollection == null || group == null) {
            return;
        }
        if (objectOrCollection instanceof Collection) {
            Iterator iterator = ((Collection)objectOrCollection).iterator();
            while (iterator.hasNext()) {
                this.load(iterator.next(), group, referenceDescriptor, fromFetchGroup);
            }
        } else {
            ClassDescriptor concreteDescriptor = referenceDescriptor;
            if (concreteDescriptor.hasInheritance() && !objectOrCollection.getClass().equals(concreteDescriptor.getJavaClass())) {
                concreteDescriptor = concreteDescriptor.getInheritancePolicy().getDescriptor(objectOrCollection.getClass());
            }
            AttributeGroup concreteGroup = group.findGroup(concreteDescriptor);
            concreteDescriptor.getObjectBuilder().load(objectOrCollection, concreteGroup, this, fromFetchGroup);
        }
    }

    public CacheKey retrieveCacheKey(Object primaryKey, ClassDescriptor concreteDescriptor, JoinedAttributeManager joinManager, ObjectBuildingQuery query) {
        CacheKey cacheKey;
        if (query.requiresDeferredLocks()) {
            cacheKey = this.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor, query.isCacheCheckComplete() || query.shouldRetrieveBypassCache());
            if (cacheKey.getActiveThread() != Thread.currentThread()) {
                int counter = 0;
                while (cacheKey.getObject() == null && counter < 1000) {
                    cacheKey.releaseDeferredLock();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    cacheKey = this.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor, query.isCacheCheckComplete() || query.shouldRetrieveBypassCache());
                    if (cacheKey.getActiveThread() == Thread.currentThread()) break;
                    ++counter;
                }
                if (counter == 1000) {
                    throw ConcurrencyException.maxTriesLockOnBuildObjectExceded(cacheKey.getActiveThread(), Thread.currentThread());
                }
            }
        } else {
            cacheKey = this.getIdentityMapAccessorInstance().acquireLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor, query.isCacheCheckComplete() || query.shouldRetrieveBypassCache());
        }
        return cacheKey;
    }

    @Override
    public PartitioningPolicy getPartitioningPolicy() {
        return this.partitioningPolicy;
    }

    @Override
    public void setPartitioningPolicy(PartitioningPolicy partitioningPolicy) {
        this.partitioningPolicy = partitioningPolicy;
    }

    public MetadataRefreshListener getRefreshMetadataListener() {
        return this.metadatalistener;
    }

    public void setRefreshMetadataListener(MetadataRefreshListener metadatalistener) {
        this.metadatalistener = metadatalistener;
    }

    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    public void setIsConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    public void setShouldOptimizeResultSetAccess(boolean shouldOptimizeResultSetAccess) {
        this.shouldOptimizeResultSetAccess = shouldOptimizeResultSetAccess;
    }

    public boolean shouldOptimizeResultSetAccess() {
        return this.shouldOptimizeResultSetAccess;
    }

    public void setTolerateInvalidJPQL(boolean b) {
        this.tolerateInvalidJPQL = b;
    }

    public boolean shouldTolerateInvalidJPQL() {
        return this.tolerateInvalidJPQL;
    }
}

