/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.wim.ConfigManager;
import com.ibm.ws.security.wim.Repository;
import com.ibm.ws.security.wim.RepositoryWrapper;
import com.ibm.ws.security.wim.adapter.urbridge.URBridge;
import com.ibm.wsspi.security.wim.exception.InitializationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class UserRegistryWrapper
implements RepositoryWrapper {
    private static final String BASE_ENTRY = "registryBaseEntry";
    private static final String KEY_REGISTRY = "userRegistry";
    private final Map<String, String> baseEntries;
    private final String baseEntry;
    private final URBridge urBridge;
    static final long serialVersionUID = 8490360960763578801L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public UserRegistryWrapper(UserRegistry ur, ConfigManager configManager) throws InitializationException {
        String realm = ur.getRealm();
        this.baseEntry = "o=" + realm;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(KEY_REGISTRY, ur);
        properties.put("config.id", realm);
        properties.put(BASE_ENTRY, this.baseEntry);
        this.baseEntries = Collections.singletonMap(this.baseEntry, realm);
        this.urBridge = new URBridge(properties, ur, configManager);
    }

    @Override
    public void clear() {
    }

    @Override
    public Repository getRepository() {
        return this.urBridge;
    }

    @Override
    public Map<String, String> getRepositoryBaseEntries() {
        return this.baseEntries;
    }

    @Override
    public Set<String> getRepositoryGroups() {
        return Collections.singleton(this.urBridge.getRealm());
    }

    @Override
    public int isUniqueNameForRepository(String uniqueName, boolean isDn) {
        if (this.baseEntry.equals(uniqueName)) {
            return Integer.MAX_VALUE;
        }
        if (this.urBridge.isEntityInRealm(uniqueName)) {
            return 0;
        }
        return -1;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(UserRegistryWrapper.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
    }
}

