/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.urbridge;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.registry.CertificateMapFailedException;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.CustomRegistryException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.NotImplementedException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.wim.ConfigManager;
import com.ibm.ws.security.wim.Repository;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntity;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntityFactory;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeHelper;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeXPathHelper;
import com.ibm.ws.security.wim.util.ControlsHelper;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.InitializationException;
import com.ibm.wsspi.security.wim.exception.PasswordCheckFailedException;
import com.ibm.wsspi.security.wim.exception.SearchControlException;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Control;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.GroupMemberControl;
import com.ibm.wsspi.security.wim.model.GroupMembershipControl;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.LoginAccount;
import com.ibm.wsspi.security.wim.model.LoginControl;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.PropertyControl;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class URBridge
implements Repository {
    private UserRegistry userRegistry = null;
    private static final String KEY_ID = "config.id";
    private String reposId = null;
    private Map<String, String> attrMap = null;
    private Map<String, String> customPropertyMap = null;
    private Map<String, String> propsMap = null;
    private String baseEntryName = null;
    private static final TraceComponent tc = Tr.register(URBridge.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
    private static final String BASE_ENTRY = "registryBaseEntry";
    static final String BASE_ENTRY_NAME = "name";
    public static final String SPI_PREFIX = "WIM_SPI ";
    private static final String SAFRegistryImplClass = "com.ibm.ws.security.registry.saf.internal.SAFDelegatingUserRegistry";
    private String personAccountType = null;
    private String groupAccountType = null;
    private HashMap<String, String> entityConfigMap = null;
    private ConfigManager configManager = null;
    private static List<String> defaultSupportedEntities = null;
    private static Map<String, String[]> defaultRDNProperties = null;
    static final long serialVersionUID = 2588147827132388695L;

    private static void initializeSupportedEntities() {
        defaultSupportedEntities = new ArrayList<String>(2);
        defaultSupportedEntities.add("PersonAccount");
        defaultSupportedEntities.add("Group");
    }

    private static void initializeRDNProperties() {
        defaultRDNProperties = new HashMap<String, String[]>();
        String[] personRDN = new String[]{"uid"};
        String[] groupRDN = new String[]{"cn"};
        defaultRDNProperties.put("PersonAccount", personRDN);
        defaultRDNProperties.put("Group", groupRDN);
    }

    /*
     * WARNING - void declaration
     */
    public URBridge(Map<String, Object> configProps, UserRegistry ur, ConfigManager configMgr) throws InitializationException {
        this.reposId = (String)configProps.get(KEY_ID);
        this.userRegistry = ur;
        this.configManager = configMgr;
        if (defaultSupportedEntities == null) {
            URBridge.initializeSupportedEntities();
        }
        if (defaultRDNProperties == null) {
            URBridge.initializeRDNProperties();
        }
        try {
            this.initialize(configProps);
        }
        catch (WIMException wIMException) {
            void e;
            FFDCFilter.processException((Throwable)wIMException, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"197", (Object)this, (Object[])new Object[]{configProps, ur, configMgr});
            throw new InitializationException((Throwable)e);
        }
    }

    private void setMapping() {
        this.attrMap = new HashMap<String, String>(6);
        this.attrMap.put("groupSecurityNameProperty", this.customPropertyMap.get("groupSecurityNameProperty") == null ? "uniqueName" : this.customPropertyMap.get("groupSecurityNameProperty"));
        this.attrMap.put("groupDisplayNameProperty", this.customPropertyMap.get("groupDisplayNameProperty") == null ? "displayName" : this.customPropertyMap.get("groupDisplayNameProperty"));
        this.attrMap.put("uniqueGroupIdProperty", this.customPropertyMap.get("uniqueGroupIdProperty") == null ? "uniqueId" : this.customPropertyMap.get("uniqueGroupIdProperty"));
        this.attrMap.put("userDisplayNameProperty", this.customPropertyMap.get("userDisplayNameProperty") == null ? "displayName" : this.customPropertyMap.get("userDisplayNameProperty"));
        this.attrMap.put("userSecurityNameProperty", this.customPropertyMap.get("userSecurityNameProperty") == null ? "uniqueName" : this.customPropertyMap.get("userSecurityNameProperty"));
        this.attrMap.put("uniqueUserIdProperty", this.customPropertyMap.get("uniqueUserIdProperty") == null ? "uniqueId" : this.customPropertyMap.get("uniqueUserIdProperty"));
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(Map<String, Object> configProps) throws WIMException {
        try {
            this.reposId = (String)configProps.get(KEY_ID);
            this.setCustomProperties((List)configProps.get("CustomProperties"));
            this.setMapping();
            this.setBaseEntry(configProps);
            this.setConfigEntityMapping(configProps);
            this.propsMap = new HashMap<String, String>();
            this.propsMap.putAll(this.attrMap);
            this.propsMap.putAll(this.customPropertyMap);
            URBridgeHelper.mapSupportedEntityTypeList(this.getSupportedEntityTypes());
            this.personAccountType = URBridgeHelper.getPersonAccountType();
            this.groupAccountType = URBridgeHelper.getGroupAccountType();
        }
        catch (Throwable throwable) {
            void th;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"279", (Object)this, (Object[])new Object[]{configProps});
            throw new InitializationException("REPOSITORY_INITIALIZATION_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"REPOSITORY_INITIALIZATION_FAILED", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId, (Object)th.toString())));
        }
    }

    private void setBaseEntry(Map<String, Object> configProps) throws WIMException {
        this.baseEntryName = (String)configProps.get(BASE_ENTRY);
        if (this.baseEntryName == null) {
            throw new WIMApplicationException("MISSING_BASE_ENTRY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_BASE_ENTRY", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId)));
        }
    }

    private void setCustomProperties(List<Map<String, String>> propList) throws WIMException {
        String METHODNAME = "setCustomProperties";
        this.customPropertyMap = new HashMap<String, String>();
        if (propList == null) {
            return;
        }
        for (Map<String, String> propMap : propList) {
            String propName = propMap.get(BASE_ENTRY_NAME);
            String propValue = propMap.get("value");
            this.customPropertyMap.put(propName, propValue);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCustomProperties custom properties " + this.customPropertyMap), (Object[])new Object[0]);
        }
    }

    private void setConfigEntityMapping(Map<String, Object> configProps) throws WIMException {
        List<String> entityTypes = this.getSupportedEntityTypes();
        String type = null;
        this.entityConfigMap = new HashMap();
        for (int i = 0; i < entityTypes.size(); ++i) {
            type = entityTypes.get(i);
            String rdnProp = this.getRDNProperties(type) == null ? null : this.getRDNProperties(type)[0];
            this.entityConfigMap.put(type, rdnProp);
        }
        if (this.entityConfigMap.get("LoginAccount") == null && this.entityConfigMap.get(this.personAccountType) != null) {
            this.entityConfigMap.put("LoginAccount", this.entityConfigMap.get(this.personAccountType));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setConfigEntityMapping entityConfigMap:" + this.entityConfigMap), (Object[])new Object[0]);
        }
    }

    private String[] getRDNProperties(String type) {
        String[] rdnProperties = this.configManager.getRDNProperties(type);
        if (rdnProperties == null || rdnProperties.length == 0) {
            rdnProperties = defaultRDNProperties.get(type);
            if (rdnProperties == null || rdnProperties.length == 0) {
                return null;
            }
            return rdnProperties;
        }
        return rdnProperties;
    }

    private List<String> getSupportedEntityTypes() {
        List<String> supportedEntities = this.configManager.getSupportedEntityTypes();
        if (supportedEntities != null && supportedEntities.size() > 0) {
            return supportedEntities;
        }
        return defaultSupportedEntities;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Root get(Root root) throws WIMException {
        Root returnRoot = new Root();
        String uniqueName = null;
        String auditName = null;
        AuditManager auditManager = new AuditManager();
        try {
            List<String> attrList = null;
            List<String> grpMbrAttrs = null;
            List<String> grpMbrshipAttrs = null;
            Map<String, Control> ctrlMap = ControlsHelper.getControlMap(root);
            PropertyControl propertyCtrl = (PropertyControl)ctrlMap.get("PropertyControl");
            GroupMemberControl grpMbrCtrl = (GroupMemberControl)ctrlMap.get("GroupMemberControl");
            GroupMembershipControl grpMbrshipCtrl = (GroupMembershipControl)ctrlMap.get("GroupMembershipControl");
            if (grpMbrCtrl != null) {
                grpMbrAttrs = this.getAttributes((PropertyControl)grpMbrCtrl, this.personAccountType);
            }
            if (grpMbrshipCtrl != null) {
                grpMbrshipAttrs = this.getAttributes((PropertyControl)grpMbrshipCtrl, this.groupAccountType);
            }
            List entities = root.getEntities();
            for (Entity entity : entities) {
                int limit;
                uniqueName = entity.getIdentifier().getUniqueName();
                if (uniqueName == null) {
                    if (entity.getIdentifier().getUniqueId() != null) {
                        auditName = entity.getIdentifier().getUniqueId();
                    } else if (entity.getIdentifier().getExternalName() != null) {
                        auditName = entity.getIdentifier().getExternalName();
                    } else if (entity.getIdentifier().getExternalId() != null) {
                        auditName = entity.getIdentifier().getExternalId();
                    }
                }
                String memberType = this.validateEntity(entity);
                Object returnEntity = null;
                returnEntity = "Group".equalsIgnoreCase(memberType) ? new Group() : new PersonAccount();
                returnRoot.getEntities().add(returnEntity);
                IdentifierType identifier = new IdentifierType();
                identifier.setRepositoryId(this.reposId);
                returnEntity.setIdentifier(identifier);
                URBridgeEntityFactory osEntityFactory = new URBridgeEntityFactory();
                URBridgeEntity osEntity = osEntityFactory.createObject((Entity)returnEntity, this, this.propsMap, this.baseEntryName, this.entityConfigMap);
                osEntity.setSecurityNameProp(uniqueName);
                attrList = this.getAttributes(propertyCtrl, memberType);
                if (attrList != null) {
                    osEntity.populateEntity(attrList);
                }
                if ("Group".equalsIgnoreCase(memberType) && grpMbrCtrl != null && grpMbrAttrs != null) {
                    limit = 0;
                    if (grpMbrCtrl.isSetCountLimit()) {
                        limit = grpMbrCtrl.getCountLimit();
                    }
                    osEntity.getUsersForGroup(grpMbrAttrs, limit);
                    continue;
                }
                if (!"LoginAccount".equalsIgnoreCase(memberType) && !"PersonAccount".equalsIgnoreCase(memberType) || grpMbrshipCtrl == null || grpMbrshipAttrs == null) continue;
                limit = 0;
                if (grpMbrshipCtrl.isSetCountLimit()) {
                    limit = grpMbrshipCtrl.getCountLimit();
                }
                osEntity.getGroupsForUser(grpMbrshipAttrs, limit);
            }
        }
        catch (EntityNotFoundException attrList) {
            void e;
            FFDCFilter.processException((Throwable)attrList, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"480", (Object)this, (Object[])new Object[]{root});
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "get", this.reposId, uniqueName == null ? auditName : uniqueName, this.userRegistry.getRealm(), returnRoot, Integer.valueOf("212"), "urbridge"});
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"488", (Object)this, (Object[])new Object[]{root});
            throw new WIMException((Throwable)e);
        }
        this.setReturnContext(root, returnRoot);
        auditManager.setRealm(this.userRegistry.getRealm());
        if (returnRoot != null && !returnRoot.getEntities().isEmpty()) {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "get", this.reposId, uniqueName, this.userRegistry.getRealm(), returnRoot, Integer.valueOf("200"), "urbridge"});
        }
        return returnRoot;
    }

    public String buildRDN(String value) {
        String rdnProperty = "uid";
        String rdnStyleName = rdnProperty + "=" + value + ",o=" + this.reposId;
        return rdnStyleName;
    }

    private List<String> getAttributes(PropertyControl control, String type) throws WIMException {
        List<String> attrList = new ArrayList<String>(10);
        if (control != null && control.getProperties() != null) {
            attrList = control.getProperties();
        }
        if (attrList.size() > 0 && "*".equals(attrList.get(0))) {
            attrList = this.getAttributes(type);
        }
        attrList.addAll(this.getIdentifierAttributes(type));
        return attrList;
    }

    private List<String> getAttributes(String entityType) throws WIMException {
        String METHODNAME = "getAttributes(entityType)";
        ArrayList<String> attrList = new ArrayList<String>();
        if ("Group".equals(entityType) || Entity.getSubEntityTypes((String)"Group").contains(entityType)) {
            attrList.add(this.entityConfigMap.get(entityType));
            attrList.add(this.attrMap.get("groupDisplayNameProperty"));
        } else if ("LoginAccount".equals(entityType) || Entity.getSubEntityTypes((String)"LoginAccount").contains(entityType)) {
            attrList.add(this.entityConfigMap.get(entityType));
            attrList.add("principalName");
            attrList.add(this.attrMap.get("userDisplayNameProperty"));
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAttributes(entityType) Entity type " + entityType + " is invalid and is ignored."), (Object[])new Object[0]);
        }
        return attrList;
    }

    private List<String> getIdentifierAttributes(String entityType) throws WIMException {
        String METHODNAME = "getIdentifierAttributes";
        ArrayList<String> attrList = new ArrayList<String>();
        if ("Group".equals(entityType) || Entity.getSubEntityTypes((String)"Group").contains(entityType)) {
            attrList.add(this.attrMap.get("uniqueGroupIdProperty"));
            attrList.add(this.attrMap.get("groupSecurityNameProperty"));
        } else if ("LoginAccount".equals(entityType) || Entity.getSubEntityTypes((String)"LoginAccount").contains(entityType)) {
            attrList.add(this.attrMap.get("uniqueUserIdProperty"));
            attrList.add(this.attrMap.get("userSecurityNameProperty"));
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getIdentifierAttributes Entity type " + entityType + " is invalid and is ignored."), (Object[])new Object[0]);
        }
        return attrList;
    }

    private String validateEntity(Entity entity) throws WIMException {
        String METHODNAME = "validateEntity";
        String type = null;
        String secName = null;
        String uniqueId = null;
        String uniqueName = null;
        if (entity.getIdentifier().isSet("uniqueName")) {
            uniqueName = entity.getIdentifier().getUniqueName();
        } else if (entity.getIdentifier().isSet("externalName")) {
            uniqueName = entity.getIdentifier().getExternalName();
        } else if (entity.getIdentifier().isSet("uniqueId")) {
            uniqueId = entity.getIdentifier().getUniqueId();
        } else if (entity.getIdentifier().isSet("externalId")) {
            uniqueId = entity.getIdentifier().getExternalId();
        }
        if (uniqueName != null) {
            secName = uniqueName;
        }
        if (uniqueId != null && uniqueId.trim().length() > 0) {
            if (this.isValidUserOrGroup(uniqueId)) {
                uniqueName = uniqueId;
                secName = uniqueId;
            } else {
                uniqueName = secName = this.getSecNameFromUniqueID(uniqueId);
            }
        }
        if (secName != null && secName.trim().length() > 0) {
            String rdnAttr = this.getRDN(entity.getIdentifier().getUniqueName());
            Set<String> EntityTypes = this.entityConfigMap.keySet();
            ArrayList<String> entities = new ArrayList<String>();
            for (String entityType : EntityTypes) {
                if (rdnAttr != null && !rdnAttr.equalsIgnoreCase(this.entityConfigMap.get(entityType))) continue;
                entities.add(entityType);
            }
            String inputType = entity.getTypeName();
            type = this.getEntityTypeFromUniqueName(secName, entities, inputType);
            entity.getIdentifier().setUniqueName(uniqueName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " The entity type for " + secName + " is " + type), (Object[])new Object[0]);
        }
        if (type == null) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)secName)));
        }
        return type;
    }

    private String getSecNameFromUniqueID(String uniqueId) throws WIMException {
        String METHODNAME = "getSecNameFromUniqueID";
        String secName = null;
        try {
            secName = this.getUserSecurityName(uniqueId);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"650", (Object)this, (Object[])new Object[]{uniqueId});
            try {
                secName = this.getGroupSecurityName(uniqueId);
            }
            catch (EntryNotFoundException entryNotFoundException2) {
                FFDCFilter.processException((Throwable)entryNotFoundException2, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"653", (Object)this, (Object[])new Object[]{uniqueId});
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueId)));
            }
            catch (RegistryException renf) {
                FFDCFilter.processException((Throwable)renf, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"656", (Object)this, (Object[])new Object[]{uniqueId});
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueId)));
            }
        }
        catch (RegistryException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"660", (Object)this, (Object[])new Object[]{uniqueId});
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueId)));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " The Security Name for " + uniqueId + " is " + secName), (Object[])new Object[0]);
        }
        return secName;
    }

    private String getEntityTypeFromUniqueName(String secName, List<String> entityType, String inputType) throws WIMException {
        String METHODNAME = "getEntityTypeFromUniqueName";
        String type = null;
        ArrayList<String> typeList = new ArrayList<String>();
        try {
            boolean noSpecificEntityType = false;
            if (entityType.size() == 0 || entityType.size() > 1) {
                noSpecificEntityType = true;
            }
            if (this.isSafRegistry()) {
                if ((entityType.contains(this.personAccountType) || noSpecificEntityType) && this.userRegistry.isValidUser(secName)) {
                    typeList.add(this.personAccountType);
                }
                if ((entityType.contains(this.groupAccountType) || noSpecificEntityType) && this.userRegistry.isValidGroup(secName)) {
                    typeList.add(this.groupAccountType);
                }
            } else {
                int resultSize;
                if ((entityType.contains(this.personAccountType) || noSpecificEntityType) && (resultSize = this.searchUsers(secName, 1).getList().size()) > 0) {
                    typeList.add(this.personAccountType);
                }
                if ((entityType.contains(this.groupAccountType) || noSpecificEntityType) && (resultSize = this.searchGroups(secName, 1).getList().size()) > 0) {
                    typeList.add(this.groupAccountType);
                }
            }
            if (typeList.size() > 1) {
                for (int i = 0; i < typeList.size(); ++i) {
                    if (!((String)typeList.get(i)).equals(inputType)) continue;
                    type = (String)typeList.get(i);
                    break;
                }
            }
            if (type == null && typeList.size() > 0) {
                type = (String)typeList.get(0);
            }
        }
        catch (RegistryException noSpecificEntityType) {
            FFDCFilter.processException((Throwable)noSpecificEntityType, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"724", (Object)this, (Object[])new Object[]{secName, entityType, inputType});
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)secName)));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " The entity type for " + secName + " is " + type), (Object[])new Object[0]);
        }
        return type;
    }

    private String getRDN(String name) {
        if (name == null) {
            return name;
        }
        int indexOfEqual = name.indexOf(61);
        if (indexOfEqual < 0) {
            return name;
        }
        String rdnValue = name.substring(0, indexOfEqual);
        return rdnValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={EntryNotFoundException.class, RegistryException.class})
    public Root search(Root root) throws WIMException {
        IdentifierType identifier;
        Entity entitee;
        String METHODNAME = "search";
        String uniqueName = null;
        Root returnRoot = new Root();
        AuditManager auditManager = new AuditManager();
        List entitys = root.getEntities();
        if (entitys != null && !entitys.isEmpty() && (entitee = (Entity)entitys.get(0)) != null && (identifier = entitee.getIdentifier()) != null) {
            uniqueName = identifier.getUniqueName();
        }
        try {
            URBridgeEntity osEntity;
            IdentifierType id;
            Object matchDO;
            int j;
            URBridgeEntityFactory osEntityFactory2;
            List<String> returnNames;
            List<String> searchAttrs;
            int i;
            String expression;
            int countLimit = 0;
            Map<String, Control> ctrlMap = ControlsHelper.getControlMap(root);
            SearchControl searchControl = (SearchControl)ctrlMap.get("SearchControl");
            if (searchControl.isSetCountLimit()) {
                countLimit = searchControl.getCountLimit();
            }
            if ((expression = searchControl.getExpression()) == null || expression.trim().length() == 0) {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "search", this.reposId, uniqueName, this.userRegistry.getRealm(), returnRoot, Integer.valueOf("217"), "urbridge"});
                throw new SearchControlException("MISSING_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_SEARCH_EXPRESSION", (Object[])new Object[0]));
            }
            URBridgeXPathHelper xpathHelper = new URBridgeXPathHelper(expression);
            expression = xpathHelper.getExpression();
            boolean returnSubType = searchControl.isReturnSubType();
            List<String> entityTypes = xpathHelper.getEntityTypes();
            HashSet<String> entityTypeSet = new HashSet<String>();
            ArrayList entityTypeList = null;
            if (returnSubType) {
                for (int i2 = 0; i2 < entityTypes.size(); ++i2) {
                    String type = entityTypes.get(i2);
                    HashSet subTypes = Entity.getSubEntityTypes((String)type);
                    entityTypeSet.add(type);
                    if (subTypes == null) continue;
                    entityTypeSet.addAll(subTypes);
                }
            } else {
                entityTypeSet.addAll(entityTypes);
            }
            entityTypeList = new ArrayList(entityTypeSet);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("search entityType List: " + entityTypeList), (Object[])new Object[0]);
            }
            for (i = 0; i < entityTypeList.size(); ++i) {
                String type = (String)entityTypeList.get(i);
                if (!"Group".equalsIgnoreCase(type) && !Entity.getSubEntityTypes((String)"Group").contains(type)) continue;
                searchAttrs = this.getAttributes((PropertyControl)searchControl, type);
                returnNames = new ArrayList<String>();
                if (this.isSafRegistry() && !expression.endsWith("*")) {
                    try {
                        returnNames.add(this.userRegistry.getGroupSecurityName(expression));
                    }
                    catch (EntryNotFoundException entryNotFoundException) {
                    }
                    catch (RegistryException registryException) {}
                } else {
                    if (!expression.contains("*")) {
                        countLimit = 1;
                    }
                    returnNames = this.searchGroups(expression, countLimit).getList();
                }
                if (returnNames.size() <= 0) break;
                osEntityFactory2 = new URBridgeEntityFactory();
                for (j = 0; j < returnNames.size(); ++j) {
                    matchDO = null;
                    matchDO = type.equalsIgnoreCase("PersonAccount") ? new PersonAccount() : new Group();
                    returnRoot.getEntities().add(matchDO);
                    id = new IdentifierType();
                    matchDO.setIdentifier(id);
                    osEntity = osEntityFactory2.createObject((Entity)matchDO, this, this.propsMap, this.baseEntryName, this.entityConfigMap);
                    osEntity.setSecurityNameProp((String)returnNames.get(j));
                    osEntity.populateEntity(searchAttrs);
                    id.setRepositoryId(this.reposId);
                }
                break;
            }
            for (i = 0; i < entityTypeList.size(); ++i) {
                String type = (String)entityTypeList.get(i);
                if (!Entity.getSubEntityTypes((String)"LoginAccount").contains(type)) continue;
                searchAttrs = this.getAttributes((PropertyControl)searchControl, type);
                returnNames = new ArrayList();
                if (this.isSafRegistry() && !expression.endsWith("*")) {
                    try {
                        returnNames.add(this.userRegistry.getUserSecurityName(expression));
                    }
                    catch (EntryNotFoundException osEntityFactory2) {
                    }
                    catch (RegistryException osEntityFactory2) {}
                } else {
                    if (!expression.contains("*")) {
                        countLimit = 1;
                    }
                    returnNames = this.searchUsers(expression, countLimit).getList();
                }
                if (returnNames.size() > 0) {
                    osEntityFactory2 = new URBridgeEntityFactory();
                    if (type.equalsIgnoreCase("LoginAccount")) {
                        type = URBridgeHelper.getPersonAccountType();
                    }
                    for (j = 0; j < returnNames.size(); ++j) {
                        matchDO = new PersonAccount();
                        returnRoot.getEntities().add(matchDO);
                        id = new IdentifierType();
                        matchDO.setIdentifier(id);
                        osEntity = osEntityFactory2.createObject((Entity)matchDO, this, this.propsMap, this.baseEntryName, this.entityConfigMap);
                        osEntity.setSecurityNameProp((String)returnNames.get(j));
                        osEntity.populateEntity(searchAttrs);
                        id.setRepositoryId(this.reposId);
                    }
                }
                break;
            }
        }
        catch (WIMException countLimit) {
            void we;
            FFDCFilter.processException((Throwable)countLimit, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"903", (Object)this, (Object[])new Object[]{root});
            throw we;
        }
        catch (Exception we) {
            void e;
            FFDCFilter.processException((Throwable)we, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"905", (Object)this, (Object[])new Object[]{root});
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "search", this.reposId, uniqueName, this.userRegistry.getRealm(), returnRoot, Integer.valueOf("221"), "urbridge"});
            throw new WIMApplicationException("ENTITY_SEARCH_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_SEARCH_FAILED", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString())));
        }
        if (returnRoot != null && !returnRoot.getEntities().isEmpty()) {
            auditManager.setRealm(this.userRegistry.getRealm());
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "search", this.reposId, uniqueName, this.userRegistry.getRealm(), returnRoot, Integer.valueOf("200"), "urbridge"});
        }
        return returnRoot;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={CertificateMapFailedException.class})
    public Root login(Root root) throws WIMException {
        List entities;
        String METHODNAME = "login";
        Root returnRoot = new Root();
        URBridgeEntityFactory osEntityFactory = new URBridgeEntityFactory();
        List<String> attrList = null;
        Map<String, Control> ctrlMap = ControlsHelper.getControlMap(root);
        LoginControl propertyCtrl = (LoginControl)ctrlMap.get("LoginControl");
        if (propertyCtrl != null) {
            attrList = this.getAttributes((PropertyControl)propertyCtrl, "LoginAccount");
        }
        if ((entities = root.getEntities()).size() > 0) {
            Entity ent = (Entity)entities.get(0);
            String type = ent.getTypeName();
            String securityName = null;
            if ("LoginAccount".equalsIgnoreCase(type) || Entity.getSubEntityTypes((String)"LoginAccount").contains(type)) {
                LoginAccount entity = (LoginAccount)entities.get(0);
                if (entity.isSet("principalName")) {
                    boolean isValidUser;
                    String passwordStr;
                    String pname;
                    block33: {
                        List returnNames;
                        block34: {
                            pname = entity.getPrincipalName();
                            byte[] pwd = entity.getPassword();
                            if (pname == null || pname.trim().length() == 0) {
                                throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_OR_EMPTY_PRINCIPAL_NAME", (Object[])new Object[0]));
                            }
                            if (pwd == null || pwd.length == 0) {
                                throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PASSWORD", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_OR_EMPTY_PASSWORD", (Object[])new Object[0]));
                            }
                            try {
                                passwordStr = new String(pwd, "UTF-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"965", (Object)this, (Object[])new Object[]{root});
                                throw new WIMApplicationException("CUSTOM_REGISTRY_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"CUSTOM_REGISTRY_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId)));
                            }
                            isValidUser = false;
                            if (this.isSafRegistry()) {
                                try {
                                    isValidUser = this.userRegistry.isValidUser(pname);
                                }
                                catch (RegistryException registryException) {
                                    FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"975", (Object)this, (Object[])new Object[]{root});
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"WIM_SPI login", (Object[])new Object[]{" principal, " + pname + ", not found in " + this.reposId});
                                    }
                                    break block33;
                                }
                            }
                            returnNames = null;
                            try {
                                returnNames = this.userRegistry.getUsers(pname, 1).getList();
                            }
                            catch (RegistryException registryException) {
                                FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"985", (Object)this, (Object[])new Object[]{root});
                                if (!tc.isDebugEnabled()) break block34;
                                Tr.debug((TraceComponent)tc, (String)"WIM_SPI login", (Object[])new Object[]{" principal, " + pname + ", not found in " + this.reposId});
                            }
                        }
                        boolean bl = isValidUser = returnNames != null && returnNames.size() > 0;
                    }
                    if (isValidUser) {
                        try {
                            securityName = this.userRegistry.checkPassword(pname, passwordStr);
                        }
                        catch (RegistryException returnNames) {
                            void e;
                            FFDCFilter.processException((Throwable)returnNames, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"995", (Object)this, (Object[])new Object[]{root});
                            throw new WIMException((Throwable)e);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WIM_SPI login principal, " + pname + ", not found in " + this.reposId), (Object[])new Object[0]);
                    }
                } else if (entity.isSet("certificate")) {
                    List certList = entity.getCertificate();
                    int certListSize = certList.size();
                    if (certListSize > 0) {
                        X509Certificate[] certs = new X509Certificate[certListSize];
                        for (int i = 0; i < certs.length; ++i) {
                            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])certList.get(i));
                            try {
                                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                certs[i] = (X509Certificate)cf.generateCertificate(bais);
                                bais.close();
                                continue;
                            }
                            catch (Exception cf) {
                                FFDCFilter.processException((Throwable)cf, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"1015", (Object)this, (Object[])new Object[]{root});
                                throw new WIMApplicationException("CERTIFICATE_GENERATE_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"CERTIFICATE_GENERATE_FAILED", (Object[])new Object[0]));
                            }
                        }
                        try {
                            securityName = this.userRegistry.mapCertificate(certs);
                        }
                        catch (CertificateMapNotSupportedException i) {
                            void e;
                            FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"1021", (Object)this, (Object[])new Object[]{root});
                            throw new com.ibm.wsspi.security.wim.exception.CertificateMapNotSupportedException((Throwable)e);
                        }
                        catch (CertificateMapFailedException e) {
                        }
                        catch (RegistryException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"1025", (Object)this, (Object[])new Object[]{root});
                            throw new WIMException((Throwable)e);
                        }
                    }
                } else {
                    throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_OR_EMPTY_PRINCIPAL_NAME", (Object[])new Object[0]));
                }
                if (securityName != null) {
                    PersonAccount person = new PersonAccount();
                    returnRoot.getEntities().add(person);
                    IdentifierType id = new IdentifierType();
                    person.setIdentifier(id);
                    person.setPrincipalName(securityName);
                    URBridgeEntity osEntity = osEntityFactory.createObject((Entity)person, this, this.attrMap, this.baseEntryName, this.entityConfigMap);
                    osEntity.setSecurityNameProp(securityName);
                    if (attrList != null) {
                        osEntity.populateEntity(attrList);
                    }
                    id.setRepositoryId(this.reposId);
                }
            } else {
                throw new WIMApplicationException("ENTITY_TYPE_NOT_SUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_TYPE_NOT_SUPPORTED", (Object[])WIMMessageHelper.generateMsgParms((Object)type)));
            }
        }
        return returnRoot;
    }

    @FFDCIgnore(value={RegistryException.class})
    private boolean isValidUserOrGroup(String uniqueId) {
        try {
            if (this.userRegistry.isValidUser(uniqueId)) {
                return true;
            }
            return this.userRegistry.isValidGroup(uniqueId);
        }
        catch (RegistryException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to determine if this is a valid User/Group", (Object[])new Object[0]);
            }
            return false;
        }
    }

    @Override
    public String getRealm() {
        return this.userRegistry.getRealm();
    }

    public String getUserSecurityName(String uniqueId) throws EntryNotFoundException, RegistryException {
        return this.userRegistry.getUserSecurityName(uniqueId);
    }

    public String getUniqueUserId(String securityName) throws EntryNotFoundException, RegistryException {
        return this.userRegistry.getUniqueUserId(securityName);
    }

    public String getUserDisplayName(String securityName) throws EntryNotFoundException, RegistryException {
        return this.userRegistry.getUserDisplayName(securityName);
    }

    public String getGroupSecurityName(String uniqueId) throws EntryNotFoundException, RegistryException {
        return this.userRegistry.getGroupSecurityName(uniqueId);
    }

    public String getUniqueGroupId(String securityName) throws EntryNotFoundException, RegistryException {
        return this.userRegistry.getUniqueGroupId(securityName);
    }

    public String getGroupDisplayName(String securityName) throws EntryNotFoundException, RegistryException {
        return this.userRegistry.getGroupDisplayName(securityName);
    }

    private SearchResult searchUsers(String secName, int i) throws RegistryException {
        return this.userRegistry.getUsers(secName, i);
    }

    private SearchResult searchGroups(String secName, int i) throws RegistryException {
        return this.userRegistry.getGroups(secName, i);
    }

    public List<String> getGroupsForUser(String securityName) throws EntryNotFoundException, RegistryException {
        return this.userRegistry.getGroupsForUser(securityName);
    }

    public SearchResult getUsersForGroup(String securityName, int countLimit) throws RemoteException, NotImplementedException, EntryNotFoundException, CustomRegistryException, RegistryException {
        return this.userRegistry.getUsersForGroup(securityName, countLimit);
    }

    private void setReturnContext(Root inRoot, Root returnRoot) {
        if (returnRoot != null && !returnRoot.getEntities().isEmpty()) {
            boolean hasIsURBrigeResult = false;
            if (inRoot != null) {
                List contexts = inRoot.getContexts();
                for (Context contextInput : contexts) {
                    String key = contextInput.getKey();
                    if (key == null || !"isURBridgeResult".equals(key)) continue;
                    hasIsURBrigeResult = true;
                }
            }
            if (hasIsURBrigeResult) {
                Context context = new Context();
                context.setKey("isURBridgeResult");
                context.setValue((Object)"true");
                returnRoot.getContexts().add(context);
            }
        }
    }

    @Override
    public Root delete(Root root) throws WIMException {
        AuditManager auditManager = new AuditManager();
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "delete", auditManager.getRepositoryId(), auditManager.getRepositoryUniqueName(), this.userRegistry.getRealm(), root, Integer.valueOf("209"), "urbridge"});
        throw new WIMApplicationException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", Tr.formatMessage((TraceComponent)tc, (String)"CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId)));
    }

    @Override
    public Root create(Root root) throws WIMException {
        AuditManager auditManager = new AuditManager();
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", auditManager.getRepositoryId(), auditManager.getRepositoryUniqueName(), this.userRegistry.getRealm(), root, Integer.valueOf("209"), "urbridge"});
        throw new WIMApplicationException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", Tr.formatMessage((TraceComponent)tc, (String)"CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId)));
    }

    @Override
    public Root update(Root root) throws WIMException {
        AuditManager auditManager = new AuditManager();
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "update", auditManager.getRepositoryId(), auditManager.getRepositoryUniqueName(), this.userRegistry.getRealm(), root, Integer.valueOf("209"), "urbridge"});
        throw new WIMApplicationException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", Tr.formatMessage((TraceComponent)tc, (String)"CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId)));
    }

    private boolean isURBridgeResult(Root returnRoot) {
        if (returnRoot != null && !returnRoot.getEntities().isEmpty()) {
            List contexts = returnRoot.getContexts();
            for (Context context : contexts) {
                String key = context.getKey();
                if (key == null || !"isURBridgeResult".equals(key) || !"true".equalsIgnoreCase((String)context.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @FFDCIgnore(value={Exception.class})
    public boolean isEntityInRealm(String uniqueName) {
        block11: {
            SearchResult result2;
            if (this.isSafRegistry()) {
                try {
                    return this.userRegistry.isValidUser(uniqueName);
                }
                catch (Exception exception) {
                    try {
                        return this.userRegistry.isValidGroup(uniqueName);
                    }
                    catch (Exception exception2) {
                        break block11;
                    }
                }
            }
            try {
                result2 = this.userRegistry.getUsers(uniqueName, 1);
                if (result2 != null && result2.getList().size() > 0) {
                    return true;
                }
            }
            catch (Exception result2) {
                // empty catch block
            }
            try {
                result2 = this.userRegistry.getGroups(uniqueName, 1);
                if (result2 != null && result2.getList().size() > 0) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @FFDCIgnore(value={Exception.class})
    public List<String> getEntityType(String entity) {
        if (this.isSafRegistry()) {
            try {
                if (this.userRegistry.isValidUser(entity)) {
                    ArrayList<String> returnValue = new ArrayList<String>();
                    returnValue.add("PersonAccount");
                    returnValue.add(this.userRegistry.getUserSecurityName(entity));
                    return returnValue;
                }
            }
            catch (Exception returnValue) {
                // empty catch block
            }
            try {
                if (this.userRegistry.isValidGroup(entity)) {
                    ArrayList<String> returnValue = new ArrayList<String>();
                    returnValue.add("Group");
                    returnValue.add(this.userRegistry.getGroupSecurityName(entity));
                    return returnValue;
                }
            }
            catch (Exception returnValue) {}
        } else {
            Object result2;
            try {
                result2 = this.userRegistry.getUsers(entity, 1);
                if (result2 != null && result2.getList().size() > 0) {
                    ArrayList<String> returnValue = new ArrayList<String>();
                    returnValue.add("PersonAccount");
                    returnValue.add(entity);
                    return returnValue;
                }
            }
            catch (Exception result2) {
                // empty catch block
            }
            try {
                result2 = this.userRegistry.getGroups(entity, 1);
                if (result2 != null && result2.getList().size() > 0) {
                    ArrayList<String> returnValue = new ArrayList<String>();
                    returnValue.add("Group");
                    returnValue.add(entity);
                    return returnValue;
                }
            }
            catch (Exception result3) {
                // empty catch block
            }
            try {
                result2 = this.userRegistry.getUserSecurityName(entity);
                if (result2 != null) {
                    ArrayList<String> returnValue = new ArrayList<String>();
                    returnValue.add("PersonAccount");
                    returnValue.add((String)result2);
                    return returnValue;
                }
            }
            catch (Exception result4) {
                // empty catch block
            }
            try {
                result2 = this.userRegistry.getGroupSecurityName(entity);
                if (result2 != null) {
                    ArrayList<String> returnValue = new ArrayList<String>();
                    returnValue.add("Group");
                    returnValue.add((String)result2);
                    return returnValue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isSafRegistry() {
        return SAFRegistryImplClass.equalsIgnoreCase(this.userRegistry.getClass().getName());
    }
}

