/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileUtils {
    static final long serialVersionUID = 3645464030492067561L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean fileIsFile(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -9125000907267770650L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.isFile();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean fileIsDirectory(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 4507998829986060038L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.isDirectory();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static synchronized boolean fileExists(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 147847712244709535L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.exists();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long fileLength(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            long l = AccessController.doPrivileged(new PrivilegedAction<Long>(){
                static final long serialVersionUID = 7748691803771689518L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Long run() {
                    return target.length();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return l;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static File[] listFiles(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            File[] fileArray = AccessController.doPrivileged(new PrivilegedAction<File[]>(){
                static final long serialVersionUID = 1931397079026076501L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public File[] run() {
                    return target.listFiles();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(5.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return fileArray;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static String[] list(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            String[] stringArray = AccessController.doPrivileged(new PrivilegedAction<String[]>(){
                static final long serialVersionUID = -8155626404282928600L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String[] run() {
                    return target.list();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(6.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return stringArray;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getInputStream(final File target) throws FileNotFoundException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            InputStream inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){
                static final long serialVersionUID = 3188625175753228201L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public InputStream run() throws FileNotFoundException {
                    return new FileInputStream(target);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(7.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return inputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.kernel.service.utils.FileUtils", (String)"171", null, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof FileNotFoundException) {
                throw (FileNotFoundException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static FileOutputStream getFileOutputStream(final File target) throws FileNotFoundException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            FileOutputStream fileOutputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){
                static final long serialVersionUID = -315265157990717776L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(target);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(8.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return fileOutputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.kernel.service.utils.FileUtils", (String)"195", null, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof FileNotFoundException) {
                throw (FileNotFoundException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long fileLastModified(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            long l = AccessController.doPrivileged(new PrivilegedAction<Long>(){
                static final long serialVersionUID = -7793335905333239495L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Long run() {
                    return target.lastModified();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(9.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return l;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean fileCanRead(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -304436447824986957L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.canRead();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(10.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean fileCanWrite(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 1846788298802000561L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.canWrite();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(11.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static synchronized boolean fileMkDirs(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -1233678982350089542L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.mkdirs();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(12.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean fileDelete(final File file) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 4208713978911657518L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return file.delete();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(13.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean ensureDirExists(File dir) {
        return FileUtils.fileMkDirs(dir) || FileUtils.fileExists(dir);
    }

    public static boolean tryToClose(Closeable closeable) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            if (closeable != null) {
                try {
                    closeable.close();
                    boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.kernel.service.utils.FileUtils", (String)"335", null, (Object[])new Object[]{closeable});
                }
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return false;
    }

    public static boolean setUserReadWriteOnly(File file) {
        return AccessController.doPrivileged(new SetFilePermsAction(file));
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean fileCreate(final File target) throws IOException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            Boolean bl = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = 8955403724970473749L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() throws IOException {
                    return target.createNewFile();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(14.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                }
            });
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.kernel.service.utils.FileUtils", (String)"394", null, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FileUtils.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SetFilePermsAction
    implements PrivilegedAction<Boolean> {
        private final File file;
        static final long serialVersionUID = 868083811396583507L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SetFilePermsAction(File file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            this.file.setReadable(false, false);
            this.file.setWritable(false, false);
            this.file.setExecutable(false, false);
            this.file.setReadable(true, true);
            this.file.setWritable(true, true);
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SetFilePermsAction.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }
}

