/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class IllegalXmlCharacterFilterWriter
extends FilterWriter {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final char BLANK_CHAR = ' ';

    public IllegalXmlCharacterFilterWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        if (IllegalXmlCharacterFilterWriter.isInvalidChar((char)c)) {
            super.write(32);
        } else {
            super.write(c);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        super.write(IllegalXmlCharacterFilterWriter.encodeCharArray(cbuf, off, len), off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        super.write(IllegalXmlCharacterFilterWriter.encodeString(str, off, len), off, len);
    }

    private static String encodeString(String str, int off, int len) {
        if (str == null) {
            return null;
        }
        boolean containsInvalidChar = false;
        char[] encodedCharArray = EMPTY_CHAR_ARRAY;
        int to = off + len;
        for (int i = off; i < to; ++i) {
            if (!IllegalXmlCharacterFilterWriter.isInvalidChar(str.charAt(i))) continue;
            if (!containsInvalidChar) {
                containsInvalidChar = true;
                encodedCharArray = str.toCharArray();
            }
            encodedCharArray[i] = 32;
        }
        if (containsInvalidChar) {
            return String.valueOf(encodedCharArray);
        }
        return str;
    }

    private static char[] encodeCharArray(char[] cbuf, int off, int len) {
        if (cbuf == null) {
            return null;
        }
        int to = off + len;
        for (int i = off; i < to; ++i) {
            if (!IllegalXmlCharacterFilterWriter.isInvalidChar(cbuf[i])) continue;
            cbuf[i] = 32;
        }
        return cbuf;
    }

    private static boolean isInvalidChar(char c) {
        if (Character.isSurrogate(c)) {
            return true;
        }
        if (c == '\t' || c == '\n' || c == '\r') {
            return false;
        }
        if (c > ' ' && c < '\ud7ff') {
            return false;
        }
        return c <= '\ue000' || c >= '\ufffd';
    }
}

