/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.InboundSseEvent;
import javax.ws.rs.sse.SseEventSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.sse.client.InboundSseEventListener;
import org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class SseEventSourceImpl
implements SseEventSource {
    private static final Logger LOG = LogUtils.getL7dLogger(SseEventSourceImpl.class);
    private final WebTarget target;
    private final Collection<InboundSseEventListener> listeners;
    private final AtomicReference<SseSourceState> state;
    private volatile ScheduledExecutorService executor;
    private volatile boolean managedExecutor;
    private volatile InboundSseEventProcessor processor;
    private volatile long delay;
    private volatile boolean isOpened;
    static final long serialVersionUID = -7586696449456079387L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    SseEventSourceImpl(WebTarget target, long delay, TimeUnit unit) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "<init>", new Object[]{target, delay, unit});
        }
        this.listeners = new CopyOnWriteArrayList<InboundSseEventListener>();
        this.state = new AtomicReference<SseSourceState>(SseSourceState.CLOSED);
        this.managedExecutor = true;
        this.target = target;
        this.delay = TimeUnit.MILLISECONDS.convert(delay, unit);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void register(Consumer<InboundSseEvent> onEvent) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "register", new Object[]{onEvent});
        }
        this.listeners.add(new InboundSseEventListenerImpl(onEvent));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "register");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "register", new Object[]{onEvent, onError});
        }
        this.listeners.add(new InboundSseEventListenerImpl(onEvent, onError));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "register");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError, Runnable onComplete) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "register", new Object[]{onEvent, onError, onComplete});
        }
        this.listeners.add(new InboundSseEventListenerImpl(onEvent, onError, onComplete));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "register");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void open() {
        Object lastEventId;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "open", new Object[0]);
        }
        if (!this.state.compareAndSet(SseSourceState.CLOSED, SseSourceState.CONNECTING)) {
            throw new IllegalStateException("The SseEventSource is already in " + (Object)((Object)this.state.get()) + " state");
        }
        Configuration configuration = this.target.getConfiguration();
        if (this.executor == null) {
            this.executor = (ScheduledExecutorService)configuration.getProperty("scheduledExecutorService");
            if (this.executor == null) {
                this.executor = Executors.newSingleThreadScheduledExecutor();
                this.managedExecutor = false;
            }
        }
        this.connect((lastEventId = configuration.getProperty("Last-Event-ID")) != null ? lastEventId.toString() : null);
        this.isOpened = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "open");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Exception.class})
    private void connect(String lastEventId) {
        Response response;
        InboundSseEventListenerDelegate delegate;
        block22: {
            block21: {
                block20: {
                    long retryAfterDelay;
                    block19: {
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.entering("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "connect", new Object[]{lastEventId});
                        }
                        delegate = new InboundSseEventListenerDelegate();
                        response = null;
                        Invocation.Builder builder = this.target.request(new String[]{"text/event-stream"});
                        if (lastEventId != null) {
                            builder.header("Last-Event-ID", (Object)lastEventId);
                        }
                        if ((response = builder.get()).getStatus() != 204) break block19;
                        LOG.fine("SSE endpoint " + this.target.getUri() + " returns no data, disconnecting");
                        delegate.onComplete();
                        this.state.set(SseSourceState.CLOSED);
                        response.close();
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "connect");
                        }
                        return;
                    }
                    if (response.getStatus() != 503) break block20;
                    LOG.fine("SSE endpoint " + this.target.getUri() + " returns 503");
                    MultivaluedMap headerMap = response.getHeaders();
                    Object retryAfter = headerMap.getFirst((Object)"Retry-After");
                    if (retryAfter == null) break block20;
                    this.delay = retryAfterDelay = this.handleRetry((String)retryAfter);
                    if (retryAfterDelay <= -1L) break block20;
                    this.scheduleReconnect(retryAfterDelay, lastEventId);
                    response.close();
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "connect");
                    }
                    return;
                }
                int status = response.getStatus();
                String contentType = response.getHeaderString("Content-Type");
                if (status == 200 && "text/event-stream".equals(contentType)) break block21;
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "Received " + status + " Content-Type=" + contentType);
                }
                Response fResponse = response;
                Throwable t = !"text/event-stream".equals(contentType) ? new WebApplicationException("Unexpected Content-Type in response", response) : AccessController.doPrivileged(() -> {
                    Constructor ctor;
                    Class throwableClass = ExceptionUtils.getWebApplicationExceptionClass((Response)fResponse, WebApplicationException.class);
                    try {
                        ctor = throwableClass.getConstructor(Response.class);
                    }
                    catch (NoSuchMethodException ex) {
                        ctor = null;
                    }
                    return ctor == null ? (Throwable)throwableClass.newInstance() : (Throwable)ctor.newInstance(fResponse);
                });
                delegate.onError(t);
                delegate.onComplete();
                response.close();
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "connect");
                }
                return;
            }
            if (this.state.get() != SseSourceState.CLOSED) break block22;
            LOG.fine("SSE connection to " + this.target.getUri() + " has been closed already");
            response.close();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "connect");
            }
            return;
        }
        try {
            if (this.processor == null || this.processor.isClosed()) {
                Endpoint endpoint = WebClient.getConfig((Object)this.target).getEndpoint();
                LOG.fine("Creating new instance of SSE event processor ...");
                this.processor = new InboundSseEventProcessor(endpoint, delegate);
            }
            this.processor.run(response);
            LOG.fine("SSE event processor has been started ...");
            if (!this.state.compareAndSet(SseSourceState.CONNECTING, SseSourceState.OPEN)) {
                throw new IllegalStateException("The SseEventSource is already in " + (Object)((Object)this.state.get()) + " state");
            }
            LOG.fine("Successfuly opened SSE connection to " + this.target.getUri());
        }
        catch (Exception ex) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "caught exception in connect(...)", ex);
            }
            if (this.processor != null) {
                this.processor.close(1L, TimeUnit.SECONDS);
                this.processor = null;
            }
            if (response != null) {
                response.close();
            }
            LOG.fine("Failed to open SSE connection to " + this.target.getUri() + ". " + ex.getMessage());
            delegate.onError(ex);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "connect");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={NumberFormatException.class, IllegalArgumentException.class, ParseException.class})
    private long handleRetry(String retryValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "handleRetry", new Object[]{retryValue});
        }
        if (!retryValue.contains(":")) {
            long l;
            try {
                Long retryLong = Long.valueOf(retryValue);
                l = TimeUnit.MILLISECONDS.convert(retryLong, TimeUnit.SECONDS);
            }
            catch (NumberFormatException e) {
                LOG.fine("SSE RETRY_AFTER Incorrect time value: " + e);
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                l = l;
                LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "handleRetry", l);
            }
            return l;
        } else {
            block12: {
                char[] retryValueArray = retryValue.toCharArray();
                SimpleDateFormat sdf = null;
                sdf = retryValueArray[3] == ',' ? new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z") : (retryValueArray[6] == ',' ? new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss z") : (retryValueArray[7] == ',' ? new SimpleDateFormat("EEEEEEE, dd-MMM-yy HH:mm:ss z") : (retryValueArray[8] == ',' ? new SimpleDateFormat("EEEEEEEE, dd-MMM-yy HH:mm:ss z") : (retryValueArray[9] == ',' ? new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z") : (retryValueArray[8] == ',' ? new SimpleDateFormat("EEEEEEEE, dd-MMM-yy HH:mm:ss z") : (retryValueArray[8] == ' ' ? new SimpleDateFormat("EEE MMM  d HH:mm:ss yyyy") : new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy")))))));
                Date retryDate = sdf.parse(retryValue);
                long retryTime = retryDate.getTime();
                long now = System.currentTimeMillis();
                long delayTime = retryTime - now;
                if (delayTime <= 0L) break block12;
                long l = delayTime;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    l = l;
                    LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "handleRetry", l);
                }
                return l;
            }
            try {
                LOG.fine("SSE RETRY_AFTER Date value represents a time already past");
            }
            catch (IllegalArgumentException ex) {
                LOG.fine("SSE RETRY_AFTER Date value format incorrect:  " + ex);
            }
            catch (ParseException e2) {
                LOG.fine("SSE RETRY_AFTER Date value cannot be parsed: " + e2);
            }
        }
        long l = -1L;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            l = l;
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "handleRetry", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isOpen() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "isOpen", new Object[0]);
        }
        boolean bl = this.isOpened;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "isOpen", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean close(long timeout, TimeUnit tunit) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "close", new Object[]{timeout, tunit});
        }
        this.isOpened = false;
        if (this.state.get() == SseSourceState.CLOSED) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "close", bl);
            }
            return bl;
        }
        if (this.state.compareAndSet(SseSourceState.CONNECTING, SseSourceState.CLOSED)) {
            LOG.fine("The SseEventSource was not connected, closing anyway");
        } else if (!this.state.compareAndSet(SseSourceState.OPEN, SseSourceState.CLOSED)) {
            throw new IllegalStateException("The SseEventSource is not opened, but in " + (Object)((Object)this.state.get()) + " state");
        }
        if (this.executor != null && !this.managedExecutor) {
            AccessController.doPrivileged(() -> {
                this.executor.shutdownNow();
                return null;
            });
            this.executor = null;
            this.managedExecutor = true;
        }
        if (this.processor == null) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "close", bl);
            }
            return bl;
        }
        boolean bl = this.processor.close(timeout, tunit);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "close", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void scheduleReconnect(long tdelay, String lastEventId) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "scheduleReconnect", new Object[]{tdelay, lastEventId});
        }
        if (tdelay < 0L || this.executor == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "scheduleReconnect");
            }
            return;
        }
        if (this.state.get() == SseSourceState.CLOSED) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "scheduleReconnect");
            }
            return;
        }
        if (this.state.get() != SseSourceState.CONNECTING) {
            LOG.fine("The SseEventSource is still opened, moving it to connecting state");
            if (!this.state.compareAndSet(SseSourceState.OPEN, SseSourceState.CONNECTING)) {
                throw new IllegalStateException("The SseEventSource is not opened, but in " + (Object)((Object)this.state.get()) + " state, unable to reconnect");
            }
        }
        this.executor.schedule(() -> {
            if (this.state.get() == SseSourceState.CONNECTING) {
                LOG.fine("Reestablishing SSE connection to " + this.target.getUri());
                this.connect(lastEventId);
            }
        }, tdelay, TimeUnit.MILLISECONDS);
        LOG.fine("The reconnection attempt to " + this.target.getUri() + " is scheduled in " + tdelay + "ms");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.SseEventSourceImpl", "scheduleReconnect");
        }
    }

    public String toString() {
        return this.getClass().getName() + "|target=" + this.target + "|listeners=" + this.listeners + "|state=" + this.state + "|executor=" + this.executor + "|managedExecutor=" + this.managedExecutor + "|processor = " + this.processor + "|delay=" + this.delay + "|isOpened=" + this.isOpened;
    }

    private static enum SseSourceState {
        CONNECTING,
        OPEN,
        CLOSED;

    }

    @Trivial
    private class InboundSseEventListenerImpl
    implements InboundSseEventListener {
        private final Consumer<InboundSseEvent> onEvent;
        private final Consumer<Throwable> onError;
        private final Runnable onComplete;

        InboundSseEventListenerImpl(Consumer<InboundSseEvent> e) {
            this(e, ex -> {}, () -> {});
        }

        InboundSseEventListenerImpl(Consumer<InboundSseEvent> e, Consumer<Throwable> t) {
            this(e, t, () -> {});
        }

        InboundSseEventListenerImpl(Consumer<InboundSseEvent> e, Consumer<Throwable> t, Runnable c) {
            this.onEvent = e;
            this.onError = t;
            this.onComplete = c;
        }

        @Override
        public void onNext(InboundSseEvent event) {
            this.onEvent.accept(event);
        }

        @Override
        public void onError(Throwable ex) {
            this.onError.accept(ex);
        }

        @Override
        public void onComplete() {
            this.onComplete.run();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class InboundSseEventListenerDelegate
    implements InboundSseEventListener {
        private String lastEventId;
        static final long serialVersionUID = 294453646185637682L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private InboundSseEventListenerDelegate() {
        }

        @Override
        public void onNext(InboundSseEvent event) {
            this.lastEventId = event.getId();
            SseEventSourceImpl.this.listeners.forEach(listener -> listener.onNext(event));
            if (event.isReconnectDelaySet()) {
                SseEventSourceImpl.this.delay = event.getReconnectDelay();
            }
        }

        @Override
        public void onError(Throwable ex) {
            SseEventSourceImpl.this.listeners.forEach(listener -> listener.onError(ex));
            if (SseEventSourceImpl.this.delay >= 0L) {
                SseEventSourceImpl.this.scheduleReconnect(SseEventSourceImpl.this.delay, this.lastEventId);
            }
        }

        @Override
        public void onComplete() {
            SseEventSourceImpl.this.listeners.forEach(InboundSseEventListener::onComplete);
            if (SseEventSourceImpl.this.delay >= 0L) {
                SseEventSourceImpl.this.scheduleReconnect(SseEventSourceImpl.this.delay, this.lastEventId);
            }
            SseEventSourceImpl.this.delay = -1L;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(InboundSseEventListenerDelegate.class, null, null);
        }
    }
}

