/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.extended;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ReferrerURLCookieHandlerExtended
extends ReferrerURLCookieHandler {
    private static final TraceComponent tc = Tr.register(ReferrerURLCookieHandlerExtended.class, null, null);
    public static final String REFERRER_URL_COOKIENAME = "WASReqURL";
    public static final String CUSTOM_RELOGIN_URL_COOKIENAME = "WASReLoginURL";
    static final long serialVersionUID = 8707600419704641631L;

    public ReferrerURLCookieHandlerExtended(WebAppSecurityConfig webAppSecConfig) {
        super(webAppSecConfig);
    }

    public Cookie createCookie(String cookieName, @Sensitive String value, boolean enableHttpOnly, HttpServletRequest req) {
        Cookie c = new Cookie(cookieName, value);
        if (cookieName.equals(REFERRER_URL_COOKIENAME) || cookieName.startsWith("WASOidcStateKey")) {
            c.setPath(this.getPathName(req));
        } else {
            c.setPath("/");
        }
        c.setMaxAge(-1);
        if (enableHttpOnly && this.webAppSecConfig.getHttpOnlyCookies()) {
            c.setHttpOnly(true);
        }
        if (this.webAppSecConfig.getSSORequiresSSL()) {
            c.setSecure(true);
        }
        return c;
    }
}

