/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.extended;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.tai.TAIService;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.WebRequestImpl;
import com.ibm.ws.webcontainer.security.extended.ReferrerURLCookieHandlerExtended;
import com.ibm.ws.webcontainer.security.extended.SSOCookieHelperImplExtended;
import com.ibm.ws.webcontainer.security.internal.SSOAuthenticator;
import com.ibm.ws.webcontainer.security.internal.TAIAuthenticator;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.oauth20.OAuth20Service;
import com.ibm.ws.webcontainer.security.openid20.OpenidClientService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcClient;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebProviderAuthenticatorProxyExtended
extends WebProviderAuthenticatorProxy {
    private static final TraceComponent tc = Tr.register(WebProviderAuthenticatorProxyExtended.class, null, null);
    static final List<String> authenticatorOdering = Collections.unmodifiableList(Arrays.asList("com.ibm.ws.security.spnego", "com.ibm.ws.security.openid"));
    AuthenticationResult OAUTH_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OAuth service said continue...");
    AuthenticationResult OPENID_CLIENT_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OpenID client service said continue...");
    AuthenticationResult OIDC_SERVER_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OpenID Connect server said continue...");
    AuthenticationResult OIDC_CLIENT_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OpenID Connect client said continue...");
    AuthenticationResult SPNEGO_CONT = new AuthenticationResult(AuthResult.CONTINUE, "SPNEGO said continue...");
    private final AtomicServiceReference<OAuth20Service> oauthServiceRef;
    private final AtomicServiceReference<OpenidClientService> openIdClientServiceRef;
    private final AtomicServiceReference<OidcServer> oidcServerRef;
    private final AtomicServiceReference<OidcClient> oidcClientRef;
    private WebProviderAuthenticatorHelper authHelper;
    private ReferrerURLCookieHandler referrerURLCookieHandler = null;
    private WebAppSecurityConfig webAppSecurityConfig = null;
    static final long serialVersionUID = -7137198683586004663L;

    public WebProviderAuthenticatorProxyExtended(AtomicServiceReference<SecurityService> securityServiceRef, AtomicServiceReference<TAIService> taiServiceRef, ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef, WebAppSecurityConfig webAppSecurityConfig, AtomicServiceReference<OAuth20Service> oauthServiceRef, AtomicServiceReference<OpenidClientService> openIdClientServiceRef, AtomicServiceReference<OidcServer> oidcServerRef, AtomicServiceReference<OidcClient> oidcClientRef, ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef) {
        super(securityServiceRef, taiServiceRef, interceptorServiceRef, webAppSecurityConfig, webAuthenticatorRef);
        this.webAppSecurityConfig = webAppSecurityConfig;
        this.oauthServiceRef = oauthServiceRef;
        this.oidcServerRef = oidcServerRef;
        this.openIdClientServiceRef = openIdClientServiceRef;
        this.oidcClientRef = oidcClientRef;
        this.authHelper = new WebProviderAuthenticatorHelper(securityServiceRef);
        this.referrerURLCookieHandler = new ReferrerURLCookieHandlerExtended(webAppSecurityConfig);
    }

    public void setWebProviderAuthenticatorHelper(WebProviderAuthenticatorHelper authHelper) {
        this.authHelper = authHelper;
    }

    public AuthenticationResult authenticate(WebRequest webRequest) {
        HttpServletRequest request = webRequest.getHttpServletRequest();
        HttpServletResponse response = webRequest.getHttpServletResponse();
        AuthenticationResult authResult = this.handleTAI(webRequest, true);
        if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleAccessToken(webRequest)).getStatus() == AuthResult.CONTINUE) {
            webRequest.setCallAfterSSO(false);
            authResult = this.handleSpnego(webRequest);
            if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleOidcClient(request, response, true)).getStatus() == AuthResult.CONTINUE && (authResult = this.handleSSO(webRequest, null)).getStatus() == AuthResult.CONTINUE) {
                webRequest.setCallAfterSSO(true);
                authResult = this.handleSpnego(webRequest);
                if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleTAI(webRequest, false)).getStatus() == AuthResult.CONTINUE) {
                    authResult = this.handleOidcClient(request, response, false);
                }
            }
        }
        return authResult;
    }

    protected AuthenticationResult handleJaspi(WebRequest webRequest, HashMap<String, Object> props) {
        return super.handleJaspi(webRequest, props);
    }

    public AuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> props) throws Exception {
        AuthenticationResult authResult;
        WebRequestImpl webRequest = new WebRequestImpl(request, response, null, null, null, null, this.webAppSecurityConfig);
        if (props != null && props.get("authType").equals("com.ibm.ws.security.spnego")) {
            authResult = this.handleSpnego((WebRequest)webRequest);
        } else {
            authResult = this.handleJaspi((WebRequest)webRequest, props);
            if (authResult.getStatus() == AuthResult.CONTINUE) {
                authResult = this.handleOpenidClient(request, response);
            }
        }
        return authResult;
    }

    private AuthenticationResult handleAccessToken(WebRequest webRequest) {
        HttpServletResponse res;
        HttpServletRequest req = webRequest.getHttpServletRequest();
        AuthenticationResult authResult = this.handleOAuth(req, res = webRequest.getHttpServletResponse());
        if (authResult.getStatus() != AuthResult.CONTINUE) {
            authResult.setAuditCredType("OAuth token");
        }
        return authResult;
    }

    public AuthenticationResult handleSpnego(WebRequest webRequest) {
        HttpServletResponse response;
        HttpServletRequest request;
        WebAuthenticator webAuthenticator;
        AuthenticationResult authResult = this.SPNEGO_CONT;
        if (this.webAuthenticatorRef != null && (webAuthenticator = this.getSpnegoAuthenticator()) != null && (authResult = webAuthenticator.authenticate(webRequest)).getStatus() == AuthResult.SUCCESS && AuthResult.SUCCESS == (authResult = this.authHelper.loginWithHashtable(request = webRequest.getHttpServletRequest(), response = webRequest.getHttpServletResponse(), authResult.getSubject())).getStatus()) {
            SSOCookieHelper ssoCh = this.webAppSecurityConfig.createSSOCookieHelper();
            ssoCh.addSSOCookiesToResponse(authResult.getSubject(), request, response);
        }
        if (authResult.getStatus() != AuthResult.CONTINUE) {
            authResult.setAuditCredType("SPNEGO");
        }
        return authResult;
    }

    public WebAuthenticator getSpnegoAuthenticator() {
        WebAuthenticator webAuthenticator = (WebAuthenticator)this.webAuthenticatorRef.getService((Object)"com.ibm.ws.security.spnego");
        return webAuthenticator;
    }

    private AuthenticationResult handleOpenidClient(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthenticationResult authResult = this.OPENID_CLIENT_CONT;
        OpenidClientService openIdClientService = (OpenidClientService)this.openIdClientServiceRef.getService();
        if (openIdClientService != null) {
            String opId = openIdClientService.getOpenIdIdentifier(request);
            if (opId != null && !opId.isEmpty()) {
                openIdClientService.createAuthRequest(request, response);
                authResult = new AuthenticationResult(AuthResult.REDIRECT_TO_PROVIDER, "OpenID client creates auth request...");
            } else if (openIdClientService.getRpRequestIdentifier(request, response) != null) {
                ProviderAuthenticationResult result = openIdClientService.verifyOpResponse(request, response);
                if (result.getStatus() != AuthResult.SUCCESS) {
                    return new AuthenticationResult(AuthResult.FAILURE, "OpenID client failed with status code " + result.getStatus());
                }
                authResult = this.authHelper.loginWithUserName(request, response, result.getUserName(), result.getSubject(), result.getCustomProperties(), openIdClientService.isMapIdentityToRegistryUser());
            }
        }
        if (authResult.getStatus() != AuthResult.CONTINUE) {
            authResult.setAuditCredType("IDToken");
        }
        return authResult;
    }

    private AuthenticationResult handleOidcClient(HttpServletRequest req, HttpServletResponse res, boolean firstCall) {
        AuthenticationResult authResult = this.OIDC_CLIENT_CONT;
        OidcClient oidcClient = (OidcClient)this.oidcClientRef.getService();
        if (oidcClient == null) {
            return new AuthenticationResult(AuthResult.CONTINUE, "OpenID Connect client is not available, skipping OpenID Connect client...");
        }
        if (firstCall && !oidcClient.anyClientIsBeforeSso()) {
            return authResult;
        }
        String provider = oidcClient.getOidcProvider(req);
        if (provider == null) {
            return new AuthenticationResult(AuthResult.CONTINUE, "not an OpenID Connect client request, skipping OpenID Connect client...");
        }
        ProviderAuthenticationResult oidcResult = oidcClient.authenticate(req, res, provider, this.referrerURLCookieHandler, firstCall);
        if (oidcResult.getStatus() == AuthResult.CONTINUE) {
            return this.OIDC_CLIENT_CONT;
        }
        if (oidcResult.getStatus() == AuthResult.REDIRECT_TO_PROVIDER) {
            return new AuthenticationResult(AuthResult.REDIRECT, oidcResult.getRedirectUrl());
        }
        if (oidcResult.getStatus() == AuthResult.FAILURE) {
            if (401 == oidcResult.getHttpStatusCode()) {
                return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OpenID Connect client failed the request...");
            }
            return new AuthenticationResult(AuthResult.FAILURE, "OpenID Connect client failed the request...");
        }
        if (oidcResult.getStatus() != AuthResult.SUCCESS) {
            if (401 == oidcResult.getHttpStatusCode()) {
                return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OpenID Connect client returned with status: " + oidcResult.getStatus());
            }
            return new AuthenticationResult(AuthResult.FAILURE, "OpenID Connect client returned with status: " + oidcResult.getStatus());
        }
        if (oidcResult.getStatus() == AuthResult.SUCCESS && oidcResult.getUserName() != null && AuthResult.SUCCESS == (authResult = this.authHelper.loginWithUserName(req, res, oidcResult.getUserName(), oidcResult.getSubject(), oidcResult.getCustomProperties(), oidcClient.isMapIdentityToRegistryUser(provider))).getStatus()) {
            boolean bDisableLtpaCookie = firstCall;
            boolean bPropagationTokenAuthenticated = this.isNotNullAndTrue(req, "com.ibm.ws.webcontainer.security.openidconnect.propagation.token.authenticated");
            boolean bAuthnSessionDisabled = (Boolean)req.getAttribute("com.ibm.ws.webcontainer.security.openidconnect.authn.session.disabled");
            String inboundValue = (String)req.getAttribute("com.ibm.ws.webcontainer.security.openidconnect.inbound.propagation.value");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Booleans: fisrtCall:" + firstCall + " tokenAuthenticated:" + bPropagationTokenAuthenticated + " SessionDisabled:" + bAuthnSessionDisabled + " inboundValue:" + inboundValue), (Object[])new Object[0]);
            }
            boolean includeAccessTokenInLtpa = (Boolean)req.getAttribute("com.ibm.ws.webcontainer.security.oidc.accesstoken.in.ltpa");
            if ("none".equals(inboundValue) && !bDisableLtpaCookie || "required".equals(inboundValue) && !bAuthnSessionDisabled || "supported".equals(inboundValue) && !bPropagationTokenAuthenticated && !bDisableLtpaCookie || includeAccessTokenInLtpa && "supported".equals(inboundValue)) {
                SSOCookieHelper ssoCh = this.webAppSecurityConfig.createSSOCookieHelper();
                if (includeAccessTokenInLtpa) {
                    this.addAccessTokenToTheCookie(authResult, ssoCh);
                }
                ssoCh.addSSOCookiesToResponse(authResult.getSubject(), req, res);
            }
        }
        return authResult;
    }

    private void addAccessTokenToTheCookie(AuthenticationResult authResult, SSOCookieHelper ssoCh) {
        Subject subject = authResult.getSubject();
        if (subject != null) {
            String accessToken = WebProviderAuthenticatorProxyExtended.getAccessTokenFromTheSubject(subject, "access_token");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"access token from the subject = ", (Object[])new Object[]{accessToken});
            }
            SingleSignonToken ssoToken = ssoCh.getDefaultSSOTokenFromSubject(subject);
            if (accessToken != null && ssoToken != null) {
                ssoToken.addAttribute("oidc_access_token", accessToken);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Successfully added the access token to the single sign on token  = ", (Object[])new Object[]{accessToken});
                }
            }
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    static String getAccessTokenFromTheSubject(Subject subject, String attribKey) {
        String result;
        block3: {
            result = null;
            try {
                Set<Object> publicCredentials = subject.getPublicCredentials();
                result = WebProviderAuthenticatorProxyExtended.getCredentialAttribute(publicCredentials, attribKey, "publicCredentials");
                if (result == null || result.isEmpty()) {
                    Set<Object> privateCredentials = subject.getPrivateCredentials();
                    result = WebProviderAuthenticatorProxyExtended.getCredentialAttribute(privateCredentials, attribKey, "privateCredentials");
                }
            }
            catch (PrivilegedActionException e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Did not find a value for the attribute (" + attribKey + ")"), (Object[])new Object[0]);
            }
        }
        return result;
    }

    static String getCredentialAttribute(final Set<Object> credentials, final String attribKey, final String msg) throws PrivilegedActionException {
        Object obj = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
            static final long serialVersionUID = 1351133135317650211L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() throws Exception {
                int iCnt = 0;
                for (Object credentialObj : credentials) {
                    Object value;
                    Object accessToken;
                    ++iCnt;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(msg + "(" + iCnt + ") class:" + credentialObj.getClass().getName()), (Object[])new Object[0]);
                    }
                    if (!(credentialObj instanceof Map) || (accessToken = ((Map)credentialObj).get("access_token")) == null || (value = ((Map)credentialObj).get(attribKey)) == null) continue;
                    return value;
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, null, null);
            }
        });
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    private AuthenticationResult handleOAuth(HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult authResult = this.OAUTH_CONT;
        if (this.oauthServiceRef != null) {
            OAuth20Service oauthService = (OAuth20Service)this.oauthServiceRef.getService();
            if (oauthService == null) {
                return new AuthenticationResult(AuthResult.CONTINUE, "OAuth service is not available, skipping OAuth...");
            }
            ProviderAuthenticationResult oauthResult = oauthService.authenticate(req, res);
            if (oauthResult.getStatus() == AuthResult.CONTINUE) {
                return this.OAUTH_CONT;
            }
            if (oauthResult.getStatus() == AuthResult.FAILURE) {
                if (401 == oauthResult.getHttpStatusCode()) {
                    return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OAuth service failed the request");
                }
                return new AuthenticationResult(AuthResult.FAILURE, "OAuth service failed the request...");
            }
            if (oauthResult.getStatus() != AuthResult.SUCCESS) {
                if (401 == oauthResult.getHttpStatusCode()) {
                    return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OAuth service failed the request due to unsuccessful request");
                }
                return new AuthenticationResult(AuthResult.FAILURE, "OAuth service returned with status: " + oauthResult.getStatus());
            }
            if (oauthResult.getUserName() != null) {
                authResult = this.authHelper.loginWithUserName(req, res, oauthResult.getUserName(), oauthResult.getSubject(), oauthResult.getCustomProperties(), true);
            }
        }
        return authResult;
    }

    protected TAIAuthenticator getTaiAuthenticator() {
        TAIAuthenticator taiAuthenticator = null;
        TAIService taiService = (TAIService)this.taiServiceRef.getService();
        Iterator interceptorServices = this.interceptorServiceRef.getServices();
        if (taiService != null || interceptorServices != null && interceptorServices.hasNext()) {
            SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
            taiAuthenticator = new TAIAuthenticator(taiService, this.interceptorServiceRef, securityService.getAuthenticationService(), (SSOCookieHelper)new SSOCookieHelperImplExtended(this.webAppSecurityConfig, this.oidcServerRef));
        }
        return taiAuthenticator;
    }

    public WebAuthenticator getSSOAuthenticator(WebRequest webRequest, String ssoCookieName) {
        SecurityMetadata securityMetadata = webRequest.getSecurityMetadata();
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        SSOCookieHelperImplExtended cookieHelper = ssoCookieName != null ? new SSOCookieHelperImplExtended(this.webAppSecurityConfig, ssoCookieName) : new SSOCookieHelperImplExtended(this.webAppSecurityConfig, this.oidcServerRef);
        return new SSOAuthenticator(securityService.getAuthenticationService(), securityMetadata, this.webAppSecurityConfig, (SSOCookieHelper)cookieHelper);
    }
}

