/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.ws.logging.collector.BurstDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DateFormatHelper {
    private static ThreadLocal<BurstDateFormat[]> dateformats = new ThreadLocal();
    private static final String localeDatePattern;

    private static final String removeClockFormat(StringBuilder sb) {
        char letter;
        int start;
        int end = sb.length() - 1;
        for (start = 0; start <= end && ((letter = sb.charAt(start)) == ' ' || letter == 'a'); ++start) {
        }
        while (end > start && ((letter = sb.charAt(end)) == ' ' || letter == 'a')) {
            --end;
        }
        for (int i = start; i <= end; ++i) {
            letter = sb.charAt(i);
            if (letter == 'h' || letter == 'k' || letter == 'K') {
                sb.setCharAt(i, 'H');
                continue;
            }
            if (letter != 'a') continue;
            sb.setCharAt(i, ' ');
        }
        return sb.substring(start, end + 1);
    }

    public static final String formatTime(long timestamp, boolean useIsoDateFormat) {
        int index;
        BurstDateFormat[] dfs = dateformats.get();
        int n = index = useIsoDateFormat ? 1 : 0;
        if (dfs == null) {
            dfs = new BurstDateFormat[index + 1];
            dateformats.set(dfs);
        } else if (useIsoDateFormat && dfs.length == 1) {
            BurstDateFormat[] newDfs = new BurstDateFormat[2];
            newDfs[0] = dfs[0];
            dfs = newDfs;
            dateformats.set(dfs);
        }
        if (dfs[index] == null) {
            dfs[index] = new BurstDateFormat(new SimpleDateFormat(useIsoDateFormat ? "yyyy-MM-dd'T'HH:mm:ss.SSSZ" : localeDatePattern));
        }
        return dfs[index].format(timestamp);
    }

    static {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            String pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            StringBuilder newPattern = new StringBuilder(pattern.substring(0, endOfSecsIndex) + ":SSS z");
            if (endOfSecsIndex < patternLength) {
                newPattern.append(pattern.substring(endOfSecsIndex, patternLength));
            }
            localeDatePattern = DateFormatHelper.removeClockFormat(newPattern);
        } else {
            localeDatePattern = "dd/MMM/yyyy HH:mm:ss:SSS z";
        }
    }
}

