/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.logging.Logger;
import org.eclipse.yasson.internal.AnnotationFinder;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.CreatorModel;
import org.eclipse.yasson.internal.model.JsonbCreator;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.spi.JsonbComponentInstanceCreator;

class ConstructorPropertiesAnnotationIntrospector {
    private static final Logger LOG = Logger.getLogger(JsonbComponentInstanceCreator.class.getName());
    private final JsonbContext jsonbContext;
    private final AnnotationFinder constructorProperties;

    public static final ConstructorPropertiesAnnotationIntrospector forContext(JsonbContext jsonbContext) {
        return new ConstructorPropertiesAnnotationIntrospector(jsonbContext, AnnotationFinder.findConstructorProperties());
    }

    protected ConstructorPropertiesAnnotationIntrospector(JsonbContext context, AnnotationFinder annotationFinder) {
        this.jsonbContext = context;
        this.constructorProperties = annotationFinder;
    }

    public JsonbCreator getCreator(Constructor<?>[] constructors) {
        JsonbCreator jsonbCreator = null;
        for (Constructor<?> constructor : constructors) {
            Object properties = this.constructorProperties.valueIn(constructor.getDeclaredAnnotations());
            if (!(properties instanceof String[])) continue;
            if (jsonbCreator != null) {
                LOG.warning(Messages.getMessage(MessageKeys.MULTIPLE_CONSTRUCTOR_PROPERTIES_CREATORS, constructor.getDeclaringClass().getName()));
                return null;
            }
            jsonbCreator = this.createJsonbCreator(constructor, (String[])properties);
        }
        return jsonbCreator;
    }

    private JsonbCreator createJsonbCreator(Executable executable, String[] properties) {
        Parameter[] parameters = executable.getParameters();
        CreatorModel[] creatorModels = new CreatorModel[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            creatorModels[i] = new CreatorModel(properties[i], parameter, this.jsonbContext);
        }
        return new JsonbCreator(executable, creatorModels);
    }

    public String toString() {
        return "ConstructorPropertiesAnnotationIntrospector [jsonbContext=" + this.jsonbContext + ", constructorProperties=" + this.constructorProperties + "]";
    }
}

