/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.MethodFinder;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.impl.AbstractAnnotationConfig;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackHandlerFactory;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceFunction;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceProvider;
import com.ibm.ws.microprofile.faulttolerance.utils.FTDebug;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FallbackConfig
extends AbstractAnnotationConfig<Fallback> {
    private static final TraceComponent tc = Tr.register(FallbackConfig.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.cdi.resources.FaultToleranceCDI");
    private static final SecureAction secure = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Class<? extends FallbackHandler>> valueConfig = this.getParameterConfigClass("value", FallbackHandler.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<String> fallbackMethodConfig = this.getParameterConfig("fallbackMethod", String.class);
    static final long serialVersionUID = -6078729231993487216L;

    public FallbackConfig(Method annotatedMethod, Class<?> annotatedClass, Fallback annotation) {
        super(annotatedMethod, annotatedClass, annotation, Fallback.class);
    }

    private Class<? extends FallbackHandler<?>> value() {
        return this.valueConfig.getValue();
    }

    private String fallbackMethod() {
        return this.fallbackMethodConfig.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate() {
        block8: {
            Method fallbackMethod;
            Method originalMethod = this.getAnnotatedMethod();
            Class<?> originalMethodReturnType = originalMethod.getReturnType();
            Class<FallbackHandler<?>> fallbackClass = this.value();
            String fallbackMethodName = this.fallbackMethod();
            if (fallbackClass != null && fallbackClass != Fallback.DEFAULT.class && fallbackMethodName != null && !"".equals(fallbackMethodName)) {
                throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"fallback.policy.conflicts.CWMFT5009E", (Object[])new Object[]{FTDebug.formatMethod((Method)originalMethod), fallbackClass, fallbackMethodName}));
            }
            if (fallbackClass != null && fallbackClass != Fallback.DEFAULT.class) {
                try {
                    Method[] ms = fallbackClass.getMethods();
                    Method handleMethod = FallbackHandler.class.getMethod("handle", ExecutionContext.class);
                    boolean validFallbackHandler = false;
                    for (Method m : ms) {
                        Class<?>[] params;
                        if (!m.getName().equals(handleMethod.getName()) || m.getParameterCount() != 1 || !ExecutionContext.class.isAssignableFrom((params = m.getParameterTypes())[0]) || !originalMethodReturnType.isAssignableFrom(m.getReturnType())) continue;
                        validFallbackHandler = true;
                        break;
                    }
                    if (!validFallbackHandler) {
                        throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"fallback.policy.invalid.CWMFT5008E", (Object[])new Object[]{FTDebug.formatMethod((Method)originalMethod), fallbackClass, originalMethodReturnType, originalMethod.getName()}));
                    }
                    break block8;
                }
                catch (NoSuchMethodException ms) {
                    void e;
                    FFDCFilter.processException((Throwable)ms, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig", (String)"102", (Object)this, (Object[])new Object[0]);
                    throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT5998E", (Object[])new Object[0]), (Throwable)e);
                }
                catch (SecurityException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig", (String)"105", (Object)this, (Object[])new Object[0]);
                    throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT5998E", (Object[])new Object[0]), (Throwable)e);
                }
            }
            if (fallbackMethodName != null && !"".equals(fallbackMethodName) && (fallbackMethod = MethodFinder.findMatchingMethod(originalMethod, fallbackMethodName)) == null) {
                throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"fallback.method.not.found.CWMFT5021E", (Object[])new Object[]{fallbackMethodName, originalMethod.getName(), originalMethod.getDeclaringClass()}));
            }
        }
    }

    public FallbackPolicy generatePolicy(InvocationContext context, BeanManager beanManager) {
        FallbackPolicy fallbackPolicy = null;
        Class<? extends FallbackHandler<?>> fallbackClass = this.value();
        String fallbackMethodName = this.fallbackMethod();
        if (fallbackClass != null && fallbackClass != Fallback.DEFAULT.class) {
            FallbackHandlerFactory fallbackHandlerFactory = FallbackConfig.getFallbackHandlerFactory(beanManager);
            fallbackPolicy = FallbackConfig.newFallbackPolicy(fallbackClass, fallbackHandlerFactory);
        } else if (fallbackMethodName != null && !"".equals(fallbackMethodName)) {
            Object beanInstance = context.getTarget();
            Method originalMethod = context.getMethod();
            Method fallbackMethod = MethodFinder.findMatchingMethod(originalMethod, fallbackMethodName);
            if (fallbackMethod == null) {
                throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"fallback.method.not.found.CWMFT5021E", (Object[])new Object[]{fallbackMethodName, originalMethod.getName(), originalMethod.getDeclaringClass()}));
            }
            if (!Modifier.isPublic(fallbackMethod.getModifiers()) && !fallbackMethod.isAccessible()) {
                secure.setAccessible(fallbackMethod, true);
            }
            Class<?> fallbackReturn = fallbackMethod.getReturnType();
            fallbackPolicy = FallbackConfig.newFallbackPolicy(beanInstance, fallbackMethod, fallbackReturn);
        } else {
            throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT5998E", (Object[])new Object[0]));
        }
        return fallbackPolicy;
    }

    private static FallbackHandlerFactory getFallbackHandlerFactory(final BeanManager beanManager) {
        FallbackHandlerFactory factory = new FallbackHandlerFactory(){
            static final long serialVersionUID = -5922692287711363464L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public <F extends FallbackHandler<?>> F newHandler(Class<F> fallbackClass) {
                AnnotatedType aType = beanManager.createAnnotatedType(fallbackClass);
                CreationalContext cc = beanManager.createCreationalContext(null);
                InjectionTargetFactory factory = beanManager.getInjectionTargetFactory(aType);
                InjectionTarget injectionTarget = factory.createInjectionTarget(null);
                FallbackHandler instance = (FallbackHandler)injectionTarget.produce(cc);
                injectionTarget.inject((Object)instance, cc);
                injectionTarget.postConstruct((Object)instance);
                return (F)instance;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.cdi.resources.FaultToleranceCDI");
            }
        };
        return factory;
    }

    private static <R> FallbackPolicy newFallbackPolicy(final Object beanInstance, final Method fallbackMethod, Class<R> fallbackReturn) {
        FaultToleranceFunction fallbackFunction = new FaultToleranceFunction<ExecutionContext, R>(){
            static final long serialVersionUID = 7631662184327667625L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @FFDCIgnore(value={InvocationTargetException.class})
            public R execute(ExecutionContext context) throws Exception {
                Object result = null;
                try {
                    result = fallbackMethod.invoke(beanInstance, context.getParameters());
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    throw ex;
                }
                return result;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.cdi.resources.FaultToleranceCDI");
            }
        };
        FallbackPolicy fallbackPolicy = FallbackConfig.newFallbackPolicy(fallbackFunction);
        return fallbackPolicy;
    }

    private static FallbackPolicy newFallbackPolicy(Class<? extends FallbackHandler<?>> fallbackHandlerClass, FallbackHandlerFactory factory) {
        FallbackPolicy fallbackPolicy = FaultToleranceProvider.newFallbackPolicy();
        fallbackPolicy.setFallbackHandler(fallbackHandlerClass, factory);
        return fallbackPolicy;
    }

    private static FallbackPolicy newFallbackPolicy(FaultToleranceFunction<ExecutionContext, ?> fallbackFunction) {
        FallbackPolicy fallbackPolicy = FaultToleranceProvider.newFallbackPolicy();
        fallbackPolicy.setFallbackFunction(fallbackFunction);
        return fallbackPolicy;
    }
}

