/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.state.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.faulttolerance20.state.impl.CircuitBreakerStateImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.BitSet;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CircuitBreakerRollingWindow {
    private final int size;
    private final int threshold;
    private final BitSet results;
    private int nextResultIndex;
    private int failures;
    private int resultCount;
    static final long serialVersionUID = -4175898659157109674L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CircuitBreakerRollingWindow(int size, double failureRatio) {
        this.size = size;
        this.threshold = (int)Math.ceil((double)size * failureRatio);
        this.results = new BitSet(size);
        this.nextResultIndex = 0;
        this.failures = 0;
        this.resultCount = 0;
    }

    public void record(CircuitBreakerStateImpl.CircuitBreakerResult result) {
        boolean isFailure;
        boolean bl = isFailure = result == CircuitBreakerStateImpl.CircuitBreakerResult.FAILURE;
        if (this.resultCount < this.size) {
            ++this.resultCount;
        } else {
            boolean oldestResultIsFailure = this.results.get(this.nextResultIndex);
            if (oldestResultIsFailure) {
                --this.failures;
            }
        }
        this.results.set(this.nextResultIndex, isFailure);
        if (isFailure) {
            ++this.failures;
        }
        ++this.nextResultIndex;
        if (this.nextResultIndex >= this.size) {
            this.nextResultIndex = 0;
        }
    }

    public boolean isOverThreshold() {
        return this.size == this.resultCount && this.failures >= this.threshold;
    }

    public void clear() {
        this.results.clear();
        this.nextResultIndex = 0;
        this.failures = 0;
        this.resultCount = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("[Rolling window:");
        sb.append(" current failures: (").append(this.failures).append('/').append(this.resultCount).append(')');
        sb.append(" limit (").append(this.threshold).append('/').append(this.size).append(')');
        sb.append(']');
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CircuitBreakerRollingWindow.class, (String)"FAULTTOLERANCE", null);
    }
}

